/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.io.Serializable;
import java.util.concurrent.Callable;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.cache.DistributeCacheUtil;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.lock.ModelTaskLock;
import kd.fi.pa.engine.task.AbstractBusinessSequenceTaskGroup;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.BusinessTaskResultProcessor;
import kd.fi.pa.engine.task.IDataWorkTask;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOEnum;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.helper.PALogHelper;
import kd.fi.pa.model.impl.ThreeValueTuple;

public class PABusinessSequenceTaskGroup
extends AbstractBusinessSequenceTaskGroup {
    private static final Log logger = LogFactory.getLog(PABusinessSequenceTaskGroup.class);
    private ModelTaskLock taskLock;
    protected ExecutionLogDTO executionLogDTO;

    public PABusinessSequenceTaskGroup(Serializable taskKey, Serializable version, ModelTaskLock taskLock, ExecutionLogDTO executionLogDTO) {
        super(taskKey, version, new BusinessTaskResultProcessor());
        this.taskLock = taskLock;
        this.executionLogDTO = executionLogDTO;
        this.exceptionListener = this::onTaskError;
        this.updateReference = false;
        this.throwException = false;
    }

    public void initializeTaskJob() {
        this.initTaskStatistics();
        super.initializeTaskJob();
    }

    protected BusinessTaskResult doTaskJob() {
        logger.info(String.format("[FI-PA] TaskExecute PABusinessSequenceTaskGroup doTaskJob begin groupTask:%s", new Object[]{this}));
        this.execute();
        logger.info(String.format("[FI-PA] TaskExecute PABusinessSequenceTaskGroup doTaskJob end groupTask:%s", new Object[]{this}));
        return (BusinessTaskResult)this.taskResult;
    }

    protected void executeSubTask(int taskIndex, ThreeValueTuple<IDataWorkTask<BusinessTaskResult>, Boolean, Boolean> workTaskInfo) {
        logger.info(String.format("[FI-PA] TaskExecute PABusinessSequenceTaskGroup executeSubTask begin taskIndex:%s subTaskInfo:%s", taskIndex, workTaskInfo));
        IDataWorkTask subWorkTask = (IDataWorkTask)workTaskInfo.getKey();
        if (subWorkTask.getUpdateReference()) {
            this.updateSubTaskReference(subWorkTask);
        }
        try {
            this.updateTaskStatistics(1, 0, 0, 0);
            BusinessTaskResult subBusinessTaskResult = (BusinessTaskResult)subWorkTask.call();
            this.processTaskResultFunc.processWorkTaskResult(taskIndex, (Callable)subWorkTask, (Object)subBusinessTaskResult);
            if (subBusinessTaskResult != null) {
                Long code = subBusinessTaskResult.getCode();
                if (code == 0L) {
                    this.terminateOnError();
                    this.updateTaskStatistics(0, 0, 0, 1);
                } else if (code == 2L) {
                    this.updateTaskStatistics(0, 0, 1, 0);
                } else {
                    this.updateTaskStatistics(0, 1, 0, 0);
                }
            }
        }
        catch (Exception ex) {
            this.onSubTaskError(ex);
            throw new PABusinessException(ex, PABusinessErrorCodeBox.SYSTEM, "executeSubTask error");
        }
        BusinessTaskResultProcessor businessTaskResultProcessor = (BusinessTaskResultProcessor)this.processTaskResultFunc;
        this.taskResult = businessTaskResultProcessor.getBasicResult();
        logger.info(String.format("[FI-PA] TaskExecute PABusinessSequenceTaskGroup executeSubTask end taskIndex:%s subTaskInfo:%s", taskIndex, workTaskInfo));
    }

    protected void updateTaskStageCode(int newStageCode) {
        super.updateTaskStageCode(newStageCode);
        Long executeLogId = this.executionLogDTO.getId();
        switch (newStageCode) {
            case 2: {
                PALogHelper.updateExecuteLogStatus((Object)executeLogId, (String)PASyncLogStatusEnum.PROCESSING.getCodeString(), (Long)System.currentTimeMillis());
                break;
            }
            case 9: {
                String endMsg = ((BusinessTaskResult)this.taskResult).getMsg();
                PALogHelper.updateExecuteLogStatus((Object)executeLogId, (String)((BusinessTaskResult)this.taskResult).getLogStatus(), (String)endMsg, (String)endMsg);
                PALogHelper.createResultEntry((ExecutionLogDTO)this.executionLogDTO, (boolean)((BusinessTaskResult)this.taskResult).getLogResultStatus());
                this.endTaskStatistics(endMsg);
                break;
            }
            case -9: 
            case 10: {
                String errorMsg = BusinessTaskResult.getErrorMsg();
                PALogHelper.updateExecuteLogStatus((Object)executeLogId, (String)PASyncLogStatusEnum.FAILURE.getCodeString(), (String)errorMsg, (String)errorMsg);
                PALogHelper.createResultEntry((ExecutionLogDTO)this.executionLogDTO, (boolean)false);
                this.errorTaskStatistics(errorMsg);
                break;
            }
        }
    }

    protected boolean onException(Throwable exception) {
        if (logger.isErrorEnabled()) {
            logger.error(String.format("[FI-PA] TaskExecute Error PABusinessSequenceTaskGroup Msg=%s", exception.getMessage()), exception);
        }
        return this.exceptionListener.onError(exception);
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        block13: {
            if (this.taskLock != null && this.taskLock.existsLock()) {
                PABusinessException paBusinessException = new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "Get model task lock failed, please try later");
                this.taskResult = BusinessTaskResult.failed((Throwable)((Object)paBusinessException));
                if (logger.isErrorEnabled()) {
                    logger.error("[FI-PA] Get model task lock failed");
                }
                throw paBusinessException;
            }
            ConfigDTOManager configDTOManager = this.getConfigDTOManager();
            try {
                if (this.taskLock == null || this.taskLock.tryLock(5000L)) {
                    String configKey = FieldUtil.configFormat(this.executionLogDTO.getId().toString());
                    DistributeCacheUtil.put((String)configKey, (Object)SerializationUtils.toByte((Object)configDTOManager), (int)14400);
                    logger.info("[FI-PA] TaskExecute Before exec task job, put config into cache, configKey is " + configKey + ", timeout param is 14400s");
                    try {
                        this.taskResult = super.doTaskJob();
                        if (((BusinessTaskResult)this.taskResult).getCode() == 0L) {
                            // empty if block
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        this.taskResult = BusinessTaskResult.failed(e);
                        throw e;
                    }
                    finally {
                        logger.info("[FI-PA] TaskExecute After exec task job, into finally block");
                    }
                }
                PABusinessException paBusinessException = new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "Get model task lock failed, please try later");
                this.taskResult = BusinessTaskResult.failed((Throwable)((Object)paBusinessException));
                throw paBusinessException;
            }
            finally {
                if (this.taskLock != null) {
                    this.taskLock.unlock();
                }
            }
        }
    }

    private ConfigDTOManager getConfigDTOManager() {
        Long analysisModelId = this.executionLogDTO.getAnalysisModel();
        Long logId = this.executionLogDTO.getId();
        return new ConfigDTOManager().putConfig(ConfigDTOEnum.MODEL, new AnalysisModelConfigDTO(analysisModelId)).putConfig(ConfigDTOEnum.LOG, new LogConfigDTO(logId));
    }
}

