/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.engine.action.AdjustAction;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.model.IRule;
import kd.fi.pa.engine.service.RuleServiceFactory;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.IDataAbstractWorkTask;
import kd.fi.pa.helper.PALogHelper;

public class PABusinessSimpleAdjustTask
extends IDataAbstractWorkTask<BusinessTaskResult> {
    private static final Log logger = LogFactory.getLog(PABusinessSimpleAdjustTask.class);
    protected Long executeAdLogId;
    protected Long adjustId;
    protected Long executeLogId;

    public PABusinessSimpleAdjustTask(Object taskKey, Long executeAdLogId, Long adjustId, Long executeLogId) {
        super(taskKey);
        this.executeAdLogId = executeAdLogId;
        this.adjustId = adjustId;
        this.executeLogId = executeLogId;
    }

    protected BusinessTaskResult doTaskJob() {
        logger.info("[FI-PA] TaskExecute PABusinessSimpleAdjustTask doTaskJob begin");
        ExecutorLog executorLog = this.getExecutorLog();
        try {
            IRule adjustRule = RuleServiceFactory.getAdjustRule().createModel(this.adjustId);
            AdjustAction action = new AdjustAction();
            action.execute(adjustRule, executorLog);
            this.taskResult = BusinessTaskResult.succeed(executorLog);
        }
        catch (Exception e) {
            this.onException(e);
            this.taskResult = BusinessTaskResult.failed(e);
        }
        logger.info("[FI-PA] TaskExecute PABusinessSimpleAdjustTask doTaskJob end");
        return (BusinessTaskResult)this.taskResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateTaskStageCode(int newStageCode) {
        super.updateTaskStageCode(newStageCode);
        try (TXHandle h = TX.notSupported((String)"updateExecuteRuleLogStatus");){
            switch (newStageCode) {
                case 2: {
                    PALogHelper.updateExecuteAdjustLogStatus((Object)this.executeAdLogId, (String)PASyncLogStatusEnum.PROCESSING.getCodeString(), (Long)System.currentTimeMillis());
                    return;
                }
                case 9: {
                    PALogHelper.updateExecuteAdjustLogStatus((Object)this.executeAdLogId, (String)((BusinessTaskResult)this.taskResult).getLogStatus());
                    return;
                }
                case -9: 
                case 10: {
                    PALogHelper.updateExecuteAdjustLogStatus((Object)this.executeAdLogId, (String)PASyncLogStatusEnum.FAILURE.getCodeString());
                    return;
                }
            }
            return;
        }
    }

    protected boolean onException(Throwable exception) {
        if (logger.isErrorEnabled()) {
            logger.error(String.format("[FI-PA] TaskExecute Error PABusinessSimpleAdjustTask Msg=%s", exception.getMessage()), exception);
        }
        return this.exceptionListener == null || this.exceptionListener.onError(exception);
    }

    private ExecutorLog getExecutorLog() {
        ExecutorLog executorLog = ExecutorLog.getInstance();
        executorLog.setLogId(this.executeAdLogId);
        return executorLog;
    }
}

