/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.action.BatchWriteOffAction;
import kd.fi.pa.engine.action.IPaAction;
import kd.fi.pa.engine.action.OnceWriteOffAction;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.model.IRule;
import kd.fi.pa.engine.model.OnceWriteOffRule;
import kd.fi.pa.engine.service.RuleServiceFactory;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.IDataAbstractWorkTask;
import kd.fi.pa.enums.WriteOffTypeEnum;

public class PABusinessSimpleOffTask
extends IDataAbstractWorkTask<BusinessTaskResult> {
    private static final Log logger = LogFactory.getLog(PABusinessSimpleOffTask.class);
    protected ExecutionLogDTO executionLogDTO;

    public PABusinessSimpleOffTask(Object taskKey, ExecutionLogDTO executionLogDTO) {
        super(taskKey);
        this.executionLogDTO = executionLogDTO;
    }

    protected BusinessTaskResult doTaskJob() {
        logger.info("[FI-PA] TaskExecute PABusinessSimpleOffTask doTaskJob begin");
        ExecutorLog executorLog = this.getExecutorLog();
        try (TXHandle h = TX.required((String)"offExecute");){
            try {
                IRule offRule = this.getRule();
                if (offRule != null) {
                    IPaAction action = this.createAction(offRule);
                    action.execute(offRule, executorLog);
                    this.taskResult = BusinessTaskResult.succeed(executorLog);
                }
            }
            catch (Exception e) {
                this.onException(e);
                h.markRollback();
                this.taskResult = BusinessTaskResult.failed(e);
            }
        }
        logger.info("[FI-PA] TaskExecute PABusinessSimpleOffTask doTaskJob end");
        return (BusinessTaskResult)this.taskResult;
    }

    protected boolean onException(Throwable exception) {
        if (logger.isErrorEnabled()) {
            logger.error(String.format("[FI-PA] TaskExecute Error PABusinessSimpleOffTask Msg=%s", exception.getMessage()), exception);
        }
        return this.exceptionListener == null || this.exceptionListener.onError(exception);
    }

    private IRule getRule() {
        char offType = this.executionLogDTO.getWriteOffType();
        if (WriteOffTypeEnum.SINGLE_RULE.getCode() == offType || WriteOffTypeEnum.SINGLE_ADJUST.getCode() == offType) {
            return RuleServiceFactory.getWriteOffRuleOnce().createModel(this.executionLogDTO);
        }
        if (WriteOffTypeEnum.BATCH.getCode() == offType) {
            return RuleServiceFactory.getBatchWriteOffRule().createModel(this.executionLogDTO);
        }
        return null;
    }

    private ExecutorLog getExecutorLog() {
        ExecutorLog executorLog = ExecutorLog.getInstance();
        executorLog.setLogId(this.executionLogDTO.getId());
        return executorLog;
    }

    private IPaAction createAction(IRule rule) {
        if (rule instanceof OnceWriteOffRule) {
            return new OnceWriteOffAction();
        }
        return new BatchWriteOffAction();
    }
}

