/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.io.Serializable;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.cache.DistributeCacheUtil;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.engine.model.DerivationRule;
import kd.fi.pa.engine.mservice.TaskInstMService;
import kd.fi.pa.engine.service.RuleServiceFactory;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.IDataAbstractWorkTask;
import kd.fi.pa.enginealgox.model.config.AllocationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOEnum;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.DerivationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.service.AllocationAlgoXService;
import kd.fi.pa.enginealgox.service.DerivationAlgoXService;
import kd.fi.pa.enginealgox.service.SummaryCalculateAlgoXService;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enums.SubTaskInstStatusEnum;
import kd.fi.pa.helper.PALogHelper;

public class PABusinessSimpleRuleTask
extends IDataAbstractWorkTask<BusinessTaskResult> {
    private static final Log logger = LogFactory.getLog(PABusinessSimpleRuleTask.class);
    protected Long executeLogId;
    protected Long executeRuleLogId;
    protected Long ruleId;
    protected String ruleType;
    protected Long businessRuleId;
    protected Set<Long> accountIdSet;
    protected boolean isSummary;
    private Long taskInstRequestId;
    protected boolean taskInstRegistered;
    protected int taskCount;
    protected int ruleTaskIndex;
    protected String ruleTaskUUID;
    protected String ruleTaskName;
    protected int sumCalTaskIndex;
    protected String sumCalTaskUUID;
    protected String sumCalTaskName;

    public PABusinessSimpleRuleTask(Serializable taskKey, Long executeLogId, Long executeRuleId, Long ruleId, String ruleType, Long businessRuleId, Set<Long> accountIdSet, boolean isSummary, boolean taskInstRegistered, int taskCount, int ruleTaskIndex, int sumCalTaskIndex, Long taskInstRequestId, String ruleTaskUUID, String ruleTaskName, String sumCalTaskUUID, String sumCalTaskName) {
        super((Object)taskKey);
        this.executeLogId = executeLogId;
        this.executeRuleLogId = executeRuleId;
        this.ruleId = ruleId;
        this.ruleType = ruleType;
        this.businessRuleId = businessRuleId;
        this.accountIdSet = accountIdSet;
        this.isSummary = isSummary;
        this.taskInstRegistered = taskInstRegistered;
        this.taskCount = taskCount;
        this.ruleTaskIndex = ruleTaskIndex;
        this.sumCalTaskIndex = sumCalTaskIndex;
        this.taskInstRequestId = taskInstRequestId;
        this.ruleTaskUUID = ruleTaskUUID;
        this.ruleTaskName = ruleTaskName;
        this.sumCalTaskUUID = sumCalTaskUUID;
        this.sumCalTaskName = sumCalTaskName;
    }

    protected BusinessTaskResult doTaskJob() {
        logger.info(String.format("[FI-PA] TaskExecute PABusinessSimpleRuleTask doTaskJob begin simpleTask:%s", new Object[]{this}));
        this.execute();
        logger.info(String.format("[FI-PA] TaskExecute PABusinessSimpleRuleTask doTaskJob end simpleTask:%s", new Object[]{this}));
        return (BusinessTaskResult)this.taskResult;
    }

    protected void updateTaskStageCode(int newStageCode) {
        super.updateTaskStageCode(newStageCode);
        switch (newStageCode) {
            case 2: {
                PALogHelper.updateExecuteRuleLogStatus((Object)this.executeRuleLogId, (String)PASyncLogStatusEnum.PROCESSING.getCodeString(), (Long)System.currentTimeMillis());
                break;
            }
            case 9: {
                PALogHelper.updateExecuteRuleLogStatus((Object)this.executeRuleLogId, (String)((BusinessTaskResult)this.taskResult).getLogStatus());
                break;
            }
            case -9: 
            case 10: {
                PALogHelper.updateExecuteRuleLogStatus((Object)this.executeRuleLogId, (String)PASyncLogStatusEnum.FAILURE.getCodeString());
                break;
            }
        }
    }

    protected boolean onException(Throwable exception) {
        if (logger.isErrorEnabled()) {
            logger.error(String.format("[FI-PA] TaskExecute Error PABusinessSimpleRuleTask Msg=%s", exception.getMessage()), exception);
        }
        return this.exceptionListener == null || this.exceptionListener.onError(exception);
    }

    protected void execute() {
        ConfigDTOManager configDTOManager = this.getConfigDTOManager();
        if (configDTOManager == null) {
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "configDTOManager is null");
        }
        if (!this.taskInstRegistered) {
            this.ruleTaskUUID = "pa_business_ruleexec";
            this.ruleTaskName = ResManager.loadKDString((String)"\u76c8\u5229\u80fd\u529b\u5206\u6790\u4e1a\u52a1\u5904\u7406-\u89c4\u5219\u6267\u884c", (String)"PABusinessSimpleRuleTask_0", (String)"fi-pa-business", (Object[])new Object[0]);
            this.sumCalTaskUUID = "pa_business_sumcal";
            this.sumCalTaskName = ResManager.loadKDString((String)"\u76c8\u5229\u80fd\u529b\u5206\u6790\u4e1a\u52a1\u5904\u7406-\u6c47\u603b\u8ba1\u7b97", (String)"PABusinessSimpleRuleTask_1", (String)"fi-pa-business", (Object[])new Object[0]);
        }
        try {
            this.taskInstUpdate(this.ruleTaskIndex, this.taskCount, SubTaskInstStatusEnum.DOING, null, this.taskInstRequestId);
            this.ruleExec(configDTOManager);
            this.taskInstUpdate(this.ruleTaskIndex, this.taskCount, SubTaskInstStatusEnum.DONE, null, this.taskInstRequestId);
            this.taskResult = BusinessTaskResult.succeed();
        }
        catch (Exception e) {
            this.taskInstUpdate(this.ruleTaskIndex, this.taskCount, SubTaskInstStatusEnum.FAILED, e.getMessage(), this.taskInstRequestId);
            this.onException(e);
            this.taskResult = BusinessTaskResult.failed(e);
            return;
        }
        if (this.isSummary) {
            try {
                this.taskInstUpdate(this.sumCalTaskIndex, this.taskCount, SubTaskInstStatusEnum.DOING, null, this.taskInstRequestId);
                this.sumCalExec(configDTOManager);
                this.taskInstUpdate(this.sumCalTaskIndex, this.taskCount, SubTaskInstStatusEnum.DONE, null, this.taskInstRequestId);
                this.taskResult = BusinessTaskResult.succeed();
            }
            catch (Exception e) {
                this.taskInstUpdate(this.sumCalTaskIndex, this.taskCount, SubTaskInstStatusEnum.FAILED, e.getMessage(), this.taskInstRequestId);
                this.onException(e);
                this.taskResult = BusinessTaskResult.failed(e);
            }
        }
    }

    private void ruleExec(ConfigDTOManager configDTOManager) {
        LogConfigDTO logConfigDTO = (LogConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.LOG);
        logConfigDTO.setAccountIdSet(this.accountIdSet);
        logConfigDTO.setRuleExecutionLogId(this.executeRuleLogId);
        switch (this.ruleType) {
            case "A": {
                DerivationRule derivationRule = (DerivationRule)RuleServiceFactory.getDerivationRule().createModel(this.ruleId);
                DerivationRuleConfigDTO derivationRuleConfigDTO = new DerivationRuleConfigDTO(derivationRule);
                configDTOManager.putConfig(ConfigDTOEnum.DERIVATION, derivationRuleConfigDTO);
                DerivationAlgoXService derivationAlgoXService = new DerivationAlgoXService();
                derivationAlgoXService.execute(configDTOManager, this.ruleTaskUUID, this.ruleTaskName);
                break;
            }
            case "B": {
                AllocationRule allocationRule = (AllocationRule)RuleServiceFactory.getAllocationRule().createModel(this.ruleId);
                AllocationRuleConfigDTO allocationRuleConfigDTO = new AllocationRuleConfigDTO(allocationRule);
                configDTOManager.putConfig(ConfigDTOEnum.ALLOCATION, allocationRuleConfigDTO);
                AllocationAlgoXService allocationAlgoXService = new AllocationAlgoXService();
                allocationAlgoXService.execute(configDTOManager, this.ruleTaskUUID, this.ruleTaskName);
                break;
            }
        }
    }

    private void sumCalExec(ConfigDTOManager configDTOManager) {
        if (this.isSummary) {
            SummaryCalculateAlgoXService summaryCalculateAlgoXService = new SummaryCalculateAlgoXService();
            summaryCalculateAlgoXService.execute(configDTOManager, this.sumCalTaskUUID, this.sumCalTaskName);
        }
    }

    private void taskInstUpdate(int subTaskIndex, int subTaskCount, SubTaskInstStatusEnum subTaskInstStatusEnum, String subTaskComment, Long taskInstRequestId) {
        if (this.taskInstRegistered) {
            TaskInstMService.batchUpdateSubTask(taskInstRequestId, subTaskCount, subTaskIndex, subTaskInstStatusEnum.getCodeString(), subTaskComment);
        }
    }

    private ConfigDTOManager getConfigDTOManager() {
        String configKey = FieldUtil.configFormat(this.executeLogId.toString());
        logger.info("[FI-PA] PABusinessSimpleRuleTask.executeAlgoX, configkey is " + configKey);
        DistributeCacheUtil.expireAfter((String)configKey, (int)14400);
        byte[] configDTOManagerBytes = (byte[])DistributeCacheUtil.get((String)configKey, byte[].class);
        if (configDTOManagerBytes == null) {
            return null;
        }
        return (ConfigDTOManager)SerializationUtils.fromByte((byte[])configDTOManagerBytes);
    }
}

