/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.warpper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.algox.PARowXProcessor;

public class ReceiverRelateGroupWrapper
implements Serializable {
    private String[] groupDims;
    private Map<String, List<Map<String, String>>> classifyMap;
    private static final int SCALE = 8;
    private static final String HUNDRED = "100";
    private static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;
    private static final String GROUP_FLAG = "nogroup";

    public ReceiverRelateGroupWrapper(Set<String> groupDimNums) {
        if (!CollectionUtils.isEmpty(groupDimNums)) {
            this.groupDims = groupDimNums.toArray(new String[0]);
        }
    }

    public ReceiverRelateGroupWrapper(Set<String> groupDimNums, List<Map<String, String>> receiverList) {
        this(groupDimNums);
        if (this.noGroup()) {
            this.classifyMap = new HashMap<String, List<Map<String, String>>>(2);
            this.classifyMap.put(GROUP_FLAG, receiverList);
        } else {
            this.classifyMap = this.classifyReceiverString(receiverList);
        }
    }

    public List<Map<String, String>> buildRate(List<Map<String, Object>> actionList, List<String> recvDimNums, BigDecimal total) {
        ArrayList<Map<String, String>> receiverList = new ArrayList<Map<String, String>>(16);
        if (CollectionUtils.isEmpty(actionList)) {
            return receiverList;
        }
        if (this.noGroup()) {
            this.classifyBuildRate(actionList, recvDimNums, total, receiverList);
        } else {
            this.buildGroupRate(actionList, recvDimNums, receiverList);
        }
        return receiverList;
    }

    private void buildGroupRate(List<Map<String, Object>> actionList, List<String> recvDimNums, List<Map<String, String>> receiverList) {
        HashMap<String, List> classifyMap = new HashMap<String, List>(16);
        for (Map<String, Object> newMap : actionList) {
            String rowKey = this.buildKey(newMap);
            List classifyList = classifyMap.computeIfAbsent(rowKey, k -> new ArrayList(16));
            classifyList.add(newMap);
        }
        for (List valueList : classifyMap.values()) {
            BigDecimal classifyTotal = BigDecimal.ZERO;
            for (Map newMap : valueList) {
                Object value = newMap.get("factorValue");
                classifyTotal = classifyTotal.add((BigDecimal)value);
            }
            this.classifyBuildRate(valueList, recvDimNums, classifyTotal, receiverList);
        }
    }

    private Map<String, List<Map<String, String>>> classifyReceiverString(List<Map<String, String>> actionList) {
        HashMap<String, List<Map<String, String>>> classifyMap = new HashMap<String, List<Map<String, String>>>(actionList.size());
        for (Map<String, String> newMap : actionList) {
            String rowKey = this.buildKey(newMap);
            List classifyList = classifyMap.computeIfAbsent(rowKey, k -> new ArrayList(16));
            classifyList.add(newMap);
        }
        return classifyMap;
    }

    private void classifyBuildRate(List<Map<String, Object>> valueList, List<String> recvDimNums, BigDecimal classifyTotal, List<Map<String, String>> receiverList) {
        if (BigDecimal.ZERO.compareTo(classifyTotal) == 0) {
            return;
        }
        ArrayList subReceiverList = new ArrayList(16);
        for (Map<String, Object> newMap : valueList) {
            HashMap<String, String> result = new HashMap<String, String>(16);
            Object factorValue = newMap.remove("factorValue");
            BigDecimal rate = ((BigDecimal)factorValue).multiply(new BigDecimal(HUNDRED)).divide(classifyTotal, 8, ROUNDING_MODE);
            result.put("sharerate", rate.toString());
            for (String field : recvDimNums) {
                result.put(field, String.valueOf(newMap.get(field)));
            }
            subReceiverList.add(result);
        }
        receiverList.addAll(subReceiverList);
    }

    private String buildKey(Map<String, ?> newMap) {
        StringBuilder sb = new StringBuilder();
        for (String groupDim : this.groupDims) {
            sb.append(newMap.get(groupDim)).append(',');
        }
        return sb.toString();
    }

    public String[] getGroupDims() {
        return this.groupDims;
    }

    public void setGroupDims(String[] groupDims) {
        this.groupDims = groupDims;
    }

    public Map<String, List<Map<String, String>>> getClassifyMap() {
        return this.classifyMap;
    }

    public void setClassifyMap(Map<String, List<Map<String, String>>> classifyMap) {
        this.classifyMap = classifyMap;
    }

    private boolean noGroup() {
        return this.groupDims == null || this.groupDims.length == 0;
    }

    public boolean isEmpty() {
        if (this.noGroup()) {
            return this.classifyMap == null || CollectionUtils.isEmpty((Collection)this.classifyMap.get(GROUP_FLAG));
        }
        return false;
    }

    public List<Map<String, String>> achieveReceiver(PARowXProcessor sourcePARowXProcessor) {
        if (this.noGroup()) {
            return this.classifyMap.get(GROUP_FLAG);
        }
        StringBuilder sb = new StringBuilder();
        for (String groupDim : this.groupDims) {
            sb.append(sourcePARowXProcessor.getValue(groupDim)).append(',');
        }
        String key = sb.toString();
        return this.classifyMap.get(key);
    }
}

