/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.allocation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.algox.PAIdCreator;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;
import kd.fi.pa.engine.executor.allocation.TailDifferenceProcessor;
import kd.fi.pa.engine.warpper.ReceiverRelateGroupWrapper;
import kd.fi.pa.enums.AllocationFlagEnum;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.utils.AnalysisModelHashUtil;

public class AllocationDetailFlatMapFunction
extends FlatMapFunction {
    private static final long serialVersionUID = -3757237256159324480L;
    private static final BigDecimal oneHundred = new BigDecimal(100);
    private final PARowMetaBuilder rowMetaBuilder;
    private final PARowMetaBuilder resultRowMetaBuilder;
    private final PAIdCreator idCreator;
    private final Long executionLogId;
    private final Long ruleExecutionLogId;
    private final BigDecimal sendRate;
    private final List<String> modelHashDimensionNumberList;
    private final List<String> allocationMeasureNumberList;
    private final Set<String> allocationMeasureNumberSet;
    private final Map<String, Integer> modelMeasureNumberMap;
    private final ReceiverRelateGroupWrapper receiverRelateGroupWrapper;
    private final Map<String, Set<String>> ordCalMeaMappingMap;
    private final TailDifferenceProcessor tailDifferenceProcessor;
    private final boolean allocationFlag;
    private final int rowCount;
    private final Map<String, Map<String, Object>> allocationFlagMap;

    public AllocationDetailFlatMapFunction(RowMeta rowMeta, Long executionLogId, Long ruleExecutionLogId, BigDecimal sendRate, List<String> allocationMeasureNumberList, ReceiverRelateGroupWrapper receiverRelateGroupWrapper, List<String> modelHashDimensionNumberList, Map<String, Integer> modelMeasureNumberMap, Map<String, Set<String>> ordCalMeaMappingMap, TailDifferenceProcessor tailDifferenceProcessor, boolean allocationFlag, int rowCount, Map<String, Map<String, Object>> allocationFlagMap) {
        this.executionLogId = executionLogId;
        this.ruleExecutionLogId = ruleExecutionLogId;
        this.sendRate = sendRate;
        this.allocationMeasureNumberList = allocationMeasureNumberList;
        this.allocationMeasureNumberSet = new HashSet<String>(allocationMeasureNumberList);
        this.receiverRelateGroupWrapper = receiverRelateGroupWrapper;
        this.modelHashDimensionNumberList = modelHashDimensionNumberList;
        this.modelMeasureNumberMap = modelMeasureNumberMap;
        this.ordCalMeaMappingMap = ordCalMeaMappingMap;
        this.rowMetaBuilder = new PARowMetaBuilder(rowMeta);
        this.resultRowMetaBuilder = this.initResultRowMetaBuilder();
        this.idCreator = new PAIdCreator();
        this.tailDifferenceProcessor = tailDifferenceProcessor;
        this.allocationFlag = allocationFlag;
        this.rowCount = rowCount;
        this.allocationFlagMap = allocationFlagMap;
    }

    public void flatMap(RowX rowX, Collector collector) {
        if (this.receiverRelateGroupWrapper.isEmpty()) {
            return;
        }
        PARowXProcessor sourceRowXProcessor = this.rowMetaBuilder.create(rowX);
        List<Map<String, String>> receiverList = this.receiverRelateGroupWrapper.achieveReceiver(sourceRowXProcessor);
        if (CollectionUtils.isEmpty(receiverList)) {
            return;
        }
        List<BigDecimal> receiverRates = this.getReceiverRates(receiverList);
        this.createAllocationData(sourceRowXProcessor, collector, receiverList, receiverRates);
        this.createOffsetData(sourceRowXProcessor, collector);
        this.updateSummaryData(sourceRowXProcessor, collector);
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMetaBuilder.getRowMeta();
    }

    private List<BigDecimal> getReceiverRates(List<Map<String, String>> receiverList) {
        ArrayList<BigDecimal> receiverRates = new ArrayList<BigDecimal>(receiverList.size());
        block0: for (int i = 0; i < receiverList.size(); ++i) {
            Map<String, String> receiverMap = receiverList.get(i);
            for (Map.Entry<String, String> entry : receiverMap.entrySet()) {
                String key = entry.getKey();
                if (!"sharerate".equals(key)) continue;
                receiverRates.add(new BigDecimal(entry.getValue()));
                continue block0;
            }
        }
        return receiverRates;
    }

    private void createAllocationData(PARowXProcessor sourceRowXProcessor, Collector collector, List<Map<String, String>> receiverList, List<BigDecimal> receiverRates) {
        Date curDate = new Date();
        HashMap<String, BigDecimal> ordAllocateMeasureAmountMap = new HashMap<String, BigDecimal>(this.allocationMeasureNumberSet.size());
        HashMap<String, List<BigDecimal>> receiverAmtMap = new HashMap<String, List<BigDecimal>>(this.allocationMeasureNumberSet.size());
        int tailDifferenceReceiverIndex = this.tailDifferenceProcessor == null ? -1 : this.tailDifferenceProcessor.getTailDifferenceReceiverIndex(receiverRates);
        PARowXProcessor tailDifferenceReceiverRowXProcessor = null;
        Object summaryId = sourceRowXProcessor.getValue("id");
        for (int i = 0; i < receiverList.size(); ++i) {
            long detailId = this.idCreator.getId();
            PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(sourceRowXProcessor);
            this.processAllocationFlagDimensionValue(resultRowXProcessor);
            this.processAllocateDimensionValue(receiverList.get(i), resultRowXProcessor);
            boolean allMeasureZero = true;
            for (String measureNumber : this.modelMeasureNumberMap.keySet()) {
                if (this.allocationMeasureNumberSet.contains(measureNumber)) {
                    BigDecimal ordAllocateMeasureAmount = ordAllocateMeasureAmountMap.computeIfAbsent(measureNumber, key -> this.calculateOffsetAmt((BigDecimal)sourceRowXProcessor.getValue((String)key), measureNumber));
                    BigDecimal allocatedMeasureAmount = this.calculateAllocateAmt(ordAllocateMeasureAmount, receiverRates.get(i), measureNumber);
                    List receiverAmts = receiverAmtMap.computeIfAbsent(measureNumber, key -> new ArrayList(receiverRates.size()));
                    receiverAmts.add(allocatedMeasureAmount);
                    if (allocatedMeasureAmount.compareTo(BigDecimal.ZERO) != 0) {
                        allMeasureZero = false;
                    }
                    resultRowXProcessor.updateValue(measureNumber, allocatedMeasureAmount);
                    continue;
                }
                resultRowXProcessor.updateValue(measureNumber, BigDecimal.ZERO);
            }
            RowX allocationRowX = resultRowXProcessor.updateValue("id", detailId).updateValue("collectstatus", PACollectStatusEnum.DETAIL.getLongCode()).updateValue("datastatus", DataStatusEnum.ALLOCATE.getLongCode()).updateValue("operationstatus", OperationStatusEnum.UNUSED.getLongCode()).updateValue("del", -1L).updateValue("createtime", curDate).updateValue("sourceformid", " ").updateValue("sourcebillid", 0L).updateValue("execlogid", this.executionLogId).updateValue("subexeclogid", this.ruleExecutionLogId).updateValue("execparentbillid", summaryId).updateValue("createstamp", curDate.getTime()).getRowX();
            int index = resultRowXProcessor.getRowMeta().getFieldIndex("dimhash", false);
            if (index >= 0) {
                allocationRowX.set(index, (Object)AnalysisModelHashUtil.calculateDimHash((RowMeta)resultRowXProcessor.getRowMeta(), (RowX)allocationRowX, this.modelHashDimensionNumberList));
            }
            if (tailDifferenceReceiverIndex != i) {
                if (allMeasureZero) continue;
                collector.collect(allocationRowX);
                continue;
            }
            tailDifferenceReceiverRowXProcessor = resultRowXProcessor;
        }
        this.processAllocateTailDifference(tailDifferenceReceiverRowXProcessor, collector, receiverRates, ordAllocateMeasureAmountMap, receiverAmtMap);
    }

    private void processAllocationFlagDimensionValue(PARowXProcessor resultRowXProcessor) {
        if (!this.allocationFlag) {
            return;
        }
        if (this.allocationFlagMap == null || this.allocationFlagMap.isEmpty()) {
            return;
        }
        for (int i = 1; i <= this.rowCount; ++i) {
            String key = String.valueOf(i);
            Map<String, Object> valueMap = this.allocationFlagMap.get(key);
            if (valueMap == null) continue;
            String flagType = (String)valueMap.get("flagtype");
            String targetDimNumber = (String)valueMap.get("targetdimnumber");
            String sourceDimNumber = (String)valueMap.get("sourcedimnumber");
            Object value = valueMap.get("value");
            if (StringUtils.equals((CharSequence)AllocationFlagEnum.SENDER.getCode(), (CharSequence)flagType) && !StringUtils.isEmpty((CharSequence)sourceDimNumber)) {
                Object sourceValue = resultRowXProcessor.getValue(sourceDimNumber);
                resultRowXProcessor.updateValue(targetDimNumber, sourceValue);
            }
            if (!StringUtils.equals((CharSequence)AllocationFlagEnum.VALUE.getCode(), (CharSequence)flagType) || value == null) continue;
            resultRowXProcessor.updateValue(targetDimNumber, value);
        }
    }

    private void processAllocateDimensionValue(Map<String, String> receiverMap, PARowXProcessor resultRowXProcessor) {
        for (Map.Entry<String, String> entry : receiverMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("sharerate".equals(key)) continue;
            if (resultRowXProcessor.getValue(key) instanceof Long && !StringUtils.isBlank((CharSequence)value)) {
                resultRowXProcessor.updateValue(key, Long.valueOf(value));
                continue;
            }
            resultRowXProcessor.updateValue(key, value);
        }
    }

    private void processAllocateTailDifference(PARowXProcessor tailDifferenceReceiverRowXProcessor, Collector collector, List<BigDecimal> receiverRates, Map<String, BigDecimal> ordAllocateMeasureAmountMap, Map<String, List<BigDecimal>> receiverAmtMap) {
        if (tailDifferenceReceiverRowXProcessor == null) {
            return;
        }
        boolean allMeasureZero = true;
        for (String measureNumber : this.allocationMeasureNumberSet) {
            BigDecimal tailDifferenceAmount = this.tailDifferenceProcessor.calculateTailDifference(receiverRates, receiverAmtMap.get(measureNumber), ordAllocateMeasureAmountMap.get(measureNumber));
            BigDecimal ordMeasureAmount = (BigDecimal)tailDifferenceReceiverRowXProcessor.getValue(measureNumber);
            BigDecimal finalMeasureAmount = ordMeasureAmount.add(tailDifferenceAmount);
            if (finalMeasureAmount.compareTo(BigDecimal.ZERO) != 0) {
                allMeasureZero = false;
            }
            tailDifferenceReceiverRowXProcessor.updateValue(measureNumber, finalMeasureAmount);
        }
        if (!allMeasureZero) {
            collector.collect(tailDifferenceReceiverRowXProcessor.getRowX());
        }
    }

    private void createOffsetData(PARowXProcessor sourceRowXProcessor, Collector collector) {
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(sourceRowXProcessor);
        long detailId = this.idCreator.getId();
        Object summaryId = sourceRowXProcessor.getValue("id");
        Date curDate = new Date();
        for (String measureNumber : this.modelMeasureNumberMap.keySet()) {
            if (this.allocationMeasureNumberSet.contains(measureNumber)) {
                BigDecimal measureAmount = (BigDecimal)resultRowXProcessor.getValue(measureNumber);
                BigDecimal offsetMeasureAmount = this.calculateOffsetAmt(measureAmount, measureNumber);
                resultRowXProcessor.updateValue(measureNumber, offsetMeasureAmount.negate());
                continue;
            }
            resultRowXProcessor.updateValue(measureNumber, BigDecimal.ZERO);
        }
        RowX offSetRowX = resultRowXProcessor.updateValue("id", detailId).updateValue("collectstatus", PACollectStatusEnum.DETAIL.getLongCode()).updateValue("datastatus", DataStatusEnum.OFF_ALLOCATE.getLongCode()).updateValue("operationstatus", OperationStatusEnum.USED.getLongCode()).updateValue("del", -1L).updateValue("createtime", curDate).updateValue("summaryid", summaryId).updateValue("sourceformid", " ").updateValue("sourcebillid", 0L).updateValue("execlogid", this.executionLogId).updateValue("subexeclogid", this.ruleExecutionLogId).updateValue("execparentbillid", summaryId).updateValue("createstamp", curDate.getTime()).getRowX();
        int index = resultRowXProcessor.getRowMeta().getFieldIndex("dimhash", false);
        if (index >= 0) {
            offSetRowX.set(index, (Object)AnalysisModelHashUtil.calculateDimHash((RowMeta)resultRowXProcessor.getRowMeta(), (RowX)offSetRowX, this.modelHashDimensionNumberList));
        }
        collector.collect(offSetRowX);
    }

    private void updateSummaryData(PARowXProcessor sourceRowXProcessor, Collector collector) {
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(sourceRowXProcessor);
        for (String ordMeasureNumber : this.allocationMeasureNumberList) {
            BigDecimal ordMeasureAmount = (BigDecimal)resultRowXProcessor.getValue(ordMeasureNumber);
            BigDecimal offsetMeasureAmount = this.calculateOffsetAmt(ordMeasureAmount, ordMeasureNumber);
            resultRowXProcessor.updateValue(ordMeasureNumber, ordMeasureAmount.subtract(offsetMeasureAmount));
            Set<String> calMeasureSet = this.ordCalMeaMappingMap.get(ordMeasureNumber);
            if (calMeasureSet == null) continue;
            for (String calMeasureNumber : calMeasureSet) {
                BigDecimal calMeasureAmount = (BigDecimal)resultRowXProcessor.getValue(calMeasureNumber);
                if (calMeasureAmount == null) continue;
                resultRowXProcessor.updateValue(calMeasureNumber, calMeasureAmount.subtract(offsetMeasureAmount));
            }
        }
        collector.collect(resultRowXProcessor.getRowX());
    }

    private BigDecimal calculateAllocateAmt(BigDecimal amt, BigDecimal allocateRate, String measureNumber) {
        Integer precision = this.modelMeasureNumberMap.get(measureNumber);
        return amt.multiply(allocateRate).divide(oneHundred, (int)precision, RoundingMode.HALF_UP);
    }

    private BigDecimal calculateOffsetAmt(BigDecimal amt, String measureNumber) {
        if (this.sendRate != null && this.sendRate.compareTo(BigDecimal.ZERO) > 0 && this.sendRate.compareTo(oneHundred) < 0) {
            Integer precision = this.modelMeasureNumberMap.get(measureNumber);
            return amt.multiply(this.sendRate).divide(oneHundred, (int)precision, RoundingMode.HALF_UP);
        }
        return amt;
    }

    private PARowMetaBuilder initResultRowMetaBuilder() {
        Field summaryIdField = new Field("summaryid", (DataType)DataType.LongType);
        Field sourceBillIdField = new Field("sourcebillid", (DataType)DataType.LongType);
        Field sourceFormIdField = new Field("sourceformid", (DataType)DataType.StringType);
        Field execLogIdField = new Field("execlogid", (DataType)DataType.LongType);
        Field subExecLogIdField = new Field("subexeclogid", (DataType)DataType.LongType);
        Field execParentBillId = new Field("execparentbillid", (DataType)DataType.LongType);
        Field createStamp = new Field("createstamp", (DataType)DataType.LongType);
        return this.rowMetaBuilder.addFields(summaryIdField, sourceBillIdField, sourceFormIdField, execLogIdField, subExecLogIdField, execParentBillId, createStamp);
    }
}

