/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.derivation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.pa.algox.PAIdCreator;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;
import kd.fi.pa.common.util.ScriptEngine;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.utils.AnalysisModelHashUtil;

public class DerivationCustomFlatMapFunction
extends FlatMapFunction {
    private static final long serialVersionUID = 4239259319641858965L;
    private final PARowMetaBuilder modelRowMetaBuilder;
    private final PARowMetaBuilder resultRowMetaBuilder;
    private final PAIdCreator idCreator;
    private final Long executionLogId;
    private final Long ruleExecutionLogId;
    private final List<String> modelMeasureNumberList;
    private final List<String> modelHashDimensionNumberList;
    private final List<String> derivationMeasureNumberList;
    private final Map<String, Set<String>> ordCalMeaMappingMap;
    private final int rowCount;
    private final Map<String, Set<String>> customDimMap;
    private final Map<String, Map<String, Object>> customEntryMap;

    public DerivationCustomFlatMapFunction(RowMeta modelRowMeta, Long executionLogId, Long ruleExecutionLogId, List<String> modelMeasureNumberList, List<String> modelHashDimensionNumberList, List<String> derivationMeasureNumberList, Map<String, Set<String>> ordCalMeaMappingMap, int rowCount, Map<String, Set<String>> customDimMap, Map<String, Map<String, Object>> customEntryMap) {
        this.modelRowMetaBuilder = new PARowMetaBuilder(modelRowMeta);
        this.resultRowMetaBuilder = this.initResultRowMetaBuilder();
        this.idCreator = new PAIdCreator();
        this.executionLogId = executionLogId;
        this.ruleExecutionLogId = ruleExecutionLogId;
        this.modelMeasureNumberList = modelMeasureNumberList;
        this.modelHashDimensionNumberList = modelHashDimensionNumberList;
        this.derivationMeasureNumberList = derivationMeasureNumberList;
        this.ordCalMeaMappingMap = ordCalMeaMappingMap;
        this.rowCount = rowCount;
        this.customDimMap = customDimMap;
        this.customEntryMap = customEntryMap;
    }

    public void flatMap(RowX modelRowX, Collector collector) {
        PARowXProcessor modelRowXProcessor = this.modelRowMetaBuilder.create(modelRowX);
        boolean updateFlag = this.createDerivationData(modelRowXProcessor, collector);
        if (updateFlag) {
            this.createOffsetData(modelRowXProcessor, collector);
            this.updateSummaryData(modelRowXProcessor, collector);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMetaBuilder.getRowMeta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDerivationData(PARowXProcessor modelRowXProcessor, Collector collector) {
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(modelRowXProcessor);
        long detailId = this.idCreator.getId();
        Object summaryId = modelRowXProcessor.getValue("id");
        Date curDate = new Date();
        boolean updateFlag = false;
        ScriptEngine scriptEngine = ScriptEngine.getEngine();
        try {
            for (int i = 1; i <= this.rowCount; ++i) {
                Map<String, Object> dataValueMap;
                Set fieldNameSet;
                Map<String, Object> fieldValueMap;
                String scriptStr;
                Boolean result;
                String key = String.valueOf(i);
                Map<String, Object> valueMap = this.customEntryMap.get(key);
                if (valueMap == null || (result = (Boolean)scriptEngine.runScript(scriptStr = (String)valueMap.get("scriptStr"), fieldValueMap = this.createScriptFieldValueMap(resultRowXProcessor, fieldNameSet = (Set)valueMap.get("fieldNameSet")))) == null || !result.booleanValue()) continue;
                String targetDimNumber = (String)valueMap.get("targetDimNumber");
                String sourceDimNumber = (String)valueMap.get("sourceDimNumber");
                Set<String> sourceDimSet = this.customDimMap.get(sourceDimNumber);
                Set<String> targetDimSet = this.customDimMap.get(targetDimNumber);
                Object defaultValue = valueMap.get("defaultValue");
                if (!StringUtils.isEmpty((CharSequence)sourceDimNumber)) {
                    Object sourceValueSpecial = resultRowXProcessor.getValueSpecial(sourceDimNumber);
                    if (sourceValueSpecial != null) {
                        if (sourceDimSet != null && !sourceDimSet.isEmpty()) {
                            dataValueMap = this.createDataValueMap(resultRowXProcessor, sourceDimNumber, sourceDimSet, targetDimNumber, targetDimSet, null);
                            if (dataValueMap.isEmpty()) continue;
                            updateFlag = true;
                            resultRowXProcessor.updateValue(dataValueMap);
                            continue;
                        }
                        updateFlag = true;
                        resultRowXProcessor.updateValue(targetDimNumber, sourceValueSpecial);
                        continue;
                    }
                    if (defaultValue == null) continue;
                    if (defaultValue instanceof Map) {
                        Map defaultValueMap = (Map)defaultValue;
                        Map<String, Object> dataValueMap2 = this.createDataValueMap(resultRowXProcessor, null, null, targetDimNumber, targetDimSet, defaultValueMap);
                        if (dataValueMap2.isEmpty()) continue;
                        updateFlag = true;
                        resultRowXProcessor.updateValue(dataValueMap2);
                        continue;
                    }
                    updateFlag = true;
                    resultRowXProcessor.updateValue(targetDimNumber, defaultValue);
                    continue;
                }
                if (defaultValue == null) continue;
                if (defaultValue instanceof Map) {
                    Map defaultValueMap = (Map)defaultValue;
                    dataValueMap = this.createDataValueMap(resultRowXProcessor, null, null, targetDimNumber, targetDimSet, defaultValueMap);
                    updateFlag = true;
                    resultRowXProcessor.updateValue(dataValueMap);
                    continue;
                }
                updateFlag = true;
                resultRowXProcessor.updateValue(targetDimNumber, defaultValue);
            }
        }
        finally {
            scriptEngine.clear();
        }
        if (updateFlag) {
            for (String measureNumber : this.modelMeasureNumberList) {
                if (this.derivationMeasureNumberList.contains(measureNumber)) continue;
                resultRowXProcessor.updateValue(measureNumber, BigDecimal.ZERO);
            }
            RowX resultRowX = resultRowXProcessor.updateValue("id", detailId).updateValue("collectstatus", PACollectStatusEnum.DETAIL.getLongCode()).updateValue("datastatus", DataStatusEnum.DERIVE.getLongCode()).updateValue("operationstatus", OperationStatusEnum.UNUSED.getLongCode()).updateValue("del", -1L).updateValue("createtime", curDate).updateValue("sourceformid", " ").updateValue("sourcebillid", 0L).updateValue("execlogid", this.executionLogId).updateValue("subexeclogid", this.ruleExecutionLogId).updateValue("execparentbillid", summaryId).updateValue("createstamp", curDate.getTime()).getRowX();
            int index = resultRowXProcessor.getRowMeta().getFieldIndex("dimhash", false);
            if (index >= 0) {
                resultRowX.set(index, (Object)AnalysisModelHashUtil.calculateDimHash((RowMeta)resultRowXProcessor.getRowMeta(), (RowX)resultRowX, this.modelHashDimensionNumberList));
            }
            collector.collect(resultRowX);
        }
        return updateFlag;
    }

    private void createOffsetData(PARowXProcessor modelRowXProcessor, Collector collector) {
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(modelRowXProcessor);
        long detailId = this.idCreator.getId();
        Object summaryId = modelRowXProcessor.getValue("id");
        Date curDate = new Date();
        for (String measureNumber : this.modelMeasureNumberList) {
            if (this.derivationMeasureNumberList.contains(measureNumber)) {
                BigDecimal measureAmount = (BigDecimal)resultRowXProcessor.getValue(measureNumber);
                resultRowXProcessor.updateValue(measureNumber, measureAmount.negate());
                continue;
            }
            resultRowXProcessor.updateValue(measureNumber, BigDecimal.ZERO);
        }
        RowX offSetRowX = resultRowXProcessor.updateValue("id", detailId).updateValue("collectstatus", PACollectStatusEnum.DETAIL.getLongCode()).updateValue("datastatus", DataStatusEnum.OFF_DERIVE.getLongCode()).updateValue("operationstatus", OperationStatusEnum.USED.getLongCode()).updateValue("del", -1L).updateValue("createtime", curDate).updateValue("summaryid", summaryId).updateValue("sourceformid", " ").updateValue("sourcebillid", 0L).updateValue("execlogid", this.executionLogId).updateValue("subexeclogid", this.ruleExecutionLogId).updateValue("execparentbillid", summaryId).updateValue("createstamp", curDate.getTime()).getRowX();
        int index = resultRowXProcessor.getRowMeta().getFieldIndex("dimhash", false);
        if (index >= 0) {
            offSetRowX.set(index, (Object)AnalysisModelHashUtil.calculateDimHash((RowMeta)resultRowXProcessor.getRowMeta(), (RowX)offSetRowX, this.modelHashDimensionNumberList));
        }
        collector.collect(offSetRowX);
    }

    private void updateSummaryData(PARowXProcessor modelRowXProcessor, Collector collector) {
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(modelRowXProcessor);
        for (String ordMeasureNumber : this.derivationMeasureNumberList) {
            BigDecimal ordMeasureAmount = (BigDecimal)resultRowXProcessor.getValue(ordMeasureNumber);
            resultRowXProcessor.updateValue(ordMeasureNumber, BigDecimal.ZERO);
            Set<String> calMeasureSet = this.ordCalMeaMappingMap.get(ordMeasureNumber);
            if (calMeasureSet == null) continue;
            for (String calMeasureNumber : calMeasureSet) {
                BigDecimal calMeasureAmount = (BigDecimal)resultRowXProcessor.getValue(calMeasureNumber);
                if (calMeasureAmount == null) continue;
                resultRowXProcessor.updateValue(calMeasureNumber, calMeasureAmount.subtract(ordMeasureAmount));
            }
        }
        collector.collect(resultRowXProcessor.getRowX());
    }

    private Map<String, Object> createScriptFieldValueMap(PARowXProcessor rowXProcessor, Set<String> fieldNameSet) {
        HashMap<String, Object> paramValueMap = new HashMap<String, Object>(fieldNameSet.size());
        for (String fieldName : fieldNameSet) {
            Object fieldValue = rowXProcessor.getValue(fieldName);
            paramValueMap.put(fieldName, fieldValue);
        }
        return paramValueMap;
    }

    private Map<String, Object> createDataValueMap(PARowXProcessor rowXProcessor, String sourceDimNumber, Set<String> sourceDimFieldSet, String targetDimNumber, Set<String> targetDimFieldSet, Map<String, Object> defaultValueMap) {
        HashMap<String, Object> dataValueMap = new HashMap<String, Object>(8);
        if (defaultValueMap == null) {
            List<String> actSourceDimFieldList = sourceDimFieldSet.stream().map(field -> sourceDimNumber + "." + field).collect(Collectors.toList());
            Map<String, Object> actSourceDimValueMap = rowXProcessor.getValue(actSourceDimFieldList);
            HashMap<String, Object> dimValueMap = new HashMap<String, Object>(actSourceDimValueMap.size());
            for (Map.Entry<String, Object> entry : actSourceDimValueMap.entrySet()) {
                String dimKey = entry.getKey().replaceFirst(sourceDimNumber + ".", "");
                Object dimValue = entry.getValue();
                dimValueMap.put(dimKey, dimValue);
            }
            for (String targetDimField : targetDimFieldSet) {
                String key = targetDimNumber + "." + targetDimField;
                Object value = dimValueMap.get(targetDimField);
                dataValueMap.put(key, value);
            }
            Object id = dimValueMap.get("id");
            if (id != null) {
                dataValueMap.put(targetDimNumber, id);
            }
            return dataValueMap;
        }
        if (sourceDimNumber == null || sourceDimFieldSet == null) {
            for (String targetDimField : targetDimFieldSet) {
                String key = targetDimNumber + "." + targetDimField;
                Object value = defaultValueMap.get(targetDimField);
                dataValueMap.put(key, value);
            }
            Object id = defaultValueMap.get("id");
            if (id != null) {
                dataValueMap.put(targetDimNumber, id);
            }
            return dataValueMap;
        }
        return dataValueMap;
    }

    private PARowMetaBuilder initResultRowMetaBuilder() {
        Field summaryIdField = new Field("summaryid", (DataType)DataType.LongType);
        Field sourceBillIdField = new Field("sourcebillid", (DataType)DataType.LongType);
        Field sourceFormIdField = new Field("sourceformid", (DataType)DataType.StringType);
        Field execLogIdField = new Field("execlogid", (DataType)DataType.LongType);
        Field subExecLogIdField = new Field("subexeclogid", (DataType)DataType.LongType);
        Field execParentBillId = new Field("execparentbillid", (DataType)DataType.LongType);
        Field createStamp = new Field("createstamp", (DataType)DataType.LongType);
        return this.modelRowMetaBuilder.addFields(summaryIdField, sourceBillIdField, sourceFormIdField, execLogIdField, subExecLogIdField, execParentBillId, createStamp);
    }
}

