/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.derivation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.util.StringUtils;
import kd.fi.pa.algox.PAIdCreator;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.utils.AnalysisModelHashUtil;

public class DerivationDetailCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = -314140845296044125L;
    private final PARowMetaBuilder modelRowMetaBuilder;
    private final PARowMetaBuilder otherRowMetaBuilder;
    private final PARowMetaBuilder resultRowMetaBuilder;
    private final PAIdCreator idCreator;
    private final Long executionLogId;
    private final Long ruleExecutionLogId;
    private final List<String> modelHashDimensionNumberList;
    private final List<String> modelMeasureNumberList;
    private final List<String> derivationMeasureNumberList;
    private final Map<String, String> targetFieldMap;
    private final Map<String, Object> targetFieldDVMap;
    private final MainEntityType modelMainEntity;
    private final String otherEntrySeqField;
    private final String derivationMode;
    private final Map<String, Set<String>> ordCalMeaMappingMap;

    public DerivationDetailCoGroupFunction(RowMeta modelRowMeta, RowMeta otherRowMeta, Long executionLogId, Long ruleExecutionLogId, List<String> modelHashDimensionNumberList, List<String> modelMeasureNumberList, List<String> derivationMeasureNumberList, Map<String, String> targetFieldMap, Map<String, Object> targetFieldDVMap, String detailModelNumber, String otherEntrySeqField, String derivationMode, Map<String, Set<String>> ordCalMeaMappingMap) {
        this.executionLogId = executionLogId;
        this.ruleExecutionLogId = ruleExecutionLogId;
        this.modelHashDimensionNumberList = modelHashDimensionNumberList;
        this.modelMeasureNumberList = modelMeasureNumberList;
        this.derivationMeasureNumberList = derivationMeasureNumberList;
        this.targetFieldMap = targetFieldMap;
        this.targetFieldDVMap = targetFieldDVMap;
        this.modelRowMetaBuilder = new PARowMetaBuilder(modelRowMeta);
        this.otherRowMetaBuilder = new PARowMetaBuilder(otherRowMeta);
        this.resultRowMetaBuilder = this.initResultRowMetaBuilder();
        this.idCreator = new PAIdCreator();
        this.modelMainEntity = EntityMetadataCache.getDataEntityType((String)detailModelNumber);
        this.otherEntrySeqField = otherEntrySeqField;
        this.derivationMode = derivationMode;
        this.ordCalMeaMappingMap = ordCalMeaMappingMap;
    }

    public void coGroup(Iterable<RowX> modelIterable, Iterable<RowX> otherIterable, Collector collector) {
        RowX otherRowX = null;
        if (StringUtils.isNotEmpty((String)this.otherEntrySeqField)) {
            int maxSeq = Integer.MAX_VALUE;
            String field = this.otherEntrySeqField.substring(this.otherEntrySeqField.indexOf(32) + 1);
            for (RowX row : otherIterable) {
                PARowXProcessor otherRowXProcessor = this.otherRowMetaBuilder.create(row);
                Object seq = otherRowXProcessor.getValue(field);
                int realSeq = seq == null ? 0 : Integer.parseInt(String.valueOf(seq));
                if (realSeq >= maxSeq) continue;
                otherRowX = row;
                maxSeq = realSeq;
            }
        } else {
            int count = 0;
            for (RowX row : otherIterable) {
                if (count < 1) {
                    otherRowX = row;
                }
                ++count;
            }
        }
        if (otherRowX == null) {
            otherRowX = this.otherRowMetaBuilder.createNew().getRowX();
        }
        for (RowX modelRowX : modelIterable) {
            boolean updateFlag = this.createDerivationData(modelRowX, otherRowX, collector);
            if (!updateFlag) continue;
            this.createOffsetData(modelRowX, collector);
            this.updateSummaryData(modelRowX, collector);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMetaBuilder.getRowMeta();
    }

    private boolean createDerivationData(RowX modelRowX, RowX otherRowX, Collector collector) {
        PARowXProcessor modelRowXProcessor = this.modelRowMetaBuilder.create(modelRowX);
        PARowXProcessor otherRowXProcessor = this.otherRowMetaBuilder.create(otherRowX);
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(modelRowXProcessor);
        long detailId = this.idCreator.getId();
        Object summaryId = modelRowXProcessor.getValue("id");
        Date curDate = new Date();
        boolean updateFlag = false;
        for (String string : this.modelMeasureNumberList) {
            if (this.derivationMeasureNumberList.contains(string)) continue;
            resultRowXProcessor.updateValue(string, BigDecimal.ZERO);
        }
        for (Map.Entry entry : this.targetFieldMap.entrySet()) {
            String modelField = (String)entry.getKey();
            String otherField = (String)entry.getValue();
            Object otherValue = otherRowXProcessor.getValueSpecial(FieldUtil.valueFormat(otherField));
            if (otherValue == null) {
                if (DerivationTypeEnum.DERIVATION_MAPPING_RELATIONSHIP.getType().equals(this.derivationMode)) {
                    otherValue = otherRowXProcessor.getValueSpecial(otherField);
                } else {
                    Object object = otherValue = this.isBaseField(modelField) ? null : otherRowXProcessor.getValueSpecial(otherField);
                }
                if (otherValue == null) {
                    otherValue = this.targetFieldDVMap.get(otherField);
                }
            }
            if (otherValue == null) continue;
            updateFlag = true;
            resultRowXProcessor.updateValue(modelField, otherValue);
        }
        if (updateFlag) {
            RowX derivationRowX = resultRowXProcessor.updateValue("id", detailId).updateValue("collectstatus", PACollectStatusEnum.DETAIL.getLongCode()).updateValue("datastatus", DataStatusEnum.DERIVE.getLongCode()).updateValue("operationstatus", OperationStatusEnum.UNUSED.getLongCode()).updateValue("del", -1L).updateValue("createtime", curDate).updateValue("sourceformid", " ").updateValue("sourcebillid", 0L).updateValue("execlogid", this.executionLogId).updateValue("subexeclogid", this.ruleExecutionLogId).updateValue("execparentbillid", summaryId).updateValue("createstamp", curDate.getTime()).getRowX();
            int n = resultRowXProcessor.getRowMeta().getFieldIndex("dimhash", false);
            if (n >= 0) {
                derivationRowX.set(n, (Object)AnalysisModelHashUtil.calculateDimHash((RowMeta)resultRowXProcessor.getRowMeta(), (RowX)derivationRowX, this.modelHashDimensionNumberList));
            }
            collector.collect(derivationRowX);
        }
        return updateFlag;
    }

    private void createOffsetData(RowX modelRowX, Collector collector) {
        PARowXProcessor modelRowXProcessor = this.modelRowMetaBuilder.create(modelRowX);
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(modelRowXProcessor);
        long detailId = this.idCreator.getId();
        Object summaryId = modelRowXProcessor.getValue("id");
        Date curDate = new Date();
        for (String measureNumber : this.modelMeasureNumberList) {
            if (this.derivationMeasureNumberList.contains(measureNumber)) {
                BigDecimal measureAmount = (BigDecimal)resultRowXProcessor.getValue(measureNumber);
                resultRowXProcessor.updateValue(measureNumber, measureAmount.negate());
                continue;
            }
            resultRowXProcessor.updateValue(measureNumber, BigDecimal.ZERO);
        }
        RowX offSetRowX = resultRowXProcessor.updateValue("id", detailId).updateValue("collectstatus", PACollectStatusEnum.DETAIL.getLongCode()).updateValue("datastatus", DataStatusEnum.OFF_DERIVE.getLongCode()).updateValue("operationstatus", OperationStatusEnum.USED.getLongCode()).updateValue("del", -1L).updateValue("createtime", curDate).updateValue("summaryid", summaryId).updateValue("sourceformid", " ").updateValue("sourcebillid", 0L).updateValue("execlogid", this.executionLogId).updateValue("subexeclogid", this.ruleExecutionLogId).updateValue("execparentbillid", summaryId).updateValue("createstamp", curDate.getTime()).getRowX();
        int index = resultRowXProcessor.getRowMeta().getFieldIndex("dimhash", false);
        if (index >= 0) {
            offSetRowX.set(index, (Object)AnalysisModelHashUtil.calculateDimHash((RowMeta)resultRowXProcessor.getRowMeta(), (RowX)offSetRowX, this.modelHashDimensionNumberList));
        }
        collector.collect(offSetRowX);
    }

    private void updateSummaryData(RowX modelRowX, Collector collector) {
        PARowXProcessor modelRowXProcessor = this.modelRowMetaBuilder.create(modelRowX);
        PARowXProcessor resultRowXProcessor = this.resultRowMetaBuilder.createConversion(modelRowXProcessor);
        for (String ordMeasureNumber : this.derivationMeasureNumberList) {
            BigDecimal ordMeasureAmount = (BigDecimal)resultRowXProcessor.getValue(ordMeasureNumber);
            resultRowXProcessor.updateValue(ordMeasureNumber, BigDecimal.ZERO);
            Set<String> calMeasureSet = this.ordCalMeaMappingMap.get(ordMeasureNumber);
            if (calMeasureSet == null) continue;
            for (String calMeasureNumber : calMeasureSet) {
                BigDecimal calMeasureAmount = (BigDecimal)resultRowXProcessor.getValue(calMeasureNumber);
                if (calMeasureAmount == null) continue;
                resultRowXProcessor.updateValue(calMeasureNumber, calMeasureAmount.subtract(ordMeasureAmount));
            }
        }
        collector.collect(resultRowXProcessor.getRowX());
    }

    private boolean isBaseField(String field) {
        IDataEntityProperty property = this.modelMainEntity.findProperty(field);
        return property instanceof BasedataProp;
    }

    private PARowMetaBuilder initResultRowMetaBuilder() {
        Field summaryIdField = new Field("summaryid", (DataType)DataType.LongType);
        Field sourceBillIdField = new Field("sourcebillid", (DataType)DataType.LongType);
        Field sourceFormIdField = new Field("sourceformid", (DataType)DataType.StringType);
        Field execLogIdField = new Field("execlogid", (DataType)DataType.LongType);
        Field subExecLogIdField = new Field("subexeclogid", (DataType)DataType.LongType);
        Field execParentBillId = new Field("execparentbillid", (DataType)DataType.LongType);
        Field createStamp = new Field("createstamp", (DataType)DataType.LongType);
        return this.modelRowMetaBuilder.addFields(summaryIdField, sourceBillIdField, sourceFormIdField, execLogIdField, subExecLogIdField, execParentBillId, createStamp);
    }
}

