/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.derivation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.enginealgox.utils.FieldUtil;

public class DerivationOtherMapFunction
extends MapFunction {
    private static final long serialVersionUID = 7834761270595708366L;
    private final PARowMetaBuilder sourcePARowMetaBuilder;
    private final PARowMetaBuilder targetPARowMetaBuilder;
    private final String derivationMode;
    private final LinkedHashMap<String, String> targetFieldToMTargetFieldMap;

    public DerivationOtherMapFunction(RowMeta sourcePARowMeta, RowMeta targetPARowMeta, String derivationMode, LinkedHashMap<String, String> targetFieldToMTargetFieldMap) {
        this.sourcePARowMetaBuilder = new PARowMetaBuilder(sourcePARowMeta);
        this.targetPARowMetaBuilder = new PARowMetaBuilder(targetPARowMeta);
        this.derivationMode = derivationMode;
        this.targetFieldToMTargetFieldMap = targetFieldToMTargetFieldMap;
    }

    public RowX map(RowX rowX) {
        PARowXProcessor rowXProcessor = this.sourcePARowMetaBuilder.create(rowX);
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)this.derivationMode);
        switch (derivationTypeEnum) {
            case DERIVATION_MAPPING_RELATIONSHIP: {
                String sourceDimText = (String)rowXProcessor.getValue("source_dimtext");
                String targetDimText = (String)rowXProcessor.getValue("target_dimtext");
                Map sourceDimMap = (Map)JSON.parseObject((String)sourceDimText, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                Map targetDimMap = (Map)JSON.parseObject((String)targetDimText, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                PARowXProcessor mappingShipRowXProcessor = this.targetPARowMetaBuilder.createNew();
                sourceDimMap.forEach((field, value) -> {
                    String fieldFormat = FieldUtil.sourceFormat(field);
                    mappingShipRowXProcessor.updateValueSpecial(fieldFormat, value);
                });
                targetDimMap.forEach((field, value) -> {
                    String fieldFormat = FieldUtil.targetFormat(field);
                    mappingShipRowXProcessor.updateValueSpecial(fieldFormat, value);
                });
                return mappingShipRowXProcessor.getRowX();
            }
            case DERIVATION_MAPPING_TABLE: {
                PARowXProcessor tableRowXProcessor = this.targetPARowMetaBuilder.createConversion(rowXProcessor);
                Set<Map.Entry<String, String>> entrySet = this.targetFieldToMTargetFieldMap.entrySet();
                for (Map.Entry<String, String> targetFieldToMTargetFieldEntry : entrySet) {
                    String targetField = targetFieldToMTargetFieldEntry.getKey();
                    String mTargetField = targetFieldToMTargetFieldEntry.getValue();
                    Object mTargetFormatValue = rowXProcessor.getValue(FieldUtil.dimValueFormat(targetField));
                    if (mTargetFormatValue == null) continue;
                    tableRowXProcessor.updateValue(FieldUtil.otherValueFormat(mTargetField), mTargetFormatValue);
                }
                return tableRowXProcessor.getRowX();
            }
        }
        return null;
    }

    public RowMeta getResultRowMeta() {
        return this.targetPARowMetaBuilder.getRowMeta();
    }
}

