/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.summary;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;

public class AccountPltypeCalcMeasureMapFunction
extends MapFunction {
    private final PARowMetaBuilder resultRowMetaBuilder;
    private final List<String> calMeaNumberList;
    private final Map<String, String> calAttrMappingMap;
    private final String accountDimNumber;
    private final Set<Long> accountPltype0Set;

    public AccountPltypeCalcMeasureMapFunction(RowMeta sourceRowMeta, List<String> calMeaNumberList, Map<String, String> calAttrMappingMap, String accountDimNumber, Set<Long> accountPltype0Set) {
        this.resultRowMetaBuilder = new PARowMetaBuilder(sourceRowMeta);
        this.calMeaNumberList = calMeaNumberList;
        this.calAttrMappingMap = calAttrMappingMap;
        this.accountDimNumber = accountDimNumber;
        this.accountPltype0Set = accountPltype0Set;
    }

    public RowX map(RowX row) {
        if (CollectionUtils.isEmpty(this.calMeaNumberList) || CollectionUtils.isEmpty(this.accountPltype0Set)) {
            return row;
        }
        PARowXProcessor summaryRowXProcessor = this.resultRowMetaBuilder.create(row);
        for (String calMeaNumber : this.calMeaNumberList) {
            if (!"periodnone".equals(this.calAttrMappingMap.get(calMeaNumber)) || this.accountPltype0Set.contains((Long)summaryRowXProcessor.getValue(this.accountDimNumber))) continue;
            summaryRowXProcessor.updateValue(calMeaNumber, BigDecimal.ZERO);
        }
        return summaryRowXProcessor.getRowX();
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMetaBuilder.getRowMeta();
    }
}

