/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.summary;

import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.pa.algox.PAIdCreator;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.utils.AnalysisModelHashUtil;

public class ImmediateSumCalDetailFlatMapFunction
extends FlatMapFunction {
    private final BitSet summaryBitSet;
    private final BitSet detailDuplicateBitSet;
    private final PARowMetaBuilder detailRowMetaBuilder;
    private final List<String> calMeaNumberList;
    private final Map<String, String> calMeaMappingMap;
    private final PAIdCreator idCreator;

    public ImmediateSumCalDetailFlatMapFunction(BitSet summaryBitSet, BitSet detailDuplicateBitSet, RowMeta detailRowMeta, List<String> calMeaNumberList, Map<String, String> calMeaMappingMap) {
        this.summaryBitSet = summaryBitSet;
        this.detailDuplicateBitSet = detailDuplicateBitSet;
        this.detailRowMetaBuilder = new PARowMetaBuilder(detailRowMeta);
        this.calMeaNumberList = calMeaNumberList;
        this.calMeaMappingMap = calMeaMappingMap;
        this.idCreator = new PAIdCreator();
    }

    public void flatMap(RowX detailRowX, Collector collector) {
        PARowXProcessor detailRowXProcessor = this.detailRowMetaBuilder.create(detailRowX);
        String dimhash = (String)detailRowXProcessor.getValue("dimhash");
        int dimhashIntValue = AnalysisModelHashUtil.dimhashToIntValue((String)dimhash);
        if (!this.summaryBitSet.get(dimhashIntValue) && !this.detailDuplicateBitSet.get(dimhashIntValue)) {
            Long summaryId = this.idCreator.getId();
            detailRowXProcessor.updateValue("immediate_sum", 1).updateValue("summaryid", summaryId).updateValue("operationstatus", OperationStatusEnum.USED.getLongCode());
            PARowXProcessor summaryRowXProcessor = this.detailRowMetaBuilder.createCopy(detailRowXProcessor.getRowX());
            Date curDate = new Date();
            summaryRowXProcessor.updateValue("id", summaryId).updateValue("immediate_sum", 1).updateValue("collectstatus", PACollectStatusEnum.COLLECT.getLongCode()).updateValue("datastatus", DataStatusEnum.SOURCE.getLongCode()).updateValue("del", -1L).updateValue("offstatus", 0L).updateValue("operationstatus", OperationStatusEnum.UNUSED.getLongCode()).updateValue("situationtype", 0L).updateValue("createtime", curDate);
            for (String calMeaNumber : this.calMeaNumberList) {
                String ordMeaNumber = this.calMeaMappingMap.get(calMeaNumber);
                if (StringUtils.isEmpty((CharSequence)ordMeaNumber)) continue;
                summaryRowXProcessor.updateValue(calMeaNumber, summaryRowXProcessor.getValue(ordMeaNumber));
            }
            RowX summaryRowX = summaryRowXProcessor.getRowX();
            collector.collect(summaryRowX);
        }
        collector.collect(detailRowXProcessor.getRowX());
    }

    public RowMeta getResultRowMeta() {
        return this.detailRowMetaBuilder.getRowMeta();
    }
}

