/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.func.summary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.fi.pa.algox.PAIdCreator;
import kd.fi.pa.algox.PARowMetaBuilder;
import kd.fi.pa.algox.PARowXProcessor;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.utils.NumberUtils;

public class SummarySumCoCroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 6283742734407266652L;
    private final PARowMetaBuilder modelRowMetaBuilder;
    private final PARowMetaBuilder modelDetailRowMetaBuilder;
    private final PARowMetaBuilder resultRowMetaBuilder;
    private final PAIdCreator idCreator;
    private final List<String> ordinaryMeasureNumberList;
    private final List<String> calMeaNumberList;
    private final Map<String, String> calMeaMappingMap;

    public SummarySumCoCroupFunction(RowMeta modelRowMeta, RowMeta modelDetailRowMeta, List<String> ordinaryMeasureNumberList, List<String> calMeaNumberList, Map<String, String> calMeaMappingMap) {
        this.ordinaryMeasureNumberList = ordinaryMeasureNumberList;
        this.calMeaNumberList = calMeaNumberList;
        this.calMeaMappingMap = calMeaMappingMap;
        this.modelRowMetaBuilder = new PARowMetaBuilder(modelRowMeta);
        this.modelDetailRowMetaBuilder = new PARowMetaBuilder(modelDetailRowMeta);
        this.resultRowMetaBuilder = this.initResultRowMetaBuilder();
        this.idCreator = new PAIdCreator();
    }

    public void coGroup(Iterable<RowX> sumIterable, Iterable<RowX> detailIterable, Collector collector) {
        PARowXProcessor originSummaryRowXProcessor = this.getSummaryRowXProcessor(sumIterable);
        PARowXProcessor resultSummaryRowXProcessor = this.summaryDetailRow(detailIterable, originSummaryRowXProcessor, collector);
        if (resultSummaryRowXProcessor == null) {
            return;
        }
        collector.collect(resultSummaryRowXProcessor.getRowX());
    }

    private PARowXProcessor getSummaryRowXProcessor(Iterable<RowX> sumIterable) {
        ArrayList<PARowXProcessor> summaryRowXProcessorList = new ArrayList<PARowXProcessor>(1);
        for (RowX rowX : sumIterable) {
            summaryRowXProcessorList.add(this.modelRowMetaBuilder.create(rowX));
        }
        if (summaryRowXProcessorList.isEmpty()) {
            return null;
        }
        if (summaryRowXProcessorList.size() == 1) {
            return (PARowXProcessor)summaryRowXProcessorList.get(0);
        }
        throw new KDBizException("duplicate summaray data. pkid is " + summaryRowXProcessorList.stream().map(summaryRowXProcessor -> String.valueOf(summaryRowXProcessor.getValue("id"))).collect(Collectors.joining(",")));
    }

    private PARowXProcessor summaryDetailRow(Iterable<RowX> detailIterable, PARowXProcessor originSummaryRowXProcessor, Collector collector) {
        PARowXProcessor resultSummaryRowXProcessor = null;
        Long summaryId = null;
        for (RowX rowX : detailIterable) {
            PARowXProcessor detailRowXProcessor = this.modelDetailRowMetaBuilder.create(rowX);
            if (resultSummaryRowXProcessor == null) {
                resultSummaryRowXProcessor = this.copyDetailToSummary(detailRowXProcessor, originSummaryRowXProcessor);
                summaryId = (Long)resultSummaryRowXProcessor.getValue("id");
            }
            for (String ordMeaNumber : this.ordinaryMeasureNumberList) {
                BigDecimal detailMeasureAmount = (BigDecimal)detailRowXProcessor.getValue(ordMeaNumber);
                BigDecimal summaryMeasureAmount = (BigDecimal)resultSummaryRowXProcessor.getValue(ordMeaNumber);
                resultSummaryRowXProcessor.updateValue(ordMeaNumber, NumberUtils.sum((BigDecimal[])new BigDecimal[]{detailMeasureAmount, summaryMeasureAmount}));
            }
            for (String calcMeaNumber : this.calMeaNumberList) {
                String ordMeaNumber = this.calMeaMappingMap.get(calcMeaNumber);
                if (StringUtils.isEmpty((CharSequence)ordMeaNumber)) continue;
                BigDecimal detailMeasureAmount = (BigDecimal)detailRowXProcessor.getValue(ordMeaNumber);
                BigDecimal summaryMeasureAmount = (BigDecimal)resultSummaryRowXProcessor.getValue(calcMeaNumber);
                resultSummaryRowXProcessor.updateValue(calcMeaNumber, NumberUtils.sum((BigDecimal[])new BigDecimal[]{detailMeasureAmount, summaryMeasureAmount}));
            }
            PARowXProcessor detailResultRowXProcessor = this.resultRowMetaBuilder.createConversion(detailRowXProcessor);
            RowX resultRowX = detailResultRowXProcessor.updateValue("operationstatus", OperationStatusEnum.USED.getLongCode()).updateValue("summaryid", summaryId).getRowX();
            collector.collect(resultRowX);
        }
        return resultSummaryRowXProcessor;
    }

    private PARowXProcessor copyDetailToSummary(PARowXProcessor detailRowXProcessor, PARowXProcessor originSummaryRowXProcessor) {
        PARowXProcessor summaryRowXProcessor = this.resultRowMetaBuilder.createConversion(detailRowXProcessor);
        if (originSummaryRowXProcessor != null) {
            BigDecimal amount;
            summaryRowXProcessor.updateValue("id", originSummaryRowXProcessor.getValue("id")).updateValue("dbstatus", 2L);
            Iterator<String> iterator = this.ordinaryMeasureNumberList.iterator();
            while (iterator.hasNext()) {
                String ordMeaNumber;
                amount = (BigDecimal)originSummaryRowXProcessor.getValue(ordMeaNumber = iterator.next());
                summaryRowXProcessor.updateValue(ordMeaNumber, amount != null ? amount : BigDecimal.ZERO);
            }
            iterator = this.calMeaNumberList.iterator();
            while (iterator.hasNext()) {
                String calcMeaNumber;
                amount = (BigDecimal)originSummaryRowXProcessor.getValue(calcMeaNumber = iterator.next());
                summaryRowXProcessor.updateValue(calcMeaNumber, amount != null ? amount : BigDecimal.ZERO);
            }
        } else {
            Long summaryId = this.idCreator.getId();
            summaryRowXProcessor.updateValue("id", summaryId).updateValue("dbstatus", 1L);
            for (String ordMeaNumber : this.ordinaryMeasureNumberList) {
                summaryRowXProcessor.updateValue(ordMeaNumber, BigDecimal.ZERO);
            }
            for (String calcMeaNumber : this.calMeaNumberList) {
                summaryRowXProcessor.updateValue(calcMeaNumber, BigDecimal.ZERO);
            }
        }
        summaryRowXProcessor.updateValue("collectstatus", PACollectStatusEnum.COLLECT.getLongCode()).updateValue("datastatus", DataStatusEnum.SOURCE.getLongCode()).updateValue("del", -1L).updateValue("offstatus", 0L).updateValue("operationstatus", OperationStatusEnum.UNUSED.getLongCode()).updateValue("situationtype", 0L).updateValue("createtime", new Date());
        return summaryRowXProcessor;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMetaBuilder.getRowMeta();
    }

    private PARowMetaBuilder initResultRowMetaBuilder() {
        Field dbStatusField = new Field("dbstatus", (DataType)DataType.LongType);
        return this.modelDetailRowMetaBuilder.addFields(dbStatusField);
    }
}

