/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.pa.algox.XDbGroupOutput;
import kd.fi.pa.algox.XDbOutput;
import kd.fi.pa.enginealgox.model.business.AbstractBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AllocationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOEnum;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enginealgox.utils.SqlUtil;

public class AllocationBusinessDTO
extends AbstractBusinessDTO {
    private AnalysisModelConfigDTO modelConfigDTO = null;
    private LogConfigDTO logConfigDTO = null;
    private AllocationRuleConfigDTO allocationRuleConfigDTO = null;
    private RowMeta modelDetailRowMeta = null;
    private Map<String, Set<String>> ordCalMeaMappingMap;
    private List<String> allocationCalcMeasureList;
    private RowMeta updateModelRowMeta = null;

    public AllocationBusinessDTO(ConfigDTOManager configDTOManager) {
        super(configDTOManager);
        if (configDTOManager != null) {
            this.initBusiness();
        }
    }

    @Override
    public final void initBusiness() {
        ConfigDTOManager configDTOManager = this.getConfigDTOManager();
        this.modelConfigDTO = (AnalysisModelConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.MODEL);
        this.logConfigDTO = (LogConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.LOG);
        this.allocationRuleConfigDTO = (AllocationRuleConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.ALLOCATION);
        this.ordCalMeaMappingMap = this.initOrdCalMeaMappingMap(new HashSet<String>(this.allocationRuleConfigDTO.getAllocationMeasureNumberList()), this.modelConfigDTO.getCalMeaMappingMap());
        this.modelDetailRowMeta = this.initModelDetailRowMeta();
        this.updateModelRowMeta = this.initUpdateModelRowMeta();
    }

    private Map<String, Set<String>> initOrdCalMeaMappingMap(Set<String> allocationMeasureNumberSet, Map<String, String> calMeaMappingMap) {
        HashSet<String> allocationCalcMeaSet = new HashSet<String>(16);
        HashMap<String, Set<String>> ordCalMeaMappingMap = new HashMap<String, Set<String>>(8);
        if (calMeaMappingMap != null) {
            for (Map.Entry<String, String> entry : calMeaMappingMap.entrySet()) {
                String calMeasureNumber = entry.getKey();
                String ordMeasureNumber = entry.getValue();
                if (!allocationMeasureNumberSet.contains(ordMeasureNumber)) continue;
                Set calMeasureSet = ordCalMeaMappingMap.computeIfAbsent(ordMeasureNumber, k -> new HashSet(8));
                calMeasureSet.add(calMeasureNumber);
                allocationCalcMeaSet.add(calMeasureNumber);
            }
        }
        this.allocationCalcMeasureList = new ArrayList<String>(allocationCalcMeaSet);
        return ordCalMeaMappingMap;
    }

    private RowMeta initModelDetailRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        return ModelUtil.getModelDetailRowMeta(analysisModel);
    }

    private RowMeta initUpdateModelRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        ArrayList<String> fieldList = new ArrayList<String>(this.modelConfigDTO.getModelMeasureNumberList().size());
        fieldList.addAll(this.allocationRuleConfigDTO.getAllocationMeasureNumberList());
        for (String ordMeasureNumber : this.allocationRuleConfigDTO.getAllocationMeasureNumberList()) {
            Set<String> calMeasureSet = this.ordCalMeaMappingMap.get(ordMeasureNumber);
            if (calMeasureSet == null) continue;
            fieldList.addAll(calMeasureSet);
        }
        fieldList.add("id");
        fieldList.addAll(this.modelConfigDTO.getSummaryModelShardingFields());
        return ModelUtil.getModelRowMeta(analysisModel, fieldList);
    }

    public Output getModelDetailDbOutput() {
        String insertAllocationModelSQL = SqlUtil.getInsertSQL(this.modelDetailRowMeta, this.modelConfigDTO.getModelDetailTableNumber());
        Set<String> shardingFieldSet = this.modelConfigDTO.getDetailModelShardingFields();
        if (shardingFieldSet.isEmpty()) {
            return new XDbOutput("fias", insertAllocationModelSQL, this.modelDetailRowMeta);
        }
        String[] shardingFields = shardingFieldSet.toArray(new String[0]);
        return new XDbGroupOutput("fias", insertAllocationModelSQL, this.modelDetailRowMeta, shardingFields, new String[0]);
    }

    public Output getUpdateModelDbOutput() {
        Set<String> shardingFieldSet = this.modelConfigDTO.getSummaryModelShardingFields();
        String modelUpdateSQL = SqlUtil.getUpdateSQLExcludeFields(this.updateModelRowMeta, this.modelConfigDTO.getModelTableNumber(), shardingFieldSet);
        if (!shardingFieldSet.isEmpty()) {
            String[] shardingFields = shardingFieldSet.toArray(new String[0]);
            return new XDbGroupOutput("fias", modelUpdateSQL, this.updateModelRowMeta, shardingFields, shardingFields, true, this.modelConfigDTO.getModelTableNumber());
        }
        return new XDbOutput("fias", modelUpdateSQL, this.updateModelRowMeta);
    }

    public AnalysisModelConfigDTO getModelConfigDTO() {
        return this.modelConfigDTO;
    }

    public LogConfigDTO getLogConfigDTO() {
        return this.logConfigDTO;
    }

    public AllocationRuleConfigDTO getAllocationRuleConfigDTO() {
        return this.allocationRuleConfigDTO;
    }

    public Map<String, Set<String>> getOrdCalMeaMappingMap() {
        return this.ordCalMeaMappingMap;
    }

    public List<String> getAllocationCalcMeasureList() {
        return this.allocationCalcMeasureList;
    }

    public RowMeta getModelDetailRowMeta() {
        return this.modelDetailRowMeta;
    }

    public RowMeta getUpdateModelRowMeta() {
        return this.updateModelRowMeta;
    }
}

