/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.algox.XDbGroupOutput;
import kd.fi.pa.algox.XDbOutput;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.engine.model.DerivationRule;
import kd.fi.pa.enginealgox.model.business.AbstractBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOEnum;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.DerivationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enginealgox.utils.SqlUtil;
import kd.fi.pa.enums.MeasureTypeEnum;

public class DerivationBusinessDTO
extends AbstractBusinessDTO {
    private AnalysisModelConfigDTO modelConfigDTO = null;
    private LogConfigDTO logConfigDTO = null;
    private DerivationRuleConfigDTO derivationRuleConfigDTO = null;
    private List<String> ordinaryMeasureNumberList = null;
    private Map<String, Set<String>> ordCalMeaMappingMap = null;
    private RowMeta modelDetailRowMeta = null;
    private RowMeta otherRowMeta = null;
    private RowMeta updateModelRowMeta = null;

    public DerivationBusinessDTO(ConfigDTOManager configDTOManager) {
        super(configDTOManager);
        if (configDTOManager != null) {
            this.initBusiness();
        }
    }

    @Override
    public final void initBusiness() {
        ConfigDTOManager configDTOManager = this.getConfigDTOManager();
        this.modelConfigDTO = (AnalysisModelConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.MODEL);
        this.logConfigDTO = (LogConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.LOG);
        this.derivationRuleConfigDTO = (DerivationRuleConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.DERIVATION);
        this.ordinaryMeasureNumberList = this.initOrdinaryMeasureNumberList();
        this.ordCalMeaMappingMap = this.initOrdCalMeaMappingMap();
        this.modelDetailRowMeta = this.initModelDetailRowMeta();
        this.otherRowMeta = this.initOtherRowMeta();
        this.updateModelRowMeta = this.initUpdateModelRowMeta();
    }

    private List<String> initOrdinaryMeasureNumberList() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        DynamicObjectCollection measureEntry = analysisModel.getDynamicObjectCollection("measure_entry");
        ArrayList<String> resultList = new ArrayList<String>(measureEntry.size());
        for (DynamicObject entry : measureEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String measureType = measure.getString("measuretype");
            if (!String.valueOf(MeasureTypeEnum.ORDINARY.getCode()).equals(measureType)) continue;
            resultList.add(measure.getString("number"));
        }
        return resultList;
    }

    private Map<String, Set<String>> initOrdCalMeaMappingMap() {
        HashSet<String> ordinaryMeasureNumberSet = new HashSet<String>(this.ordinaryMeasureNumberList);
        Map<String, String> calMeaMappingMap = this.modelConfigDTO.getCalMeaMappingMap();
        HashMap<String, Set<String>> ordCalMeaMappingMap = new HashMap<String, Set<String>>(8);
        if (calMeaMappingMap != null) {
            for (Map.Entry<String, String> entry : calMeaMappingMap.entrySet()) {
                String calMeasureNumber = entry.getKey();
                String ordMeasureNumber = entry.getValue();
                if (!ordinaryMeasureNumberSet.contains(ordMeasureNumber)) continue;
                Set calMeasureSet = ordCalMeaMappingMap.computeIfAbsent(ordMeasureNumber, k -> new HashSet(8));
                calMeasureSet.add(calMeasureNumber);
            }
        }
        return ordCalMeaMappingMap;
    }

    private RowMeta initModelDetailRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        return ModelUtil.getModelDetailRowMeta(analysisModel);
    }

    private RowMeta initOtherRowMeta() {
        String derivationMode = this.derivationRuleConfigDTO.getDerivationMode();
        DerivationRule derivationRule = this.derivationRuleConfigDTO.getDerivationRule();
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)derivationMode);
        switch (derivationTypeEnum) {
            case DERIVATION_MAPPING_RELATIONSHIP: {
                Long relationShipId = derivationRule.getMappingRelationShip().getLong("id");
                QFilter idFilter = new QFilter("id", "=", (Object)relationShipId);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_mappingrelationship", (String)"id,number,sourcedim,targetdim", (QFilter[])new QFilter[]{idFilter});
                DynamicObjectCollection sourceCollection = dynamicObject.getDynamicObjectCollection("sourcedim");
                DynamicObjectCollection targetCollection = dynamicObject.getDynamicObjectCollection("targetdim");
                HashMap mappingShipFieldMap = new HashMap(sourceCollection.size() + targetCollection.size());
                sourceCollection.forEach(dy -> {
                    DynamicObject sourceDy = dy.getDynamicObject("fbasedataid");
                    String number = sourceDy.getString("number");
                    String type = sourceDy.getString("dimensiontype");
                    String entityNumber = sourceDy.getString("dimensionsource_id");
                    String fieldName = FieldUtil.sourceFormat(number);
                    DataType fieldType = ModelUtil.getDimDataType(type, entityNumber);
                    mappingShipFieldMap.put(fieldName, fieldType);
                });
                targetCollection.forEach(dy -> {
                    DynamicObject targetDy = dy.getDynamicObject("fbasedataid");
                    String number = targetDy.getString("number");
                    String type = targetDy.getString("dimensiontype");
                    String entityNumber = targetDy.getString("dimensionsource_id");
                    String fieldName = FieldUtil.targetFormat(number);
                    DataType fieldType = ModelUtil.getDimDataType(type, entityNumber);
                    mappingShipFieldMap.put(fieldName, fieldType);
                });
                Field[] mappingShipFields = (Field[])mappingShipFieldMap.entrySet().stream().map(v -> new Field((String)v.getKey(), (DataType)v.getValue())).toArray(Field[]::new);
                return new RowMeta(mappingShipFields);
            }
            case DERIVATION_MAPPING_TABLE: {
                String mappingEntityNumber = derivationRule.getMappingMapType();
                DynamicObjectCollection mtSourceEntryEntity = derivationRule.getMtSourceEntryEntity();
                DynamicObjectCollection mtTargetEntryEntity = derivationRule.getMtTargetEntryEntity();
                HashMap<String, IntegerType> tableFieldFieldMap = new HashMap<String, IntegerType>(mtSourceEntryEntity.size() + mtTargetEntryEntity.size());
                mtSourceEntryEntity.forEach(dy -> {
                    String number = dy.getString("mt_m_sourcefield_number");
                    String fieldName = FieldUtil.otherFormat(number);
                    DataType dataType = ModelUtil.getDataType(mappingEntityNumber, number);
                    tableFieldFieldMap.put(fieldName, (IntegerType)dataType);
                });
                mtTargetEntryEntity.forEach(dy -> {
                    String number = dy.getString("mt_m_targetfield_number");
                    String fieldName = FieldUtil.otherFormat(number);
                    DataType dataType = ModelUtil.getDataType(mappingEntityNumber, number);
                    tableFieldFieldMap.put(fieldName, (IntegerType)dataType);
                    DynamicObject targetDy = dy.getDynamicObject("mt_target");
                    String type = targetDy.getString("dimensiontype");
                    String entityNumber = targetDy.getString("dimensionsource_id");
                    DataType valueDataType = ModelUtil.getDimDataType(type, entityNumber);
                    String fieldValueName = FieldUtil.otherValueFormat(number);
                    tableFieldFieldMap.put(fieldValueName, (IntegerType)valueDataType);
                });
                String seqField = derivationRule.getEntrySeqField();
                if (StringUtils.isNotEmpty((String)seqField)) {
                    String field = seqField.substring(seqField.indexOf(32) + 1);
                    tableFieldFieldMap.put(field, DataType.IntegerType);
                }
                Field[] tableFields = (Field[])tableFieldFieldMap.entrySet().stream().map(v -> new Field((String)v.getKey(), (DataType)v.getValue())).toArray(Field[]::new);
                return new RowMeta(tableFields);
            }
        }
        return null;
    }

    private RowMeta initUpdateModelRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        ArrayList<String> fieldList = new ArrayList<String>(this.modelConfigDTO.getModelMeasureNumberList().size());
        fieldList.addAll(this.ordinaryMeasureNumberList);
        for (String ordMeasureNumber : this.ordinaryMeasureNumberList) {
            Set<String> calMeasureSet = this.ordCalMeaMappingMap.get(ordMeasureNumber);
            if (calMeasureSet == null) continue;
            fieldList.addAll(calMeasureSet);
        }
        fieldList.add("id");
        fieldList.addAll(this.modelConfigDTO.getSummaryModelShardingFields());
        return ModelUtil.getModelRowMeta(analysisModel, fieldList);
    }

    public Output getModelDetailDbOutput() {
        String insertAllocationModelSQL = SqlUtil.getInsertSQL(this.modelDetailRowMeta, this.modelConfigDTO.getModelDetailTableNumber());
        Set<String> shardingFieldSet = this.modelConfigDTO.getDetailModelShardingFields();
        if (shardingFieldSet.isEmpty()) {
            return new XDbOutput("fias", insertAllocationModelSQL, this.modelDetailRowMeta);
        }
        String[] shardingFields = shardingFieldSet.toArray(new String[0]);
        return new XDbGroupOutput("fias", insertAllocationModelSQL, this.modelDetailRowMeta, shardingFields, new String[0]);
    }

    public Output getUpdateModelDbOutput() {
        Set<String> shardingFieldSet = this.modelConfigDTO.getSummaryModelShardingFields();
        String modelUpdateSQL = SqlUtil.getUpdateSQLExcludeFields(this.updateModelRowMeta, this.modelConfigDTO.getModelTableNumber(), shardingFieldSet);
        if (!shardingFieldSet.isEmpty()) {
            String[] shardingFields = shardingFieldSet.toArray(new String[0]);
            return new XDbGroupOutput("fias", modelUpdateSQL, this.updateModelRowMeta, shardingFields, shardingFields, true, this.modelConfigDTO.getModelTableNumber());
        }
        return new XDbOutput("fias", modelUpdateSQL, this.updateModelRowMeta);
    }

    public AnalysisModelConfigDTO getModelConfigDTO() {
        return this.modelConfigDTO;
    }

    public LogConfigDTO getLogConfigDTO() {
        return this.logConfigDTO;
    }

    public DerivationRuleConfigDTO getDerivationRuleConfigDTO() {
        return this.derivationRuleConfigDTO;
    }

    public List<String> getOrdinaryMeasureNumberList() {
        return this.ordinaryMeasureNumberList;
    }

    public Map<String, Set<String>> getOrdCalMeaMappingMap() {
        return this.ordCalMeaMappingMap;
    }

    public RowMeta getModelDetailRowMeta() {
        return this.modelDetailRowMeta;
    }

    public RowMeta getOtherRowMeta() {
        return this.otherRowMeta;
    }

    public RowMeta getUpdateModelRowMeta() {
        return this.updateModelRowMeta;
    }
}

