/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.business;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.pa.algox.XDbGroupOutput;
import kd.fi.pa.algox.XDbOutput;
import kd.fi.pa.enginealgox.model.business.AbstractBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOEnum;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enginealgox.utils.SqlUtil;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.model.BdPeriod;
import kd.fi.pa.utils.AnalysisModelHashUtil;

public class SummaryCalculateBusinessDTO
extends AbstractBusinessDTO {
    private AnalysisModelConfigDTO modelConfigDTO = null;
    private LogConfigDTO logConfigDTO = null;
    private RowMeta insertModelRowMeta = null;
    private RowMeta updateModelRowMeta = null;
    private RowMeta updateDimHashRowMeta = null;
    private RowMeta updateModelDetailRowMeta = null;
    private Long periodTypeId = null;
    private String periodSourceNumber = null;
    private DynamicObject previousPeriod;
    private boolean modelContainsDimHash = false;

    public SummaryCalculateBusinessDTO(ConfigDTOManager configDTOManager) {
        super(configDTOManager);
        if (configDTOManager != null) {
            this.initBusiness();
        }
    }

    @Override
    public final void initBusiness() {
        ConfigDTOManager configDTOManager = this.getConfigDTOManager();
        this.modelConfigDTO = (AnalysisModelConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.MODEL);
        this.logConfigDTO = (LogConfigDTO)configDTOManager.getConfig(ConfigDTOEnum.LOG);
        this.insertModelRowMeta = this.initInsertModelRowMeta();
        this.updateModelRowMeta = this.initUpdateModelRowMeta();
        this.updateDimHashRowMeta = this.initUpdateDimHashRowMeta();
        this.updateModelDetailRowMeta = this.initUpdateModelDetailRowMeta();
        this.initModelPeriod();
        this.modelContainsDimHash = AnalysisModelHashUtil.isModelContainsDimHash((String)this.modelConfigDTO.getModelDetailEntityNumber()) && AnalysisModelHashUtil.isModelContainsDimHash((String)this.modelConfigDTO.getModelEntityNumber());
    }

    private RowMeta initInsertModelRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        return ModelUtil.getModelRowMeta(analysisModel);
    }

    private RowMeta initUpdateModelRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        ArrayList<String> fieldList = new ArrayList<String>(this.modelConfigDTO.getModelMeasureNumberList().size());
        fieldList.addAll(this.modelConfigDTO.getModelMeasureNumberList());
        fieldList.add("id");
        fieldList.addAll(this.modelConfigDTO.getSummaryModelShardingFields());
        return ModelUtil.getModelRowMeta(analysisModel, fieldList);
    }

    private RowMeta initUpdateDimHashRowMeta() {
        return new RowMeta(new String[]{"dimhash", "id"}, new DataType[]{DataType.StringType, DataType.LongType});
    }

    private RowMeta initUpdateModelDetailRowMeta() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        ArrayList<String> basicFields = new ArrayList<String>(2);
        basicFields.add("operationstatus");
        basicFields.add("summaryid");
        ArrayList<String> fieldList = new ArrayList<String>(basicFields.size());
        fieldList.addAll(basicFields);
        fieldList.add("id");
        fieldList.addAll(this.modelConfigDTO.getDetailModelShardingFields());
        return ModelUtil.getModelDetailRowMeta(analysisModel, fieldList);
    }

    private void initModelPeriod() {
        DynamicObject analysisModel = this.modelConfigDTO.getAnalysisModel();
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject entry : dimensionEntry) {
            String necessity = entry.getString("necessity_dim");
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) continue;
            DynamicObject dimension = entry.getDynamicObject("dimension");
            this.periodTypeId = dimension.getLong("group_id");
            this.periodSourceNumber = dimension.getString("dimensionsource.number");
            break;
        }
        Long periodId = this.logConfigDTO.getPeriod();
        if ("bd_period".equals(this.periodSourceNumber) && periodId != null && periodId != 0L) {
            BdPeriod bdPeriod = new BdPeriod(periodId);
            HashSet<String> periodAggSet = new HashSet<String>(this.modelConfigDTO.getCalAttrMappingMap().values());
            this.previousPeriod = bdPeriod.queryPreviousPeriod(periodAggSet);
        }
    }

    public Output getInsertModelDbOutput() {
        String insertModelSQL = SqlUtil.getInsertSQL(this.insertModelRowMeta, this.modelConfigDTO.getModelTableNumber());
        return new XDbOutput("fias", insertModelSQL, this.insertModelRowMeta);
    }

    public Output getUpdateModelDbOutput() {
        Set<String> shardingFieldSet = this.modelConfigDTO.getSummaryModelShardingFields();
        String modelUpdateSQL = SqlUtil.getUpdateSQLExcludeFields(this.updateModelRowMeta, this.modelConfigDTO.getModelTableNumber(), shardingFieldSet);
        if (!shardingFieldSet.isEmpty()) {
            String[] shardingFields = shardingFieldSet.toArray(new String[0]);
            return new XDbGroupOutput("fias", modelUpdateSQL, this.updateModelRowMeta, shardingFields, shardingFields, true, this.modelConfigDTO.getModelTableNumber());
        }
        return new XDbOutput("fias", modelUpdateSQL, this.updateModelRowMeta);
    }

    public String getUpdateDimHashSql(boolean isDetail) {
        return SqlUtil.getUpdateSQL(this.updateDimHashRowMeta, isDetail ? this.modelConfigDTO.getModelDetailTableNumber() : this.modelConfigDTO.getModelTableNumber());
    }

    public Output getUpdateModelDetailDbOutput() {
        Set<String> shardingFieldSet = this.modelConfigDTO.getDetailModelShardingFields();
        String modelDetailUpdateSQL = SqlUtil.getUpdateSQLExcludeFields(this.updateModelDetailRowMeta, this.modelConfigDTO.getModelDetailTableNumber(), shardingFieldSet);
        if (!shardingFieldSet.isEmpty()) {
            String[] shardingFields = shardingFieldSet.toArray(new String[0]);
            return new XDbGroupOutput("fias", modelDetailUpdateSQL, this.updateModelDetailRowMeta, shardingFields, shardingFields, true, this.modelConfigDTO.getModelDetailTableNumber());
        }
        return new XDbOutput("fias", modelDetailUpdateSQL, this.updateModelDetailRowMeta);
    }

    public AnalysisModelConfigDTO getModelConfigDTO() {
        return this.modelConfigDTO;
    }

    public LogConfigDTO getLogConfigDTO() {
        return this.logConfigDTO;
    }

    public RowMeta getInsertModelRowMeta() {
        return this.insertModelRowMeta;
    }

    public RowMeta getUpdateModelRowMeta() {
        return this.updateModelRowMeta;
    }

    public RowMeta getUpdateModelDetailRowMeta() {
        return this.updateModelDetailRowMeta;
    }

    public Long getPeriodTypeId() {
        return this.periodTypeId;
    }

    public String getPeriodSourceNumber() {
        return this.periodSourceNumber;
    }

    public DynamicObject getPreviousPeriod() {
        return this.previousPeriod;
    }

    public boolean isModelContainsDimHash() {
        return this.modelContainsDimHash;
    }
}

