/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.enginealgox.model.config.AbstractConfigDTO;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.utils.PAUtil;

public class AllocationRuleConfigDTO
extends AbstractConfigDTO {
    private static final long serialVersionUID = 7155079744621285985L;
    private final AllocationRule allocationRule;
    private List<String> allocationMeasureNumberList = null;
    private int allocationFlagEntryCount = 0;
    private Map<String, Map<String, Object>> allocationFlagMap = null;

    public AllocationRuleConfigDTO(AllocationRule allocationRule) {
        this.allocationRule = allocationRule;
        if (allocationRule != null) {
            this.initConfig();
        }
    }

    @Override
    public final void initConfig() {
        this.initRuleBasic();
    }

    private void initRuleBasic() {
        this.processAllocationMeasure();
        this.processAllocationFlag();
    }

    private void processAllocationMeasure() {
        DynamicObjectCollection measureEntry = this.allocationRule.getMeasureEntry();
        List idList = measureEntry.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObjectCollection measureDynamicObjects = QueryServiceHelper.query((String)"pa_measure", (String)"number", (QFilter[])new QFilter("id", "in", idList).toArray());
        this.allocationMeasureNumberList = measureDynamicObjects.stream().map(v -> v.getString("number")).collect(Collectors.toList());
    }

    private void processAllocationFlag() {
        HashMap<String, Map<String, Object>> newAllocationFlagMap = new HashMap<String, Map<String, Object>>();
        boolean addShareFlag = this.allocationRule.isAddShareFlag();
        if (addShareFlag) {
            DynamicObjectCollection flagEntryDyCol = this.allocationRule.getFlagEntry();
            this.allocationFlagEntryCount = flagEntryDyCol.size();
            for (DynamicObject flagEntryDy : flagEntryDyCol) {
                int seq = flagEntryDy.getInt("seq");
                HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
                String type = flagEntryDy.getString("f_flagtype");
                if (StringUtils.isEmpty((CharSequence)type)) continue;
                dataMap.put("flagtype", type);
                DynamicObject targetDimDy = flagEntryDy.getDynamicObject("f_targetdim");
                if (targetDimDy == null) continue;
                String targetDimNumber = targetDimDy.getString("number");
                dataMap.put("targetdimnumber", targetDimNumber);
                DynamicObject sourceDimDy = flagEntryDy.getDynamicObject("f_sourcedim");
                if (sourceDimDy != null) {
                    String sourceDimNumber = sourceDimDy.getString("number");
                    dataMap.put("sourcedimnumber", sourceDimNumber);
                }
                String dimensionType = targetDimDy.getString("dimensiontype");
                String value = flagEntryDy.getString("f_value");
                DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
                switch (dimensionTypeEnum) {
                    case ASSISTANTDATA: 
                    case DATABASE: {
                        DynamicObject dimensionSourceDy = targetDimDy.getDynamicObject("dimensionsource");
                        String srcEntityNum = dimensionSourceDy != null ? dimensionSourceDy.getString("number") : "bos_assistantdata_detail";
                        Object dimDataType = null;
                        dimDataType = StringUtils.isEmpty((CharSequence)srcEntityNum) ? DataType.LongType : ModelUtil.getDimDataType(dimensionType, srcEntityNum);
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            if (dimDataType == DataType.LongType) {
                                Long longValue = PAUtil.safeToLong((String)value);
                                if (longValue == null) {
                                    longValue = 0L;
                                }
                                dataMap.put("value", longValue);
                                break;
                            }
                            dataMap.put("value", value);
                            break;
                        }
                        dataMap.put("value", null);
                        break;
                    }
                    case DENUMS: 
                    case OTHER: {
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            dataMap.put("value", value);
                            break;
                        }
                        dataMap.put("value", null);
                        break;
                    }
                }
                newAllocationFlagMap.put(String.valueOf(seq), dataMap);
            }
        }
        this.allocationFlagMap = newAllocationFlagMap;
    }

    public AllocationRule getAllocationRule() {
        return this.allocationRule;
    }

    public List<String> getAllocationMeasureNumberList() {
        return this.allocationMeasureNumberList;
    }

    public int getAllocationFlagEntryCount() {
        return this.allocationFlagEntryCount;
    }

    public Map<String, Map<String, Object>> getAllocationFlagMap() {
        return this.allocationFlagMap;
    }

    public String toString() {
        return "AllocationRuleConfigDTO{allocationRule=" + this.allocationRule + ", allocationMeasureNumberList=" + this.allocationMeasureNumberList + '}';
    }
}

