/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.enginealgox.model.config.AbstractConfigDTO;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.MeasureTypeEnum;
import kd.fi.pa.helper.AccountHelper;
import kd.fi.pa.model.BdPeriod;
import kd.fi.pa.utils.AnalysisModelHashUtil;
import kd.fi.pa.utils.ShardingUtil;

public class AnalysisModelConfigDTO
extends AbstractConfigDTO {
    private static final long serialVersionUID = 1830493933685202977L;
    private final Long analysisModelId;
    private DynamicObject analysisModel = null;
    private String modelEntityNumber = null;
    private String modelTableNumber = null;
    private String modelDetailEntityNumber = null;
    private String modelDetailTableNumber = null;
    private List<String> modelDimensionNumberList = null;
    private List<String> modelHashDimensionNumberList = null;
    private String orgDimNumber;
    private String periodDimNumber;
    private String periodSourceNumber = null;
    private String accountDimNumber;
    private Long accountTableId;
    private List<String> modelMeasureNumberList = null;
    private Map<String, Integer> modelMeasureNumberMap = null;
    private List<String> ordinaryMeasureNumberList = null;
    private List<String> calculateMeasureNumberList = null;
    private Map<String, String> calMeaMappingMap = null;
    private Map<String, String> calAttrMappingMap = null;
    private Set<Long> accountPltype0Set;
    private int ormInputParallelism = 1;
    private Set<String> detailModelShardingFields = new HashSet<String>(1);
    private Set<String> summaryModelShardingFields = new HashSet<String>(1);

    public AnalysisModelConfigDTO(Long analysisModelId) {
        this.analysisModelId = analysisModelId;
        if (analysisModelId != null) {
            this.initConfig();
        }
    }

    @Override
    public final void initConfig() {
        this.initModelBasic();
        this.initModelDimension();
        this.initModelMeasure();
        this.initModelShardingFields();
    }

    private void initModelBasic() {
        this.analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)this.analysisModelId, (String)"pa_analysismodel");
        this.modelEntityNumber = PACommonConstans.buildEntityName((String)this.analysisModel.getString("tablenumber"));
        this.modelTableNumber = PACommonConstans.buildTableName((String)this.analysisModel.getString("tablenumber"));
        this.modelDetailEntityNumber = PACommonConstans.buildDetailEntityName((String)this.analysisModel.getString("tablenumber"));
        this.modelDetailTableNumber = PACommonConstans.buildDetailTableName((String)this.analysisModel.getString("tablenumber"));
    }

    private void initModelDimension() {
        DynamicObjectCollection dimensionEntry = this.analysisModel.getDynamicObjectCollection("dimension_entry");
        this.modelDimensionNumberList = new ArrayList<String>();
        for (DynamicObject entry : dimensionEntry) {
            DynamicObject dim = entry.getDynamicObject("dimension");
            String dimNumber = dim.getString("number");
            String necessity = entry.getString("necessity_dim");
            if (DimensionNecessityEnum.ORG.getCode().equals(necessity)) {
                this.orgDimNumber = dimNumber;
            } else if (DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) {
                this.periodDimNumber = dimNumber;
                this.periodSourceNumber = dim.getString("dimensionsource.number");
            } else if (DimensionNecessityEnum.ACCOUNT.getCode().equals(necessity)) {
                this.accountDimNumber = dimNumber;
                this.accountTableId = (Long)dim.get("group_id");
            }
            this.modelDimensionNumberList.add(dimNumber);
        }
        this.modelHashDimensionNumberList = AnalysisModelHashUtil.queryModelHashDimension((DynamicObject)this.analysisModel);
    }

    private void initModelMeasure() {
        this.modelMeasureNumberList = new ArrayList<String>(8);
        this.ordinaryMeasureNumberList = new ArrayList<String>(8);
        this.calculateMeasureNumberList = new ArrayList<String>(8);
        this.modelMeasureNumberMap = new HashMap<String, Integer>(8);
        this.calMeaMappingMap = new HashMap<String, String>(8);
        this.calAttrMappingMap = new HashMap<String, String>(8);
        DynamicObjectCollection measureEntry = this.analysisModel.getDynamicObjectCollection("measure_entry");
        for (DynamicObject entry : measureEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String measureType = measure.getString("measuretype");
            String measureNumber = measure.getString("number");
            if (String.valueOf(MeasureTypeEnum.ORDINARY.getCode()).equals(measureType)) {
                this.ordinaryMeasureNumberList.add(measureNumber);
            } else if (String.valueOf(MeasureTypeEnum.CALCULATION.getCode()).equals(measureType) && "bd_period".equals(this.periodSourceNumber)) {
                String dimAttrNumber = measure.getString("dimensionattrnb");
                this.calculateMeasureNumberList.add(measureNumber);
                this.calMeaMappingMap.put(measureNumber, measure.getString("measure.number"));
                String periodAggAttr = BdPeriod.parsePeriodAggAttr((String)dimAttrNumber);
                if (StringUtils.isNotEmpty((CharSequence)periodAggAttr)) {
                    this.calAttrMappingMap.put(measureNumber, periodAggAttr);
                    if ("periodnone".equals(periodAggAttr) && this.accountPltype0Set == null) {
                        this.accountPltype0Set = AccountHelper.queryAccountPltype0Set((Long)this.accountTableId);
                    }
                }
            }
            this.modelMeasureNumberMap.put(measureNumber, measure.getInt("precision"));
            this.modelMeasureNumberList.add(measureNumber);
        }
    }

    private void initModelShardingFields() {
        this.detailModelShardingFields = ShardingUtil.getShardingFields((String)this.modelDetailEntityNumber);
        this.summaryModelShardingFields = ShardingUtil.getShardingFields((String)this.modelEntityNumber);
        List<String> supportShardingFields = Arrays.asList(this.orgDimNumber, this.periodDimNumber, this.accountDimNumber);
        this.detailModelShardingFields.removeIf(field -> !supportShardingFields.contains(field));
        this.summaryModelShardingFields.removeIf(field -> !supportShardingFields.contains(field));
    }

    public Long getAnalysisModelId() {
        return this.analysisModelId;
    }

    public DynamicObject getAnalysisModel() {
        return this.analysisModel;
    }

    public String getModelEntityNumber() {
        return this.modelEntityNumber;
    }

    public String getModelTableNumber() {
        return this.modelTableNumber;
    }

    public String getModelDetailEntityNumber() {
        return this.modelDetailEntityNumber;
    }

    public String getModelDetailTableNumber() {
        return this.modelDetailTableNumber;
    }

    public List<String> getModelDimensionNumberList() {
        return this.modelDimensionNumberList;
    }

    public List<String> getModelHashDimensionNumberList() {
        return this.modelHashDimensionNumberList;
    }

    public String getOrgDimNumber() {
        return this.orgDimNumber;
    }

    public String getPeriodDimNumber() {
        return this.periodDimNumber;
    }

    public String getAccountDimNumber() {
        return this.accountDimNumber;
    }

    public List<String> getModelMeasureNumberList() {
        return this.modelMeasureNumberList;
    }

    public Map<String, Integer> getModelMeasureNumberMap() {
        return this.modelMeasureNumberMap;
    }

    public List<String> getOrdinaryMeasureNumberList() {
        return this.ordinaryMeasureNumberList;
    }

    public List<String> getCalculateMeasureNumberList() {
        return this.calculateMeasureNumberList;
    }

    public Map<String, String> getCalMeaMappingMap() {
        return this.calMeaMappingMap;
    }

    public Map<String, String> getCalAttrMappingMap() {
        return this.calAttrMappingMap;
    }

    public Set<Long> getAccountPltype0Set() {
        if (this.accountPltype0Set == null) {
            return Collections.emptySet();
        }
        return this.accountPltype0Set;
    }

    public int getOrmInputParallelism() {
        return this.ormInputParallelism;
    }

    public Set<String> getDetailModelShardingFields() {
        return this.detailModelShardingFields;
    }

    public Set<String> getSummaryModelShardingFields() {
        return this.summaryModelShardingFields;
    }

    public String toString() {
        return "AnalysisModelConfigDTO{analysisModelId=" + this.analysisModelId + ", analysisModel=" + this.analysisModel + ", modelEntityNumber='" + this.modelEntityNumber + '\'' + ", modelTableNumber='" + this.modelTableNumber + '\'' + ", modelDetailEntityNumber='" + this.modelDetailEntityNumber + '\'' + ", modelDetailTableNumber='" + this.modelDetailTableNumber + '\'' + ", modelDimensionNumberList=" + this.modelDimensionNumberList + ", modelMeasureNumberList=" + this.modelMeasureNumberList + '}';
    }
}

