/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.common.util.ScriptBuilder;
import kd.fi.pa.engine.model.DerivationRule;
import kd.fi.pa.enginealgox.model.config.AbstractConfigDTO;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.utils.AnalysisModelUtil;
import kd.fi.pa.utils.PAUtil;

public class DerivationRuleConfigDTO
extends AbstractConfigDTO {
    private static final long serialVersionUID = 7476251981370749246L;
    private final DerivationRule derivationRule;
    private String derivationMode = null;
    private Map<String, String> sourceFieldMap = null;
    private Map<String, String> targetFieldMap = null;
    private Map<String, Object> targetFieldDVMap = null;
    private LinkedHashMap<String, String> targetFieldToMTargetFieldMap = null;
    private int customEntryCount = 0;
    private Map<String, Set<String>> customDimMap = null;
    private Map<String, Map<String, Object>> customEntryMap = null;

    public DerivationRuleConfigDTO(DerivationRule derivationRule) {
        this.derivationRule = derivationRule;
        if (derivationRule != null) {
            this.initConfig();
        }
    }

    @Override
    public final void initConfig() {
        this.initRuleBasic();
    }

    private void initRuleBasic() {
        this.derivationMode = this.derivationRule.getDerivationMode();
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)this.derivationMode);
        switch (derivationTypeEnum) {
            case DERIVATION_MAPPING_RELATIONSHIP: {
                this.processMappingShip();
                break;
            }
            case DERIVATION_MAPPING_TABLE: {
                this.processMappingTable();
                break;
            }
            case DERIVATION_CUSTOM: {
                this.processCustom();
                break;
            }
        }
    }

    private void processMappingShip() {
        DynamicObjectCollection sourceEntryEntity = this.derivationRule.getSourceEntryEntity();
        DynamicObjectCollection targetEntryEntity = this.derivationRule.getTargetEntryEntity();
        HashMap<String, String> newSourceFieldMap = new HashMap<String, String>(8);
        HashMap<String, String> newTargetFieldMap = new HashMap<String, String>(8);
        HashMap<String, Object> newTargetFieldDVMap = new HashMap<String, Object>(8);
        for (DynamicObject dy : sourceEntryEntity) {
            DynamicObject sourceDy = dy.getDynamicObject("sourcefield");
            String sourceNumber = sourceDy.getString("number");
            String sourceNumberFormat = FieldUtil.sourceFormat(sourceNumber);
            newSourceFieldMap.put(sourceNumber, sourceNumberFormat);
        }
        for (DynamicObject dy : targetEntryEntity) {
            DynamicObject targetDy = dy.getDynamicObject("targetfield");
            String defaultText = dy.getString("default_text_e");
            String defaultTextId = dy.getString("default_text");
            String targetNumber = targetDy.getString("number");
            String dimensionType = targetDy.getString("dimensiontype");
            String entityNumber = targetDy.getString("dimensionsource_id");
            String targetNumberFormat = FieldUtil.targetFormat(targetNumber);
            newTargetFieldMap.put(targetNumber, targetNumberFormat);
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.OTHER == dimensionTypeEnum || DimensionTypeEnum.DENUMS == dimensionTypeEnum) {
                if (!StringUtils.isNotEmpty((CharSequence)defaultText)) continue;
                newTargetFieldDVMap.put(targetNumberFormat, defaultText);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)defaultTextId)) continue;
            DataType dimDataType = ModelUtil.getDimDataType(dimensionType, entityNumber);
            if (dimDataType == DataType.LongType) {
                newTargetFieldDVMap.put(targetNumberFormat, Long.valueOf(defaultTextId));
                continue;
            }
            newTargetFieldDVMap.put(targetNumberFormat, defaultTextId);
        }
        this.sourceFieldMap = newSourceFieldMap;
        this.targetFieldMap = newTargetFieldMap;
        this.targetFieldDVMap = newTargetFieldDVMap;
    }

    private void processMappingTable() {
        DynamicObjectCollection mtSourceEntryEntity = this.derivationRule.getMtSourceEntryEntity();
        DynamicObjectCollection mtTargetEntryEntity = this.derivationRule.getMtTargetEntryEntity();
        HashMap<String, String> newSourceFieldMap = new HashMap<String, String>(8);
        HashMap<String, String> newTargetFieldMap = new HashMap<String, String>(8);
        HashMap<String, Object> newTargetFieldDVMap = new HashMap<String, Object>(8);
        LinkedHashMap<String, String> newTargetFieldToMTargetFieldMap = new LinkedHashMap<String, String>(8);
        for (DynamicObject dy : mtSourceEntryEntity) {
            DynamicObject sourceDy = dy.getDynamicObject("mt_source");
            String mtSourceFieldNumber = dy.getString("mt_sourcefield_number");
            String mtMSourceFieldNumber = dy.getString("mt_m_sourcefield_number");
            String mtSourceFieldNumberFormat = FieldUtil.modelFormat(mtSourceFieldNumber);
            String number = sourceDy.getString("number");
            String dimensionType = sourceDy.getString("dimensiontype");
            String mtMSourceFieldNumberFormat = FieldUtil.otherFormat(mtMSourceFieldNumber);
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.OTHER != dimensionTypeEnum) {
                String sourceField = number + "_" + mtSourceFieldNumberFormat;
                newSourceFieldMap.put(sourceField, mtMSourceFieldNumberFormat);
                continue;
            }
            newSourceFieldMap.put(number, mtMSourceFieldNumberFormat);
        }
        for (DynamicObject dy : mtTargetEntryEntity) {
            DynamicObject targetDy = dy.getDynamicObject("mt_target");
            String mtTargetFieldNumber = dy.getString("mt_targetfield_number");
            String mtMTargetFieldNumber = dy.getString("mt_m_targetfield_number");
            String mtMDefaultText = dy.getString("mt_m_default_text_e");
            String mtMDefaultTextId = dy.getString("mt_m_default_text");
            String number = targetDy.getString("number");
            String dimensionType = targetDy.getString("dimensiontype");
            String entityNumber = targetDy.getString("dimensionsource_id");
            String mtMTargetFieldNumberFormat = FieldUtil.otherFormat(mtMTargetFieldNumber);
            String newTargetField = number + '.' + mtTargetFieldNumber;
            newTargetFieldToMTargetFieldMap.put(newTargetField, mtMTargetFieldNumber);
            newTargetFieldMap.put(number, mtMTargetFieldNumberFormat);
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.OTHER == dimensionTypeEnum || DimensionTypeEnum.DENUMS == dimensionTypeEnum) {
                if (!StringUtils.isNotEmpty((CharSequence)mtMDefaultText)) continue;
                newTargetFieldDVMap.put(mtMTargetFieldNumberFormat, mtMDefaultText);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)mtMDefaultTextId)) continue;
            DataType dimDataType = ModelUtil.getDimDataType(dimensionType, entityNumber);
            if (dimDataType == DataType.LongType) {
                newTargetFieldDVMap.put(mtMTargetFieldNumberFormat, Long.valueOf(mtMDefaultTextId));
                continue;
            }
            newTargetFieldDVMap.put(mtMTargetFieldNumberFormat, mtMDefaultTextId);
        }
        this.sourceFieldMap = newSourceFieldMap;
        this.targetFieldMap = newTargetFieldMap;
        this.targetFieldDVMap = newTargetFieldDVMap;
        this.targetFieldToMTargetFieldMap = newTargetFieldToMTargetFieldMap;
    }

    private void processCustom() {
        DynamicObject analysisModelDy = this.derivationRule.getAnalysisModel();
        Map<String, Set<String>> newCustomDimMap = this.createCustomDimMap(analysisModelDy.getLong("id"));
        DynamicObjectCollection customEntryEntity = this.derivationRule.getCustomEntryEntity();
        int customEntryEntityRowCount = customEntryEntity.getRowCount();
        String entityNumber = AnalysisModelUtil.buildEntityNumber((String)analysisModelDy.getString("tablenumber"));
        Map<String, Map<String, Object>> newCustomEntryMap = this.createCustomEntryMao(customEntryEntity, entityNumber, newCustomDimMap);
        this.customDimMap = newCustomDimMap;
        this.customEntryCount = customEntryEntityRowCount;
        this.customEntryMap = newCustomEntryMap;
    }

    private Map<String, Set<String>> createCustomDimMap(Long analysisModelId) {
        Set dimFieldSet = PAAnalysisModelHelper.getDimFieldSet((Long)analysisModelId);
        Set dimPkFieldSet = PAAnalysisModelHelper.getDimPkFieldSet((Set)dimFieldSet);
        dimFieldSet.addAll(dimPkFieldSet);
        HashMap<String, Set<String>> newCustomDimMap = new HashMap<String, Set<String>>(8);
        for (String dimField : dimFieldSet) {
            if (dimField.contains(".")) {
                String[] split = dimField.split("\\.", 2);
                String dimNumber = split[0];
                String dimFieldNumber = split[1];
                if (newCustomDimMap.containsKey(dimNumber)) {
                    Set curDimFieldSet = (Set)newCustomDimMap.get(dimNumber);
                    curDimFieldSet.add(dimFieldNumber);
                    continue;
                }
                HashSet<String> newDimFieldSet = new HashSet<String>();
                newDimFieldSet.add(dimFieldNumber);
                newCustomDimMap.put(dimNumber, newDimFieldSet);
                continue;
            }
            newCustomDimMap.put(dimField, new HashSet());
        }
        return newCustomDimMap;
    }

    private Map<String, Map<String, Object>> createCustomEntryMao(DynamicObjectCollection customEntryEntity, String entityNumber, Map<String, Set<String>> newCustomDimMap) {
        HashMap<String, Map<String, Object>> newCustomEntryMap = new HashMap<String, Map<String, Object>>(8);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (DynamicObject customEntryDy : customEntryEntity) {
            DynamicObject targetDimDy;
            FilterCondition filterCondition;
            int seq = customEntryDy.getInt("seq");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            String conditionJson = customEntryDy.getString("filterconditionjson_tag");
            if (StringUtils.isEmpty((CharSequence)conditionJson) || (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class)) == null) continue;
            ScriptBuilder scriptBuilder = new ScriptBuilder(mainEntityType, filterCondition);
            ScriptBuilder.ValueAndDesc valueAndDesc = scriptBuilder.buildScript();
            String scriptStr = valueAndDesc.getValue();
            dataMap.put("scriptStr", scriptStr);
            List filterRowList = filterCondition.getFilterRow();
            HashSet<String> fieldNameSet = new HashSet<String>(filterRowList.size());
            for (SimpleFilterRow filterRow : filterRowList) {
                List valueList;
                String fieldName = filterRow.getFieldName();
                fieldNameSet.add(fieldName);
                String compareType = filterRow.getCompareType();
                if (!StringUtils.equals((CharSequence)"-1", (CharSequence)compareType) && !StringUtils.equals((CharSequence)"-2", (CharSequence)compareType) || (valueList = filterRow.getValue()) == null || valueList.isEmpty()) continue;
                FilterValue filterValue = (FilterValue)valueList.get(0);
                fieldNameSet.add((String)filterValue.getValue());
            }
            dataMap.put("fieldNameSet", fieldNameSet);
            DynamicObject sourceDimDy = customEntryDy.getDynamicObject("sourcedim");
            if (sourceDimDy != null) {
                String sourceDimNumber = sourceDimDy.getString("number");
                dataMap.put("sourceDimNumber", sourceDimNumber);
            }
            if ((targetDimDy = customEntryDy.getDynamicObject("targetdim")) == null) continue;
            String targetDimNumber = targetDimDy.getString("number");
            dataMap.put("targetDimNumber", targetDimNumber);
            String dimensionType = targetDimDy.getString("dimensiontype");
            String defaultTextValue = customEntryDy.getString("defaulttextvalue");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: {
                    DynamicObject dimensionSourceDy = targetDimDy.getDynamicObject("dimensionsource");
                    String dimensionSource = dimensionSourceDy != null ? dimensionSourceDy.getString("number") : "bos_assistantdata_detail";
                    DataType dimDataType = ModelUtil.getDimDataType(dimensionType, entityNumber);
                    if (StringUtils.isNotEmpty((CharSequence)defaultTextValue)) {
                        Set<String> fieldSet = newCustomDimMap.get(targetDimNumber);
                        if (dimDataType == DataType.LongType) {
                            Long longDefaultTextValue = PAUtil.safeToLong((String)defaultTextValue);
                            if (longDefaultTextValue == null) {
                                longDefaultTextValue = 0L;
                            }
                            Map<String, Object> defaultValueMap = this.expandDefaultValue(longDefaultTextValue, dimensionSource, fieldSet);
                            dataMap.put("defaultValue", defaultValueMap);
                            break;
                        }
                        Map<String, Object> defaultValueMap = this.expandDefaultValue(defaultTextValue, dimensionSource, fieldSet);
                        dataMap.put("defaultValue", defaultValueMap);
                        break;
                    }
                    if (dimDataType == DataType.LongType) {
                        dataMap.put("defaultValue", 0L);
                        break;
                    }
                    dataMap.put("defaultValue", " ");
                    break;
                }
                case OTHER: 
                case DENUMS: {
                    if (StringUtils.isNotEmpty((CharSequence)defaultTextValue)) {
                        dataMap.put("defaultValue", defaultTextValue);
                        break;
                    }
                    dataMap.put("defaultValue", " ");
                    break;
                }
            }
            newCustomEntryMap.put(String.valueOf(seq), dataMap);
        }
        return newCustomEntryMap;
    }

    private Map<String, Object> expandDefaultValue(Object pkId, String entityNumber, Set<String> fieldSet) {
        String selectFields;
        DynamicObject defaultDy;
        if (fieldSet == null || fieldSet.isEmpty()) {
            fieldSet = Collections.singleton("id");
        }
        if ((defaultDy = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)entityNumber, (String)(selectFields = String.join((CharSequence)",", fieldSet)))) == null) {
            return null;
        }
        HashMap<String, Object> defaultMap = new HashMap<String, Object>(fieldSet.size());
        for (String field : fieldSet) {
            Object defaultValue = defaultDy.get(field);
            if (defaultValue instanceof OrmLocaleValue) {
                defaultMap.put(field, ((OrmLocaleValue)defaultValue).getLocaleValue());
                continue;
            }
            defaultMap.put(field, defaultValue);
        }
        return defaultMap;
    }

    public DerivationRule getDerivationRule() {
        return this.derivationRule;
    }

    public String getDerivationMode() {
        return this.derivationMode;
    }

    public Map<String, String> getSourceFieldMap() {
        return this.sourceFieldMap;
    }

    public Map<String, String> getTargetFieldMap() {
        return this.targetFieldMap;
    }

    public Map<String, Object> getTargetFieldDVMap() {
        return this.targetFieldDVMap;
    }

    public LinkedHashMap<String, String> getTargetFieldToMTargetFieldMap() {
        return this.targetFieldToMTargetFieldMap;
    }

    public int getCustomEntryCount() {
        return this.customEntryCount;
    }

    public Map<String, Map<String, Object>> getCustomEntryMap() {
        return this.customEntryMap;
    }

    public Map<String, Set<String>> getCustomDimMap() {
        return this.customDimMap;
    }

    public String toString() {
        return "DerivationRuleConfigDTO{derivationRule=" + this.derivationRule + ", derivationMode='" + this.derivationMode + '\'' + ", targetFieldToMTargetFieldMap=" + this.targetFieldToMTargetFieldMap + ", sourceFieldMap=" + this.sourceFieldMap + ", targetFieldMap=" + this.targetFieldMap + ", targetFieldDVMap=" + this.targetFieldDVMap + '}';
    }
}

