/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.config;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import kd.fi.pa.dto.BusinessExecutionParamDTO;
import kd.fi.pa.enginealgox.model.config.AbstractConfigDTO;
import kd.fi.pa.helper.PALogHelper;

public class LogConfigDTO
extends AbstractConfigDTO {
    private static final long serialVersionUID = -4007542888924318414L;
    private final Long executionLogId;
    private ArrayList<Long> orgIds;
    private Long period;
    private Date startDate;
    private Date endDate;
    private Set<Long> accountIdSet;
    private long ruleExecutionLogId;

    public LogConfigDTO(Long logId) {
        this.executionLogId = logId;
        if (logId != null) {
            this.initConfig();
        }
    }

    @Override
    public final void initConfig() {
        this.initLogBasic();
    }

    private void initLogBasic() {
        BusinessExecutionParamDTO executionLogConditionDTO = PALogHelper.getExecutionLogCondition((Long)this.executionLogId);
        this.orgIds = executionLogConditionDTO.getOrgIds();
        this.period = executionLogConditionDTO.getPeriod();
        this.startDate = executionLogConditionDTO.getStartDate();
        this.endDate = executionLogConditionDTO.getEndDate();
    }

    public Long getExecutionLogId() {
        return this.executionLogId;
    }

    public ArrayList<Long> getOrgIds() {
        return this.orgIds;
    }

    public Long getPeriod() {
        return this.period;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Set<Long> getAccountIdSet() {
        return this.accountIdSet;
    }

    public void setAccountIdSet(Set<Long> accountIdSet) {
        this.accountIdSet = accountIdSet;
    }

    public long getRuleExecutionLogId() {
        return this.ruleExecutionLogId;
    }

    public void setRuleExecutionLogId(long ruleExecutionLogId) {
        this.ruleExecutionLogId = ruleExecutionLogId;
    }
}

