/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.job;

import java.util.List;
import java.util.Map;
import kd.bos.algo.input.OrmInput;
import kd.fi.pa.engine.executor.AllocationReceiverBuildExecutor;
import kd.fi.pa.engine.executor.AllocationSenderBuildExecutor;
import kd.fi.pa.enginealgox.model.business.AllocationBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AllocationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;

public class AllocationJobDTO {
    private final OrmInput[] senderOrmInputs;
    private final List<Map<String, String>> receiverList;

    public AllocationJobDTO(AllocationBusinessDTO allocationBusinessDTO) {
        this.senderOrmInputs = this.buildSender(allocationBusinessDTO);
        this.receiverList = this.buildReceiver(allocationBusinessDTO);
    }

    private OrmInput[] buildSender(AllocationBusinessDTO allocationBusinessDTO) {
        AllocationRuleConfigDTO allocationRuleConfigDTO = allocationBusinessDTO.getAllocationRuleConfigDTO();
        AnalysisModelConfigDTO modelConfigDTO = allocationBusinessDTO.getModelConfigDTO();
        LogConfigDTO logConfigDTO = allocationBusinessDTO.getLogConfigDTO();
        AllocationSenderBuildExecutor senderBuildExecutor = new AllocationSenderBuildExecutor(allocationRuleConfigDTO.getAllocationRule(), modelConfigDTO.getAnalysisModel());
        return senderBuildExecutor.buildAlgoX(allocationBusinessDTO, logConfigDTO);
    }

    private List<Map<String, String>> buildReceiver(AllocationBusinessDTO allocationBusinessDTO) {
        AllocationRuleConfigDTO allocationRuleConfigDTO = allocationBusinessDTO.getAllocationRuleConfigDTO();
        AnalysisModelConfigDTO modelConfigDTO = allocationBusinessDTO.getModelConfigDTO();
        LogConfigDTO logConfigDTO = allocationBusinessDTO.getLogConfigDTO();
        AllocationReceiverBuildExecutor receiverBuildExecutor = new AllocationReceiverBuildExecutor(allocationRuleConfigDTO.getAllocationRule(), modelConfigDTO.getAnalysisModel());
        return receiverBuildExecutor.buildAlgoX(logConfigDTO);
    }

    public OrmInput[] getSenderOrmInputs() {
        return this.senderOrmInputs;
    }

    public List<Map<String, String>> getReceiverList() {
        return this.receiverList;
    }
}

