/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.model.job;

import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.engine.executor.DerivationReceiverBuildExecutor;
import kd.fi.pa.engine.executor.DerivationSenderBuildExecutor;
import kd.fi.pa.engine.model.DerivationRule;
import kd.fi.pa.enginealgox.model.business.DerivationBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.DerivationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.DimensionTypeEnum;

public class DerivationJobDTO {
    private static final String ALGO_KEY = DerivationJobDTO.class.getName();
    private final OrmInput[] senderOrmInputs;
    private final OrmInput receiverOrmInput;
    private final OrmInput[] dimensionOrmInput;

    public DerivationJobDTO(DerivationBusinessDTO derivationBusinessDTO) {
        this.senderOrmInputs = this.buildSender(derivationBusinessDTO);
        this.receiverOrmInput = this.buildReceiver(derivationBusinessDTO);
        this.dimensionOrmInput = this.buildDimension(derivationBusinessDTO);
    }

    private OrmInput[] buildSender(DerivationBusinessDTO derivationBusinessDTO) {
        DerivationRuleConfigDTO derivationRuleConfigDTO = derivationBusinessDTO.getDerivationRuleConfigDTO();
        AnalysisModelConfigDTO modelConfigDTO = derivationBusinessDTO.getModelConfigDTO();
        LogConfigDTO logConfigDTO = derivationBusinessDTO.getLogConfigDTO();
        DerivationSenderBuildExecutor senderBuildExecutor = new DerivationSenderBuildExecutor(derivationRuleConfigDTO.getDerivationRule(), modelConfigDTO.getAnalysisModel());
        return senderBuildExecutor.buildAlgoX(derivationBusinessDTO, logConfigDTO);
    }

    private OrmInput buildReceiver(DerivationBusinessDTO derivationBusinessDTO) {
        DerivationRuleConfigDTO derivationRuleConfigDTO = derivationBusinessDTO.getDerivationRuleConfigDTO();
        AnalysisModelConfigDTO modelConfigDTO = derivationBusinessDTO.getModelConfigDTO();
        DerivationReceiverBuildExecutor receiverBuildExecutor = new DerivationReceiverBuildExecutor(derivationRuleConfigDTO.getDerivationRule(), modelConfigDTO.getAnalysisModel());
        return receiverBuildExecutor.buildAlgoX();
    }

    private OrmInput[] buildDimension(DerivationBusinessDTO derivationBusinessDTO) {
        DerivationRuleConfigDTO derivationRuleConfigDTO = derivationBusinessDTO.getDerivationRuleConfigDTO();
        DerivationRule derivationRule = derivationRuleConfigDTO.getDerivationRule();
        DynamicObjectCollection mtTargetEntryEntity = derivationRule.getMtTargetEntryEntity();
        if (mtTargetEntryEntity.isEmpty()) {
            return null;
        }
        OrmInput[] dimensionInput = new OrmInput[mtTargetEntryEntity.size()];
        int index = 0;
        for (DynamicObject dy : mtTargetEntryEntity) {
            if (dy == null) {
                dimensionInput[index] = null;
                continue;
            }
            String number = dy.getDynamicObject("mt_target").getString("number");
            String dimensionType = dy.getDynamicObject("mt_target").getString("dimensiontype");
            String targetField = dy.getString("mt_targetfield_number");
            String newTargetField = number + '.' + targetField;
            String targetAlias = FieldUtil.dimFormat(newTargetField);
            String targetFieldFormat = FieldUtil.alias(targetField, targetAlias);
            String targetFieldValueFormat = FieldUtil.dimValueFormatAlias(newTargetField);
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.DATABASE == dimensionTypeEnum) {
                String baseDataEntityNumber = dy.getString("mt_m_fieldtype_basedata");
                String selectFields = String.join((CharSequence)",", targetFieldFormat, targetFieldValueFormat);
                QFilter[] qFilters = ModelUtil.isExistField(baseDataEntityNumber, "enable") ? new QFilter[]{new QFilter("enable", "=", (Object)"1")} : new QFilter[]{};
                dimensionInput[index] = new OrmInput(ALGO_KEY, baseDataEntityNumber, selectFields, qFilters);
            } else if (DimensionTypeEnum.ASSISTANTDATA == dimensionTypeEnum) {
                String assistantGroupNumber = dy.getString("mt_m_fieldtype_assistant");
                String assistantEntityNumber = "bos_assistantdata_detail";
                String selectFields = String.join((CharSequence)",", targetFieldFormat, targetFieldValueFormat);
                QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("group.number", "=", (Object)assistantGroupNumber)};
                dimensionInput[index] = new OrmInput(ALGO_KEY, assistantEntityNumber, selectFields, qFilters);
            } else {
                dimensionInput[index] = null;
            }
            ++index;
        }
        return dimensionInput;
    }

    public OrmInput[] getSenderOrmInputs() {
        return this.senderOrmInputs;
    }

    public OrmInput getReceiverOrmInput() {
        return this.receiverOrmInput;
    }

    public OrmInput[] getDimensionOrmInput() {
        return this.dimensionOrmInput;
    }
}

