/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.enums.TailDifferenceTypeEnum;
import kd.fi.pa.engine.executor.allocation.TailDifferenceProcessor;
import kd.fi.pa.engine.executor.allocation.TailDifferenceProcessorFactory;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.engine.warpper.ReceiverRelateGroupWrapper;
import kd.fi.pa.enginealgox.func.BasicResultMapFunction;
import kd.fi.pa.enginealgox.func.allocation.AllocationDetailFlatMapFunction;
import kd.fi.pa.enginealgox.func.allocation.AllocationEmptyFilterFunction;
import kd.fi.pa.enginealgox.func.summary.AccountPltypeCalcMeasureMapFunction;
import kd.fi.pa.enginealgox.model.business.AllocationBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AllocationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.model.job.AllocationJobDTO;
import kd.fi.pa.enums.PACollectStatusEnum;

public class AllocationAlgoXService {
    private static final Log logger = LogFactory.getLog(AllocationAlgoXService.class);

    public void execute(ConfigDTOManager configDTOManager, String taskUUID, String taskName) {
        logger.info("[FI-PA] AlgoXExecute AllocationAlgoXService execute begin!");
        this.execute(new AllocationBusinessDTO(configDTOManager), taskUUID, taskName);
        logger.info("[FI-PA] AlgoXExecute AllocationAlgoXService execute end!");
    }

    public void execute(AllocationBusinessDTO allocationBusinessDTO, String taskUUID, String taskName) {
        AllocationJobDTO allocationJobDTO = new AllocationJobDTO(allocationBusinessDTO);
        logger.info("[FI-PA] AlgoXExecute AllocationAlgoXService create DTO end!");
        JobSession jobSession = AlgoX.createSession((String)taskName, (String)taskUUID);
        this.process(jobSession, allocationBusinessDTO, allocationJobDTO);
        jobSession.commit(1, TimeUnit.DAYS);
        logger.info("[FI-PA] AlgoXExecute AllocationAlgoXService create JOB end!");
    }

    private void process(JobSession jobSession, AllocationBusinessDTO allocationBusinessDTO, AllocationJobDTO allocationJobDTO) {
        logger.info("[FI-PA] AlgoXExecute AllocationAlgoXService process SESSION start!");
        DataSetX resultDataSetX = this.pretreatmentDetailData(jobSession, allocationBusinessDTO, allocationJobDTO);
        DataSetX addDetailResultDataSetX = resultDataSetX.filter(String.format("%s=%d", "collectstatus", PACollectStatusEnum.DETAIL.getLongCode())).map((MapFunction)new BasicResultMapFunction(resultDataSetX.getRowMeta(), allocationBusinessDTO.getModelDetailRowMeta()));
        Output insertModelDbOutput = allocationBusinessDTO.getModelDetailDbOutput();
        addDetailResultDataSetX.output(insertModelDbOutput);
        AnalysisModelConfigDTO modelConfigDTO = allocationBusinessDTO.getModelConfigDTO();
        DataSetX updateModelDataSetX = resultDataSetX.filter(String.format("%s=%d", "collectstatus", PACollectStatusEnum.COLLECT.getLongCode())).map((MapFunction)new AccountPltypeCalcMeasureMapFunction(resultDataSetX.getRowMeta(), allocationBusinessDTO.getAllocationCalcMeasureList(), modelConfigDTO.getCalAttrMappingMap(), modelConfigDTO.getAccountDimNumber(), modelConfigDTO.getAccountPltype0Set())).map((MapFunction)new BasicResultMapFunction(resultDataSetX.getRowMeta(), allocationBusinessDTO.getUpdateModelRowMeta()));
        Output updateModelDbOutput = allocationBusinessDTO.getUpdateModelDbOutput();
        updateModelDataSetX.output(updateModelDbOutput);
        logger.info("[FI-PA] AlgoXExecute AllocationAlgoXService process SESSION end!");
    }

    private DataSetX pretreatmentDetailData(JobSession jobSession, AllocationBusinessDTO allocationBusinessDTO, AllocationJobDTO allocationJobDTO) {
        AllocationRuleConfigDTO allocationRuleConfigDTO = allocationBusinessDTO.getAllocationRuleConfigDTO();
        AnalysisModelConfigDTO modelConfigDTO = allocationBusinessDTO.getModelConfigDTO();
        LogConfigDTO logConfigDTO = allocationBusinessDTO.getLogConfigDTO();
        AllocationRule allocationRule = allocationRuleConfigDTO.getAllocationRule();
        DataSetX summaryDataSetX = jobSession.fromInput((Input[])allocationJobDTO.getSenderOrmInputs());
        List<Map<String, String>> receiverList = allocationJobDTO.getReceiverList();
        TailDifferenceProcessor tailDifferenceProcessor = TailDifferenceProcessorFactory.createProcessor(TailDifferenceTypeEnum.getTailDifferenceTypeEnum((String)allocationRule.getTailDifferenceType()));
        if (tailDifferenceProcessor == null) {
            logger.error("[FI-PA] tailDifferenceProcessor is null");
        } else {
            tailDifferenceProcessor.sortReceiverList(receiverList);
        }
        ReceiverRelateGroupWrapper receiverRelateGroupWrapper = new ReceiverRelateGroupWrapper(allocationRule.getRelatedGroupDimNums(), receiverList);
        DataSetX summaryResultDataX = summaryDataSetX.filter((FilterFunction)new AllocationEmptyFilterFunction(summaryDataSetX.getRowMeta(), allocationRuleConfigDTO.getAllocationMeasureNumberList()));
        return summaryResultDataX.flatMap((FlatMapFunction)new AllocationDetailFlatMapFunction(summaryResultDataX.getRowMeta(), logConfigDTO.getExecutionLogId(), logConfigDTO.getRuleExecutionLogId(), allocationRule.getSendRate(), allocationRuleConfigDTO.getAllocationMeasureNumberList(), receiverRelateGroupWrapper, modelConfigDTO.getModelHashDimensionNumberList(), modelConfigDTO.getModelMeasureNumberMap(), allocationBusinessDTO.getOrdCalMeaMappingMap(), tailDifferenceProcessor, allocationRule.isAddShareFlag(), allocationRuleConfigDTO.getAllocationFlagEntryCount(), allocationRuleConfigDTO.getAllocationFlagMap()));
    }
}

