/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.enginealgox.func.BasicResultMapFunction;
import kd.fi.pa.enginealgox.func.derivation.DerivationCustomFlatMapFunction;
import kd.fi.pa.enginealgox.func.derivation.DerivationDetailCoGroupFunction;
import kd.fi.pa.enginealgox.func.derivation.DerivationEmptyFilterFunction;
import kd.fi.pa.enginealgox.func.derivation.DerivationOtherMapFunction;
import kd.fi.pa.enginealgox.func.summary.AccountPltypeCalcMeasureMapFunction;
import kd.fi.pa.enginealgox.model.business.DerivationBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.model.config.DerivationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.model.job.DerivationJobDTO;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enums.PACollectStatusEnum;

public class DerivationAlgoXService {
    private static final Log logger = LogFactory.getLog(DerivationAlgoXService.class);

    public void execute(ConfigDTOManager configDTOManager, String taskUUID, String taskName) {
        logger.info("[FI-PA] AlgoXExecute DerivationAlgoXService execute begin!");
        this.execute(new DerivationBusinessDTO(configDTOManager), taskUUID, taskName);
        logger.info("[FI-PA] AlgoXExecute DerivationAlgoXService execute end!");
    }

    public void execute(DerivationBusinessDTO derivationBusinessDTO, String taskUUID, String taskName) {
        DerivationJobDTO derivationJobDTO = new DerivationJobDTO(derivationBusinessDTO);
        logger.info("[FI-PA] AlgoXExecute DerivationAlgoXService create DTO end!");
        JobSession jobSession = AlgoX.createSession((String)taskName, (String)taskUUID);
        this.process(jobSession, derivationBusinessDTO, derivationJobDTO);
        jobSession.commit(1, TimeUnit.DAYS);
        logger.info("[FI-PA] AlgoXExecute DerivationAlgoXService create JOB end!");
    }

    private void process(JobSession jobSession, DerivationBusinessDTO derivationBusinessDTO, DerivationJobDTO derivationJobDTO) {
        logger.info("[FI-PA] AlgoXExecute DerivationAlgoXService process SESSION start!");
        DataSetX resultDataSetX = this.pretreatmentDetailData(jobSession, derivationBusinessDTO, derivationJobDTO);
        if (resultDataSetX == null) {
            logger.error("[FI-PA] AlgoXExecute DerivationAlgoXService orchestrate algoX error!");
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "orchestrate algoX error");
        }
        DataSetX addDetailResultDataSetX = resultDataSetX.filter(String.format("%s=%d", "collectstatus", PACollectStatusEnum.DETAIL.getLongCode())).map((MapFunction)new BasicResultMapFunction(resultDataSetX.getRowMeta(), derivationBusinessDTO.getModelDetailRowMeta()));
        Output insertModelDbOutput = derivationBusinessDTO.getModelDetailDbOutput();
        addDetailResultDataSetX.output(insertModelDbOutput);
        AnalysisModelConfigDTO modelConfigDTO = derivationBusinessDTO.getModelConfigDTO();
        DataSetX updateModelDataSetX = resultDataSetX.filter(String.format("%s=%d", "collectstatus", PACollectStatusEnum.COLLECT.getLongCode())).map((MapFunction)new AccountPltypeCalcMeasureMapFunction(resultDataSetX.getRowMeta(), modelConfigDTO.getCalculateMeasureNumberList(), modelConfigDTO.getCalAttrMappingMap(), modelConfigDTO.getAccountDimNumber(), modelConfigDTO.getAccountPltype0Set())).map((MapFunction)new BasicResultMapFunction(resultDataSetX.getRowMeta(), derivationBusinessDTO.getUpdateModelRowMeta()));
        Output updateModelDbOutput = derivationBusinessDTO.getUpdateModelDbOutput();
        updateModelDataSetX.output(updateModelDbOutput);
        logger.info("[FI-PA] AlgoXExecute DerivationAlgoXService process SESSION end!");
    }

    private DataSetX pretreatmentDetailData(JobSession jobSession, DerivationBusinessDTO derivationBusinessDTO, DerivationJobDTO derivationJobDTO) {
        DerivationRuleConfigDTO derivationRuleConfigDTO = derivationBusinessDTO.getDerivationRuleConfigDTO();
        AnalysisModelConfigDTO modelConfigDTO = derivationBusinessDTO.getModelConfigDTO();
        LogConfigDTO logConfigDTO = derivationBusinessDTO.getLogConfigDTO();
        DataSetX summaryDataSetX = jobSession.fromInput((Input[])derivationJobDTO.getSenderOrmInputs());
        DataSetX summaryResultDataSetX = summaryDataSetX.filter((FilterFunction)new DerivationEmptyFilterFunction(summaryDataSetX.getRowMeta(), derivationBusinessDTO.getOrdinaryMeasureNumberList()));
        String derivationMode = derivationRuleConfigDTO.getDerivationMode();
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)derivationMode);
        switch (derivationTypeEnum) {
            case DERIVATION_MAPPING_TABLE: 
            case DERIVATION_MAPPING_RELATIONSHIP: {
                DataSetX otherDataSetX = this.processReceiverDataSetX(jobSession, derivationBusinessDTO, derivationJobDTO);
                DataSetX otherResultDataSetX = otherDataSetX.map((MapFunction)new DerivationOtherMapFunction(otherDataSetX.getRowMeta(), derivationBusinessDTO.getOtherRowMeta(), derivationRuleConfigDTO.getDerivationMode(), derivationRuleConfigDTO.getTargetFieldToMTargetFieldMap()));
                CoGroupDataSetX coGroupDataSetX = summaryResultDataSetX.coGroup(otherResultDataSetX, (CoGroupFunction)new DerivationDetailCoGroupFunction(summaryResultDataSetX.getRowMeta(), otherResultDataSetX.getRowMeta(), logConfigDTO.getExecutionLogId(), logConfigDTO.getRuleExecutionLogId(), modelConfigDTO.getModelHashDimensionNumberList(), modelConfigDTO.getModelMeasureNumberList(), derivationBusinessDTO.getOrdinaryMeasureNumberList(), derivationRuleConfigDTO.getTargetFieldMap(), derivationRuleConfigDTO.getTargetFieldDVMap(), modelConfigDTO.getModelDetailEntityNumber(), derivationRuleConfigDTO.getDerivationRule().getEntrySeqField(), derivationRuleConfigDTO.getDerivationMode(), derivationBusinessDTO.getOrdCalMeaMappingMap()));
                for (Map.Entry<String, String> entry : derivationRuleConfigDTO.getSourceFieldMap().entrySet()) {
                    coGroupDataSetX.on(entry.getKey(), entry.getValue());
                }
                return coGroupDataSetX;
            }
            case DERIVATION_CUSTOM: {
                return summaryResultDataSetX.flatMap((FlatMapFunction)new DerivationCustomFlatMapFunction(summaryResultDataSetX.getRowMeta(), logConfigDTO.getExecutionLogId(), logConfigDTO.getRuleExecutionLogId(), modelConfigDTO.getModelMeasureNumberList(), modelConfigDTO.getModelHashDimensionNumberList(), derivationBusinessDTO.getOrdinaryMeasureNumberList(), derivationBusinessDTO.getOrdCalMeaMappingMap(), derivationRuleConfigDTO.getCustomEntryCount(), derivationRuleConfigDTO.getCustomDimMap(), derivationRuleConfigDTO.getCustomEntryMap()));
            }
        }
        return null;
    }

    private DataSetX processReceiverDataSetX(JobSession jobSession, DerivationBusinessDTO derivationBusinessDTO, DerivationJobDTO derivationJobDTO) {
        DerivationRuleConfigDTO derivationRuleConfigDTO = derivationBusinessDTO.getDerivationRuleConfigDTO();
        String derivationMode = derivationRuleConfigDTO.getDerivationMode();
        DataSetX receiverDataSetX = jobSession.fromInput((Input)derivationJobDTO.getReceiverOrmInput());
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)derivationMode);
        if (derivationTypeEnum == DerivationTypeEnum.DERIVATION_MAPPING_TABLE) {
            LinkedHashMap<String, String> targetFieldToMTargetFieldMap = derivationRuleConfigDTO.getTargetFieldToMTargetFieldMap();
            OrmInput[] dimensionOrmInput = derivationJobDTO.getDimensionOrmInput();
            if (dimensionOrmInput != null && dimensionOrmInput.length > 0) {
                int index = 0;
                Set entrySet = targetFieldToMTargetFieldMap.entrySet();
                DataSetX tempDataSetX = receiverDataSetX;
                for (Map.Entry targetFieldToMTargetFieldEntry : entrySet) {
                    String targetField = (String)targetFieldToMTargetFieldEntry.getKey();
                    String mTargetField = (String)targetFieldToMTargetFieldEntry.getValue();
                    String mTargetFieldFormat = FieldUtil.otherFormat(mTargetField);
                    String targetFieldFormat = FieldUtil.dimFormat(targetField);
                    OrmInput ormInput = dimensionOrmInput[index];
                    if (ormInput != null) {
                        DataSetX dimDataSetX = jobSession.fromInput((Input)ormInput);
                        tempDataSetX = tempDataSetX.leftJoin(dimDataSetX).on(mTargetFieldFormat, targetFieldFormat);
                    }
                    ++index;
                }
                return tempDataSetX;
            }
        }
        return receiverDataSetX;
    }
}

