/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.service;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.enginealgox.func.BasicResultMapFunction;
import kd.fi.pa.enginealgox.func.summary.AccountPltypeCalcMeasureMapFunction;
import kd.fi.pa.enginealgox.func.summary.DimhashFilterFunction;
import kd.fi.pa.enginealgox.func.summary.ImmediateSumCalDetailFlatMapFunction;
import kd.fi.pa.enginealgox.func.summary.SummarySumCoCroupFunction;
import kd.fi.pa.enginealgox.model.business.SummaryCalculateBusinessDTO;
import kd.fi.pa.enginealgox.model.config.AllocationRuleConfigDTO;
import kd.fi.pa.enginealgox.model.config.AnalysisModelConfigDTO;
import kd.fi.pa.enginealgox.model.config.ConfigDTOEnum;
import kd.fi.pa.enginealgox.model.config.ConfigDTOManager;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PACollectStatusEnum;
import kd.fi.pa.helper.PACustomParamHelper;
import kd.fi.pa.helper.PAFilterHelper;
import kd.fi.pa.utils.AnalysisModelHashUtil;
import kd.fi.pa.utils.CollectionUtils;

public class SummaryCalculateAlgoXService {
    private static final Log logger = LogFactory.getLog(SummaryCalculateAlgoXService.class);
    private static final String ALGO_KEY = SummaryCalculateAlgoXService.class.getName();
    private static final ThreadLocal<BloomFilter<String>> detailBloomFilterTL = new ThreadLocal();
    private static final ThreadLocal<BitSet> detailDuplicateBitSetTL = new ThreadLocal();
    private static final ThreadLocal<BitSet> summaryBitSetTL = new ThreadLocal();
    private static final ThreadLocal<Set<Object>> detailOrgIdsTL = new ThreadLocal();

    public void execute(ConfigDTOManager configDTOManager, String taskUUID, String taskName) {
        logger.info("[FI-PA] AlgoXExecute SummaryCalculateAlgoXService execute begin!");
        this.execute(new SummaryCalculateBusinessDTO(configDTOManager), taskUUID, taskName);
        logger.info("[FI-PA] AlgoXExecute SummaryCalculateAlgoXService execute end!");
    }

    private void execute(SummaryCalculateBusinessDTO summaryCalculateDTO, String taskUUID, String taskName) {
        JobSession jobSession = AlgoX.createSession((String)taskName, (String)taskUUID);
        this.summaryCalculateProcess(jobSession, summaryCalculateDTO);
        jobSession.commit(1, TimeUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void summaryCalculateProcess(JobSession jobSession, SummaryCalculateBusinessDTO summaryCalculateDTO) {
        QFilter modelDetailFilter = this.buildModelDetailQFilter(summaryCalculateDTO, true);
        this.fillModelDimHash(summaryCalculateDTO, modelDetailFilter, true);
        this.fillModelDimHash(summaryCalculateDTO, this.buildOrgPeriodQFilter(summaryCalculateDTO, this.buildCurrentPeriodQFilter(summaryCalculateDTO)), false);
        try {
            String summaryTagId = this.tagIncrementSummaryData(summaryCalculateDTO, modelDetailFilter);
            DataSetX incrementSummaryDataSetX = this.summaryIncrementData(jobSession, summaryCalculateDTO, summaryTagId);
            this.outputIncrementSummaryData(summaryCalculateDTO, incrementSummaryDataSetX);
        }
        finally {
            detailBloomFilterTL.remove();
            detailDuplicateBitSetTL.remove();
            summaryBitSetTL.remove();
            detailOrgIdsTL.remove();
        }
    }

    private void fillModelDimHash(SummaryCalculateBusinessDTO summaryCalculateDTO, QFilter modelFilter, boolean isDetail) {
        long costTime;
        if (!summaryCalculateDTO.isModelContainsDimHash()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        String entityName = null;
        String updateSql = summaryCalculateDTO.getUpdateDimHashSql(isDetail);
        entityName = isDetail ? summaryCalculateDTO.getModelConfigDTO().getModelDetailEntityNumber() : summaryCalculateDTO.getModelConfigDTO().getModelEntityNumber();
        int batchSize = 5000;
        ArrayList<Object[]> params = new ArrayList<Object[]>(batchSize);
        List<String> modelHashDimensionNumberList = summaryCalculateDTO.getModelConfigDTO().getModelHashDimensionNumberList();
        QFilter dimhashEmptyFilter = new QFilter("dimhash", "=", (Object)" ");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryEmptyDimHash", (String)entityName, (String)("id," + String.join((CharSequence)",", modelHashDimensionNumberList)), (QFilter[])new QFilter[]{modelFilter, dimhashEmptyFilter}, null);){
            for (Row row : ds) {
                params.add(new Object[]{AnalysisModelHashUtil.calculateDimHash((Row)row, modelHashDimensionNumberList), row.getLong("id")});
                if (params.size() != batchSize) continue;
                logger.warn("[FI-PA] model {} data's dimhash is empty, warning", (Object)entityName);
                SummaryCalculateAlgoXService.executeBatchDB(updateSql, params);
            }
        }
        if (params.size() > 0) {
            logger.warn("[FI-PA] model {} data's dimhash is empty, warning", (Object)entityName);
            SummaryCalculateAlgoXService.executeBatchDB(updateSql, params);
        }
        if ((costTime = System.currentTimeMillis() - startTime) > 1000L) {
            logger.info("[FI-PA] fill model {} dimhash cost {}ms", (Object)entityName, (Object)costTime);
        }
    }

    private String tagIncrementSummaryData(SummaryCalculateBusinessDTO dto, QFilter modelDetailFilter) {
        if (!dto.isModelContainsDimHash()) {
            return "";
        }
        Pair<Boolean, Set<String>> analysisResult = this.shouldTagIncrementSummaryData(dto, modelDetailFilter);
        if (!((Boolean)analysisResult.getKey()).booleanValue()) {
            this.buildIncrementSummaryDataBitSet(dto);
            return "";
        }
        return this.tagIncrementSummaryDataByDimhash(dto, (Set)analysisResult.getValue());
    }

    private Pair<Boolean, Set<String>> shouldTagIncrementSummaryData(SummaryCalculateBusinessDTO dto, QFilter modelDetailFilter) {
        long startTime = System.currentTimeMillis();
        boolean shoudTagSummary = true;
        int tagSummaryDetailCountLimit = PACustomParamHelper.getTagSummaryDetailCountLimit();
        HashSet<Object> detailOrgIds = new HashSet<Object>(32);
        HashSet<String> dimhashSet = new HashSet<String>(tagSummaryDetailCountLimit);
        BloomFilter detailBloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (int)10000000, (double)0.01);
        BitSet detailDuplicateBitSet = new BitSet(Integer.parseInt("FFFFFF", 16));
        BitSet detailBitSet = new BitSet(Integer.parseInt("FFFFFF", 16));
        String detailEntityNumber = dto.getModelConfigDTO().getModelDetailEntityNumber();
        long detailCount = 0L;
        String orgDimNumber = dto.getModelConfigDTO().getOrgDimNumber();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDetailModelDimhash", (String)detailEntityNumber, (String)(orgDimNumber + "," + "dimhash"), (QFilter[])new QFilter[]{modelDetailFilter}, null);){
            for (Row row : ds) {
                int dimhashIntValue;
                String dimhash = row.getString("dimhash");
                if (!AnalysisModelHashUtil.isValidDimhash((String)dimhash)) {
                    throw new KDBizException(String.format("detail model %s data's dimhash is empty or length is not equal to 16, stop summary", detailEntityNumber));
                }
                detailOrgIds.add(row.get(orgDimNumber));
                ++detailCount;
                detailBloomFilter.put((Object)dimhash);
                if (shoudTagSummary) {
                    if (detailCount <= (long)tagSummaryDetailCountLimit) {
                        dimhashSet.add(dimhash);
                    } else {
                        shoudTagSummary = false;
                    }
                }
                if (detailBitSet.get(dimhashIntValue = AnalysisModelHashUtil.dimhashToIntValue((String)dimhash))) {
                    detailDuplicateBitSet.set(dimhashIntValue);
                }
                detailBitSet.set(dimhashIntValue);
            }
        }
        if (!shoudTagSummary) {
            detailBloomFilterTL.set((BloomFilter<String>)detailBloomFilter);
            detailDuplicateBitSetTL.set(detailDuplicateBitSet);
        }
        detailOrgIdsTL.set(detailOrgIds);
        long costTime = System.currentTimeMillis() - startTime;
        if (costTime > 1000L) {
            logger.info("[FI-PA] build detail model {} data's dimhash bloomFilter cost {}ms, total detail count is {}", new Object[]{detailEntityNumber, costTime, detailCount});
        }
        return new Pair((Object)shoudTagSummary, dimhashSet);
    }

    private void buildIncrementSummaryDataBitSet(SummaryCalculateBusinessDTO dto) {
        long startTime = System.currentTimeMillis();
        long summaryCount = 0L;
        QFilter summaryOrgPeriodQFilter = null;
        summaryOrgPeriodQFilter = this.buildOrgPeriodQFilter(dto, this.buildCurrentPeriodQFilter(dto));
        String summaryEntityNumber = dto.getModelConfigDTO().getModelEntityNumber();
        BloomFilter<String> detailBloomFilter = detailBloomFilterTL.get();
        BitSet summaryBitSet = new BitSet(Integer.parseInt("FFFFFF", 16));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySummaryModelDimhash", (String)summaryEntityNumber, (String)"dimhash", (QFilter[])new QFilter[]{summaryOrgPeriodQFilter}, null);){
            for (Row row : ds) {
                String dimhash = row.getString("dimhash");
                if (!AnalysisModelHashUtil.isValidDimhash((String)dimhash)) {
                    throw new KDBizException(String.format("summary model %s data's dimhash is empty or length is not equal to 16, stop summary", summaryEntityNumber));
                }
                if (!detailBloomFilter.mightContain((Object)dimhash)) continue;
                ++summaryCount;
                int dimhashIntValue = AnalysisModelHashUtil.dimhashToIntValue((String)dimhash);
                summaryBitSet.set(dimhashIntValue);
            }
        }
        summaryBitSetTL.set(summaryBitSet);
        long costTime = System.currentTimeMillis() - startTime;
        if (costTime > 1000L) {
            logger.info("[FI-PA] build summary model {} data's dimhash bitSet cost {}ms, total summary count is {}", new Object[]{summaryEntityNumber, costTime, summaryCount});
        }
    }

    private String tagIncrementSummaryDataByDimhash(SummaryCalculateBusinessDTO dto, Set<String> dimhashSet) {
        long startTime = System.currentTimeMillis();
        String summaryEntityNumber = dto.getModelConfigDTO().getModelEntityNumber();
        QFilter summaryOrgPeriodQFilter = null;
        summaryOrgPeriodQFilter = this.buildOrgPeriodQFilter(dto, this.buildCurrentPeriodQFilter(dto));
        String tagId = String.valueOf(DB.genGlobalLongId());
        List dimhashList = CollectionUtils.splitArray((Object[])dimhashSet.toArray(new String[0]), (int)20000);
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        String orgFieldName = dto.getModelConfigDTO().getOrgDimNumber();
        String periodFieldName = dto.getModelConfigDTO().getPeriodDimNumber();
        for (CharSequence[] dimhashArr : dimhashList) {
            String updateSql = String.format("update %s set %s=? where %s and %s in (%s) ", dto.getModelConfigDTO().getModelTableNumber(), "fimportbatch", summaryOrgPeriodQFilter.toString().replaceAll(orgFieldName, "f" + orgFieldName).replaceAll(periodFieldName, "f" + periodFieldName), "fdimhash", "'" + String.join((CharSequence)"','", dimhashArr) + "'");
            params.add(new Object[]{tagId});
            SummaryCalculateAlgoXService.executeBatchDB(updateSql, params);
        }
        long costTime = System.currentTimeMillis() - startTime;
        if (costTime > 1000L) {
            logger.info("[FI-PA] tag summary model {} data cost {}ms", (Object)summaryEntityNumber, (Object)costTime);
        }
        return tagId;
    }

    private static void executeBatchDB(String sql, List<Object[]> params) {
        if (kd.bos.util.CollectionUtils.isEmpty(params)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fias"), (String)sql, params);
        params.clear();
    }

    private DataSetX summaryIncrementData(JobSession jobSession, SummaryCalculateBusinessDTO summaryCalculateDTO, String summaryTagId) {
        AnalysisModelConfigDTO modelConfigDTO = summaryCalculateDTO.getModelConfigDTO();
        OrmInput[] modelDetailOrmInputs = this.buildModelDetailOrmInput(summaryCalculateDTO);
        DataSetX modelDetailDataSetX = jobSession.fromInput((Input[])modelDetailOrmInputs);
        BitSet summaryBitSet = summaryBitSetTL.get();
        BitSet detailDuplicateBitSet = detailDuplicateBitSetTL.get();
        if (summaryBitSet != null && detailDuplicateBitSet != null) {
            modelDetailDataSetX = this.immediateSumCalDetailData(summaryBitSet, detailDuplicateBitSet, modelDetailDataSetX, summaryCalculateDTO);
        }
        OrmInput[] modelSummaryOrmInputs = this.buildModelSummaryOrmInput(summaryCalculateDTO, summaryTagId, this.buildCurrentPeriodQFilter(summaryCalculateDTO));
        DataSetX modelSummaryDataSetX = jobSession.fromInput((Input[])modelSummaryOrmInputs);
        BloomFilter<String> detailBloomFilter = detailBloomFilterTL.get();
        if (detailBloomFilter != null) {
            modelSummaryDataSetX = modelSummaryDataSetX.filter((FilterFunction)new DimhashFilterFunction(modelSummaryDataSetX.getRowMeta(), detailBloomFilter));
        }
        CoGroupDataSetX coGroupDataSetX = modelSummaryDataSetX.coGroup(modelDetailDataSetX, (CoGroupFunction)new SummarySumCoCroupFunction(modelSummaryDataSetX.getRowMeta(), modelDetailDataSetX.getRowMeta(), modelConfigDTO.getOrdinaryMeasureNumberList(), modelConfigDTO.getCalculateMeasureNumberList(), modelConfigDTO.getCalMeaMappingMap()));
        for (String number : modelConfigDTO.getModelDimensionNumberList()) {
            coGroupDataSetX = coGroupDataSetX.on(number, number);
        }
        this.outputUpdateDetailData(summaryCalculateDTO, coGroupDataSetX.filter(this.buildCollectStatusFilter(PACollectStatusEnum.DETAIL)));
        return coGroupDataSetX.filter(this.buildCollectStatusFilter(PACollectStatusEnum.COLLECT));
    }

    private DataSetX immediateSumCalDetailData(BitSet summaryBitSet, BitSet detailDuplicateBitSet, DataSetX modelDetailDataSetX, SummaryCalculateBusinessDTO summaryCalculateDTO) {
        AnalysisModelConfigDTO modelConfigDTO = summaryCalculateDTO.getModelConfigDTO();
        modelDetailDataSetX = modelDetailDataSetX.addFields(new Field[]{new Field("immediate_sum", (DataType)DataType.IntegerType)}, new Object[]{0});
        DataSetX summaryResultDataSetX = modelDetailDataSetX.flatMap((FlatMapFunction)new ImmediateSumCalDetailFlatMapFunction(summaryBitSet, detailDuplicateBitSet, modelDetailDataSetX.getRowMeta(), modelConfigDTO.getCalculateMeasureNumberList(), modelConfigDTO.getCalMeaMappingMap()));
        DataSetX immediateSummaryResultDataSetX = summaryResultDataSetX.filter("immediate_sum=1");
        this.outputUpdateDetailData(summaryCalculateDTO, immediateSummaryResultDataSetX.filter(this.buildCollectStatusFilter(PACollectStatusEnum.DETAIL)));
        this.outputIncrementSummaryData(summaryCalculateDTO, immediateSummaryResultDataSetX.filter(this.buildCollectStatusFilter(PACollectStatusEnum.COLLECT)));
        return summaryResultDataSetX.filter("immediate_sum=0").removeFields(new String[]{"immediate_sum"});
    }

    private void outputIncrementSummaryData(SummaryCalculateBusinessDTO summaryCalculateDTO, DataSetX incrementSummaryDataSetX) {
        AnalysisModelConfigDTO modelConfigDTO = summaryCalculateDTO.getModelConfigDTO();
        if ((incrementSummaryDataSetX = incrementSummaryDataSetX.map((MapFunction)new AccountPltypeCalcMeasureMapFunction(incrementSummaryDataSetX.getRowMeta(), modelConfigDTO.getCalculateMeasureNumberList(), modelConfigDTO.getCalAttrMappingMap(), modelConfigDTO.getAccountDimNumber(), modelConfigDTO.getAccountPltype0Set()))).getRowMeta().getFieldIndex("dbstatus", false) >= 0) {
            DataSetX addSumDataSetX = incrementSummaryDataSetX.filter("dbstatus=1");
            DataSetX addSumResultDataSetX = addSumDataSetX.map((MapFunction)new BasicResultMapFunction(addSumDataSetX.getRowMeta(), summaryCalculateDTO.getInsertModelRowMeta()));
            DataSetX updateSumDataSetX = incrementSummaryDataSetX.filter("dbstatus=2");
            DataSetX updateSumResultDataSetX = updateSumDataSetX.map((MapFunction)new BasicResultMapFunction(updateSumDataSetX.getRowMeta(), summaryCalculateDTO.getUpdateModelRowMeta()));
            Output insertModelDbOutput = summaryCalculateDTO.getInsertModelDbOutput();
            Output updateModelDbOutput = summaryCalculateDTO.getUpdateModelDbOutput();
            addSumResultDataSetX.output(insertModelDbOutput);
            updateSumResultDataSetX.output(updateModelDbOutput);
        } else {
            DataSetX addSumResultDataSetX = incrementSummaryDataSetX.map((MapFunction)new BasicResultMapFunction(incrementSummaryDataSetX.getRowMeta(), summaryCalculateDTO.getInsertModelRowMeta()));
            Output insertModelDbOutput = summaryCalculateDTO.getInsertModelDbOutput();
            addSumResultDataSetX.output(insertModelDbOutput);
        }
    }

    private void outputUpdateDetailData(SummaryCalculateBusinessDTO summaryCalculateDTO, DataSetX detailDataSetX) {
        DataSetX updateDetailResultDataSetX = detailDataSetX.map((MapFunction)new BasicResultMapFunction(detailDataSetX.getRowMeta(), summaryCalculateDTO.getUpdateModelDetailRowMeta()));
        Output updateModelDetailDbOutput = summaryCalculateDTO.getUpdateModelDetailDbOutput();
        updateDetailResultDataSetX.output(updateModelDetailDbOutput);
    }

    private QFilter buildModelDetailQFilter(SummaryCalculateBusinessDTO summaryCalculateDTO, boolean includeOrgQFilter) {
        QFilter qFilter = new QFilter("operationstatus", "=", (Object)OperationStatusEnum.UNUSED.getLongCode());
        QFilter periodQFilter = this.buildCurrentPeriodQFilter(summaryCalculateDTO);
        if (includeOrgQFilter) {
            QFilter orgQFilter = this.buildOrgQFilter(summaryCalculateDTO);
            return qFilter.and(orgQFilter).and(periodQFilter);
        }
        return qFilter.and(periodQFilter);
    }

    private QFilter buildOrgQFilter(SummaryCalculateBusinessDTO summaryCalculateDTO) {
        AllocationRule allocationRule;
        AllocationRuleConfigDTO allocationRuleConfigDTO = (AllocationRuleConfigDTO)summaryCalculateDTO.getConfigDTOManager().getConfig(ConfigDTOEnum.ALLOCATION);
        if (allocationRuleConfigDTO != null && MultiOrgShareEnum.YES == (allocationRule = allocationRuleConfigDTO.getAllocationRule()).getMultiOrgShare()) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        String orgDimNumber = summaryCalculateDTO.getModelConfigDTO().getOrgDimNumber();
        return new QFilter(orgDimNumber, "in", summaryCalculateDTO.getLogConfigDTO().getOrgIds());
    }

    private QFilter buildCurrentPeriodQFilter(SummaryCalculateBusinessDTO summaryCalculateDTO) {
        String periodDimNumber = summaryCalculateDTO.getModelConfigDTO().getPeriodDimNumber();
        Long periodId = summaryCalculateDTO.getLogConfigDTO().getPeriod();
        if (periodId == null) {
            return new QFilter("1", "=", (Object)1);
        }
        return new QFilter(periodDimNumber, "=", (Object)periodId);
    }

    private QFilter buildOrgPeriodQFilter(SummaryCalculateBusinessDTO summaryCalculateDTO, QFilter periodQFilter) {
        QFilter orgQFilter = this.buildOrgQFilter(summaryCalculateDTO);
        if (periodQFilter != null) {
            return orgQFilter.and(periodQFilter);
        }
        return orgQFilter;
    }

    private OrmInput[] buildModelDetailOrmInput(SummaryCalculateBusinessDTO summaryCalculateDTO) {
        AnalysisModelConfigDTO modelConfigDTO = summaryCalculateDTO.getModelConfigDTO();
        String modelDetailEntityNumber = modelConfigDTO.getModelDetailEntityNumber();
        String fields = this.processModelDetailFields(modelConfigDTO);
        QFilter[] includeOrgQFilters = null;
        Set<Object> detailOrgIds = detailOrgIdsTL.get();
        if (detailOrgIds != null && !detailOrgIds.isEmpty()) {
            QFilter excludeOrgQFilter = this.buildModelDetailQFilter(summaryCalculateDTO, false);
            int maxOrgInputCount = PACustomParamHelper.getMaxOrgInputCount();
            String orgDimNumber = summaryCalculateDTO.getModelConfigDTO().getOrgDimNumber();
            includeOrgQFilters = PAFilterHelper.splitQFilters((QFilter)excludeOrgQFilter, (String)orgDimNumber, (Object[])detailOrgIds.toArray(), (int)maxOrgInputCount);
        } else {
            QFilter includeOrgQFilter = this.buildModelDetailQFilter(summaryCalculateDTO, true);
            includeOrgQFilters = new QFilter[]{includeOrgQFilter};
        }
        ArrayList<OrmInput> ormInputList = new ArrayList<OrmInput>(includeOrgQFilters.length);
        for (QFilter qFilter : includeOrgQFilters) {
            ormInputList.add(new OrmInput(ALGO_KEY, modelDetailEntityNumber, fields, qFilter.toArray()));
        }
        return ormInputList.toArray(new OrmInput[0]);
    }

    private OrmInput[] buildModelSummaryOrmInput(SummaryCalculateBusinessDTO summaryCalculateDTO, String summaryTagId, QFilter periodQFilter) {
        AnalysisModelConfigDTO modelConfigDTO = summaryCalculateDTO.getModelConfigDTO();
        String modelEntityNumber = modelConfigDTO.getModelEntityNumber();
        String fields = this.processModelSummaryFields(modelConfigDTO.getAnalysisModel());
        if (StringUtils.isNotBlank((CharSequence)summaryTagId)) {
            periodQFilter.and("importbatch", "=", (Object)summaryTagId);
        }
        QFilter[] includeOrgQFilters = null;
        Set<Object> detailOrgIds = detailOrgIdsTL.get();
        if (detailOrgIds != null && !detailOrgIds.isEmpty()) {
            int maxOrgInputCount = PACustomParamHelper.getMaxOrgInputCount();
            String orgDimNumber = summaryCalculateDTO.getModelConfigDTO().getOrgDimNumber();
            includeOrgQFilters = PAFilterHelper.splitQFilters((QFilter)periodQFilter, (String)orgDimNumber, (Object[])detailOrgIds.toArray(), (int)maxOrgInputCount);
        } else {
            QFilter includeOrgQFilter = periodQFilter.and(this.buildOrgQFilter(summaryCalculateDTO));
            includeOrgQFilters = new QFilter[]{includeOrgQFilter};
        }
        ArrayList<OrmInput> ormInputList = new ArrayList<OrmInput>(includeOrgQFilters.length);
        for (QFilter qFilter : includeOrgQFilters) {
            ormInputList.add(new OrmInput(ALGO_KEY, modelEntityNumber, fields, qFilter.toArray()));
        }
        return ormInputList.toArray(new OrmInput[0]);
    }

    private String processModelSummaryFields(DynamicObject analysisModel) {
        List<String> fieldList = ModelUtil.getModelFieldList(analysisModel);
        return String.join((CharSequence)",", fieldList);
    }

    private String processModelDetailFields(AnalysisModelConfigDTO modelConfigDTO) {
        List<String> fieldList = ModelUtil.getModelDetailFieldList(modelConfigDTO.getAnalysisModel());
        fieldList.remove("sourceformid");
        fieldList.remove("sourcebillid");
        fieldList.remove("execlogid");
        fieldList.remove("subexeclogid");
        fieldList.remove("execparentbillid");
        fieldList.remove("createstamp");
        return String.join((CharSequence)",", fieldList);
    }

    private String buildCollectStatusFilter(PACollectStatusEnum collectStatus) {
        return String.format("%s=%d", "collectstatus", collectStatus.getLongCode());
    }
}

