/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.utils;

public class FieldUtil {
    public static final String PREFIX_CONFIG = "config_";
    public static final String PREFIX_DIM = "dim_";
    public static final String PREFIX_OTHER = "other_";
    public static final String SUFFIX_VALUE = "_value";
    public static final String PREFIX_SOURCE = "source_";
    public static final String PREFIX_TARGET = "target_";

    private FieldUtil() {
    }

    public static String replace(String field) {
        return field.replaceAll("\\.", "_");
    }

    public static String prefix(String field, String prefix) {
        return String.format("%s%s", prefix, field);
    }

    public static String suffix(String field, String suffix) {
        return String.format("%s%s", field, suffix);
    }

    public static String alias(String field1, String field2) {
        return String.format("%s %s", field1, field2);
    }

    public static String configFormat(String field) {
        return FieldUtil.prefix(field, PREFIX_CONFIG);
    }

    public static String modelFormat(String field) {
        return FieldUtil.replace(field);
    }

    public static String valueFormat(String field) {
        return FieldUtil.suffix(field, SUFFIX_VALUE);
    }

    public static String modelFormatAlias(String field) {
        return FieldUtil.alias(field, FieldUtil.replace(field));
    }

    public static String sourceFormat(String field) {
        return FieldUtil.prefix(field, PREFIX_SOURCE);
    }

    public static String sourceFormatAlias(String field) {
        return FieldUtil.alias(field, FieldUtil.prefix(field, PREFIX_SOURCE));
    }

    public static String targetFormat(String field) {
        return FieldUtil.prefix(field, PREFIX_TARGET);
    }

    public static String targetFormatAlias(String field) {
        return FieldUtil.alias(field, FieldUtil.prefix(field, PREFIX_TARGET));
    }

    public static String dimFormat(String field) {
        return FieldUtil.replace(FieldUtil.prefix(field, PREFIX_DIM));
    }

    public static String dimFormatAlias(String field) {
        return FieldUtil.alias(field, FieldUtil.replace(FieldUtil.prefix(field, PREFIX_DIM)));
    }

    public static String dimValueFormat(String field) {
        return FieldUtil.replace(String.format("%s%s%s", PREFIX_DIM, field, SUFFIX_VALUE));
    }

    public static String dimValueFormatAlias(String field) {
        return FieldUtil.alias("id", FieldUtil.replace(String.format("%s%s%s", PREFIX_DIM, field, SUFFIX_VALUE)));
    }

    public static String otherFormat(String field) {
        return FieldUtil.replace(FieldUtil.prefix(field, PREFIX_OTHER));
    }

    public static String otherFormatAlias(String field) {
        return FieldUtil.alias(field, FieldUtil.replace(FieldUtil.prefix(field, PREFIX_OTHER)));
    }

    public static String otherValueFormat(String field) {
        return FieldUtil.replace(String.format("%s%s%s", PREFIX_OTHER, field, SUFFIX_VALUE));
    }
}

