/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.utils.AnalysisModelHashUtil;
import kd.fi.pa.utils.AnalysisModelUtil;

public class ModelUtil {
    private static final Log logger = LogFactory.getLog(ModelUtil.class);

    private ModelUtil() {
    }

    public static boolean isExistField(String entityNumber, String fieldNumber) {
        return MetadataServiceHelper.getDataEntityType((String)entityNumber).getProperties().stream().anyMatch(iDataEntityProperty -> fieldNumber.equals(iDataEntityProperty.getName()));
    }

    public static DataType getDataType(String entityNumber, String fieldNumber) {
        RowMeta rowMeta = ORM.create().createRowMeta(entityNumber, fieldNumber);
        Field field = rowMeta.getField(fieldNumber);
        return field.getDataType();
    }

    public static String getDimValue(String type, String text) {
        return ModelUtil.getDimValue(type, text, null, null);
    }

    public static String getDimValue(String type, String text, String idStr, String valueStr) {
        String value;
        block6: {
            DimensionTypeEnum dimType;
            block5: {
                value = null;
                dimType = DimensionTypeEnum.getEnum((String)type);
                if (!StringUtils.isNotBlank((CharSequence)text)) break block5;
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: 
                    case DENUMS: {
                        Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        value = String.join((CharSequence)",", map.keySet());
                        break block6;
                    }
                    case OTHER: {
                        value = text.replace('\n', ',');
                        break block6;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block6;
                    }
                    default: {
                        throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "dimType error");
                    }
                }
            }
            value = dimType == DimensionTypeEnum.OTHER ? valueStr : idStr;
        }
        return value;
    }

    public static DataType getDimDataType(String type, String entityNumber) {
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)type);
        switch (dimType) {
            case DATABASE: {
                return ModelUtil.getDataType(entityNumber, "id");
            }
            case ASSISTANTDATA: 
            case PERIOD: {
                return DataType.LongType;
            }
            case DENUMS: 
            case OTHER: {
                return DataType.StringType;
            }
            case DATE: {
                return DataType.DateType;
            }
            case NOTHING: {
                return DataType.NullType;
            }
        }
        throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "dimType error");
    }

    public static QFilter getDimQFilter(String type, String number, String baseEntityId, String condition, String value) {
        QFilter qFilter = null;
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)type);
        FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)condition);
        block0 : switch (conditionEnum) {
            case IS_NULL: {
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        boolean isString = PADimensionModel.isStringPrimaryKeyType((String)baseEntityId);
                        qFilter = isString ? new QFilter(number, "=", (Object)"").or(number, "=", (Object)" ").or(number, "is null", null) : new QFilter(number, "=", (Object)0);
                        break block0;
                    }
                    case DENUMS: 
                    case OTHER: {
                        qFilter = new QFilter(number, "=", (Object)"").or(number, "=", (Object)" ").or(number, "is null", null);
                        break block0;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block0;
                    }
                }
                throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "dimType error");
            }
            case IS_NOTNULL: {
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        boolean isString = PADimensionModel.isStringPrimaryKeyType((String)baseEntityId);
                        qFilter = isString ? new QFilter(number, "!=", (Object)"").and(number, "!=", (Object)" ").and(number, "is not null", null) : new QFilter(number, "!=", (Object)0);
                        break block0;
                    }
                    case DENUMS: 
                    case OTHER: {
                        qFilter = new QFilter(number, "!=", (Object)"").and(number, "!=", (Object)" ").and(number, "is not null", null);
                        break block0;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block0;
                    }
                }
                throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "dimType error");
            }
            case IN: 
            case NOT_IN: {
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        boolean isString = PADimensionModel.isStringPrimaryKeyType((String)baseEntityId);
                        List idList = Stream.of(value.split(",")).map(idStr -> isString ? idStr : Long.valueOf(idStr)).collect(Collectors.toList());
                        qFilter = new QFilter(number, conditionEnum.getValue(), idList);
                        break block0;
                    }
                    case DENUMS: 
                    case OTHER: {
                        String[] values = value.split(",");
                        qFilter = new QFilter(number, conditionEnum.getValue(), (Object)values);
                        break block0;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block0;
                    }
                }
                throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "dimType error");
            }
            case ALL: {
                break;
            }
            default: {
                throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "filterCondition error");
            }
        }
        return qFilter;
    }

    public static boolean dimValueIsEmpty(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        try {
            if (fieldValue instanceof Long) {
                return (Long)fieldValue == 0L;
            }
            if (fieldValue instanceof Integer) {
                return (Integer)fieldValue == 0;
            }
            if (fieldValue instanceof OrmLocaleValue || fieldValue instanceof String) {
                return " ".equals(fieldValue = fieldValue.toString()) || "".equals(fieldValue);
            }
        }
        catch (Exception e) {
            logger.error("[FI-PA] ModelUtil type&value is not mate", (Throwable)e);
            return true;
        }
        return false;
    }

    public static RowMeta getModelRowMeta(DynamicObject analysisModel) {
        String entityNumber = PACommonConstans.buildEntityName((String)analysisModel.getString("tablenumber"));
        String fields = String.join((CharSequence)",", ModelUtil.getModelFieldList(analysisModel));
        return ORM.create().createRowMeta(entityNumber, fields);
    }

    public static RowMeta getModelRowMeta(DynamicObject analysisModel, List<String> fieldList) {
        String entityNumber = PACommonConstans.buildEntityName((String)analysisModel.getString("tablenumber"));
        String fields = String.join((CharSequence)",", fieldList);
        return ORM.create().createRowMeta(entityNumber, fields);
    }

    public static RowMeta getModelDetailRowMeta(DynamicObject analysisModel) {
        String entityNumber = PACommonConstans.buildDetailEntityName((String)analysisModel.getString("tablenumber"));
        String fields = String.join((CharSequence)",", ModelUtil.getModelDetailFieldList(analysisModel));
        return ORM.create().createRowMeta(entityNumber, fields);
    }

    public static RowMeta getModelDetailRowMeta(DynamicObject analysisModel, List<String> fieldList) {
        String entityNumber = PACommonConstans.buildDetailEntityName((String)analysisModel.getString("tablenumber"));
        String fields = String.join((CharSequence)",", fieldList);
        return ORM.create().createRowMeta(entityNumber, fields);
    }

    public static List<String> getModelFieldList(DynamicObject analysisModel) {
        String tableNumber = analysisModel.getString("tablenumber");
        String detailEntityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
        String summaryEntityNumber = AnalysisModelUtil.buildEntityNumber((String)tableNumber);
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntry = analysisModel.getDynamicObjectCollection("measure_entry");
        ArrayList<String> basicFieldList = new ArrayList<String>(8);
        basicFieldList.add("id");
        basicFieldList.add("collectstatus");
        basicFieldList.add("datastatus");
        basicFieldList.add("del");
        basicFieldList.add("offstatus");
        basicFieldList.add("operationstatus");
        basicFieldList.add("situationtype");
        basicFieldList.add("createtime");
        if (AnalysisModelHashUtil.isModelContainsDimHash((String)detailEntityNumber) && AnalysisModelHashUtil.isModelContainsDimHash((String)summaryEntityNumber)) {
            basicFieldList.add("dimhash");
        }
        List dimensionFieldList = dimensionEntry.stream().map(dy -> {
            DynamicObject dim = dy.getDynamicObject("dimension");
            return dim.getString("number");
        }).collect(Collectors.toList());
        List measureFieldList = measureEntry.stream().map(dy -> {
            DynamicObject measure = dy.getDynamicObject("measure");
            return measure.getString("number");
        }).collect(Collectors.toList());
        ArrayList<String> fieldList = new ArrayList<String>(basicFieldList.size() + dimensionFieldList.size() + measureFieldList.size());
        fieldList.addAll(basicFieldList);
        fieldList.addAll(dimensionFieldList);
        fieldList.addAll(measureFieldList);
        return fieldList;
    }

    public static List<String> getModelDetailFieldList(DynamicObject analysisModel) {
        List<String> modelFieldList = ModelUtil.getModelFieldList(analysisModel);
        ArrayList<String> extraFieldList = new ArrayList<String>(4);
        extraFieldList.add("summaryid");
        extraFieldList.add("sourceformid");
        extraFieldList.add("sourcebillid");
        extraFieldList.add("execlogid");
        extraFieldList.add("subexeclogid");
        extraFieldList.add("execparentbillid");
        extraFieldList.add("createstamp");
        ArrayList<String> fieldList = new ArrayList<String>(modelFieldList.size() + extraFieldList.size());
        fieldList.addAll(modelFieldList);
        fieldList.addAll(extraFieldList);
        return fieldList;
    }

    public static QFilter[] parallelQFilters(int parallel, QFilter[] qFilters) {
        if (qFilters == null || qFilters.length == 0 || parallel <= qFilters.length) {
            return qFilters;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(parallel);
        if (parallel % qFilters.length == 0) {
            int factor = parallel / qFilters.length;
            for (QFilter qFilter : qFilters) {
                for (int i = 0; i < factor; ++i) {
                    qFilterList.add(new QFilter(String.format("id%%%d", factor), "=", (Object)i).and(qFilter));
                }
            }
        } else {
            int i;
            int factor = parallel - qFilters.length + 1;
            for (i = 0; i < factor; ++i) {
                qFilterList.add(new QFilter(String.format("id%%%d", factor), "=", (Object)i).and(qFilters[0]));
            }
            for (i = 1; i < qFilters.length; ++i) {
                qFilterList.add(qFilters[i]);
            }
        }
        return qFilterList.toArray(new QFilter[0]);
    }
}

