/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.enginealgox.utils;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.fi.pa.algox.PASQLBuilder;

public class SqlUtil {
    private SqlUtil() {
    }

    public static String getInsertSQL(RowMeta rowMeta, String tableNumber) {
        PASQLBuilder builder = new PASQLBuilder(tableNumber);
        for (String fieldName : rowMeta.getFieldNames()) {
            builder.insert("f" + fieldName);
        }
        return builder.toInsertSQL();
    }

    public static String getDeleteSQL(RowMeta rowMeta, String tableNumber) {
        PASQLBuilder builder = new PASQLBuilder(tableNumber);
        for (Field field : rowMeta.getFields()) {
            builder.where("f" + field.getName(), field.getDataType());
        }
        return builder.toDeleteSQL();
    }

    public static String getUpdateSQL(RowMeta rowMeta, String tableNumber) {
        PASQLBuilder builder = new PASQLBuilder(tableNumber);
        for (String fieldName : rowMeta.getFieldNames()) {
            if ("id".equals(fieldName)) continue;
            builder.set("f" + fieldName);
        }
        builder.where("fid");
        return builder.toUpdateSQL();
    }

    public static String getUpdateSQLExcludeFields(RowMeta rowMeta, String tableNumber, Set<String> excludeFields) {
        PASQLBuilder builder = new PASQLBuilder(tableNumber);
        for (String fieldName : rowMeta.getFieldNames()) {
            if ("id".equals(fieldName) || excludeFields != null && excludeFields.contains(fieldName)) continue;
            builder.set("f" + fieldName);
        }
        builder.where("fid");
        return builder.toUpdateSQL();
    }

    public static String getSelectSQL(RowMeta rowMeta, String tableNumber) {
        PASQLBuilder builder = new PASQLBuilder(tableNumber);
        for (Field field : rowMeta.getFields()) {
            builder.where("f" + field.getName(), field.getDataType());
        }
        String selectFields = Stream.of(rowMeta.getFieldNames()).map(v -> "f" + v).collect(Collectors.joining(","));
        return builder.toSelectSQL(selectFields);
    }
}

