/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.export.excel;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FeatureOption;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.export.excel.ColumnData;
import kd.fi.pa.export.excel.ExcelColumn;
import kd.fi.pa.export.excel.ImportFile;
import kd.fi.pa.model.impl.PADimensionModel;
import kd.fi.pa.model.impl.ThreeValueTuple;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BaseExportHandler {
    protected static final String KEY_ILLEGALITY = "illegality";
    protected final Map<Integer, CellStyle> cellStyleMap = new HashMap<Integer, CellStyle>(6);

    HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable var3) {
            return HorizontalAlignment.GENERAL;
        }
    }

    CellStyle getCellStyle(Workbook workbook, boolean isTitle, boolean isHighLight, boolean isDefaultCell) {
        CellStyle cs;
        Integer index = 0;
        if (isHighLight) {
            index = index + 2;
        }
        if (isTitle) {
            index = index + 4;
        }
        if (isDefaultCell) {
            index = index + 8;
        }
        if ((cs = this.cellStyleMap.get(index)) == null) {
            cs = workbook.createCellStyle();
            this.cellStyleMap.put(index, cs);
            Font font = workbook.createFont();
            if (isHighLight) {
                cs.setDataFormat(workbook.createDataFormat().getFormat("@"));
                font.setColor(IndexedColors.RED.getIndex());
            }
            if (isTitle) {
                font.setFontHeightInPoints(Short.parseShort("18"));
                cs.setAlignment(this.getAlignment("center"));
            } else {
                cs.setAlignment(this.getAlignment("default"));
            }
            cs.setFont(font);
            if (isDefaultCell) {
                cs.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
                cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
        }
        return cs;
    }

    SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    void createCellCombo(SXSSFSheet sheet, int startRow, int startColumn, Map<String, String> comboMap) {
        CellRangeAddressList rangeAddressList = new CellRangeAddressList(startRow, startRow + 1000, startColumn, startColumn);
        String[] typeItems = comboMap.values().toArray(new String[0]);
        XSSFDataValidationConstraint dataValidationConstraint = new XSSFDataValidationConstraint(typeItems);
        XSSFDataValidationHelper xssfDataValidationHelper = new XSSFDataValidationHelper(null);
        DataValidation dataValidation = xssfDataValidationHelper.createValidation((DataValidationConstraint)dataValidationConstraint, rangeAddressList);
        sheet.addValidationData(dataValidation);
    }

    void processBasedataProp(IDataEntityProperty property, List<ExcelColumn> columnList, DynamicObject dimension) {
        String name;
        StringBuilder sb;
        ExcelColumn ec;
        DynamicProperty bdProp;
        BasedataEntityType baseEntityType = property instanceof BasedataProp ? (BasedataEntityType)((BasedataProp)property).getComplexType() : (BasedataEntityType)((MulBasedataProp)property).getComplexType();
        String propertyName = property.getName();
        String numberName = baseEntityType.getNumberProperty();
        if (StringUtils.isNotEmpty((String)numberName)) {
            boolean hasType;
            String baseEntityId = property instanceof BasedataProp ? ((BasedataProp)property).getBaseEntityId() : ((MulBasedataProp)property).getBaseEntityId();
            bdProp = baseEntityType.getProperty(numberName);
            ec = new ExcelColumn();
            ec.setProperty(property);
            ec.setNumber(propertyName + "." + numberName);
            sb = new StringBuilder(property.getDisplayName().toString());
            sb.append(bdProp.getDisplayName().toString());
            ec.setName(sb.toString());
            ec.setMustInput(true);
            ec.setDataType((DataType)DataType.StringType);
            boolean bl = hasType = "bd_period".equals(baseEntityId) || "bd_accountview".equals(baseEntityId) || "bos_assistantdata_detail".equals(baseEntityId);
            if (hasType) {
                ec.setTypeField(dimension.getString("typefield"));
                ec.setTypeId(dimension.get("group_id"));
            }
            columnList.add(ec);
        }
        if (StringUtils.isNotEmpty((String)(name = baseEntityType.getNameProperty()))) {
            bdProp = baseEntityType.getProperty(name);
            ec = new ExcelColumn();
            ec.setProperty(property);
            ec.setNumber(propertyName + "." + name);
            sb = new StringBuilder(property.getDisplayName().toString());
            sb.append(bdProp.getDisplayName().toString());
            ec.setName(sb.toString());
            ec.setMustInput(false);
            ec.setDataType((DataType)DataType.StringType);
            columnList.add(ec);
        }
    }

    ExcelColumn createComboExcelColumn(IDataEntityProperty property) {
        ExcelColumn ec = this.createStringExcelColumn(property);
        List items = ((ComboProp)property).getComboItems();
        LinkedHashMap<String, String> comboMap = new LinkedHashMap<String, String>(items.size());
        for (ValueMapItem item : items) {
            comboMap.put(item.getValue(), item.getName().toString());
        }
        ec.setComboMap(comboMap);
        return ec;
    }

    ExcelColumn createDateExcelColumn(IDataEntityProperty property) {
        ExcelColumn ec = this.createExcelColumn(property);
        ec.setDataType((DataType)DataType.DateType);
        return ec;
    }

    ExcelColumn createStringExcelColumn(IDataEntityProperty property) {
        ExcelColumn ec = this.createExcelColumn(property);
        ec.setDataType((DataType)DataType.StringType);
        return ec;
    }

    ExcelColumn createDecimalExcelColumn(IDataEntityProperty property) {
        ExcelColumn ec = this.createExcelColumn(property);
        ec.setDataType((DataType)DataType.BigDecimalType);
        return ec;
    }

    ExcelColumn createExcelColumn(IDataEntityProperty property) {
        ExcelColumn ec = new ExcelColumn();
        ec.setProperty(property);
        ec.setNumber(property.getName());
        ec.setName(property.getDisplayName().toString());
        ec.setMustInput(true);
        return ec;
    }

    IDataEntityProperty createProperty(DynamicObject dimObj) {
        String number = dimObj.getString("number");
        DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)((String)dimObj.get("dimensiontype")));
        String name = dimObj.getString("name");
        Map<String, String> enumMap = dimObj.getDynamicObjectCollection("entryentityenums").stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title")));
        switch (dimensionType) {
            case DATABASE: 
            case ASSISTANTDATA: 
            case PERIOD: {
                String sourceEntity = this.getDimensionSourceNumber(dimensionType, dimObj);
                BasedataProp newBaseDataProperty = new BasedataProp();
                newBaseDataProperty.setName(number);
                newBaseDataProperty.setBaseEntityId(sourceEntity);
                newBaseDataProperty.setDisplayName(new LocaleString(name));
                newBaseDataProperty.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)sourceEntity));
                newBaseDataProperty.setFeatures(FeatureOption.Copyable.getValue());
                VarcharProp idProp = PADimensionModel.isStringPrimaryKeyType((String)sourceEntity) ? new VarcharProp() : new LongProp();
                idProp.setName(number + "_id");
                newBaseDataProperty.setRefIdProp((IDataEntityProperty)idProp);
                newBaseDataProperty.setRefIdPropName(idProp.getName());
                return newBaseDataProperty;
            }
            case OTHER: {
                TextProp newTextProperty = new TextProp();
                newTextProperty.setName(number);
                newTextProperty.setDisplayName(new LocaleString(name));
                newTextProperty.setFeatures(FeatureOption.Copyable.getValue());
                return newTextProperty;
            }
            case DENUMS: {
                ComboProp newComboProperty = new ComboProp();
                newComboProperty.setName(number);
                newComboProperty.setDisplayName(new LocaleString(name));
                List comboItems = enumMap.entrySet().stream().map(dy -> new ValueMapItem(null, (String)dy.getKey(), new LocaleString((String)dy.getValue()))).collect(Collectors.toList());
                newComboProperty.setComboItems(comboItems);
                newComboProperty.setFeatures(FeatureOption.Copyable.getValue());
                return newComboProperty;
            }
            case DATE: {
                DateTimeProp dateTimeProp = new DateTimeProp();
                dateTimeProp.setName(number);
                dateTimeProp.setDisplayName(new LocaleString(name));
                return dateTimeProp;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"BaseExportHandler_1", (String)"fi-pa-business", (Object[])new Object[0]));
    }

    String getDimensionSourceNumber(DimensionTypeEnum dimensionType, DynamicObject dimensionObj) {
        if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
            return "bos_assistantdata_detail";
        }
        if (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.PERIOD == dimensionType) {
            return dimensionObj.getString("dimensionsource.number");
        }
        return null;
    }

    ThreeValueTuple<List<ColumnData>, Object, Map<Integer, List<String>>> uploadBase(ImportFile importFile, List<ExcelColumn> columnList) {
        HSSFWorkbook wb = null;
        InputStream is = null;
        try {
            if (importFile.isTemp()) {
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                is = tempFileCache.getInputStream(importFile.getUrl());
            } else {
                FileService service = FileServiceFactory.getAttachmentFileService();
                is = service.getInputStream(importFile.getUrl());
            }
            String extStr = importFile.getFileType();
            if (".xls".equals(extStr)) {
                wb = new HSSFWorkbook(is);
            } else if (".xlsx".equals(extStr)) {
                wb = new XSSFWorkbook(is);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u644a\u56e0\u5b50\u5bfc\u5165Excel\u6570\u636e\u5931\u8d25 :%s\u3002", (String)"BaseExportHandler_2", (String)"fi-pa-business", (Object[])new Object[0]), e.getMessage()));
        }
        if (wb == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef,\u5fc5\u987b\u4e3axls\u6216xlsx\u6587\u4ef6\u3002", (String)"BaseExportHandler_3", (String)"fi-pa-business", (Object[])new Object[0]));
        }
        try {
            if (CollectionUtils.isEmpty(columnList)) {
                return null;
            }
            ArrayList<ColumnData> excelColumnList = new ArrayList<ColumnData>(columnList.size());
            Sheet firstSheet = wb.getSheetAt(0);
            int rowNumber = firstSheet.getPhysicalNumberOfRows();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (rowNumber >= 10005) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u6b21\u4e0a\u4f20\u6700\u5927\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc710000\u6761\u3002", (String)"BaseExportHandler_4", (String)"fi-pa-business", (Object[])new Object[0]));
            }
            HashMap errorLoggerMap = new HashMap(10);
            int dataRowIndex = 0;
            for (int i = 0; i < rowNumber; ++i) {
                Row row = firstSheet.getRow(i);
                if (row == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20Excel\u6587\u4ef6\u7b2c%s\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u6570\u636e\u3002", (String)"BaseExportHandler_5", (String)"fi-pa-business", (Object[])new Object[0]), i + 1));
                }
                if (i == 2) {
                    short end = row.getLastCellNum();
                    for (short cellIndex = 0; cellIndex < end; cellIndex = (short)(cellIndex + 1)) {
                        String field;
                        try {
                            field = row.getCell((int)cellIndex).getStringCellValue();
                        }
                        catch (Exception e) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"BaseExportHandler_0", (String)"fi-pa-business", (Object[])new Object[0]));
                        }
                        Optional<ExcelColumn> ecOp = columnList.stream().filter(ec -> ec.getNumber().equals(field)).findFirst();
                        if (!ecOp.isPresent()) continue;
                        ColumnData columnData = new ColumnData();
                        columnData.setEc(ecOp.get());
                        columnData.setCellIndex(cellIndex);
                        columnData.setDataList(new ArrayList<Object>(10));
                        excelColumnList.add(columnData);
                    }
                    if (CollectionUtils.isEmpty(excelColumnList)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"BaseExportHandler_0", (String)"fi-pa-business", (Object[])new Object[0]));
                    }
                    if (excelColumnList.size() >= columnList.size()) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"excel\u7ef4\u5ea6\u5c11\u4e8e\u5f53\u524d\u5206\u644a\u56e0\u5b50\u3002", (String)"BaseExportHandler_6", (String)"fi-pa-business", (Object[])new Object[0]));
                }
                if (i < 4) continue;
                ArrayList<String> errorMessage = new ArrayList<String>(3);
                for (ColumnData columnData : excelColumnList) {
                    Cell cell = row.getCell(columnData.getCellIndex());
                    DataType dataType = columnData.getEc().getDataType();
                    Object value = null;
                    if (cell != null) {
                        try {
                            int cellTypeCode = cell.getCellType().getCode();
                            String cellStrValue = "";
                            switch (cellTypeCode) {
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        cellStrValue = simpleDateFormat.format(cell.getDateCellValue());
                                        break;
                                    }
                                    cellStrValue = BigDecimal.valueOf(cell.getNumericCellValue()).stripTrailingZeros().toPlainString();
                                    break;
                                }
                                case 1: {
                                    cellStrValue = cell.getStringCellValue();
                                    break;
                                }
                                case 3: {
                                    cellStrValue = "";
                                    break;
                                }
                                default: {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u5217\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", (String)"BaseExportHandler_7", (String)"fi-pa-business", (Object[])new Object[0]));
                                }
                            }
                            if (DataType.StringType.equals((Object)dataType)) {
                                value = cellStrValue;
                                if (columnData.getEc().getProperty() instanceof ComboProp) {
                                    Set<Map.Entry<String, String>> itemSet = columnData.getEc().getComboMap().entrySet();
                                    boolean matcher = false;
                                    for (Map.Entry<String, String> comboItem : itemSet) {
                                        if (!comboItem.getValue().equals(value)) continue;
                                        matcher = true;
                                        value = comboItem.getKey();
                                        break;
                                    }
                                    if (!matcher) {
                                        String error = ResManager.loadKDString((String)"\u5217\u503c\u4e0d\u5408\u6cd5\uff0c\u8d85\u8fc7\u4e86\u679a\u4e3e\u8303\u56f4", (String)"BaseExportHandler_8", (String)"fi-pa-business", (Object[])new Object[0]);
                                        errorMessage.add(columnData.getEc().getName() + error);
                                        value = KEY_ILLEGALITY;
                                    }
                                }
                                if (StringUtils.isEmpty((String)cellStrValue)) {
                                    value = null;
                                }
                            } else if (DataType.DateType.equals((Object)dataType)) {
                                value = StringUtils.isNotEmpty((String)cellStrValue) ? simpleDateFormat.parse(cellStrValue) : null;
                            } else if (DataType.BigDecimalType.equals((Object)dataType)) {
                                value = StringUtils.isNotEmpty((String)cellStrValue) ? new BigDecimal(cellStrValue) : null;
                            }
                        }
                        catch (Exception e) {
                            String error = ResManager.loadKDString((String)"\u5217\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", (String)"BaseExportHandler_7", (String)"fi-pa-business", (Object[])new Object[0]);
                            errorMessage.add(columnData.getEc().getName() + error);
                        }
                    }
                    if (value == null && columnData.getEc().isMustInput()) {
                        String error = ResManager.loadKDString((String)"\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"BaseExportHandler_9", (String)"fi-pa-business", (Object[])new Object[0]);
                        errorMessage.add(columnData.getEc().getName() + error);
                    }
                    columnData.getDataList().add(value);
                }
                if (!errorMessage.isEmpty()) {
                    errorLoggerMap.put(dataRowIndex, errorMessage);
                }
                ++dataRowIndex;
            }
            wb.close();
            is.close();
            return new ThreeValueTuple(excelColumnList, null, errorLoggerMap);
        }
        catch (Exception e) {
            throw new KDBizException(StringUtils.isBlank((String)e.getMessage()) ? ResManager.loadKDString((String)"\u5bfc\u5165Excel\u6587\u4ef6\u9519\u8bef,\u8bf7\u4ece\u5bf9\u5e94\u7684\u5206\u644a\u56e0\u5b50\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\u3002", (String)"BaseExportHandler_10", (String)"fi-pa-business", (Object[])new Object[0]) : e.getMessage());
        }
    }

    static boolean isIllegality(Object value) {
        return KEY_ILLEGALITY.equals(value);
    }

    List<Object> queryBasedataMappingId(ColumnData columnData, Map<Integer, List<String>> errorLoggerMap) {
        BasedataProp basedataProp = (BasedataProp)columnData.getEc().getProperty();
        String baseEntityNumber = basedataProp.getBaseEntityId();
        StringBuilder selectField = new StringBuilder("id");
        String filterField = columnData.getEc().achieveFieldInBaseEntity();
        selectField.append(',').append(filterField);
        HashMap<String, Object> numberToIdMap = new HashMap<String, Object>(columnData.getDataList().size());
        QFilter[] filter = StringUtils.isNotEmpty((String)columnData.getEc().getTypeField()) ? new QFilter[]{columnData.achieveQFilterInBase(), new QFilter(columnData.getEc().getTypeField(), "=", columnData.getEc().getTypeId())} : new QFilter[]{columnData.achieveQFilterInBase()};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PADownLoadEntryTemplateFormPlugin.queryBasedataMappingId", (String)baseEntityNumber, (String)selectField.toString(), (QFilter[])filter, null);){
            for (kd.bos.algo.Row row : dataSet) {
                String key2 = row.getString(filterField);
                Object value = numberToIdMap.get(key2);
                if (value != null) {
                    ArrayList<Object> repeatNumberList;
                    if (value instanceof List) {
                        repeatNumberList = (ArrayList<Object>)value;
                        repeatNumberList.add(row.get("id"));
                        numberToIdMap.put(key2, repeatNumberList);
                    } else {
                        repeatNumberList = new ArrayList<Object>(3);
                        repeatNumberList.add(value);
                        repeatNumberList.add(row.get("id"));
                        numberToIdMap.put(key2, repeatNumberList);
                    }
                    numberToIdMap.put(row.getString(filterField), row.get("id"));
                    continue;
                }
                numberToIdMap.put(row.getString(filterField), row.get("id"));
            }
        }
        ArrayList<Object> idList = new ArrayList<Object>(columnData.getDataList().size());
        int dataRowIndex = 0;
        for (Object oldValue : columnData.getDataList()) {
            String error;
            List errorMessage;
            Object newValue = numberToIdMap.get(oldValue);
            if (oldValue != null && newValue == null) {
                errorMessage = errorLoggerMap.computeIfAbsent(dataRowIndex, key -> new ArrayList(3));
                error = ResManager.loadKDString((String)"\u5217\u503c\u4e0d\u5408\u6cd5\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u57fa\u7840\u8d44\u6599", (String)"BaseExportHandler_11", (String)"fi-pa-business", (Object[])new Object[0]);
                errorMessage.add(columnData.getEc().getName() + error);
                idList.add(null);
            } else if (newValue instanceof List) {
                errorMessage = errorLoggerMap.computeIfAbsent(dataRowIndex, key -> new ArrayList(3));
                error = ResManager.loadKDString((String)"\u5217\u65e0\u6cd5\u6839\u636e\u7f16\u53f7\u786e\u5b9a\u552f\u4e00\u4e00\u6761\u57fa\u7840\u8d44\u6599\u6570\u636e", (String)"BaseExportHandler_12", (String)"fi-pa-business", (Object[])new Object[0]);
                errorMessage.add(columnData.getEc().getName() + error);
                idList.add(null);
            } else {
                idList.add(newValue);
            }
            ++dataRowIndex;
        }
        return idList;
    }

    protected QFilter achieveDimensionTypeFilter(DynamicObject dimension) {
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
        QFilter qFilter = null;
        if (DimensionTypeEnum.DATABASE == dimType) {
            String typeField = dimension.getString("typefield");
            Object groupId = dimension.get("group_id");
            if (StringUtils.isNotEmpty((String)typeField)) {
                qFilter = new QFilter(typeField, "=", groupId);
            }
        } else if (DimensionTypeEnum.ASSISTANTDATA == dimType) {
            Object groupId = dimension.get("assistantsource_id");
            qFilter = new QFilter("group", "=", groupId);
        }
        return qFilter;
    }

    public String showMessage(Map<Integer, List<String>> errorMessageMap) {
        StringBuilder sb = new StringBuilder();
        if (errorMessageMap != null && !errorMessageMap.isEmpty()) {
            Set<Integer> errorKeySet = errorMessageMap.keySet();
            ArrayList<Integer> indexList = new ArrayList<Integer>(10);
            indexList.addAll(errorKeySet);
            indexList.sort(Integer::compareTo);
            indexList.forEach(index -> {
                StringBuilder errorRow = new StringBuilder();
                List errorList = (List)errorMessageMap.get(index);
                if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                    if (index >= 0) {
                        String header = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"BaseExportHandler_13", (String)"fi-pa-business", (Object[])new Object[0]), index + 5);
                        errorRow.append(header).append("\uff0c");
                    }
                    errorRow.append(String.join((CharSequence)"\uff0c", errorList));
                    errorRow.append("\\r\\n");
                    sb.append((CharSequence)errorRow);
                }
            });
        }
        return sb.toString();
    }
}

