/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.export.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import kd.bos.algo.DataType;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.export.excel.BaseExportHandler;
import kd.fi.pa.export.excel.ColumnData;
import kd.fi.pa.export.excel.ExcelColumn;
import kd.fi.pa.export.excel.ExportParam;
import kd.fi.pa.export.excel.IExcelExportHandler;
import kd.fi.pa.export.excel.ImportFile;
import kd.fi.pa.model.impl.ThreeValueTuple;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ShareFactorEntryExportHandler
extends BaseExportHandler
implements IExcelExportHandler {
    private static final Log logger = LogFactory.getLog(ShareFactorEntryExportHandler.class);
    private static final String SHEETNAME = "sheet1";

    @Override
    public List<ExcelColumn> buildExcelColumnList(ExportParam param) {
        ArrayList<ExcelColumn> columnList = new ArrayList<ExcelColumn>(10);
        DynamicObject analysisModelObj = param.getAnalysisModelObj();
        DynamicObjectCollection modelDimensionCol = analysisModelObj.getDynamicObjectCollection("dimension_entry");
        String entityName = PACommonConstans.buildEntityName((String)analysisModelObj.getString("tablenumber"));
        MainEntityType entityType = null;
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IDataEntityProperty entryPro = param.getEntryProp();
        if ("0".equals(param.getFactorType())) {
            IDataEntityProperty curEntryPro = param.getShowEntryProp();
            Iterator property = ((EntryProp)curEntryPro)._collectionItemPropertyType.getProperty("period");
            Optional<DynamicObject> periodDim = modelDimensionCol.stream().filter(row -> DimensionNecessityEnum.PERIOD.getCode().equals(row.getString("necessity_dim"))).findFirst();
            this.processBasedataProp((IDataEntityProperty)property, columnList, periodDim.get().getDynamicObject("dimension"));
        }
        DynamicObjectCollection dimensionCol = param.getDimensionCol();
        for (DynamicObject dynamicObject : dimensionCol) {
            ExcelColumn ec;
            IDataEntityProperty property;
            DynamicObject dimObj = dynamicObject.getDynamicObject("fbasedataid");
            String propertyName = dimObj.getString("number");
            IDataEntityProperty iDataEntityProperty = property = entityType == null ? this.createProperty(dimObj) : entityType.findProperty(propertyName);
            if (property instanceof BasedataProp) {
                Optional<DynamicObject> dim = modelDimensionCol.stream().filter(row -> propertyName.equals(row.getString("dimension.number"))).findFirst();
                this.processBasedataProp(property, columnList, dim.get().getDynamicObject("dimension"));
                continue;
            }
            if (property instanceof ComboProp) {
                ec = new ExcelColumn();
                ec.setProperty(property);
                ec.setNumber(propertyName);
                ec.setName(property.getDisplayName().toString());
                ec.setMustInput(true);
                ec.setDataType((DataType)DataType.StringType);
                List items = ((ComboProp)property).getComboItems();
                LinkedHashMap<String, String> comboMap = new LinkedHashMap<String, String>(items.size());
                for (ValueMapItem item : items) {
                    comboMap.put(item.getValue(), item.getName().toString());
                }
                ec.setComboMap(comboMap);
                columnList.add(ec);
                continue;
            }
            if (property instanceof DateTimeProp) {
                ec = new ExcelColumn();
                ec.setProperty(property);
                ec.setNumber(propertyName);
                ec.setName(property.getDisplayName().toString());
                ec.setMustInput(true);
                ec.setDataType((DataType)DataType.TimestampType);
                columnList.add(ec);
                continue;
            }
            ec = new ExcelColumn();
            ec.setProperty(property);
            ec.setNumber(propertyName);
            ec.setName(property.getDisplayName().toString());
            ec.setMustInput(true);
            ec.setDataType((DataType)DataType.StringType);
            columnList.add(ec);
        }
        ExcelColumn ec = new ExcelColumn();
        ec.setProperty((IDataEntityProperty)((EntryProp)entryPro)._collectionItemPropertyType.getProperty("value"));
        ec.setNumber("value");
        ec.setName(ResManager.loadKDString((String)"\u503c", (String)"ShareFactorEntryExportHandler_0", (String)"fi-pa-business", (Object[])new Object[0]));
        ec.setMustInput(true);
        ec.setDataType((DataType)DataType.BigDecimalType);
        columnList.add(ec);
        return columnList;
    }

    @Override
    public SXSSFWorkbook buildTemplate(List<ExcelColumn> excelColumnList) {
        if (excelColumnList.isEmpty()) {
            return null;
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet1 = workbook.createSheet(SHEETNAME);
        SXSSFRow titleRow = this.getRow(sheet1, 0);
        SXSSFRow remarkRow = this.getRow(sheet1, 1);
        SXSSFRow dimensionNumberRow = this.getRow(sheet1, 2);
        SXSSFRow dimensionNameRow = this.getRow(sheet1, 3);
        this.createCell(titleRow, 2, this.getCellStyle((Workbook)workbook, true, false, false)).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u5206\u644a\u56e0\u5b50\u503c", (String)"ShareFactorEntryExportHandler_1", (String)"fi-pa-business", (Object[])new Object[0]));
        this.createCell(remarkRow, 0, this.getCellStyle((Workbook)workbook, false, true, false)).setCellValue(ResManager.loadKDString((String)"\u6ce8\uff1a\u7ea2\u8272\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879", (String)"ShareFactorEntryExportHandler_2", (String)"fi-pa-business", (Object[])new Object[0]));
        for (int i = 0; i < excelColumnList.size(); ++i) {
            ExcelColumn column = excelColumnList.get(i);
            if (column.getComboMap() != null && !column.getComboMap().isEmpty()) {
                this.createCellCombo(sheet1, 4, i, column.getComboMap());
            }
            this.createCell(dimensionNumberRow, i, this.getCellStyle((Workbook)workbook, false, false, false)).setCellValue(column.getNumber());
            this.createCell(dimensionNameRow, i, this.getCellStyle((Workbook)workbook, false, column.isMustInput(), true)).setCellValue(column.isMustInput() ? column.getName() + "*" : column.getName());
        }
        return workbook;
    }

    private String createExcel(ExportParam param, String fileName, BiConsumer<SXSSFWorkbook, List<ExcelColumn>> consumer) {
        OutputStream fos = null;
        FileInputStream fis = null;
        SXSSFWorkbook workbook = null;
        try {
            List<ExcelColumn> columnList = this.buildExcelColumnList(param);
            workbook = this.buildTemplate(columnList);
            if (workbook == null) {
                String string = null;
                return string;
            }
            if (consumer != null) {
                consumer.accept(workbook, columnList);
            }
            File temp = File.createTempFile(FilenameUtils.getName((String)UUID.randomUUID().toString()), ".xlsx");
            fos = new FileOutputStream(temp);
            workbook.write(fos);
            fis = new FileInputStream(temp);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, (InputStream)fis, 60);
            fis.close();
            String string = url;
            return string;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public String downloadTemplate(ExportParam param) {
        String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u5206\u644a\u56e0\u5b50\u503c\u6a21\u677fExcel.xlsx", (String)"ShareFactorEntryExportHandler_3", (String)"fi-pa-business", (Object[])new Object[0]);
        String url = this.createExcel(param, fileName, null);
        return url;
    }

    @Override
    public String exportData(ExportParam param) {
        LocalDate now = LocalDate.now();
        String dateStr = String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        String fileName = String.format(ResManager.loadKDString((String)"\u5206\u644a\u56e0\u5b50\u5bfc\u51fa\u5206\u5f55\u6570\u636e_%s.xlsx", (String)"ShareFactorEntryExportHandler_4", (String)"fi-pa-business", (Object[])new Object[0]), dateStr);
        TableValueSetter tableValueSetter = param.getTableValueSetter();
        String url = this.createExcel(param, fileName, (workbook, excelColumnList) -> {
            if (tableValueSetter != null) {
                int rowCount = tableValueSetter.getCount();
                SXSSFSheet sheet1 = workbook.getSheet(SHEETNAME);
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    int realRowIndex = rowIndex + 4;
                    SXSSFRow dataRow = this.getRow(sheet1, realRowIndex);
                    for (int i = 0; i < excelColumnList.size(); ++i) {
                        ExcelColumn column = (ExcelColumn)excelColumnList.get(i);
                        Object value = tableValueSetter.get(column.getNumber(), rowIndex);
                        SXSSFCell cell = this.createCell(dataRow, i, this.getCellStyle((Workbook)workbook, false, false, false));
                        if (DataType.StringType.equals((Object)column.getDataType())) {
                            if (column.getProperty() instanceof ComboProp) {
                                String displayValue = column.getComboMap().get(value);
                                cell.setCellValue(displayValue);
                                continue;
                            }
                            cell.setCellValue((String)value);
                            continue;
                        }
                        if (DataType.DateType.equals((Object)column.getDataType())) {
                            cell.setCellValue((Date)value);
                            continue;
                        }
                        if (!DataType.BigDecimalType.equals((Object)column.getDataType())) continue;
                        cell.setCellValue(((BigDecimal)value).doubleValue());
                    }
                }
            }
        });
        return url;
    }

    @Override
    public ThreeValueTuple<String, Object, Map<Integer, List<String>>> importData(ImportFile importFile, ExportParam param) {
        DynamicObject analysisModelObj = param.getAnalysisModelObj();
        List<ExcelColumn> excelColumnList = this.buildExcelColumnList(param);
        ThreeValueTuple<List<ColumnData>, Object, Map<Integer, List<String>>> fileData = this.uploadBase(importFile, excelColumnList);
        List columnDataList = (List)fileData.getKey();
        Map errorLoggerMap = (Map)fileData.getValue();
        for (ColumnData columnData : columnDataList) {
            if (!columnData.getEc().isMustInput() || !(columnData.getEc().getProperty() instanceof BasedataProp)) continue;
            columnData.setDataList(this.queryBasedataMappingId(columnData, errorLoggerMap));
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (ColumnData columnData : columnDataList) {
            if (!columnData.getEc().isMustInput()) continue;
            List<Object> successList = this.processErrorRowValue(columnData.getDataList(), errorLoggerMap);
            tableValueSetter.addField(columnData.getEc().getProperty().getName(), successList.toArray());
        }
        return new ThreeValueTuple(null, (Object)tableValueSetter, (Object)errorLoggerMap);
    }

    private List<Object> processErrorRowValue(List<Object> valueList, Map<Integer, List<String>> errorLoggerMap) {
        ArrayList<Object> successList = new ArrayList<Object>(valueList.size());
        for (int index = 0; index < valueList.size(); ++index) {
            if (errorLoggerMap.containsKey(index)) continue;
            successList.add(valueList.get(index));
        }
        return successList;
    }
}

