/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.export.excel;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.export.excel.BaseExportHandler;
import kd.fi.pa.export.excel.ColumnData;
import kd.fi.pa.export.excel.ExcelColumn;
import kd.fi.pa.export.excel.ExportParam;
import kd.fi.pa.export.excel.IExcelExportHandler;
import kd.fi.pa.export.excel.ImportFile;
import kd.fi.pa.export.excel.ShareFactorExtend;
import kd.fi.pa.model.impl.ThreeValueTuple;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ShareFactorExportHandler
extends BaseExportHandler
implements IExcelExportHandler {
    private static final Log logger = LogFactory.getLog(ShareFactorExportHandler.class);
    protected static final String KEY_DESCRIBE = "describe";
    protected static final String KEY_NOTFOUND = "notFound";
    protected static final Integer REPEATMSG = -1;
    private static final String SHEETNAME = "sheet1";
    protected static final String[] headFields = new String[]{"number", "name", "factortype", "dimension", "describe"};

    @Override
    public List<ExcelColumn> buildExcelColumnList(ExportParam param) {
        ArrayList<ExcelColumn> excelColumnList = new ArrayList<ExcelColumn>(10);
        DynamicObject analysisModelObj = param.getAnalysisModelObj();
        DynamicObjectCollection modelDimensionCol = analysisModelObj.getDynamicObjectCollection("dimension_entry");
        String entityName = PACommonConstans.buildEntityName((String)analysisModelObj.getString("tablenumber"));
        MainEntityType modelEntityType = null;
        try {
            modelEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Object> dimIdList = modelDimensionCol.stream().map(rowData -> {
            DynamicObject dimObj = rowData.getDynamicObject("dimension");
            return dimObj.getPkValue();
        }).collect(Collectors.toList());
        Map dimMap = BusinessDataServiceHelper.loadFromCache((Object[])dimIdList.toArray(new Object[0]), (String)"pa_dimension");
        MainEntityType shareEntityType = EntityMetadataCache.getDataEntityType((String)"pa_sharefactor");
        for (String headField : headFields) {
            IDataEntityProperty property = shareEntityType.findProperty(headField);
            if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
                this.processBasedataProp(property, excelColumnList, null);
                continue;
            }
            if (property instanceof ComboProp) {
                excelColumnList.add(this.createComboExcelColumn(property));
                continue;
            }
            ExcelColumn ec = this.createStringExcelColumn(property);
            if (KEY_DESCRIBE.equals(headField)) {
                ec.setMustInput(false);
            }
            excelColumnList.add(ec);
        }
        IDataEntityProperty entryPro = shareEntityType.findProperty("share_factor_entry");
        DynamicProperty valueProp = ((EntryProp)entryPro)._collectionItemPropertyType.getProperty("value");
        ExcelColumn valueColumn = this.createDecimalExcelColumn((IDataEntityProperty)valueProp);
        valueColumn.setEntryName("share_factor_entry");
        valueColumn.setMustInput(false);
        Optional<DynamicObject> periodDim = modelDimensionCol.stream().filter(row -> DimensionNecessityEnum.PERIOD.getCode().equals(row.getString("necessity_dim"))).findFirst();
        ArrayList<ExcelColumn> dimColumn = new ArrayList<ExcelColumn>(modelDimensionCol.size());
        String periodPropertyName = "";
        if (periodDim.isPresent()) {
            DynamicObject periodObj = periodDim.get().getDynamicObject("dimension");
            periodPropertyName = periodObj.getString("number");
            IDataEntityProperty periodProperty = modelEntityType == null ? this.createProperty((DynamicObject)dimMap.get(periodObj.getPkValue())) : modelEntityType.findProperty(periodPropertyName);
            this.processBasedataProp(periodProperty, dimColumn, periodObj);
        }
        String finalPeriodPropertyName = periodPropertyName;
        List noPeriodDimList = dimMap.values().stream().filter(dimObj -> !finalPeriodPropertyName.equals(dimObj.getString("number"))).collect(Collectors.toList());
        for (DynamicObject dimObject : noPeriodDimList) {
            IDataEntityProperty property;
            String propertyName = dimObject.getString("number");
            IDataEntityProperty iDataEntityProperty = property = modelEntityType == null ? this.createProperty(dimObject) : modelEntityType.findProperty(propertyName);
            if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
                this.processBasedataProp(property, dimColumn, dimObject);
                continue;
            }
            if (property instanceof ComboProp) {
                dimColumn.add(this.createComboExcelColumn(property));
                continue;
            }
            if (property instanceof DateTimeProp) {
                dimColumn.add(this.createDateExcelColumn(property));
                continue;
            }
            dimColumn.add(this.createStringExcelColumn(property));
        }
        for (ExcelColumn excelColumn : dimColumn) {
            excelColumn.setMustInput(false);
            excelColumn.setEntryName("share_factor_entry");
            excelColumnList.add(excelColumn);
        }
        excelColumnList.add(valueColumn);
        return excelColumnList;
    }

    @Override
    public SXSSFWorkbook buildTemplate(List<ExcelColumn> excelColumnList) {
        if (excelColumnList.isEmpty()) {
            return null;
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet1 = workbook.createSheet(SHEETNAME);
        SXSSFRow entityRow = this.getRow(sheet1, 0);
        SXSSFRow remarkRow = this.getRow(sheet1, 1);
        SXSSFRow dimensionNumberRow = this.getRow(sheet1, 2);
        SXSSFRow dimensionNameRow = this.getRow(sheet1, 3);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"pa_sharefactor");
        String name = mainEntityType.getDisplayName().toString();
        IDataEntityProperty entryProp = mainEntityType.findProperty("share_factor_entry");
        String entryDisplayName = entryProp.getDisplayName().toString();
        this.createCell(entityRow, 0, this.getCellStyle((Workbook)workbook, false, false, false)).setCellValue(name + '#' + "pa_sharefactor");
        this.createCell(entityRow, 6, this.getCellStyle((Workbook)workbook, false, false, false)).setCellValue(entryDisplayName + '#' + "share_factor_entry");
        this.createCell(remarkRow, 0, this.getCellStyle((Workbook)workbook, false, true, false)).setCellValue(ResManager.loadKDString((String)"\u6ce8\uff1a\uff081\uff09\u7ea2\u8272\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\uff082\uff09\u5982\u6d89\u53ca\u591a\u4e2a\u7ef4\u5ea6\uff0c\u5728\u7ef4\u5ea6\u7f16\u53f7\u5b57\u6bb5\u4e2d\uff0c\u7528\u82f1\u6587\u7b26\u201c,\u201d\u5206\u9694", (String)"ShareFactorExportHandler_6", (String)"fi-pa-business", (Object[])new Object[0]));
        for (int i = 0; i < excelColumnList.size(); ++i) {
            ExcelColumn column = excelColumnList.get(i);
            if (column.getComboMap() != null && !column.getComboMap().isEmpty()) {
                this.createCellCombo(sheet1, 4, i, column.getComboMap());
            }
            this.createCell(dimensionNumberRow, i, this.getCellStyle((Workbook)workbook, false, false, false)).setCellValue(column.getNumber());
            this.createCell(dimensionNameRow, i, this.getCellStyle((Workbook)workbook, false, column.isMustInput(), true)).setCellValue(column.isMustInput() ? column.getName() + "*" : column.getName());
        }
        return workbook;
    }

    @Override
    public String downloadTemplate(ExportParam param) {
        String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u5206\u644a\u56e0\u5b50\u6a21\u677fExcel_%1$s_%2$s.xlsx", (String)"ShareFactorExportHandler_0", (String)"fi-pa-business", (Object[])new Object[0]);
        DynamicObject analysisModelObj = param.getAnalysisModelObj();
        DynamicObject sysObj = analysisModelObj.getDynamicObject("analysis_system");
        fileName = String.format(fileName, sysObj.getString("name"), analysisModelObj.getString("name"));
        String url = this.createExcel(param, fileName, null);
        return url;
    }

    @Override
    public String exportData(ExportParam param) {
        DynamicObject analysisModelObj = param.getAnalysisModelObj();
        DynamicObject sysObj = analysisModelObj.getDynamicObject("analysis_system");
        LocalDate now = LocalDate.now();
        String dateStr = String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u5206\u644a\u56e0\u5b50Excel_%1$s_%2$s_%3$s.xlsx", (String)"ShareFactorExportHandler_1", (String)"fi-pa-business", (Object[])new Object[0]);
        fileName = String.format(fileName, sysObj.getString("name"), analysisModelObj.getString("name"), dateStr);
        DynamicObject[] datas = param.getDatas();
        String url = this.createExcel(param, fileName, (workbook, excelColumnList) -> {
            List<ColumnData> columnDataList;
            if (datas != null && datas.length > 0 && CollectionUtils.isNotEmpty(columnDataList = this.convertColumnData(datas, (List<ExcelColumn>)excelColumnList))) {
                int rowCount = columnDataList.get(0).getDataList().size();
                SXSSFSheet sheet1 = workbook.getSheet(SHEETNAME);
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    int realRowIndex = rowIndex + 4;
                    SXSSFRow dataRow = this.getRow(sheet1, realRowIndex);
                    for (int i = 0; i < columnDataList.size(); ++i) {
                        ColumnData columnData = columnDataList.get(i);
                        if (columnData.getCellIndex() != i) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5217\u4e71\u5e8f", (String)"ShareFactorExportHandler_2", (String)"fi-pa-business", (Object[])new Object[0]));
                        }
                        CellStyle cellStyle = this.getCellStyle((Workbook)workbook, false, false, false);
                        SXSSFCell cell = this.createCell(dataRow, i, cellStyle);
                        Object value = columnData.getDataList().get(rowIndex);
                        if (value == null) continue;
                        ExcelColumn excelColumn = columnData.getEc();
                        if (DataType.StringType.equals((Object)excelColumn.getDataType())) {
                            cell.setCellValue(String.valueOf(value));
                            continue;
                        }
                        if (DataType.DateType.equals((Object)excelColumn.getDataType())) {
                            cell.setCellValue((Date)value);
                            continue;
                        }
                        if (!DataType.BigDecimalType.equals((Object)excelColumn.getDataType())) continue;
                        cell.setCellValue(((BigDecimal)value).doubleValue());
                    }
                }
            }
        });
        return url;
    }

    private String createExcel(ExportParam param, String fileName, BiConsumer<SXSSFWorkbook, List<ExcelColumn>> consumer) {
        OutputStream fos = null;
        FileInputStream fis = null;
        SXSSFWorkbook workbook = null;
        try {
            String url;
            List<ExcelColumn> excelColumnList = this.buildExcelColumnList(param);
            workbook = this.buildTemplate(excelColumnList);
            if (workbook == null) {
                String string = null;
                return string;
            }
            if (consumer != null) {
                consumer.accept(workbook, excelColumnList);
            }
            File temp = File.createTempFile(FilenameUtils.getName((String)UUID.randomUUID().toString()), ".xlsx");
            fos = new FileOutputStream(temp);
            workbook.write(fos);
            fis = new FileInputStream(temp);
            String string = url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, (InputStream)fis, 60);
            return string;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private List<ColumnData> convertColumnData(DynamicObject[] datas, List<ExcelColumn> excelColumnList) {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(excelColumnList.size());
        for (int index = 0; index < excelColumnList.size(); ++index) {
            ColumnData cd = new ColumnData();
            cd.setEc(excelColumnList.get(index));
            cd.setCellIndex(index);
            cd.setDataList(new ArrayList<Object>(10));
            columnDataList.add(cd);
        }
        for (DynamicObject data : datas) {
            DynamicObjectCollection engtryCols = data.getDynamicObjectCollection("share_factor_entry");
            int maxEntryCount = CollectionUtils.isNotEmpty((Collection)engtryCols) ? engtryCols.size() : 1;
            for (int rowIndex = 0; rowIndex < maxEntryCount; ++rowIndex) {
                Map<Object, Object> dimValueMap = new HashMap(1);
                DynamicObject rowData = null;
                if (CollectionUtils.isNotEmpty((Collection)engtryCols)) {
                    rowData = (DynamicObject)engtryCols.get(rowIndex);
                    String dimensionjson = rowData.getString("dimensionjson_tag");
                    List dimValueList = JSON.parseArray((String)dimensionjson, Map.class);
                    dimValueMap = dimValueList.stream().collect(Collectors.toMap(elem -> elem.get("number"), elem -> elem));
                }
                for (ColumnData columnData : columnDataList) {
                    Object value;
                    ExcelColumn ec = columnData.getEc();
                    String propertyName = ec.getProperty().getName();
                    String field = ec.getNumber();
                    if (StringUtils.isEmpty((String)ec.getEntryName())) {
                        DynamicObjectCollection baseDataValue;
                        if (rowIndex >= 1) {
                            columnData.getDataList().add(null);
                            continue;
                        }
                        value = data.get(propertyName);
                        if (propertyName.equals(field) || value == null) {
                            if (ec.getComboMap() != null && !ec.getComboMap().isEmpty()) {
                                value = ec.getComboMap().get(value);
                            }
                            columnData.getDataList().add(value);
                            continue;
                        }
                        if (ec.getProperty() instanceof MulBasedataProp) {
                            baseDataValue = (DynamicObjectCollection)value;
                            StringBuilder valueStr = new StringBuilder();
                            for (DynamicObject mulRowData : baseDataValue) {
                                DynamicObject dynamicObject = mulRowData.getDynamicObject("fbasedataid");
                                String subField = ec.achieveFieldInBaseEntity();
                                String subValue = dynamicObject.getString(subField);
                                valueStr.append(',').append(subValue);
                            }
                            columnData.getDataList().add(valueStr.length() > 0 ? valueStr.substring(1) : null);
                            continue;
                        }
                        baseDataValue = (DynamicObject)value;
                        String subField = ec.achieveFieldInBaseEntity();
                        String subValue = baseDataValue.getString(subField);
                        columnData.getDataList().add(subValue);
                        continue;
                    }
                    if ("value".equals(ec.getNumber())) {
                        value = rowData == null ? null : rowData.get(propertyName);
                        columnData.getDataList().add(value);
                        continue;
                    }
                    Map dimValue = (Map)dimValueMap.get(propertyName);
                    if (dimValue == null) {
                        columnData.getDataList().add(null);
                        continue;
                    }
                    Object value2 = dimValue.get("value");
                    if (propertyName.equals(field)) {
                        if (ec.getComboMap() != null && !ec.getComboMap().isEmpty()) {
                            value2 = ec.getComboMap().get(value2);
                        }
                        columnData.getDataList().add(value2);
                        continue;
                    }
                    columnData.getDataList().add(value2);
                }
            }
        }
        HashMap<IDataEntityProperty, List> baseMap = new HashMap<IDataEntityProperty, List>(10);
        for (ColumnData columnData : columnDataList) {
            String field;
            ExcelColumn ec = columnData.getEc();
            IDataEntityProperty property = ec.getProperty();
            String propertyName = ec.getProperty().getName();
            if (propertyName.equals(field = ec.getNumber()) || !StringUtils.isNotEmpty((String)ec.getEntryName())) continue;
            List list = baseMap.computeIfAbsent(property, p -> new ArrayList());
            list.add(columnData);
        }
        Set baseEntrySet = baseMap.entrySet();
        for (Map.Entry iDataEntityPropertyListEntry : baseEntrySet) {
            this.queryNameAndNumber((IDataEntityProperty)iDataEntityPropertyListEntry.getKey(), (List)iDataEntityPropertyListEntry.getValue());
        }
        return columnDataList;
    }

    private void queryNameAndNumber(IDataEntityProperty baseProperty, List<ColumnData> baseDataColumnList) {
        Map valueMap;
        String subField;
        BasedataProp prop = (BasedataProp)baseProperty;
        String formId = prop.getBaseEntityId();
        StringBuilder sb = new StringBuilder("id");
        HashSet<Object> idSet = new HashSet<Object>(10);
        String[] fields = new String[baseDataColumnList.size()];
        int index = 0;
        HashMap fieldValueMap = new HashMap(baseDataColumnList.size());
        for (ColumnData columnData : baseDataColumnList) {
            ExcelColumn ec2 = columnData.getEc();
            subField = ec2.achieveFieldInBaseEntity();
            sb.append(',').append(subField);
            idSet.addAll(columnData.getDataList());
            fields[index++] = subField;
            valueMap = new HashMap<String, Object>(10);
            fieldValueMap.put(subField, valueMap);
            for (Object e : columnData.getDataList()) {
                valueMap.put(String.valueOf(e), null);
            }
        }
        if (idSet.isEmpty() || idSet.size() == 1 && idSet.contains(null)) {
            return;
        }
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryNameAndNumber", (String)formId, (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, null);){
            for (Row row : dataSet) {
                Object pk = row.get("id");
                for (String field : fields) {
                    Map valueMap2 = (Map)fieldValueMap.get(field);
                    valueMap2.put(String.valueOf(pk), row.get(field));
                }
            }
        }
        catch (Throwable ec2) {
            Throwable throwable2 = ec2;
            throw ec2;
        }
        for (ColumnData columnData : baseDataColumnList) {
            ExcelColumn ec = columnData.getEc();
            subField = ec.achieveFieldInBaseEntity();
            valueMap = (Map)fieldValueMap.get(subField);
            List<Object> oldValueList = columnData.getDataList();
            ArrayList<Object> arrayList = new ArrayList<Object>(oldValueList.size());
            for (Object o : oldValueList) {
                arrayList.add(valueMap.get(String.valueOf(o)));
            }
            columnData.setDataList(arrayList);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ThreeValueTuple<String, Object, Map<Integer, List<String>>> importData(ImportFile importFile, ExportParam param) {
        List errorInfoList;
        IDataEntityProperty property;
        DynamicObject analysisModelObj = param.getAnalysisModelObj();
        List<ExcelColumn> excelColumnList = this.buildExcelColumnList(param);
        for (ExcelColumn excelColumn : excelColumnList) {
            excelColumn.setMustInput(false);
        }
        ThreeValueTuple<List<ColumnData>, Object, Map<Integer, List<String>>> fileData = this.uploadBase(importFile, excelColumnList);
        DynamicObjectCollection modelDimensionCol = analysisModelObj.getDynamicObjectCollection("dimension_entry");
        Map<String, DynamicObject> dimNumberToDataMap = modelDimensionCol.stream().map(rowData -> rowData.getDynamicObject("dimension")).collect(Collectors.toMap(dimObj -> dimObj.getString("number"), dimObj -> dimObj));
        List columnDataList = (List)fileData.getKey();
        List<ShareFactorExtend> shareFactorExtendList = this.dataClassify(columnDataList);
        Map errorMessageMap = (Map)fileData.getValue();
        Optional<ColumnData> dimensionColumnOptional = columnDataList.stream().filter(cd -> cd.getEc().getProperty().getName().equals("dimension")).findFirst();
        ColumnData dimensionColumn = dimensionColumnOptional.get();
        List<Object> dimensionNumberList = dimensionColumn.getDataList();
        if (CollectionUtils.isNotEmpty(dimensionNumberList)) {
            ArrayList<Object> dimensionIdList = new ArrayList<Object>(dimensionNumberList.size());
            for (Object dimensionNumbers : dimensionNumberList) {
                String[] numberArr;
                if (dimensionNumbers == null) {
                    dimensionIdList.add(null);
                    continue;
                }
                String string = String.valueOf(dimensionNumbers);
                StringBuilder idBuild = new StringBuilder();
                for (String number : numberArr = string.split(",")) {
                    if (StringUtils.isEmpty((String)number)) continue;
                    DynamicObject dimObj2 = dimNumberToDataMap.get(number);
                    if (dimObj2 == null) {
                        idBuild.append(',').append(KEY_NOTFOUND).append('_').append(number);
                        continue;
                    }
                    idBuild.append(',').append(dimObj2.getPkValue());
                }
                if (idBuild.length() > 0) {
                    String ids = idBuild.substring(1);
                    dimensionIdList.add(ids);
                    continue;
                }
                dimensionIdList.add(null);
            }
            dimensionColumn.setDataList(dimensionIdList);
        }
        HashMap<IDataEntityProperty, List> baseMap = new HashMap<IDataEntityProperty, List>(10);
        for (Object columnData : columnDataList) {
            Object field;
            ExcelColumn excelColumn = ((ColumnData)columnData).getEc();
            property = excelColumn.getProperty();
            String propertyName = excelColumn.getProperty().getName();
            if (propertyName.equals(field = excelColumn.getNumber()) || !StringUtils.isNotEmpty((String)excelColumn.getEntryName())) continue;
            List list = baseMap.computeIfAbsent(property, p -> new ArrayList());
            list.add(columnData);
        }
        Set baseEntrySet = baseMap.entrySet();
        for (Map.Entry entry : baseEntrySet) {
            property = (IDataEntityProperty)entry.getKey();
            String dimNumber = property.getName();
            this.queryId((IDataEntityProperty)entry.getKey(), (List)entry.getValue(), dimNumberToDataMap.get(dimNumber));
        }
        Optional<DynamicObject> periodDim = modelDimensionCol.stream().filter(row -> DimensionNecessityEnum.PERIOD.getCode().equals(row.getString("necessity_dim"))).findFirst();
        String string = "";
        if (periodDim.isPresent()) {
            DynamicObject periodObj = periodDim.get().getDynamicObject("dimension");
            String string2 = periodObj.getString("number");
        }
        ArrayList<DynamicObject> shareFactorList = new ArrayList<DynamicObject>(shareFactorExtendList.size());
        HashMap<DynamicObject, ShareFactorExtend> dyToExtend = new HashMap<DynamicObject, ShareFactorExtend>();
        for (ShareFactorExtend shareFactorExtend : shareFactorExtendList) {
            void var17_24;
            shareFactorExtend.init(columnDataList);
            boolean isNice = shareFactorExtend.validate(columnDataList, dimNumberToDataMap, errorMessageMap, (String)var17_24);
            if (isNice) {
                DynamicObject dy = shareFactorExtend.createDynamicObject(columnDataList, dimNumberToDataMap, (String)var17_24, analysisModelObj);
                shareFactorList.add(dy);
                shareFactorExtend.deleteErrorMsg(errorMessageMap);
                dyToExtend.put(dy, shareFactorExtend);
                continue;
            }
            shareFactorExtend.deleteHeadMsg(errorMessageMap, columnDataList);
        }
        DynamicObject[] saveArr = shareFactorList.toArray(new DynamicObject[0]);
        OperationResult or = OperationServiceHelper.executeOperate((String)"save", (String)"pa_sharefactor", (DynamicObject[])saveArr, null);
        ThreeValueTuple tvp = new ThreeValueTuple(null, (Object)or, (Object)errorMessageMap);
        int successCount = or == null || or.getSuccessPkIds() == null ? 0 : or.getSuccessPkIds().size();
        int errorCount = shareFactorExtendList.size() - successCount;
        List list = errorInfoList = or == null ? null : or.getAllErrorOrValidateInfo();
        if (errorInfoList != null && !errorInfoList.isEmpty()) {
            for (IOperateInfo operateInfo : errorInfoList) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operateInfo;
                int errDataIndex = operateErrorInfo.getDataEntityIndex();
                DynamicObject dy = saveArr[errDataIndex];
                ShareFactorExtend shareFactorExtend = (ShareFactorExtend)dyToExtend.get(dy);
                if (shareFactorExtend == null) continue;
                int excelRowIndex = shareFactorExtend.getStart();
                List errorMsgList = errorMessageMap.computeIfAbsent(excelRowIndex, rowIndex -> new ArrayList(10));
                errorMsgList.add(operateErrorInfo.getMessage());
            }
        }
        String message = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", (String)"ShareFactorExportHandler_7", (String)"fi-pa-business", (Object[])new Object[0]), successCount, errorCount);
        String prefix = "";
        prefix = successCount <= 0 ? ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a", (String)"ShareFactorExportHandler_3", (String)"fi-pa-business", (Object[])new Object[0]) : (errorCount <= 0 ? ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u5165\u5168\u90e8\u6210\u529f\uff1a", (String)"ShareFactorExportHandler_4", (String)"fi-pa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u5165\u90e8\u5206\u6210\u529f\uff1a", (String)"ShareFactorExportHandler_5", (String)"fi-pa-business", (Object[])new Object[0]));
        message = prefix + message;
        tvp.setKey((Object)message);
        return tvp;
    }

    private void queryId(IDataEntityProperty property, List<ColumnData> baseDataColumnList, DynamicObject dimObj) {
        Object filter;
        BasedataProp basedataProp = (BasedataProp)property;
        String formId = basedataProp.getBaseEntityId();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        StringBuilder fieldBuilder = new StringBuilder();
        fieldBuilder.append("id");
        String[] fields = new String[baseDataColumnList.size()];
        int index = 0;
        HashMap fieldValueMap = new HashMap(baseDataColumnList.size());
        for (ColumnData columnData : baseDataColumnList) {
            filter = columnData.achieveQFilterInBase();
            if (filter != null) {
                filterList.add((QFilter)filter);
            }
            String field3 = columnData.getEc().achieveFieldInBaseEntity();
            fieldBuilder.append(",").append(field3);
            fields[index++] = field3;
            HashMap valueMap = new HashMap();
            fieldValueMap.put(field3, valueMap);
            for (Object e : columnData.getDataList()) {
                if (e == null) continue;
                valueMap.put(e, null);
            }
        }
        if (filterList.isEmpty()) {
            return;
        }
        QFilter filter2 = this.achieveDimensionTypeFilter(dimObj);
        if (filter2 != null) {
            filterList.add(filter2);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryId", (String)formId, (String)fieldBuilder.toString(), (QFilter[])filterList.toArray(new QFilter[0]), null);
        filter = null;
        try {
            for (Row row : dataSet) {
                for (String field2 : fields) {
                    Object key;
                    Map valueMap = (Map)fieldValueMap.get(field2);
                    Object value = valueMap.get(key = row.get(field2));
                    if (value != null) {
                        ArrayList<Object> repeatIdList;
                        if (value instanceof List) {
                            repeatIdList = (ArrayList<Object>)value;
                            repeatIdList.add(row.get("id"));
                            valueMap.put(key, repeatIdList);
                            continue;
                        }
                        repeatIdList = new ArrayList<Object>(3);
                        repeatIdList.add(value);
                        repeatIdList.add(row.get("id"));
                        valueMap.put(key, repeatIdList);
                        continue;
                    }
                    valueMap.put(key, row.get("id"));
                }
            }
        }
        catch (Throwable field3) {
            filter = field3;
            throw field3;
        }
        finally {
            if (dataSet != null) {
                if (filter != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable field3) {
                        ((Throwable)filter).addSuppressed(field3);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (ColumnData columnData : baseDataColumnList) {
            String field = columnData.getEc().achieveFieldInBaseEntity();
            List<Object> oldValueList = columnData.getDataList();
            ArrayList<Object> newValueList = new ArrayList<Object>(oldValueList.size());
            for (Object o : oldValueList) {
                if (o == null) {
                    newValueList.add(null);
                    continue;
                }
                Map valueMap = (Map)fieldValueMap.get(field);
                Object newValue = valueMap.get(o);
                if (newValue == null) {
                    newValue = KEY_NOTFOUND;
                }
                newValueList.add(newValue);
            }
            columnData.setDataList(newValueList);
        }
    }

    public List<ShareFactorExtend> dataClassify(List<ColumnData> columnDataList) {
        ArrayList<ShareFactorExtend> resultList = new ArrayList<ShareFactorExtend>();
        List headData = columnDataList.stream().filter(cd -> {
            ExcelColumn ec = cd.getEc();
            return StringUtils.isEmpty((String)ec.getEntryName());
        }).collect(Collectors.toList());
        Map<IDataEntityProperty, List<ColumnData>> headFieldDataMap = headData.stream().collect(Collectors.groupingBy(cd -> cd.getEc().getProperty()));
        Set<Map.Entry<IDataEntityProperty, List<ColumnData>>> headFieldDataEntrySet = headFieldDataMap.entrySet();
        int start = 0;
        int count = ((ColumnData)headData.get(0)).getDataList().size();
        if (count > 0) {
            for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
                boolean currDataIsNull = true;
                for (Map.Entry<IDataEntityProperty, List<ColumnData>> iDataEntityPropertyListEntry : headFieldDataEntrySet) {
                    List<ColumnData> headFieldDataList = iDataEntityPropertyListEntry.getValue();
                    if (headFieldDataList.isEmpty()) continue;
                    Object value = null;
                    if (headFieldDataList.size() > 1) {
                        for (ColumnData columnData : headFieldDataList) {
                            Object columnValue = columnData.getDataList().get(rowIndex);
                            if (columnValue == null) continue;
                            value = columnValue;
                            break;
                        }
                    } else {
                        value = headFieldDataList.get(0).getDataList().get(rowIndex);
                    }
                    if (value == null) continue;
                    currDataIsNull = false;
                    break;
                }
                if (rowIndex <= 0 || currDataIsNull) continue;
                int length = rowIndex - start;
                resultList.add(new ShareFactorExtend(start, length));
                start = rowIndex;
            }
            if (count >= start + 1) {
                resultList.add(new ShareFactorExtend(start, count - start));
            }
        }
        return resultList;
    }
}

