/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.export.excel;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.dto.ShareFactorDimensionDTO;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.export.excel.BaseExportHandler;
import kd.fi.pa.export.excel.ColumnData;
import kd.fi.pa.export.excel.ExcelColumn;
import kd.fi.pa.export.excel.ShareFactorExportHandler;

public class ShareFactorExtend {
    private String number;
    private String name;
    private String factorType;
    private String dimensionIds;
    private String describe;
    private int start;
    private int length;

    public ShareFactorExtend(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public void init(List<ColumnData> columnDataList) {
        List headData = columnDataList.stream().filter(cd -> {
            ExcelColumn ec = cd.getEc();
            return StringUtils.isEmpty((String)ec.getEntryName());
        }).collect(Collectors.toList());
        Map<String, List<ColumnData>> headFieldDataMap = headData.stream().collect(Collectors.groupingBy(cd -> cd.getEc().getProperty().getName()));
        List<ColumnData> fieldDataColumnDataList = headFieldDataMap.get("number");
        if (fieldDataColumnDataList.size() == 1) {
            this.number = (String)fieldDataColumnDataList.get(0).getDataList().get(this.start);
        }
        if ((fieldDataColumnDataList = headFieldDataMap.get("name")).size() == 1) {
            this.name = (String)fieldDataColumnDataList.get(0).getDataList().get(this.start);
        }
        if ((fieldDataColumnDataList = headFieldDataMap.get("factortype")).size() == 1) {
            this.factorType = (String)fieldDataColumnDataList.get(0).getDataList().get(this.start);
        }
        if (CollectionUtils.isNotEmpty(fieldDataColumnDataList = headFieldDataMap.get("dimension"))) {
            this.dimensionIds = (String)fieldDataColumnDataList.get(0).getDataList().get(this.start);
        }
        if ((fieldDataColumnDataList = headFieldDataMap.get("describe")).size() == 1) {
            this.describe = (String)fieldDataColumnDataList.get(0).getDataList().get(this.start);
        }
    }

    public boolean validate(List<ColumnData> columnDataList, Map<String, DynamicObject> dimNumberToDataMap, Map<Integer, List<String>> errorMessageMap, String periodNumber) {
        boolean isSuccess = true;
        List headErrorList = errorMessageMap.computeIfAbsent(this.start, k -> new ArrayList(10));
        if (StringUtils.isEmpty((String)this.number)) {
            headErrorList.add(ResManager.loadKDString((String)"\u7f16\u53f7\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"ShareFactorExtend_0", (String)"fi-pa-business", (Object[])new Object[0]));
            isSuccess = false;
        }
        if (StringUtils.isEmpty((String)this.name)) {
            headErrorList.add(ResManager.loadKDString((String)"\u540d\u79f0\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"ShareFactorExtend_1", (String)"fi-pa-business", (Object[])new Object[0]));
            isSuccess = false;
        }
        if (StringUtils.isEmpty((String)this.factorType)) {
            headErrorList.add(ResManager.loadKDString((String)"\u7c7b\u578b\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"ShareFactorExtend_2", (String)"fi-pa-business", (Object[])new Object[0]));
            isSuccess = false;
        } else if (BaseExportHandler.isIllegality(this.factorType)) {
            isSuccess = false;
        }
        if (StringUtils.isEmpty((String)this.dimensionIds)) {
            headErrorList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u53f7\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"ShareFactorExtend_3", (String)"fi-pa-business", (Object[])new Object[0]));
            isSuccess = false;
        } else if (StringUtils.isNotEmpty((String)this.factorType) && !BaseExportHandler.isIllegality(this.factorType)) {
            if (this.dimensionIds.contains("notFound")) {
                String fix = this.dimensionIds.split("notFound")[1];
                String dimNumber = fix.indexOf(",") > -1 ? fix.substring(1, fix.indexOf(",")) : fix.substring(1);
                String errorMsg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u53f7\u5217\u4e2d\u7ef4\u5ea6\u7f16\u53f7\u4e3a%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u6a21\u578b\u914d\u7f6e\u7ef4\u5ea6", (String)"ShareFactorExtend_4", (String)"fi-pa-business", (Object[])new Object[0]);
                errorMsg = String.format(errorMsg, dimNumber);
                headErrorList.add(errorMsg);
                isSuccess = false;
            } else {
                String[] idArr = this.dimensionIds.split(",");
                Map<String, String> idToNumberMap = dimNumberToDataMap.values().stream().collect(Collectors.toMap(dimObj -> String.valueOf(dimObj.getPkValue()), dimObj -> dimObj.getString("number")));
                LinkedHashSet<String> dimNumberSet = new LinkedHashSet<String>();
                for (String dimIdStr : idArr) {
                    if (!StringUtils.isNotEmpty((String)dimIdStr)) continue;
                    dimNumberSet.add(idToNumberMap.get(dimIdStr));
                }
                if (dimNumberSet.contains(periodNumber)) {
                    String errorMsg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u5217\u4e2d\u4e0d\u80fd\u5b58\u5728\u7ef4\u5ea6\u7f16\u53f7\u4e3a%s\u7684\u671f\u95f4\u7ef4\u5ea6", (String)"ShareFactorExtend_5", (String)"fi-pa-business", (Object[])new Object[0]);
                    errorMsg = String.format(errorMsg, periodNumber);
                    headErrorList.add(errorMsg);
                    isSuccess = false;
                }
                Set dateDimNumberSet = dimNumberToDataMap.values().stream().filter(dimObj -> DimensionTypeEnum.getEnum((String)((String)dimObj.get("dimensiontype"))) == DimensionTypeEnum.DATE).map(dimObj -> dimObj.getString("number")).collect(Collectors.toSet());
                StringBuilder sb = new StringBuilder();
                for (String dateDimNumber : dateDimNumberSet) {
                    if (!dimNumberSet.contains(dateDimNumber)) continue;
                    sb.append(',').append(dateDimNumber);
                }
                if (sb.length() > 0) {
                    String errorMsg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u53f7\u5217\u4e2d\u4e0d\u80fd\u5b58\u5728\u7ef4\u5ea6\u7f16\u53f7\u4e3a%s\u7684\u7ef4\u5ea6", (String)"ShareFactorExtend_6", (String)"fi-pa-business", (Object[])new Object[0]);
                    errorMsg = String.format(errorMsg, sb.substring(1));
                    headErrorList.add(errorMsg);
                    isSuccess = false;
                }
                if (this.factorType.equals("0")) {
                    dimNumberSet.add(periodNumber);
                }
                dimNumberSet.add("value");
                List entryData = columnDataList.stream().filter(cd -> {
                    ExcelColumn ec = cd.getEc();
                    String dimNumber = ec.getProperty().getName();
                    return StringUtils.isNotEmpty((String)ec.getEntryName()) && dimNumberSet.contains(dimNumber);
                }).collect(Collectors.toList());
                Map<IDataEntityProperty, List<ColumnData>> entryFieldDataMap = entryData.stream().collect(Collectors.groupingBy(cd -> cd.getEc().getProperty()));
                Set<Map.Entry<IDataEntityProperty, List<ColumnData>>> entryFieldDataEntrySet = entryFieldDataMap.entrySet();
                HashMap<Integer, List> entryErrorMap = new HashMap<Integer, List>(this.length);
                for (int index = 0; index < this.length; ++index) {
                    int rowIndex = this.start + index;
                    boolean rowIsNull = true;
                    List rowErrorList = entryErrorMap.computeIfAbsent(rowIndex, k -> new ArrayList(1));
                    ArrayList<String> rowEmptyError = new ArrayList<String>(10);
                    for (Map.Entry<IDataEntityProperty, List<ColumnData>> iDataEntityPropertyListEntry : entryFieldDataEntrySet) {
                        ColumnData cd2;
                        List<ColumnData> fieldColumnList = iDataEntityPropertyListEntry.getValue();
                        if (fieldColumnList.size() == 1) {
                            cd2 = fieldColumnList.get(0);
                            Object factorValue = cd2.getDataList().get(rowIndex);
                            if (factorValue != null) {
                                rowIsNull = false;
                                if (!BaseExportHandler.isIllegality(factorValue)) continue;
                                isSuccess = false;
                                continue;
                            }
                            if ("value".equals(cd2.getEc().getNumber())) continue;
                            rowEmptyError.add(this.emptyMessage(cd2));
                            continue;
                        }
                        if (fieldColumnList.size() <= 1) continue;
                        cd2 = fieldColumnList.get(0);
                        Object baseId = cd2.getDataList().get(rowIndex);
                        if (baseId != null) {
                            rowIsNull = false;
                            if ("notFound".equals(baseId)) {
                                rowErrorList.add(this.notFoundMessage(cd2));
                                isSuccess = false;
                                continue;
                            }
                            if (!(baseId instanceof List)) continue;
                            rowErrorList.add(this.mulValueMessage(cd2));
                            isSuccess = false;
                            continue;
                        }
                        rowEmptyError.add(this.emptyMessage(cd2));
                    }
                    if (rowIsNull && this.length == 1 || rowEmptyError.isEmpty()) continue;
                    isSuccess = false;
                    rowErrorList.addAll(rowEmptyError);
                }
                boolean isComplete = true;
                for (int index = 0; index < this.length; ++index) {
                    int rowIndex = this.start + index;
                    List entryErrorList = (List)entryErrorMap.get(rowIndex);
                    List<String> rowErrorList = errorMessageMap.get(rowIndex);
                    if (entryErrorList.isEmpty()) continue;
                    isComplete = false;
                    if (rowErrorList == null) {
                        errorMessageMap.put(rowIndex, entryErrorList);
                        continue;
                    }
                    rowErrorList.addAll(entryErrorList);
                }
                if (isComplete) {
                    boolean hasPeriod = dimNumberSet.remove(periodNumber);
                    dimNumberSet.remove("value");
                    Map<String, List<ColumnData>> dimEntryFieldDataMap = entryData.stream().collect(Collectors.groupingBy(cd -> cd.getEc().getProperty().getName()));
                    LinkedHashMap<String, ArrayList<String>> combinationMap = new LinkedHashMap<String, ArrayList<String>>(1);
                    for (int index = 0; index < this.length; ++index) {
                        int rowIndex = this.start + index;
                        StringBuilder currentRowCombination = new StringBuilder();
                        if (hasPeriod) {
                            List<ColumnData> periodDataList = dimEntryFieldDataMap.get(periodNumber);
                            Object periodId = ((ColumnData)periodDataList.get(0)).getDataList().get(rowIndex);
                            currentRowCombination.append(',').append(periodId);
                        }
                        for (String dimNumber : dimNumberSet) {
                            List<ColumnData> dimDataList = dimEntryFieldDataMap.get(dimNumber);
                            Object valueObject = dimDataList.get(0).getDataList().get(rowIndex);
                            currentRowCombination.append(',').append(valueObject);
                        }
                        if (currentRowCombination.length() <= 0) continue;
                        String combinationKey = currentRowCombination.substring(1);
                        ArrayList<String> combinationRowList = (ArrayList<String>)combinationMap.get(combinationKey);
                        if (combinationRowList == null) {
                            combinationRowList = new ArrayList<String>(1);
                        }
                        combinationRowList.add(String.valueOf(rowIndex + 5));
                        combinationMap.put(combinationKey, combinationRowList);
                    }
                    if (!combinationMap.isEmpty()) {
                        StringBuilder repeatMsgBuilder = new StringBuilder();
                        for (Map.Entry entry : combinationMap.entrySet()) {
                            List combinationRowList = (List)entry.getValue();
                            if (combinationRowList == null || combinationRowList.size() <= 1) continue;
                            repeatMsgBuilder.append(',').append("[").append(String.join((CharSequence)",", combinationRowList)).append("]");
                        }
                        if (repeatMsgBuilder.length() > 0) {
                            isSuccess = false;
                            String errorMessage = hasPeriod ? String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u671f\u95f4+\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u66f4\u6539\u3002", (String)"ShareFactorExtend_7", (String)"fi-pa-business", (Object[])new Object[0]), repeatMsgBuilder.substring(1)) : String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u66f4\u6539\u3002", (String)"ShareFactorExtend_8", (String)"fi-pa-business", (Object[])new Object[0]), repeatMsgBuilder.substring(1));
                            List repeatErrorList = errorMessageMap.computeIfAbsent(ShareFactorExportHandler.REPEATMSG, k -> new ArrayList(10));
                            repeatErrorList.add(errorMessage);
                        }
                    }
                }
            }
        }
        return isSuccess;
    }

    private String mulValueMessage(ColumnData columnData) {
        String error = ResManager.loadKDString((String)"\u5217\u65e0\u6cd5\u6839\u636e\u7f16\u53f7\u786e\u5b9a\u552f\u4e00\u4e00\u6761\u57fa\u7840\u8d44\u6599\u6570\u636e", (String)"ShareFactorExtend_9", (String)"fi-pa-business", (Object[])new Object[0]);
        return columnData.getEc().getName() + error;
    }

    private String notFoundMessage(ColumnData columnData) {
        String error = ResManager.loadKDString((String)"\u5217\u503c\u4e0d\u5408\u6cd5\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u57fa\u7840\u8d44\u6599", (String)"ShareFactorExtend_10", (String)"fi-pa-business", (Object[])new Object[0]);
        return columnData.getEc().getName() + error;
    }

    private String emptyMessage(ColumnData columnData) {
        String error = ResManager.loadKDString((String)"\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"ShareFactorExtend_11", (String)"fi-pa-business", (Object[])new Object[0]);
        return columnData.getEc().getName() + error;
    }

    public DynamicObject createDynamicObject(List<ColumnData> columnDataList, Map<String, DynamicObject> dimNumberToDataMap, String periodNumber, DynamicObject analysisModelObj) {
        DynamicObject currData = BusinessDataServiceHelper.newDynamicObject((String)"pa_sharefactor");
        currData.set("number", (Object)this.number);
        currData.set("name", (Object)this.name);
        currData.set("factortype", (Object)this.factorType);
        currData.set("describe", (Object)this.describe);
        currData.set("analysis_system_id", analysisModelObj.get("analysis_system_id"));
        currData.set("analysis_model_id", analysisModelObj.getPkValue());
        currData.set("isimport", (Object)true);
        DynamicObjectCollection dimCols = currData.getDynamicObjectCollection("dimension");
        String[] idArr = this.dimensionIds.split(",");
        Map<String, String> idToNumberMap = dimNumberToDataMap.values().stream().collect(Collectors.toMap(dimObj -> String.valueOf(dimObj.getPkValue()), dimObj -> dimObj.getString("number")));
        LinkedHashSet<String> dimNumberSet = new LinkedHashSet<String>();
        boolean hasPeriod = false;
        DynamicObject periodDim = dimNumberToDataMap.get(periodNumber);
        DimensionTypeEnum periodEnum = DimensionTypeEnum.getEnum((String)periodDim.getString("dimensiontype"));
        if (this.factorType.equals("0")) {
            dimNumberSet.add(periodNumber);
            hasPeriod = true;
        }
        for (String idStr : idArr) {
            DynamicObject row = dimCols.addNew();
            row.set("fbasedataid_id", (Object)Long.valueOf(idStr));
            if (!StringUtils.isNotEmpty((String)idStr)) continue;
            dimNumberSet.add(idToNumberMap.get(idStr));
        }
        dimNumberSet.add("value");
        currData.set("dimension", (Object)dimCols);
        List entryData = columnDataList.stream().filter(cd -> {
            ExcelColumn ec = cd.getEc();
            String dimNumber = ec.getProperty().getName();
            return StringUtils.isNotEmpty((String)ec.getEntryName()) && dimNumberSet.contains(dimNumber);
        }).collect(Collectors.toList());
        Map<String, List<ColumnData>> dimEntryFieldDataMap = entryData.stream().collect(Collectors.groupingBy(cd -> cd.getEc().getProperty().getName()));
        dimNumberSet.remove(periodNumber);
        dimNumberSet.remove("value");
        DynamicObjectCollection entryCols = currData.getDynamicObjectCollection("share_factor_entry");
        for (int index = 0; index < this.length; ++index) {
            List<ColumnData> factorValue;
            Object value;
            int rowIndex = this.start + index;
            DynamicObject rowData = entryCols.addNew();
            ArrayList<ShareFactorDimensionDTO> factorDimensionDTOList = new ArrayList<ShareFactorDimensionDTO>(dimNumberSet.size());
            StringBuilder valueBuilder = new StringBuilder();
            if (hasPeriod) {
                List<ColumnData> periodDataList = dimEntryFieldDataMap.get(periodNumber);
                Object periodId = ((ColumnData)periodDataList.get(0)).getDataList().get(rowIndex);
                valueBuilder.append(',').append(periodId);
                factorDimensionDTOList.add(new ShareFactorDimensionDTO("period", periodEnum, periodId));
            }
            for (String dimNumber : dimNumberSet) {
                DynamicObject dynamicObject = dimNumberToDataMap.get(dimNumber);
                DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dynamicObject.getString("dimensiontype"));
                List<ColumnData> dimDataList = dimEntryFieldDataMap.get(dimNumber);
                Object value2 = dimDataList.get(0).getDataList().get(rowIndex);
                valueBuilder.append(',').append(value2);
                ShareFactorDimensionDTO dto = new ShareFactorDimensionDTO(dimNumber, dimensionType, value2);
                factorDimensionDTOList.add(dto);
            }
            rowData.set("dimensionjson_tag", (Object)JSON.toJSONString(factorDimensionDTOList));
            if (valueBuilder.length() > 0) {
                rowData.set("value_pks_tag", (Object)valueBuilder.substring(1));
            }
            rowData.set("value", (value = (factorValue = dimEntryFieldDataMap.get("value")).get(0).getDataList().get(rowIndex)) == null ? BigDecimal.ZERO : value);
        }
        currData.set("share_factor_entry", (Object)entryCols);
        currData.set("enable", (Object)"1");
        currData.set("status", (Object)"C");
        RequestContext rc = RequestContext.get();
        currData.set("creator_id", (Object)rc.getCurrUserId());
        currData.set("createtime", (Object)new Date());
        return currData;
    }

    public void deleteErrorMsg(Map<Integer, List<String>> errorMessageMap) {
        for (int index = 0; index < this.length; ++index) {
            int rowIndex = this.start + index;
            errorMessageMap.remove(rowIndex);
        }
    }

    public void deleteHeadMsg(Map<Integer, List<String>> errorMessageMap, List<ColumnData> columnDataList) {
        List headData = columnDataList.stream().filter(cd -> {
            ExcelColumn ec = cd.getEc();
            return StringUtils.isEmpty((String)ec.getEntryName());
        }).collect(Collectors.toList());
        for (int index = 1; index < this.length; ++index) {
            int rowIndex = this.start + index;
            List<String> rowErrorMsg = errorMessageMap.get(rowIndex);
            if (CollectionUtils.isEmpty(rowErrorMsg) || CollectionUtils.isEmpty(headData)) continue;
            for (ColumnData headDatum : headData) {
                Iterator<String> iterator = rowErrorMsg.iterator();
                String displayName = headDatum.getEc().getName();
                while (iterator.hasNext()) {
                    String errMsg = iterator.next();
                    if (!errMsg.startsWith(displayName)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFactorType() {
        return this.factorType;
    }

    public void setFactorType(String factorType) {
        this.factorType = factorType;
    }

    public String getDimensionIds() {
        return this.dimensionIds;
    }

    public void setDimensionIds(String dimensionIds) {
        this.dimensionIds = dimensionIds;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }
}

