/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.review;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.enums.DataReviewRuleTypeEnum;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.review.dto.PADerivationRuleInfoDTO;
import kd.fi.pa.review.dto.PAShareRuleInfoDTO;
import kd.fi.pa.utils.AnalysisModelUtil;

public class DataReviewHelper {
    public static List<DynamicObject> getAllOrderlyDetailsOfSummaryId(Long modelId, Long summaryId, String measureNumber) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (anaModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728,\u6a21\u578bid\u4e3a : %s", (String)"DataReviewHelper_4", (String)"fi-pa-business", (Object[])new Object[0]), modelId));
        }
        StringBuilder selectFieldStr = new StringBuilder();
        selectFieldStr.append("id").append(',');
        for (DynamicObject dimensionEntry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            String dimensionNumber = dimensionEntry.getDynamicObject("dimension").getString("number");
            selectFieldStr.append(dimensionNumber).append(',');
        }
        selectFieldStr.append("datastatus").append(',');
        selectFieldStr.append("createstamp").append(',');
        selectFieldStr.append("importbatch").append(',');
        selectFieldStr.append("execlogid").append(',');
        selectFieldStr.append("subexeclogid").append(',');
        selectFieldStr.append("summaryid").append(',');
        selectFieldStr.append("execparentbillid").append(',');
        selectFieldStr.append(measureNumber);
        QFilter summaryIdFilter = new QFilter("summaryid", "=", (Object)summaryId);
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)anaModel.getString("tablenumber"));
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectFieldStr.toString(), (QFilter[])new QFilter[]{summaryIdFilter}, (String)"createstamp desc");
        if (CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            return new ArrayList<DynamicObject>(0);
        }
        return DataReviewHelper.reOrderSelfRuleOffDetails(new ArrayList<DynamicObject>(dynamicObjectMap.values()));
    }

    private static List<DynamicObject> reOrderSelfRuleOffDetails(List<DynamicObject> details) {
        ArrayList<Tuple> swapIndexTuples = new ArrayList<Tuple>(2);
        block3: for (int i = 0; i < details.size(); ++i) {
            DynamicObject detail = details.get(i);
            DataStatusEnum dataStatus = DataStatusEnum.getEnumByCode((byte)Byte.parseByte(detail.getString("datastatus")));
            switch (dataStatus) {
                case OFF_ALLOCATE: 
                case OFF_DERIVE: 
                case OFF_ADJUST: {
                    long detailId = detail.getLong("id");
                    long detailSubExecLogId = detail.getLong("subexeclogid");
                    List businessDetailOfSameSubId = details.stream().filter(d -> detailId != d.getLong("id")).filter(d -> detailSubExecLogId == d.getLong("subexeclogid")).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(businessDetailOfSameSubId)) continue block3;
                    int selfBusinessDetailIndex = 0;
                    DynamicObject detailOfEarliest = (DynamicObject)businessDetailOfSameSubId.get(businessDetailOfSameSubId.size() - 1);
                    long selfBusinessDetailId = detailOfEarliest.getLong("id");
                    for (DynamicObject dy : details) {
                        if (selfBusinessDetailId == dy.getLong("id")) break;
                        ++selfBusinessDetailIndex;
                    }
                    if (i >= selfBusinessDetailIndex) continue block3;
                    swapIndexTuples.add(new Tuple((Object)i, (Object)selfBusinessDetailIndex));
                    continue block3;
                }
            }
        }
        for (Tuple tuple : swapIndexTuples) {
            DynamicObject offDetail = details.get((Integer)tuple.item1);
            DynamicObject selfBusinessDetailId = details.get((Integer)tuple.item2);
            Date offDetailCreateStamp = offDetail.getDate("createstamp");
            Date selfBusinessDetailCreateStamp = selfBusinessDetailId.getDate("createstamp");
            offDetail.set("createstamp", (Object)selfBusinessDetailCreateStamp);
            selfBusinessDetailId.set("createstamp", (Object)offDetailCreateStamp);
            Collections.swap(details, (int)((Integer)tuple.item1), (int)((Integer)tuple.item2));
        }
        return details;
    }

    public static DynamicObject getSummaryById(Long modelId, Long summaryId, String measureNumber) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (anaModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728,\u6a21\u578bid\u4e3a : %s", (String)"DataReviewHelper_4", (String)"fi-pa-business", (Object[])new Object[0]), modelId));
        }
        StringBuilder selectFieldStr = new StringBuilder();
        selectFieldStr.append("id").append(',');
        for (DynamicObject dimensionEntry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            String dimensionNumber = dimensionEntry.getDynamicObject("dimension").getString("number");
            selectFieldStr.append(dimensionNumber).append(',');
        }
        selectFieldStr.append("datastatus");
        if (StringUtils.isNotBlank((CharSequence)measureNumber)) {
            selectFieldStr.append(',').append(measureNumber);
        }
        String entityNumber = AnalysisModelUtil.buildEntityNumber((String)anaModel.getString("tablenumber"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)selectFieldStr.toString(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)summaryId)});
    }

    public static DynamicObject getDetailById(Long modelId, Long detailId, String measureNumber) {
        Collection<DynamicObject> detailsByIds = DataReviewHelper.getDetailsByIds(modelId, new Long[]{detailId}, measureNumber);
        return detailsByIds.stream().findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728,\u660e\u7ec6id:%s", (String)"DataReviewHelper_0", (String)"fi-pa-business", (Object[])new Object[0]), detailId)));
    }

    public static Collection<DynamicObject> getDetailsByIds(Long modelId, Long[] detailIds, String measureNumber) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (anaModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728,\u6a21\u578bid\u4e3a : %s", (String)"DataReviewHelper_4", (String)"fi-pa-business", (Object[])new Object[0]), modelId));
        }
        StringBuilder selectFieldStr = new StringBuilder();
        selectFieldStr.append("id").append(',');
        for (DynamicObject dimensionEntry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            String dimensionNumber = dimensionEntry.getDynamicObject("dimension").getString("number");
            selectFieldStr.append(dimensionNumber).append(',');
        }
        selectFieldStr.append("datastatus").append(',');
        selectFieldStr.append("createstamp").append(',');
        selectFieldStr.append("execlogid").append(',');
        selectFieldStr.append("subexeclogid").append(',');
        selectFieldStr.append("summaryid").append(',');
        selectFieldStr.append("execparentbillid");
        if (StringUtils.isNotBlank((CharSequence)measureNumber)) {
            selectFieldStr.append(',').append(measureNumber);
        }
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)anaModel.getString("tablenumber"));
        return BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectFieldStr.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)detailIds)}).values();
    }

    public static Object[] getDetailsBySummaryId(Long summaryId, Long modelId) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)anaModel.getString("tablenumber"));
        return QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("summaryid", "=", (Object)summaryId)}, null, (int)-1).toArray();
    }

    public static Collection<DynamicObject> getDetailsByExecLogId(Long modelId, Long parentId, Long subExecLogId, String measureNumber, DataStatusEnum dataStatusEnum, Long ... excludeIds) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (anaModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728,\u6a21\u578bid\u4e3a : %s", (String)"DataReviewHelper_4", (String)"fi-pa-business", (Object[])new Object[0]), modelId));
        }
        StringBuilder selectFieldStr = new StringBuilder();
        selectFieldStr.append("id").append(',');
        for (DynamicObject dimensionEntry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            String dimensionNumber = dimensionEntry.getDynamicObject("dimension").getString("number");
            selectFieldStr.append(dimensionNumber).append(',');
        }
        selectFieldStr.append("datastatus").append(',');
        selectFieldStr.append("createstamp").append(',');
        selectFieldStr.append("execlogid").append(',');
        selectFieldStr.append("subexeclogid").append(',');
        selectFieldStr.append("summaryid").append(',');
        selectFieldStr.append("execparentbillid");
        if (StringUtils.isNotBlank((CharSequence)measureNumber)) {
            selectFieldStr.append(',').append(measureNumber);
        }
        QFilter execLogIdFilter = new QFilter("subexeclogid", "=", (Object)subExecLogId);
        QFilter parentIdFilter = new QFilter("execparentbillid", "=", (Object)parentId);
        if (DataStatusEnum.ALLOCATE != dataStatusEnum && DataStatusEnum.DERIVE != dataStatusEnum && DataStatusEnum.ADJUST != dataStatusEnum) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u72b6\u6001\u7c7b\u578b\u4e0d\u652f\u6301\u7684\u6709\u8ffd\u6eaf\u64cd\u4f5c : %s", (String)"DataReviewHelper_1", (String)"fi-pa-business", (Object[])new Object[0]), dataStatusEnum.getCode()));
        }
        QFilter statusEnumFilter = new QFilter("datastatus", "=", (Object)dataStatusEnum.getCode());
        QFilter excludeIdsFilter = null;
        if (ArrayUtils.isNotEmpty((Object[])excludeIds)) {
            excludeIdsFilter = new QFilter("id", "not in", (Object)excludeIds);
        }
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)anaModel.getString("tablenumber"));
        return BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectFieldStr.toString(), (QFilter[])new QFilter[]{execLogIdFilter, parentIdFilter, statusEnumFilter, excludeIdsFilter}).values();
    }

    public static Long getRecentlyDetailCreateStampOfSummary(Long modelId, Long summaryId, String measureNumber) {
        List<DynamicObject> allOrderlyDetailsOfSummaryId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, summaryId, measureNumber);
        return allOrderlyDetailsOfSummaryId.stream().filter(DataReviewHelper::isBusinessDetail).findFirst().map(detail -> detail.getLong("createstamp")).orElse(-1L);
    }

    public static List<DynamicObject> getDetailsByDatestamp(List<DynamicObject> allOrderlyDetailsOfSummaryId, Long currentDetailDatestamp) {
        return allOrderlyDetailsOfSummaryId.stream().filter(DataReviewHelper::isBusinessDetail).filter(detail -> detail.getLong("createstamp") == currentDetailDatestamp.longValue()).collect(Collectors.toList());
    }

    public static List<DynamicObject> getDetailsOfLastStepSummary(List<DynamicObject> allOrderlyDetailsOfSummaryId, Long currentDetailDatestamp) {
        List sourceDetails = allOrderlyDetailsOfSummaryId.stream().filter(detail -> !DataReviewHelper.isBusinessDetail(detail)).collect(Collectors.toList());
        List sourceDetailIds = sourceDetails.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List notSourceDetailBeforeCurrentSummary = allOrderlyDetailsOfSummaryId.stream().filter(detail -> detail.getLong("createstamp") < currentDetailDatestamp).filter(detail -> !sourceDetailIds.contains(detail.getLong("id"))).collect(Collectors.toList());
        ArrayList<DynamicObject> remainDetails = new ArrayList<DynamicObject>();
        if (!CollectionUtils.isEmpty(notSourceDetailBeforeCurrentSummary)) {
            remainDetails.addAll(notSourceDetailBeforeCurrentSummary);
        }
        remainDetails.addAll(sourceDetails);
        return remainDetails;
    }

    public static List<DynamicObject> getDetailsOfNextStepSummary(List<DynamicObject> allOrderlyDetailsOfSummaryId, Long currentDetailDatestamp) {
        return allOrderlyDetailsOfSummaryId.stream().filter(detail -> detail.getLong("createstamp") > currentDetailDatestamp).filter(DataReviewHelper::isBusinessDetail).collect(Collectors.toList());
    }

    private static boolean isBusinessDetail(DynamicObject detail) {
        boolean isImportDetail = !"".equals(detail.getString("importbatch"));
        boolean isSourceDetail = DataStatusEnum.SOURCE == DataStatusEnum.getEnumByCode((byte)((byte)detail.getInt("datastatus")));
        return !isSourceDetail && !isImportDetail;
    }

    public static Map<DimensionNecessityEnum, DynamicObject> getDimensionNecessityMap(DynamicObject model) {
        HashMap<DimensionNecessityEnum, DynamicObject> dimensionNecessityEnumDyMap = new HashMap<DimensionNecessityEnum, DynamicObject>(3);
        DynamicObjectCollection dimension_entry = model.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dynamicObject : dimension_entry) {
            DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
            DimensionNecessityEnum anEnum = DimensionNecessityEnum.getEnum((String)dynamicObject.getString("necessity_dim"));
            if (anEnum == null) continue;
            dimensionNecessityEnumDyMap.put(anEnum, dimension);
        }
        return dimensionNecessityEnumDyMap;
    }

    public static PADerivationRuleInfoDTO getDerivationRuleInfoByExeLogId(Long ruleExecLogId) {
        PADerivationRuleInfoDTO paDerivationRuleInfoDTO = new PADerivationRuleInfoDTO();
        DynamicObject ruleExecLog = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleExecLogId, (String)"pa_ruleexeclog");
        Tuple<Long, String> businessRuleIdAndName = DataReviewHelper.getBusinessRuleIdAndName(ruleExecLog.getLong("rule_pk"), ruleExecLog.getString("rule_type"));
        paDerivationRuleInfoDTO.setBusinessRuleId((Long)businessRuleIdAndName.item1);
        paDerivationRuleInfoDTO.setBusinessRuleName((String)businessRuleIdAndName.item2);
        DynamicObject derivationStep = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleExecLog.getLong("rule_pk"), (String)"pa_derivationrule");
        DerivationTypeEnum derivationModeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)derivationStep.getString("derivationmode"));
        paDerivationRuleInfoDTO.setDerivationModeEnum(derivationModeEnum);
        switch (derivationModeEnum) {
            case DERIVATION_MAPPING_TABLE: {
                DynamicObject baseDataObject = BusinessDataServiceHelper.loadSingleFromCache((Object)derivationStep.getString("mappingmaptype"), (String)"bos_entityobject");
                paDerivationRuleInfoDTO.setSourceBaseData(baseDataObject);
                List<DynamicObject> mtSourceDimensions = DataReviewHelper.getDimensionListOfDerivationStep(derivationStep, "mt_source_entryentity", "mt_source");
                paDerivationRuleInfoDTO.setSourceDimensionList(mtSourceDimensions);
                List<DynamicObject> mtTargetDimensions = DataReviewHelper.getDimensionListOfDerivationStep(derivationStep, "mt_target_entryentity", "mt_target");
                paDerivationRuleInfoDTO.setTargetDimensionList(mtTargetDimensions);
                break;
            }
            case DERIVATION_MAPPING_RELATIONSHIP: {
                paDerivationRuleInfoDTO.setMappingRelationship(derivationStep.getDynamicObject("mappingrelationship"));
                List<DynamicObject> sourceFieldDimensions = DataReviewHelper.getDimensionListOfDerivationStep(derivationStep, "source_entryentity", "sourcefield");
                paDerivationRuleInfoDTO.setSourceDimensionList(sourceFieldDimensions);
                List<DynamicObject> targetFieldDimensions = DataReviewHelper.getDimensionListOfDerivationStep(derivationStep, "target_entryentity", "targetfield");
                paDerivationRuleInfoDTO.setTargetDimensionList(targetFieldDimensions);
                break;
            }
            case DERIVATION_CUSTOM: {
                List<DynamicObject> cusSourceFieldDimensions = DataReviewHelper.getDimensionListOfDerivationStep(derivationStep, "custom_entryentity", "sourcedim");
                paDerivationRuleInfoDTO.setSourceDimensionList(cusSourceFieldDimensions);
                List<DynamicObject> cusTargetFieldDimensions = DataReviewHelper.getDimensionListOfDerivationStep(derivationStep, "custom_entryentity", "targetdim");
                paDerivationRuleInfoDTO.setTargetDimensionList(cusTargetFieldDimensions);
            }
        }
        return paDerivationRuleInfoDTO;
    }

    private static List<DynamicObject> getDimensionListOfDerivationStep(DynamicObject derivationStep, String entryEntityNumber, String dimFieldNumber) {
        Object[] cusTargetDimensionIds = derivationStep.getDynamicObjectCollection(entryEntityNumber).stream().map(entry -> {
            DynamicObject targetDim = entry.getDynamicObject(dimFieldNumber);
            if (targetDim == null) {
                return 0L;
            }
            return targetDim.getLong("id");
        }).toArray();
        Map cusTargetFieldDimensionsMap = PADimensionHelper.loadDimensionFromCache((Object[])cusTargetDimensionIds);
        return Stream.of(cusTargetDimensionIds).filter(cusTargetFieldDimensionsMap::containsKey).map(cusTargetFieldDimensionsMap::get).collect(Collectors.toList());
    }

    public static PAShareRuleInfoDTO getShareRuleInfoByExeLogId(Long ruleExecLogId) {
        PAShareRuleInfoDTO paShareRuleInfoDTO = new PAShareRuleInfoDTO();
        DynamicObject ruleExecLog = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleExecLogId, (String)"pa_ruleexeclog");
        Tuple<Long, String> businessRuleIdAndName = DataReviewHelper.getBusinessRuleIdAndName(ruleExecLog.getLong("rule_pk"), ruleExecLog.getString("rule_type"));
        paShareRuleInfoDTO.setBusinessRuleId((Long)businessRuleIdAndName.item1);
        paShareRuleInfoDTO.setBusinessRuleName((String)businessRuleIdAndName.item2);
        DynamicObject shareStep = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleExecLog.getLong("rule_pk"), (String)"pa_sharerulenew");
        ShareTypeEnum shareTypeEnum = ShareTypeEnum.getShareTypeEnum((String)shareStep.getString("receiverule"));
        paShareRuleInfoDTO.setShareTypeEnum(shareTypeEnum);
        switch (shareTypeEnum) {
            case SHARE_FACTOR: {
                paShareRuleInfoDTO.setShareFactor(shareStep.getDynamicObject("sharefactor"));
                List<Map<String, Object>> receiveDimensionRatioMap = shareStep.getDynamicObjectCollection("savesubflexdata").stream().map(entry -> (LinkedHashMap)JSON.parseObject((String)entry.getString("subvalue_tag"), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0])).collect(Collectors.toList());
                paShareRuleInfoDTO.setReceiveDimensionRatioMap(receiveDimensionRatioMap);
                break;
            }
            case SHARE_SUBJECT: {
                paShareRuleInfoDTO.setMeasure(shareStep.getDynamicObject("measure"));
                break;
            }
            case SHARE_FIXED: {
                List<Map<String, Object>> receiveDimensionRatioMap = shareStep.getDynamicObjectCollection("savesubflexdata").stream().map(entry -> (LinkedHashMap)JSON.parseObject((String)entry.getString("subvalue_tag"), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0])).collect(Collectors.toList());
                paShareRuleInfoDTO.setReceiveDimensionRatioMap(receiveDimensionRatioMap);
            }
        }
        List<ThreeTuple<DynamicObject, String, String>> sendDimensionConditions = shareStep.getDynamicObjectCollection("sendentryentity").stream().map(entry -> new ThreeTuple((Object)entry.getDynamicObject("senddimension"), (Object)entry.getString("combofield"), (Object)entry.getString("dimensionvalue"))).collect(Collectors.toList());
        paShareRuleInfoDTO.setSendDimensionInfos(sendDimensionConditions);
        List<ThreeTuple<DynamicObject, String, String>> receiveDimensionConditions = shareStep.getDynamicObjectCollection("receiveentryentity").stream().map(entry -> new ThreeTuple((Object)entry.getDynamicObject("receivedimension"), (Object)entry.getString("comboreceive"), (Object)entry.getString("receivedimvalue"))).collect(Collectors.toList());
        paShareRuleInfoDTO.setReceiveDimensionInfos(receiveDimensionConditions);
        return paShareRuleInfoDTO;
    }

    private static Tuple<Long, String> getBusinessRuleIdAndName(Long businessRuleStepPkId, String ruleStepType) {
        QFilter qfilter;
        DataReviewRuleTypeEnum dataReviewRuleTypeEnum = DataReviewRuleTypeEnum.getEnumByCode((String)ruleStepType);
        switch (dataReviewRuleTypeEnum) {
            case DERIVATION: {
                qfilter = new QFilter("stepentry.cardderivationmodel.id", "=", (Object)businessRuleStepPkId);
                break;
            }
            case SHARE: {
                qfilter = new QFilter("stepentry.cardsharemodel.id", "=", (Object)businessRuleStepPkId);
                break;
            }
            default: {
                throw new KDBizException("error DataReviewRuleTypeEnum");
            }
        }
        DynamicObject businessRule = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_businessrule", (QFilter[])qfilter.toArray());
        return new Tuple((Object)businessRule.getLong("id"), (Object)businessRule.getString("name"));
    }

    public static String translateDataValueToDimensionValue(DynamicObject dimension, DynamicObject modelData) {
        String dimensionNumber = dimension.getString("number");
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
        switch (dimensionTypeEnum) {
            case DATABASE: {
                String baseDataSourceNumber = dimension.getDynamicObject("dimensionsource").getString("number");
                DynamicObject baseData = modelData.getDynamicObject(dimensionNumber);
                if ("bd_accountview".equals(baseDataSourceNumber)) {
                    return baseData == null ? "" : baseData.getString("fullname");
                }
                return baseData == null ? "" : baseData.getString("name");
            }
            case ASSISTANTDATA: {
                DynamicObject assistantData = modelData.getDynamicObject(dimensionNumber);
                return assistantData == null ? "" : assistantData.getString("name");
            }
            case DATE: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = modelData.getDate(dimensionNumber);
                return date == null ? "" : simpleDateFormat.format(modelData.getDate(dimensionNumber));
            }
            case DENUMS: {
                String enumValue = modelData.getString(dimensionNumber);
                DynamicObjectCollection entryEntityEnums = dimension.getDynamicObjectCollection("entryentityenums");
                return entryEntityEnums.stream().filter(entry -> entry.getString("value").equals(enumValue)).map(entry -> entry.getString("title")).findFirst().orElse("");
            }
        }
        return modelData.getString(dimensionNumber);
    }
}

