/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.review;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.enums.DataReviewBusinessTypeEnum;
import kd.fi.pa.enums.DataReviewNodeTypeEnum;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.helper.PAMeasureHelper;
import kd.fi.pa.review.DataReviewHelper;
import kd.fi.pa.review.dto.PADerivationRuleInfoDTO;
import kd.fi.pa.review.dto.PAShareRuleInfoDTO;
import kd.fi.pa.review.model.ApportionInfo;
import kd.fi.pa.review.model.MoreNode;
import kd.fi.pa.review.model.Node;
import kd.fi.pa.review.model.NodeDataInfo;
import kd.fi.pa.review.model.NodeEdge;
import kd.fi.pa.review.model.NodeRuleInfo;
import kd.fi.pa.review.model.SourceMoreNode;
import kd.fi.pa.review.model.TargetMoreNode;
import kd.fi.pa.review.model.TraceModel;

public class PADataReviewBuilder {
    private static final Log logger = LogFactory.getLog(PADataReviewBuilder.class);

    private PADataReviewBuilder() {
    }

    public static String init(Long modelId, Long summaryId, String measureNumber) {
        Long recentlyDetailCreateStampOfSummary = DataReviewHelper.getRecentlyDetailCreateStampOfSummary(modelId, summaryId, measureNumber);
        Node node = PADataReviewBuilder.createNode(modelId, summaryId, measureNumber, recentlyDetailCreateStampOfSummary, DataReviewBusinessTypeEnum.SUMMARY);
        node.setMain(true);
        TraceModel traceModel = new TraceModel();
        traceModel.addNode(node);
        PADataReviewBuilder.leftTrace(traceModel, node);
        return traceModel.toData();
    }

    public static String leftTrace(Node node) {
        TraceModel traceModel = new TraceModel();
        PADataReviewBuilder.leftTrace(traceModel, node);
        logger.info("build ratio data" + traceModel.toData());
        return traceModel.toData();
    }

    private static void leftTrace(TraceModel traceModel, Node node) {
        boolean valid = PADataReviewBuilder.validationLeftTraceOfNode(node);
        if (valid) {
            Long currentDetailDatestamp;
            List<DynamicObject> lastStepDetails;
            String measureNumber;
            Long summaryId = Long.parseLong(node.getDataId());
            Long modelId = Long.parseLong(node.getModelId());
            List<DynamicObject> allOrderlyDetailsOfSummaryId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, summaryId, measureNumber = node.getData().getMeasureNumber());
            if (!CollectionUtils.isEmpty(allOrderlyDetailsOfSummaryId) && !CollectionUtils.isEmpty(lastStepDetails = DataReviewHelper.getDetailsByDatestamp(allOrderlyDetailsOfSummaryId, currentDetailDatestamp = Long.valueOf(Long.parseLong(node.getDetailDatestamp()))))) {
                List<DynamicObject> detailsOfLastSummary = DataReviewHelper.getDetailsOfLastStepSummary(allOrderlyDetailsOfSummaryId, lastStepDetails.get(0).getLong("createstamp"));
                PADataReviewBuilder.buildLeftTraceDetailNode(traceModel, node, lastStepDetails);
                PADataReviewBuilder.buildLeftTraceSummaryNode(traceModel, node, detailsOfLastSummary);
            }
        }
    }

    private static void buildLeftTraceDetailNode(TraceModel traceModel, Node node, List<DynamicObject> lastStepDetails) {
        Long modelId = Long.parseLong(node.getModelId());
        String measureNumber = node.getData().getMeasureNumber();
        Long currentDetailDatestamp = Long.parseLong(node.getDetailDatestamp());
        block4: for (DynamicObject lastStepDetail : lastStepDetails) {
            DataStatusEnum dataStatusEnum = DataStatusEnum.getEnumByCode((byte)((byte)lastStepDetail.getInt("datastatus")));
            switch (dataStatusEnum) {
                case DERIVE: {
                    PADataReviewBuilder.leftTraceDeriveNode(traceModel, node, modelId, measureNumber, currentDetailDatestamp, lastStepDetail);
                    continue block4;
                }
                case ALLOCATE: {
                    PADataReviewBuilder.leftTraceAllocateNode(traceModel, node, modelId, measureNumber, currentDetailDatestamp, lastStepDetail);
                    continue block4;
                }
            }
            Node detailNode = PADataReviewBuilder.createNode(modelId, lastStepDetail.getLong("id"), measureNumber, currentDetailDatestamp, DataReviewBusinessTypeEnum.DETAIL);
            traceModel.addNode(detailNode);
            traceModel.addEdge(new NodeEdge(detailNode.getId(), node.getId()));
        }
    }

    private static void leftTraceDeriveNode(TraceModel traceModel, Node node, Long modelId, String measureNumber, Long currentDetailDatestamp, DynamicObject lastStepDetail) {
        List<DynamicObject> detailsOfParentDeriveSummary;
        Node deriveDetailNode = PADataReviewBuilder.createNode(modelId, lastStepDetail.getLong("id"), measureNumber, currentDetailDatestamp, DataReviewBusinessTypeEnum.DERIVATION_DETAIL);
        traceModel.addNode(deriveDetailNode);
        traceModel.addEdge(new NodeEdge(deriveDetailNode.getId(), node.getId()));
        long parentIdOfDeriveDetail = lastStepDetail.getLong("execparentbillid");
        long subExecLogIdOfDerive = lastStepDetail.getLong("subexeclogid");
        List<DynamicObject> allOrderlyDetailsOfDeriveParentId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, parentIdOfDeriveDetail, measureNumber);
        DynamicObject offDeriveDetail = allOrderlyDetailsOfDeriveParentId.stream().filter(detail -> subExecLogIdOfDerive == detail.getLong("subexeclogid") && DataStatusEnum.OFF_DERIVE == DataStatusEnum.getEnumByCode((byte)Byte.parseByte(detail.getString("datastatus")))).findFirst().orElse(null);
        if (offDeriveDetail != null && !CollectionUtils.isEmpty(detailsOfParentDeriveSummary = DataReviewHelper.getDetailsOfLastStepSummary(allOrderlyDetailsOfDeriveParentId, offDeriveDetail.getLong("createstamp")))) {
            boolean existSourceMoreNode = PADataReviewBuilder.isExistSourceMoreNode(detailsOfParentDeriveSummary);
            if (existSourceMoreNode) {
                Node deriveSummaryNode = PADataReviewBuilder.createNode(modelId, parentIdOfDeriveDetail, measureNumber, detailsOfParentDeriveSummary.get(0).getLong("createstamp"), DataReviewBusinessTypeEnum.DERIVATION_SUMMARY);
                traceModel.addNode(deriveSummaryNode);
                traceModel.addEdge(new NodeEdge(deriveSummaryNode.getId(), deriveDetailNode.getId()));
                SourceMoreNode deriveSourceMoreNode = PADataReviewBuilder.createSourceMoreNode("+");
                traceModel.addNode(deriveSourceMoreNode);
                traceModel.addEdge(new NodeEdge(deriveSourceMoreNode.getId(), deriveSummaryNode.getId()));
            } else {
                Node deriveSummaryNode = PADataReviewBuilder.createNode(modelId, parentIdOfDeriveDetail, measureNumber, -1L, DataReviewBusinessTypeEnum.DERIVATION_SUMMARY);
                traceModel.addNode(deriveSummaryNode);
                traceModel.addEdge(new NodeEdge(deriveSummaryNode.getId(), deriveDetailNode.getId()));
            }
        }
    }

    private static void leftTraceAllocateNode(TraceModel traceModel, Node node, Long modelId, String measureNumber, Long currentDetailDatestamp, DynamicObject lastStepDetail) {
        List<DynamicObject> detailsOfParentShareSummary;
        Node allocateDetailNode = PADataReviewBuilder.createNode(modelId, lastStepDetail.getLong("id"), measureNumber, currentDetailDatestamp, DataReviewBusinessTypeEnum.SHARE_DETAIL);
        traceModel.addNode(allocateDetailNode);
        traceModel.addEdge(new NodeEdge(allocateDetailNode.getId(), node.getId()));
        long parentIdOfShareDetail = lastStepDetail.getLong("execparentbillid");
        long subExecLogIdOfShare = lastStepDetail.getLong("subexeclogid");
        List<DynamicObject> allOrderlyDetailsOfShareParentId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, parentIdOfShareDetail, measureNumber);
        DynamicObject offShareDetail = allOrderlyDetailsOfShareParentId.stream().filter(detail -> subExecLogIdOfShare == detail.getLong("subexeclogid") && DataStatusEnum.OFF_ALLOCATE == DataStatusEnum.getEnumByCode((byte)Byte.parseByte(detail.getString("datastatus")))).findFirst().orElse(null);
        if (offShareDetail != null && !CollectionUtils.isEmpty(detailsOfParentShareSummary = DataReviewHelper.getDetailsOfLastStepSummary(allOrderlyDetailsOfShareParentId, offShareDetail.getLong("createstamp")))) {
            Node shareSummaryNode;
            boolean existSourceMoreNode = PADataReviewBuilder.isExistSourceMoreNode(detailsOfParentShareSummary);
            if (existSourceMoreNode) {
                shareSummaryNode = PADataReviewBuilder.createNode(modelId, parentIdOfShareDetail, measureNumber, detailsOfParentShareSummary.get(0).getLong("createstamp"), DataReviewBusinessTypeEnum.SHARE_SUMMARY);
                shareSummaryNode.getData().setTrunkDetailNodeId(allocateDetailNode.getId());
                shareSummaryNode.getData().setTrunkDetailDataId(allocateDetailNode.getDataId());
                traceModel.addNode(shareSummaryNode);
                traceModel.addEdge(new NodeEdge(shareSummaryNode.getId(), allocateDetailNode.getId()));
                SourceMoreNode shareSourceMoreNode = PADataReviewBuilder.createSourceMoreNode("+");
                traceModel.addNode(shareSourceMoreNode);
                traceModel.addEdge(new NodeEdge(shareSourceMoreNode.getId(), shareSummaryNode.getId()));
            } else {
                shareSummaryNode = PADataReviewBuilder.createNode(modelId, parentIdOfShareDetail, measureNumber, -1L, DataReviewBusinessTypeEnum.SHARE_SUMMARY);
                shareSummaryNode.getData().setTrunkDetailNodeId(allocateDetailNode.getId());
                shareSummaryNode.getData().setTrunkDetailDataId(allocateDetailNode.getDataId());
                traceModel.addNode(shareSummaryNode);
                traceModel.addEdge(new NodeEdge(shareSummaryNode.getId(), allocateDetailNode.getId()));
            }
            Collection<DynamicObject> otherShareDetailsByExecLogId = DataReviewHelper.getDetailsByExecLogId(modelId, offShareDetail.getLong("execparentbillid"), offShareDetail.getLong("subexeclogid"), measureNumber, DataStatusEnum.ALLOCATE, lastStepDetail.getLong("id"));
            if (otherShareDetailsByExecLogId.size() <= 2) {
                for (DynamicObject shareDetail : otherShareDetailsByExecLogId) {
                    Node otherShareDetailNode = PADataReviewBuilder.createNode(modelId, shareDetail.getLong("id"), measureNumber, shareDetail.getLong("createstamp"), DataReviewBusinessTypeEnum.SHARE_DETAIL);
                    traceModel.addNode(otherShareDetailNode);
                    traceModel.addEdge(new NodeEdge(shareSummaryNode.getId(), otherShareDetailNode.getId()));
                    boolean isExistTargetMoreNode = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, shareDetail.getLong("summaryid"), measureNumber).size() > 1;
                    if (!isExistTargetMoreNode) continue;
                    TargetMoreNode shareDetailTargetMoreNode = PADataReviewBuilder.createTargetMoreNode("+");
                    traceModel.addNode(shareDetailTargetMoreNode);
                    traceModel.addEdge(new NodeEdge(otherShareDetailNode.getId(), shareDetailTargetMoreNode.getId()));
                }
            } else {
                BigDecimal percentage;
                BigDecimal otherTotalMeasureValue = otherShareDetailsByExecLogId.stream().map(detail -> {
                    BigDecimal detailMeasureValue = detail.getBigDecimal(measureNumber);
                    return detailMeasureValue != null ? detailMeasureValue : BigDecimal.ZERO;
                }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (otherTotalMeasureValue.compareTo(BigDecimal.ZERO) == 0) {
                    percentage = BigDecimal.ZERO;
                } else {
                    BigDecimal lastStepDetailValue = lastStepDetail.getBigDecimal(measureNumber) != null ? lastStepDetail.getBigDecimal(measureNumber) : BigDecimal.ZERO;
                    BigDecimal sum = lastStepDetailValue.add(otherTotalMeasureValue);
                    percentage = sum.compareTo(BigDecimal.ZERO) != 0 ? otherTotalMeasureValue.multiply(new BigDecimal("100")).divide(sum, 2, 4) : new BigDecimal("100");
                }
                List<Long> detailIds = otherShareDetailsByExecLogId.stream().map(detail -> detail.getLong("id")).collect(Collectors.toList());
                MoreNode moreNode = PADataReviewBuilder.createMoreNode(String.format(ResManager.loadKDString((String)"%s\u4e2a\u5206\u644a", (String)"PADataReviewBuilder_3", (String)"fi-pa-business", (Object[])new Object[0]), detailIds.size()), percentage.toString() + "%", detailIds);
                traceModel.addNode(moreNode);
                traceModel.addEdge(new NodeEdge(shareSummaryNode.getId(), moreNode.getId()));
            }
        }
    }

    private static void buildLeftTraceSummaryNode(TraceModel traceModel, Node node, List<DynamicObject> detailsOfLastSummary) {
        Long summaryId = Long.parseLong(node.getDataId());
        Long modelId = Long.parseLong(node.getModelId());
        String measureNumber = node.getData().getMeasureNumber();
        if (!CollectionUtils.isEmpty(detailsOfLastSummary)) {
            boolean existSourceMoreNode = PADataReviewBuilder.isExistSourceMoreNode(detailsOfLastSummary);
            if (existSourceMoreNode) {
                Node lastSummaryNode = PADataReviewBuilder.createNode(modelId, summaryId, measureNumber, detailsOfLastSummary.get(0).getLong("createstamp"), DataReviewBusinessTypeEnum.SUMMARY);
                traceModel.addNode(lastSummaryNode);
                traceModel.addEdge(new NodeEdge(lastSummaryNode.getId(), node.getId()));
                SourceMoreNode summarySourceMoreNode = PADataReviewBuilder.createSourceMoreNode("+");
                traceModel.addNode(summarySourceMoreNode);
                traceModel.addEdge(new NodeEdge(summarySourceMoreNode.getId(), lastSummaryNode.getId()));
            } else {
                Node lastSummaryNode = PADataReviewBuilder.createNode(modelId, summaryId, measureNumber, -1L, DataReviewBusinessTypeEnum.SUMMARY);
                traceModel.addNode(lastSummaryNode);
                traceModel.addEdge(new NodeEdge(lastSummaryNode.getId(), node.getId()));
            }
        }
    }

    private static boolean isExistSourceMoreNode(List<DynamicObject> detailsOfLastStepSummary) {
        return detailsOfLastStepSummary.stream().anyMatch(detail -> {
            boolean isImportDetail = !"".equals(detail.getString("importbatch"));
            boolean isSourceDetail = DataStatusEnum.SOURCE == DataStatusEnum.getEnumByCode((byte)((byte)detail.getInt("datastatus")));
            return !isSourceDetail && !isImportDetail;
        });
    }

    private static SourceMoreNode createSourceMoreNode(String label) {
        SourceMoreNode sourceMoreNode = new SourceMoreNode();
        sourceMoreNode.setId(String.valueOf(DB.genGlobalLongId()));
        sourceMoreNode.setLabel(label);
        return sourceMoreNode;
    }

    private static TargetMoreNode createTargetMoreNode(String label) {
        TargetMoreNode targetMoreNode = new TargetMoreNode();
        targetMoreNode.setId(String.valueOf(DB.genGlobalLongId()));
        targetMoreNode.setLabel(label);
        return targetMoreNode;
    }

    private static MoreNode createMoreNode(String label, String percentage, List<Long> dataIds) {
        MoreNode moreNode = new MoreNode();
        moreNode.setId(String.valueOf(DB.genGlobalLongId()));
        moreNode.setLabel(label);
        moreNode.setDataIds(dataIds);
        moreNode.setPercentage(percentage);
        return moreNode;
    }

    private static Node createNode(Long modelId, Long dataId, String measureNumber, Long datestamp, DataReviewBusinessTypeEnum businessTypeEnum) {
        Node node = new Node();
        node.setId(String.valueOf(DB.genGlobalLongId()));
        node.setModelId(String.valueOf(modelId));
        node.setDataId(String.valueOf(dataId));
        node.setDetailDatestamp(String.valueOf(datestamp));
        node.setData(PADataReviewBuilder.createNodeDataInfo(modelId, dataId, datestamp, measureNumber, businessTypeEnum));
        logger.info("build ratio node" + node.toString());
        return node;
    }

    private static String getSubExecLogId(Long modelId, Long dataId, String measureNumber, Long datestamp, DataReviewBusinessTypeEnum businessTypeEnum) {
        List<DynamicObject> allOrderlyDetailsOfDeriveParentId;
        List offDetails;
        if (!(businessTypeEnum != DataReviewBusinessTypeEnum.DERIVATION_SUMMARY && businessTypeEnum != DataReviewBusinessTypeEnum.SHARE_SUMMARY || CollectionUtils.isEmpty(offDetails = DataReviewHelper.getDetailsOfNextStepSummary(allOrderlyDetailsOfDeriveParentId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, dataId, measureNumber), datestamp).stream().filter(detail -> DataStatusEnum.OFF_ALLOCATE == DataStatusEnum.getEnumByCode((byte)Byte.parseByte(detail.getString("datastatus"))) || DataStatusEnum.OFF_DERIVE == DataStatusEnum.getEnumByCode((byte)Byte.parseByte(detail.getString("datastatus")))).collect(Collectors.toList())))) {
            return ((DynamicObject)offDetails.get(offDetails.size() - 1)).getString("subexeclogid");
        }
        return "";
    }

    private static List<NodeRuleInfo> createNodeRulesInfo(Long modelId, Long dataId, Long datestamp, String measureNumber, DataReviewBusinessTypeEnum businessTypeEnum) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (anaModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728,\u6a21\u578bid\u4e3a : %s", (String)"PADataReviewBuilder_10", (String)"fi-pa-business", (Object[])new Object[0]), modelId));
        }
        ArrayList<NodeRuleInfo> nodeRuleInfos = new ArrayList<NodeRuleInfo>(1);
        List<DynamicObject> allOrderlyDetailsOfSummaryId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, dataId, measureNumber);
        List<DynamicObject> detailsOfNextStepSummary = DataReviewHelper.getDetailsOfNextStepSummary(allOrderlyDetailsOfSummaryId, datestamp);
        if (!CollectionUtils.isEmpty(detailsOfNextStepSummary)) {
            DynamicObject detailOfNextStep = detailsOfNextStepSummary.get(detailsOfNextStepSummary.size() - 1);
            long subExecLogId = detailOfNextStep.getLong("subexeclogid");
            switch (businessTypeEnum) {
                case DERIVATION_SUMMARY: {
                    PADerivationRuleInfoDTO derivationRuleInfoDTO = DataReviewHelper.getDerivationRuleInfoByExeLogId(subExecLogId);
                    DerivationTypeEnum derivationModeEnum = derivationRuleInfoDTO.getDerivationModeEnum();
                    LocaleString derivationTypeName = ((ComboProp)EntityMetadataCache.getDataEntityType((String)"pa_derivationrule").getProperty("derivationmode")).getComboItems().stream().filter(item -> derivationModeEnum.getType().equals(item.getValue())).map(ValueMapItem::getName).findFirst().orElse(null);
                    String derivationTitle = derivationTypeName == null ? "" : derivationTypeName.toString();
                    String derivationDetailBuilder = PADataReviewBuilder.joinDimensionNameListByComma(derivationRuleInfoDTO.getSourceDimensionList()) + " \u2192 " + PADataReviewBuilder.joinDimensionNameListByComma(derivationRuleInfoDTO.getTargetDimensionList());
                    nodeRuleInfos.add(new NodeRuleInfo(derivationTitle, derivationDetailBuilder));
                    break;
                }
                case SHARE_SUMMARY: {
                    PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId(subExecLogId);
                    ShareTypeEnum shareTypeEnum = shareRuleInfoDTO.getShareTypeEnum();
                    LocaleString shareTypeName = ((ComboProp)EntityMetadataCache.getDataEntityType((String)"pa_sharerulenew").getProperty("receiverule")).getComboItems().stream().filter(item -> shareTypeEnum.getType().equals(item.getValue())).map(ValueMapItem::getName).findFirst().orElse(null);
                    String shareTitle = shareTypeName == null ? "" : shareTypeName.toString();
                    List receiveDimensions = shareRuleInfoDTO.getReceiveDimensionInfos().stream().map(t -> (DynamicObject)t.item1).collect(Collectors.toList());
                    nodeRuleInfos.add(new NodeRuleInfo(shareTitle, String.format(ResManager.loadKDString((String)"\u6309%s\u63a5\u6536", (String)"PADataReviewBuilder_11", (String)"fi-pa-business", (Object[])new Object[0]), PADataReviewBuilder.joinDimensionNameListByComma(new ArrayList<DynamicObject>(receiveDimensions)))));
                }
            }
        }
        return nodeRuleInfos;
    }

    private static NodeDataInfo createNodeDataInfo(Long modelId, Long dataId, Long datestamp, String measureNumber, DataReviewBusinessTypeEnum businessTypeEnum) {
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (anaModel == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728,\u6a21\u578bid\u4e3a : %s", (String)"PADataReviewBuilder_10", (String)"fi-pa-business", (Object[])new Object[0]), modelId));
        }
        NodeDataInfo nodeDataInfo = null;
        switch (businessTypeEnum) {
            case DERIVATION_SUMMARY: 
            case SHARE_SUMMARY: 
            case SUMMARY: {
                nodeDataInfo = PADataReviewBuilder.createDataInfoOfSummaryNode(anaModel, dataId, datestamp, measureNumber, businessTypeEnum);
                break;
            }
            case DETAIL: 
            case SHARE_DETAIL: 
            case DERIVATION_DETAIL: {
                nodeDataInfo = PADataReviewBuilder.createDataInfoOfDetailNode(anaModel, dataId, measureNumber, businessTypeEnum);
            }
        }
        return nodeDataInfo;
    }

    private static NodeDataInfo createDataInfoOfDetailNode(DynamicObject anaModel, Long dataId, String measureNumber, DataReviewBusinessTypeEnum businessTypeEnum) {
        DynamicObject modelData = DataReviewHelper.getDetailById(anaModel.getLong("id"), dataId, measureNumber);
        int measureScale = PAMeasureHelper.getMeasureScale((Long)anaModel.getDynamicObject("analysis_system").getLong("id"), (String)measureNumber);
        BigDecimal measureValue = (modelData.getBigDecimal(measureNumber) != null ? modelData.getBigDecimal(measureNumber) : BigDecimal.ZERO).setScale(measureScale, 4);
        NodeDataInfo nodeDataInfo = new NodeDataInfo();
        nodeDataInfo.setMeasureNumber(measureNumber);
        String measureName = anaModel.getDynamicObjectCollection("measure_entry").stream().map(entry -> entry.getDynamicObject("measure")).filter(measure -> measureNumber.equals(measure.getString("number"))).map(measure -> measure.getString("name")).findFirst().orElse("");
        nodeDataInfo.setMeasureName(measureName);
        nodeDataInfo.setMeasureValue(measureValue.toString());
        nodeDataInfo.setTypeValue(businessTypeEnum.getCode());
        nodeDataInfo.setType(ResManager.loadKDString((String)"\u660e\u7ec6", (String)"PADataReviewBuilder_1", (String)"fi-pa-business", (Object[])new Object[0]));
        Map<DimensionNecessityEnum, DynamicObject> dimensionNecessityMap = DataReviewHelper.getDimensionNecessityMap(anaModel);
        String orgDimensionNumber = dimensionNecessityMap.get(DimensionNecessityEnum.ORG).getString("number");
        nodeDataInfo.setOrg(modelData.getDynamicObject(orgDimensionNumber).getString("name"));
        DynamicObject accountDimension = dimensionNecessityMap.get(DimensionNecessityEnum.ACCOUNT);
        if (accountDimension != null) {
            String accountDimensionNumber = accountDimension.getString("number");
            String accountDimensionSourceNumber = accountDimension.getString("dimensionsource.number");
            DynamicObject accountDy = modelData.getDynamicObject(accountDimensionNumber);
            if ("bd_accountview".equals(accountDimensionSourceNumber)) {
                nodeDataInfo.setAccount(accountDy == null ? "" : accountDy.getString("fullname"));
            } else {
                nodeDataInfo.setAccount(accountDy == null ? "" : accountDy.getString("name"));
            }
        }
        switch (businessTypeEnum) {
            case DERIVATION_DETAIL: {
                long subExecLogId = modelData.getLong("subexeclogid");
                PADerivationRuleInfoDTO derivationRuleInfoDTO = DataReviewHelper.getDerivationRuleInfoByExeLogId(subExecLogId);
                DynamicObject firstTargetDimensionButOrg = derivationRuleInfoDTO.getTargetDimensionList().stream().filter(dimension -> !orgDimensionNumber.equals(dimension.getString("number"))).findFirst().orElse(null);
                String derivationApportionDimension = "";
                if (firstTargetDimensionButOrg != null) {
                    String firstTargetDimensionName = firstTargetDimensionButOrg.getString("name");
                    String firstTargetDimensionValue = DataReviewHelper.translateDataValueToDimensionValue(firstTargetDimensionButOrg, modelData);
                    derivationApportionDimension = String.format("%1$s\uff1a%2$s", firstTargetDimensionName, firstTargetDimensionValue);
                }
                ApportionInfo apportionInfo = new ApportionInfo(derivationApportionDimension, "");
                nodeDataInfo.setApportion(apportionInfo);
                break;
            }
            case SHARE_DETAIL: {
                long subExecLogId = modelData.getLong("subexeclogid");
                PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId(subExecLogId);
                List receiveDimensions = shareRuleInfoDTO.getReceiveDimensionInfos().stream().map(t -> (DynamicObject)t.item1).collect(Collectors.toList());
                DynamicObject firstReceiveDimensionButOrg = receiveDimensions.stream().filter(dimension -> !orgDimensionNumber.equals(dimension.getString("number"))).findFirst().orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u63a8\u5bfc\u4e1a\u52a1\u6d41\u7a0b\u4e0d\u5b58\u5728\u975e\u7ec4\u7ec7\u5916\u7684\u6e90\u7ef4\u5ea6,\u6a21\u578bid:%1$s,\u6570\u636eid:%2$s", (String)"PADataReviewBuilder_12", (String)"fi-pa-business", (Object[])new Object[0]), anaModel.getLong("id"), dataId)));
                String firstReceiveDimensionName = firstReceiveDimensionButOrg.getString("name");
                String firstReceiveDimensionValue = DataReviewHelper.translateDataValueToDimensionValue(firstReceiveDimensionButOrg, modelData);
                ApportionInfo apportionInfo = new ApportionInfo(String.format("%1$s\uff1a%2$s", firstReceiveDimensionName, firstReceiveDimensionValue), PADataReviewBuilder.getRatioValue(anaModel.getLong("id"), modelData, measureNumber));
                nodeDataInfo.setApportion(apportionInfo);
                break;
            }
        }
        return nodeDataInfo;
    }

    private static NodeDataInfo createDataInfoOfSummaryNode(DynamicObject anaModel, Long dataId, Long datestamp, String measureNumber, DataReviewBusinessTypeEnum businessTypeEnum) {
        List<DynamicObject> allOrderlyDetailsOfSummaryId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(anaModel.getLong("id"), dataId, measureNumber);
        List<DynamicObject> detailsOfLastStepSummary = DataReviewHelper.getDetailsOfLastStepSummary(allOrderlyDetailsOfSummaryId, datestamp);
        List<DynamicObject> detailsByDatestamp = DataReviewHelper.getDetailsByDatestamp(allOrderlyDetailsOfSummaryId, datestamp);
        if (!CollectionUtils.isEmpty(detailsByDatestamp)) {
            detailsOfLastStepSummary.addAll(0, detailsByDatestamp);
        }
        DynamicObject modelData = DataReviewHelper.getSummaryById(anaModel.getLong("id"), dataId, null);
        int measureScale = PAMeasureHelper.getMeasureScale((Long)anaModel.getDynamicObject("analysis_system").getLong("id"), (String)measureNumber);
        BigDecimal measureValue = detailsOfLastStepSummary.stream().map(detail -> {
            BigDecimal detailMeasureValue = detail.getBigDecimal(measureNumber);
            return detailMeasureValue != null ? detailMeasureValue : BigDecimal.ZERO;
        }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(measureScale, 4);
        NodeDataInfo nodeDataInfo = new NodeDataInfo();
        nodeDataInfo.setMeasureNumber(measureNumber);
        String measureName = anaModel.getDynamicObjectCollection("measure_entry").stream().map(entry -> entry.getDynamicObject("measure")).filter(measure -> measureNumber.equals(measure.getString("number"))).map(measure -> measure.getString("name")).findFirst().orElse("");
        nodeDataInfo.setMeasureName(measureName);
        nodeDataInfo.setMeasureValue(measureValue.toString());
        nodeDataInfo.setTypeValue(businessTypeEnum.getCode());
        nodeDataInfo.setType(ResManager.loadKDString((String)"\u6c47\u603b", (String)"PADataReviewBuilder_0", (String)"fi-pa-business", (Object[])new Object[0]));
        Map<DimensionNecessityEnum, DynamicObject> dimensionNecessityMap = DataReviewHelper.getDimensionNecessityMap(anaModel);
        String orgDimensionNumber = dimensionNecessityMap.get(DimensionNecessityEnum.ORG).getString("number");
        nodeDataInfo.setOrg(modelData.getDynamicObject(orgDimensionNumber).getString("name"));
        DynamicObject accountDimension = dimensionNecessityMap.get(DimensionNecessityEnum.ACCOUNT);
        if (accountDimension != null) {
            String accountDimensionNumber = accountDimension.getString("number");
            String accountDimensionSourceNumber = accountDimension.getString("dimensionsource.number");
            DynamicObject accountDy = modelData.getDynamicObject(accountDimensionNumber);
            if ("bd_accountview".equals(accountDimensionSourceNumber)) {
                nodeDataInfo.setAccount(accountDy == null ? "" : accountDy.getString("fullname"));
            } else {
                nodeDataInfo.setAccount(accountDy == null ? "" : accountDy.getString("name"));
            }
        }
        if (DataReviewBusinessTypeEnum.SHARE_SUMMARY == businessTypeEnum) {
            long subExecLogId = 0L;
            List<DynamicObject> detailsOfNextStepSummary = DataReviewHelper.getDetailsOfNextStepSummary(allOrderlyDetailsOfSummaryId, datestamp);
            if (!CollectionUtils.isEmpty(detailsOfNextStepSummary)) {
                DynamicObject detailOfNextStep = detailsOfNextStepSummary.get(detailsOfNextStepSummary.size() - 1);
                subExecLogId = detailOfNextStep.getLong("subexeclogid");
            }
            PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId(subExecLogId);
            List receiveDimensions = shareRuleInfoDTO.getReceiveDimensionInfos().stream().map(t -> (DynamicObject)t.item1).collect(Collectors.toList());
            DynamicObject firstReceiveDimensionButOrg = receiveDimensions.stream().filter(dimension -> !orgDimensionNumber.equals(dimension.getString("number"))).findFirst().orElse(null);
            String shareApportionDimension = "";
            if (firstReceiveDimensionButOrg != null) {
                String firstReceiveDimensionName = firstReceiveDimensionButOrg.getString("name");
                String firstReceiveDimensionValue = DataReviewHelper.translateDataValueToDimensionValue(firstReceiveDimensionButOrg, modelData);
                shareApportionDimension = String.format("%1$s\uff1a%2$s", firstReceiveDimensionName, firstReceiveDimensionValue);
            }
            ApportionInfo apportionInfo = new ApportionInfo(shareApportionDimension, "");
            nodeDataInfo.setApportion(apportionInfo);
        }
        if (DataReviewBusinessTypeEnum.DERIVATION_SUMMARY == businessTypeEnum || DataReviewBusinessTypeEnum.SHARE_SUMMARY == businessTypeEnum) {
            nodeDataInfo.setRules(PADataReviewBuilder.createNodeRulesInfo(anaModel.getLong("id"), dataId, datestamp, measureNumber, businessTypeEnum));
            nodeDataInfo.setSubExecLogId(PADataReviewBuilder.getSubExecLogId(anaModel.getLong("id"), dataId, measureNumber, datestamp, businessTypeEnum));
        }
        return nodeDataInfo;
    }

    private static String getRatioValue(Long modelId, DynamicObject modelData, String measureNumber) {
        BigDecimal total;
        BigDecimal lastStepDetailValue;
        long parentIdOfShareDetail = modelData.getLong("execparentbillid");
        long subExecLogIdOfShare = modelData.getLong("subexeclogid");
        List<DynamicObject> allOrderlyDetailsOfShareParentId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, parentIdOfShareDetail, measureNumber);
        DynamicObject offShareDetail = allOrderlyDetailsOfShareParentId.stream().filter(detail -> subExecLogIdOfShare == detail.getLong("subexeclogid") && DataStatusEnum.OFF_ALLOCATE == DataStatusEnum.getEnumByCode((byte)Byte.parseByte(detail.getString("datastatus")))).findFirst().orElse(null);
        if (offShareDetail == null) {
            throw new KDBizException("offShareDetail is unExist");
        }
        Collection<DynamicObject> otherShareDetailsByExecLogId = DataReviewHelper.getDetailsByExecLogId(modelId, offShareDetail.getLong("execparentbillid"), offShareDetail.getLong("subexeclogid"), measureNumber, DataStatusEnum.ALLOCATE, modelData.getLong("id"));
        BigDecimal otherTotalMeasureValue = otherShareDetailsByExecLogId.stream().map(detail -> {
            BigDecimal detailMeasureValue = detail.getBigDecimal(measureNumber);
            return detailMeasureValue != null ? detailMeasureValue : BigDecimal.ZERO;
        }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal bigDecimal = lastStepDetailValue = modelData.getBigDecimal(measureNumber) != null ? modelData.getBigDecimal(measureNumber) : BigDecimal.ZERO;
        BigDecimal percentage = lastStepDetailValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ((total = lastStepDetailValue.add(otherTotalMeasureValue)).compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("100") : lastStepDetailValue.multiply(new BigDecimal("100")).divide(total, 2, 4));
        return percentage.toString() + "%";
    }

    private static String joinDimensionNameListByComma(List<DynamicObject> dimensionList) {
        if (CollectionUtils.isEmpty(dimensionList)) {
            return ResManager.loadKDString((String)"\u65e0", (String)"PADataReviewBuilder_2", (String)"fi-pa-business", (Object[])new Object[0]);
        }
        return dimensionList.stream().map(dimension -> dimension.getString("name")).collect(Collectors.joining(","));
    }

    private static boolean validationLeftTraceOfNode(Node node) {
        DataReviewNodeTypeEnum nodeTypeEnum = DataReviewNodeTypeEnum.getEnumByCode((String)node.getType());
        if (DataReviewNodeTypeEnum.NODE != nodeTypeEnum) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u7c7b\u578b\u4e0d\u652f\u6301\u5de6\u8ffd\u6eaf,\u8282\u70b9\u7c7b\u578b\u4e3a : %s", (String)"PADataReviewBuilder_7", (String)"fi-pa-business", (Object[])new Object[0]), nodeTypeEnum.getCode()));
        }
        NodeDataInfo data = node.getData();
        if (data == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u6570\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a,\u6a21\u578b\u8868\u6570\u636eid\u4e3a : %s", (String)"PADataReviewBuilder_8", (String)"fi-pa-business", (Object[])new Object[0]), node.getDataId()));
        }
        DataReviewBusinessTypeEnum businessTypeEnum = DataReviewBusinessTypeEnum.getEnumByCode((String)data.getTypeValue());
        if (DataReviewBusinessTypeEnum.DETAIL == businessTypeEnum || DataReviewBusinessTypeEnum.DERIVATION_DETAIL == businessTypeEnum || DataReviewBusinessTypeEnum.SHARE_DETAIL == businessTypeEnum) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de6\u8ffd\u6eaf\u4e0d\u652f\u6301\u5f53\u524d\u8282\u70b9\u4e1a\u52a1\u7c7b\u578b : %s", (String)"PADataReviewBuilder_9", (String)"fi-pa-business", (Object[])new Object[0]), businessTypeEnum.getCode()));
        }
        return true;
    }

    public static String buildShareDetailsBy(String shareSummaryNodeId, Long modelId, List<Long> detailIds, String measureNumber, Long trunkDetailDataId) {
        TraceModel traceModel = new TraceModel();
        DynamicObject detailById = DataReviewHelper.getDetailById(modelId, detailIds.get(0), measureNumber);
        Collection<DynamicObject> detailsByExecLogId = DataReviewHelper.getDetailsByExecLogId(modelId, detailById.getLong("execparentbillid"), detailById.getLong("subexeclogid"), measureNumber, DataStatusEnum.ALLOCATE, new Long[0]);
        List selectedDetails = detailsByExecLogId.stream().filter(detail -> detailIds.contains(detail.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject selectedDetail : selectedDetails) {
            if (selectedDetail.getLong("id") == trunkDetailDataId.longValue()) continue;
            Node node = PADataReviewBuilder.createNode(modelId, selectedDetail.getLong("id"), measureNumber, selectedDetail.getLong("createstamp"), DataReviewBusinessTypeEnum.SHARE_DETAIL);
            traceModel.addNode(node);
            traceModel.addEdge(new NodeEdge(shareSummaryNodeId, node.getId()));
            boolean isExistTargetMoreNode = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(modelId, selectedDetail.getLong("summaryid"), measureNumber).size() > 1;
            if (!isExistTargetMoreNode) continue;
            TargetMoreNode shareDetailTargetMoreNode = PADataReviewBuilder.createTargetMoreNode("+");
            traceModel.addNode(shareDetailTargetMoreNode);
            traceModel.addEdge(new NodeEdge(node.getId(), shareDetailTargetMoreNode.getId()));
        }
        List unSelectedDetails = detailsByExecLogId.stream().filter(detail -> !detailIds.contains(detail.getLong("id"))).collect(Collectors.toList());
        if (unSelectedDetails.size() != 0) {
            BigDecimal unSelectedDetailsTotalValue = unSelectedDetails.stream().map(detail -> {
                BigDecimal detailMeasureValue = detail.getBigDecimal(measureNumber);
                return detailMeasureValue != null ? detailMeasureValue : BigDecimal.ZERO;
            }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalValue = detailsByExecLogId.stream().map(detail -> {
                BigDecimal detailMeasureValue = detail.getBigDecimal(measureNumber);
                return detailMeasureValue != null ? detailMeasureValue : BigDecimal.ZERO;
            }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal percentage = new BigDecimal("0.00");
            if (totalValue.compareTo(BigDecimal.ZERO) != 0) {
                percentage = unSelectedDetailsTotalValue.multiply(new BigDecimal("100")).divide(totalValue, 2, 4);
            }
            List<Long> unSelectedDetailIds = unSelectedDetails.stream().map(detail -> detail.getLong("id")).collect(Collectors.toList());
            MoreNode moreNode = PADataReviewBuilder.createMoreNode(String.format(ResManager.loadKDString((String)"%s\u4e2a\u5206\u644a", (String)"PADataReviewBuilder_3", (String)"fi-pa-business", (Object[])new Object[0]), unSelectedDetails.size()), percentage.toString() + "%", unSelectedDetailIds);
            traceModel.addNode(moreNode);
            traceModel.addEdge(new NodeEdge(shareSummaryNodeId, moreNode.getId()));
        }
        return traceModel.toData();
    }

    public static String buildRemoveShareDetailsBy(String parentNodeId, List<Object> oldSelectedNodeIds, Long moreNodeId, String trunkDetailNodeId) {
        TraceModel oldTraceModel = new TraceModel();
        for (Object oldSelectedNodeId : oldSelectedNodeIds) {
            if (oldSelectedNodeId.equals(trunkDetailNodeId)) continue;
            Node node = new Node();
            node.setId(String.valueOf(oldSelectedNodeId));
            oldTraceModel.addNode(node);
            oldTraceModel.addEdge(new NodeEdge(parentNodeId, node.getId()));
        }
        MoreNode oldMoreNode = new MoreNode();
        oldMoreNode.setId(String.valueOf(moreNodeId));
        oldTraceModel.addNode(oldMoreNode);
        oldTraceModel.addEdge(new NodeEdge(parentNodeId, oldMoreNode.getId()));
        return oldTraceModel.toData();
    }
}

