/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.review.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PAMeasureHelper;
import kd.fi.pa.review.DataReviewHelper;

public class PASummaryDataByStampDTO {
    private Long modelId;
    private Long summaryId;
    private String measureNumber;
    private Long dateStamp;
    private DynamicObject summary;
    private List<DynamicObject> detailsOfSummaryByCurrentDateStamp;
    private DynamicObject anaModel;
    private Map<DimensionNecessityEnum, DynamicObject> dimensionNecessityMap;

    public PASummaryDataByStampDTO(Long modelId, Long summaryId, String measureNumber, Long dateStamp) {
        this.modelId = modelId;
        this.summaryId = summaryId;
        this.measureNumber = measureNumber;
        this.dateStamp = dateStamp;
    }

    public Tuple<String, String> getMeasureNameAndValue() {
        String measureName = this.getAnaModel().getDynamicObjectCollection("measure_entry").stream().filter(measureEntry -> measureEntry.getDynamicObject("measure").getString("number").equals(this.measureNumber)).map(measureEntry -> measureEntry.getDynamicObject("measure").getString("name")).findFirst().orElse("");
        int measureScale = PAMeasureHelper.getMeasureScale((Long)this.getAnaModel().getDynamicObject("analysis_system").getLong("id"), (String)this.measureNumber);
        BigDecimal measureValue = this.getDetailsOfSummaryByCurrentDateStamp().stream().map(detail -> detail.getBigDecimal(this.measureNumber)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(measureScale, 4);
        return new Tuple((Object)measureName, (Object)measureValue.toString());
    }

    public Tuple<String, String> getNecessaryDimensionNameAndValue(DimensionNecessityEnum dimensionNecessityEnum) {
        DynamicObject necessaryDimension = this.getDimensionNecessityMap().get(dimensionNecessityEnum);
        if (necessaryDimension == null) {
            return null;
        }
        DynamicObject summary = this.getSummary();
        return new Tuple((Object)necessaryDimension.getString("name"), (Object)DataReviewHelper.translateDataValueToDimensionValue(necessaryDimension, summary));
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(Long summaryId) {
        this.summaryId = summaryId;
    }

    public String getMeasureNumber() {
        return this.measureNumber;
    }

    public void setMeasureNumber(String measureNumber) {
        this.measureNumber = measureNumber;
    }

    public Long getDateStamp() {
        return this.dateStamp;
    }

    public void setDateStamp(Long dateStamp) {
        this.dateStamp = dateStamp;
    }

    public DynamicObject getSummary() {
        if (this.summary == null) {
            this.summary = DataReviewHelper.getSummaryById(this.modelId, this.summaryId, this.measureNumber);
        }
        return this.summary;
    }

    public List<DynamicObject> getDetailsOfSummaryByCurrentDateStamp() {
        if (CollectionUtils.isEmpty(this.detailsOfSummaryByCurrentDateStamp)) {
            List<DynamicObject> allOrderlyDetailsOfSummaryId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId(this.modelId, this.summaryId, this.measureNumber);
            this.detailsOfSummaryByCurrentDateStamp = new ArrayList<DynamicObject>(4);
            List<DynamicObject> detailsByDatestamp = DataReviewHelper.getDetailsByDatestamp(allOrderlyDetailsOfSummaryId, this.dateStamp);
            if (!CollectionUtils.isEmpty(detailsByDatestamp)) {
                this.detailsOfSummaryByCurrentDateStamp.addAll(detailsByDatestamp);
            }
            this.detailsOfSummaryByCurrentDateStamp.addAll(DataReviewHelper.getDetailsOfLastStepSummary(allOrderlyDetailsOfSummaryId, this.dateStamp));
        }
        return this.detailsOfSummaryByCurrentDateStamp;
    }

    public DynamicObject getAnaModel() {
        if (this.anaModel == null) {
            this.anaModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)this.getModelId());
        }
        return this.anaModel;
    }

    public Map<DimensionNecessityEnum, DynamicObject> getDimensionNecessityMap() {
        if (CollectionUtils.isEmpty(this.dimensionNecessityMap)) {
            this.dimensionNecessityMap = DataReviewHelper.getDimensionNecessityMap(this.getAnaModel());
        }
        return this.dimensionNecessityMap;
    }
}

