/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.common;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.pa.dto.DateRangeDTO;

public class DateRangeDialogPlugin
extends AbstractFormPlugin {
    private static final String FORMID = "pa_daterangedialog";

    public static void openBy(AbstractFormPlugin plugin, String predata, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("predata", predata);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            String predata = (String)this.getView().getFormShowParameter().getCustomParam("predata");
            if (StringUtils.isNotEmpty((CharSequence)predata)) {
                DateRangeDTO dateRange = new DateRangeDTO(predata);
                this.getModel().setValue("startdate", (Object)dateRange.getStartDate());
                this.getModel().setValue("enddate", (Object)dateRange.getEndDate());
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.returnText();
        }
    }

    private void returnText() {
        try {
            Date startdate = (Date)this.getModel().getValue("startdate");
            Date enddate = (Date)this.getModel().getValue("enddate");
            DateRangeDTO dateRange = new DateRangeDTO(startdate, enddate);
            this.getView().returnDataToParent((Object)dateRange.getDateRange());
            this.getView().close();
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }
}

