/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.common;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.DateRangeDialogPlugin;
import kd.fi.pa.common.PAInputTextFormPlugin;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.DimensionTypeEnum;
import kd.fi.pa.dto.TagTextFiledData;
import kd.fi.pa.util.BaseDataUtil;
import kd.fi.pa.utils.PAUtil;

public class MulDimSetValPlugin
extends AbstractFormPlugin {
    private static final String CK_EDIT_MODEL = "setval_edit_model";
    private static final String ACTION_SET_F_DATABASE = "action_set_database";
    private static final String ACTION_SET_F_DATERANGE = "action_set_daterange";
    private static final String ACTION_SET_F_ENUMS = "action_set_enums";
    private static final String ACTION_SET_F_TEXT = "action_set_text";

    public String getDimFieldKey() {
        return "dimension";
    }

    public void initialize() {
        this.getView().addCustomControls(new String[]{"dimensionmember"});
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if ("dimensionmember".equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    MulDimSetValPlugin.this.clickSetVal();
                }
            };
            control.setKey("dimensionmember");
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dimensionmembertxt"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object value = this.getModel().getValue(this.getDimFieldKey());
        if (value instanceof DynamicObject) {
            FieldEdit edit = (FieldEdit)this.getControl("dimensionmembertxt");
            edit.setCaption(new LocaleString(((DynamicObject)value).getString("name")));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (Objects.equals(name, this.getDimFieldKey())) {
            if (newValue instanceof DynamicObject) {
                LocaleString caption = new LocaleString(((DynamicObject)newValue).getString("name"));
                FieldEdit edittxt = (FieldEdit)this.getControl("dimensionmembertxt");
                edittxt.setCaption(caption);
                FieldEdit edit = (FieldEdit)this.getControl("dimensionmember");
                edit.setCaption(caption);
            }
            this.getModel().setValue("dimensionmembertxt", null);
            this.getModel().setValue("dimensionmember", null);
            this.getModel().setValue("dimensionmember_TAG", null);
        } else if (Objects.equals(name, "dimensionmembertxt") && StringUtils.isEmpty((CharSequence)((CharSequence)newValue))) {
            String editModel = this.getPageCache().get(CK_EDIT_MODEL);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (Objects.equals(editModel, "view") || OperationStatus.VIEW.equals((Object)status)) {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                this.getModel().beginInit();
                this.getModel().setDataChanged(false);
                this.getModel().setValue("dimensionmembertxt", oldValue);
                this.getModel().setDataChanged(false);
                this.getModel().endInit();
                this.getView().updateView("dimensionmembertxt");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MulDimSetValPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("dimensionmember_TAG", null);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("dimensionmembertxt".equals(control.getKey())) {
            this.clickSetVal();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (e.getReturnData() == null) {
            return;
        }
        String editModel = this.getPageCache().get(CK_EDIT_MODEL);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.equals(editModel, "view") || OperationStatus.VIEW.equals((Object)status)) {
            TagTextFiledData filedData = new TagTextFiledData("dimensionmembertxt", "dimensionmember_TAG");
            filedData.callBackValue(e.getReturnData());
            if (!filedData.datachange(this.getModel())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"MulDimSetValPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        if (ACTION_SET_F_DATABASE.equals(actionId) || ACTION_SET_F_ENUMS.equals(actionId) || ACTION_SET_F_DATERANGE.equals(actionId) || ACTION_SET_F_TEXT.equals(actionId)) {
            TagTextFiledData filedData = new TagTextFiledData("dimensionmembertxt", "dimensionmember_TAG");
            filedData.callBackValue(e.getReturnData());
            filedData.fillValue(this.getModel());
        }
    }

    public void clickSetVal() {
        String valuetext = (String)this.getModel().getValue("dimensionmember_TAG");
        Object pkvalue = this.getModel().getValue(this.getDimFieldKey() + "_id");
        if (PAUtil.idIsNull((Object)pkvalue)) {
            return;
        }
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)"pa_dimension");
        String dimensiontype = dimension.getString("dimensiontype");
        if (DimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            QFilter qFilter = CvprofitBusinessHelper.getQFilterByDimension((DynamicObject)dimension);
            DynamicObject baseData = dimension.getDynamicObject("dimensionsource");
            this.showF7FilterForm((String)baseData.getPkValue(), qFilter, valuetext);
        } else if (DimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            this.showF7FilterForm("bos_assistantdata_detail", CvprofitBusinessHelper.getQFilterByDimension((DynamicObject)dimension), valuetext);
        } else if (DimensionTypeEnum.DENUMS.eqScene((Object)dimensiontype)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("items", CvprofitBusinessHelper.getValueMapItems((DynamicObject)dimension));
            map.put("seleted", valuetext);
            this.openFafcombodialog(this, dimension.getString("name"), map, ACTION_SET_F_ENUMS);
        } else if (DimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
            DateRangeDialogPlugin.openBy(this, valuetext, ACTION_SET_F_DATERANGE);
        } else if (DimensionTypeEnum.OTHER.eqScene((Object)dimensiontype)) {
            PAInputTextFormPlugin.openBy(this, dimension.getString("name"), valuetext, ACTION_SET_F_TEXT);
        }
    }

    private void openFafcombodialog(AbstractFormPlugin plugin, String caption, Map<String, Object> params, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("faf_fasdialogcombo");
        fsp.setCaption(caption);
        fsp.setCustomParam("fieldtitle", (Object)caption);
        fsp.setCustomParam("params", (Object)SerializationUtils.serializeToBase64(params));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }

    private void showF7FilterForm(String formId, QFilter filter, String valuetext) {
        ListShowParameter lsf = BaseDataUtil.createF7ShowParameter(formId, true, valuetext);
        if (filter != null) {
            ListFilterParameter lfp = lsf.getListFilterParameter();
            lfp.getQFilters().add(filter);
        }
        lsf.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SET_F_DATABASE));
        this.getView().showForm((FormShowParameter)lsf);
    }
}

