/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.common;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class PAInputTextFormPlugin
extends AbstractFormPlugin {
    private static final String FORMID = "pa_inputdialog";

    public static void openBy(AbstractFormPlugin plugin, String caption, String predata, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(FORMID);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        fsp.setCustomParam("fieldtitle", (Object)caption);
        fsp.setCustomParam("predata", (Object)predata);
        plugin.getView().showForm(fsp);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String predata;
        super.afterCreateNewData(e);
        String title = (String)this.getView().getFormShowParameter().getCustomParam("fieldtitle");
        if (title != null) {
            TextEdit text = (TextEdit)this.getControl("text");
            text.setCaption(new LocaleString(title));
        }
        if (StringUtils.isNotEmpty((CharSequence)(predata = (String)this.getView().getFormShowParameter().getCustomParam("predata")))) {
            this.getModel().setValue("text", (Object)predata);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.returnText();
        }
    }

    private void returnText() {
        String text = (String)this.getModel().getValue("text");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", text);
        map.put("text", this.buildDesc(text));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public String buildDesc(String text) {
        String[] split = text.split("\n");
        String collect = Arrays.stream(split).limit(100L).collect(Collectors.joining(","));
        if (collect.length() > 200) {
            collect = collect + "...";
        } else if (split.length > 100) {
            collect = collect + "\n...";
        }
        return collect.substring(0, Math.min(200, collect.length()));
    }
}

