/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.pa.common.PAReportFilter;
import kd.fi.pa.common.ViewHelper;
import kd.fi.pa.cost.CtrlUnitUseOrg;
import kd.fi.pa.cost.CvprofitBoadCusViewHelper;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.CvprofitSnapshootEdit;
import kd.fi.pa.cost.data.CvprofitModel;
import kd.fi.pa.cost.data.CvprofitQueryParam;
import kd.fi.pa.cost.data.CvprofitSchema;
import kd.fi.pa.cost.data.CvprofitSnapshoot;
import kd.fi.pa.utils.PAUtil;

public class CvprofitBoardRptPlugin
extends AbstractReportFormPlugin {
    private static final String CACHE_REFRESH_PARAM = "cache_refresh_param";

    public void initialize() {
        this.getView().addCustomControls(new String[]{"reportfilterap"});
    }

    public void onGetControl(OnGetControlArgs e) {
        Control control;
        String key = e.getKey();
        if ("reportfilterap".equals(key) && (control = e.getControl()) != null && !(control instanceof PAReportFilter)) {
            e.setControl((Control)PAReportFilter.create((ReportFilter)control));
        }
    }

    public void registerListener(EventObject e) {
        Object value;
        BasedataEdit analysisobjectF7;
        super.registerListener(e);
        Object analysistype = this.getModel().getValue("analysistype");
        if (Objects.equals(analysistype, "pa_cvprofitschema")) {
            analysisobjectF7 = (BasedataEdit)this.getControl("analysisobject");
            analysisobjectF7.addBeforeF7SelectListener(event -> {
                CtrlUnitUseOrg useOrg = CtrlUnitUseOrg.create((String)"pa_cvprofitschema");
                event.addCustomQFilter(useOrg.getBaseDataFilter());
            });
        } else if (Objects.equals(analysistype, "pa_cvprofitsnapshoot")) {
            analysisobjectF7 = (BasedataEdit)this.getControl("analysisobject");
            analysisobjectF7.addBeforeF7SelectListener(event -> {
                CtrlUnitUseOrg useOrg = CtrlUnitUseOrg.create((String)"pa_cvprofitschema");
                event.addCustomQFilter(new QFilter("schemaorg", "in", (Object)useOrg.getAllUseOrgIds()));
            });
        }
        Object periodentity = this.getModel().getValue("periodentity");
        if (Objects.equals(periodentity, "bd_period")) {
            BasedataEdit modelF7 = (BasedataEdit)this.getControl("period");
            modelF7.addBeforeF7SelectListener(event -> {
                CvprofitModel model = CvprofitModel.create((Object)this.getModel().getValue("model_id"));
                event.addCustomQFilter(new QFilter("periodtype", "=", model.getPeriodtypeID()));
            });
        }
        if ((value = this.getModel().getValue("model")) instanceof DynamicObject) {
            BasedataEdit orgsetF7 = (BasedataEdit)this.getControl("orgset");
            orgsetF7.addBeforeF7SelectListener(event -> {
                Set permOrgs = CvprofitBusinessHelper.getMergePermOrgs();
                event.addCustomQFilter(new QFilter("id", "in", (Object)permOrgs));
            });
            BasedataEdit dimensionF7 = (BasedataEdit)this.getControl("dimension");
            dimensionF7.addBeforeF7SelectListener(event -> {
                CvprofitModel model = CvprofitModel.create((Object)this.getModel().getValue("model_id"));
                event.addCustomQFilter(new QFilter("id", "in", (Object)model.getOrdinaryDimensionSet()));
            });
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object sourceformid = this.getView().getFormShowParameter().getCustomParam("sourceformid");
        Object sourcepkValue = this.getView().getFormShowParameter().getCustomParam("sourcepkValue");
        if (StringUtils.isNotBlank((Object)sourceformid)) {
            CvprofitModel model;
            DynamicObject instance = (DynamicObject)this.getModel().getDataEntityType().createInstance();
            e.setDataEntity((Object)instance);
            DataEntityPropertyCollection properties = instance.getDataEntityType().getProperties();
            ((IFieldHandle)properties.get((Object)"analysistype")).setFieldValue(this.getModel(), (Object)instance, sourceformid);
            ((IFieldHandle)properties.get((Object)"analysisobject")).setFieldValue(this.getModel(), (Object)instance, sourcepkValue);
            Long model_id = CvprofitBusinessHelper.queryModelBySchema((Object)sourcepkValue);
            ((IFieldHandle)properties.get((Object)"model")).setFieldValue(this.getModel(), (Object)instance, (Object)model_id);
            if (PAUtil.idNotNull((Object)model_id) && StringUtils.isNotEmpty((CharSequence)(model = CvprofitModel.create((Object)model_id)).getPeriodEntityName())) {
                ((IFieldHandle)properties.get((Object)"periodentity")).setFieldValue(this.getModel(), (Object)instance, (Object)model.getPeriodEntityName());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FieldEdit edit = (FieldEdit)this.getControl("analysisobject");
        Object value = this.getModel().getValue("analysistype");
        if (value instanceof String) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)value));
            edit.setCaption(dataEntityType.getDisplayName());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object analysistype = this.getModel().getValue("analysistype");
        if (Objects.equals(name, "analysisobject")) {
            if (newValue instanceof DynamicObject) {
                Object pkvalue = ((DynamicObject)newValue).get("id");
                if (Objects.equals(analysistype, "pa_cvprofitschema")) {
                    this.changeSchama(pkvalue);
                    return;
                }
                if (Objects.equals(analysistype, "pa_cvprofitsnapshoot")) {
                    this.changeSnapshoot(pkvalue);
                    return;
                }
            }
            this.getModel().setValue("model", null);
        } else if (Objects.equals(name, "model")) {
            if (newValue instanceof DynamicObject) {
                Object pkvalue = ((DynamicObject)newValue).get("id");
                CvprofitModel model = CvprofitModel.create((Object)pkvalue);
                String periodEntityName = model.getPeriodEntityName();
                if (StringUtils.isNotEmpty((CharSequence)periodEntityName)) {
                    this.getModel().setValue("periodentity", (Object)periodEntityName);
                }
            } else {
                this.getModel().setValue("periodentity", null);
            }
            this.getModel().setValue("orgset", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("dimension", null);
            this.getModel().setValue("dimensionmembertxt", null);
            this.getModel().setValue("dimensionmember_TAG", null);
        }
    }

    private void changeSchama(Object pkvalue) {
        Long modelId = CvprofitBusinessHelper.queryModelBySchema((Object)pkvalue);
        this.getModel().setValue("model", (Object)modelId);
    }

    private void changeSnapshoot(Object pkvalue) {
        CvprofitSnapshoot snapshoot = CvprofitSnapshoot.create((Object)pkvalue);
        CvprofitQueryParam queryParam = snapshoot.getCvprofitQueryParam();
        CvprofitBusinessHelper.bindSnapshootInfo((IDataModel)this.getModel(), (CvprofitQueryParam)queryParam);
        this.getView().updateView();
    }

    public void itemClick(ItemClickEvent evt) {
        ReportQueryParam queryParam;
        boolean query;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (Objects.equals(itemKey, "tblsaveas") && (query = this.verifyQuery(queryParam = new ReportQueryParam()))) {
            CvprofitQueryParam param = (CvprofitQueryParam)queryParam.getCustomParam().get("queryParam");
            String bigObject = this.getPageCache().getBigObject(CACHE_REFRESH_PARAM);
            if (StringUtils.isEmpty((CharSequence)bigObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u201c\u67e5\u8be2\u201d\u540e\uff0c\u518d\u201c\u53e6\u5b58\u4e3a\u5feb\u7167\u201d\u3002", (String)"CvprofitBoardRptPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            CvprofitQueryParam cacheParam = (CvprofitQueryParam)SerializationUtils.fromJsonString((String)bigObject, CvprofitQueryParam.class);
            if (!param.equals((Object)cacheParam)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5148\u201c\u67e5\u8be2\u201d\u540e\uff0c\u518d\u201c\u53e6\u5b58\u4e3a\u5feb\u7167\u201d\u3002", (String)"CvprofitBoardRptPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            CvprofitBoadCusViewHelper.send_event((IFormView)this.getView(), "saveas", param);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        try {
            CvprofitQueryParam param = new CvprofitQueryParam();
            String analysistype = (String)this.getModel().getValue("analysistype");
            param.setAnalysistype(analysistype);
            Object object = this.getModel().getValue("analysisobject");
            if (!(object instanceof DynamicObject)) {
                Object pkvalue = this.getModel().getValue("analysisobject_id");
                this.showTips(Collections.singletonList("analysisobject"), PAUtil.idNotNull((Object)pkvalue));
                return false;
            }
            param.setAnalysisobjectId((Long)((DynamicObject)object).getPkValue());
            if (Objects.equals(analysistype, "pa_cvprofitschema")) {
                param.setName(((DynamicObject)object).getString("name"));
                param.setModelId((Long)this.getModel().getValue("model_id"));
                DynamicObjectCollection orgset = (DynamicObjectCollection)this.getModel().getValue("orgset");
                if (orgset != null) {
                    param.setOrgsetId(orgset.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toSet()));
                }
                param.setPeriodentity((String)this.getModel().getValue("periodentity"));
                Object period = this.getModel().getValue("period");
                if (period instanceof DynamicObject) {
                    param.setPeriodId((Long)((DynamicObject)period).getPkValue());
                }
                param.setDimensionId((Long)this.getModel().getValue("dimension_id"));
                param.setDimensionmember((String)this.getModel().getValue("dimensionmembertxt"));
                param.setDimensionmember_tag((String)this.getModel().getValue("dimensionmember_TAG"));
                queryParam.getCustomParam().put("queryParam", param);
                CvprofitSchema cvprofitSchema = CvprofitSchema.create((Object)param.getAnalysisobjectId());
                cvprofitSchema.validEnable();
                List valid = cvprofitSchema.valid(param);
                if (!valid.isEmpty()) {
                    this.showTips(valid, false);
                    return false;
                }
            } else if (Objects.equals(analysistype, "pa_cvprofitsnapshoot")) {
                CvprofitSnapshoot snapshoot = CvprofitSnapshoot.create((Object)((DynamicObject)object).getPkValue());
                CvprofitQueryParam from = snapshoot.getCvprofitQueryParam();
                from.setAnalysistype(param.getAnalysistype());
                from.setAnalysisobjectId(param.getAnalysisobjectId());
                queryParam.getCustomParam().put("queryParam", from);
                snapshoot.validEnable();
            }
        }
        catch (Exception ex) {
            ViewHelper.showTip((IFormView)this.getView(), ex);
            return false;
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        try {
            CvprofitQueryParam param = (CvprofitQueryParam)queryParam.getCustomParam().get("queryParam");
            this.getPageCache().putBigObject(CACHE_REFRESH_PARAM, SerializationUtils.toJsonString((Object)param));
            CvprofitBoadCusViewHelper.send_event((IFormView)this.getView(), "refresh", param);
        }
        catch (Exception ex) {
            ViewHelper.showTip((IFormView)this.getView(), ex);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && Objects.equals(parentView.getEntityId(), "pa_cvprofitboard")) {
            parentView.close();
            this.getView().sendFormAction(parentView);
            e.setCancel(true);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if ("cvprofitboard".equals(key) && "saveas".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            ReportQueryParam queryParam = new ReportQueryParam();
            boolean query = this.verifyQuery(queryParam);
            if (query) {
                try {
                    String useorg;
                    String snapshoot;
                    CvprofitQueryParam param = (CvprofitQueryParam)queryParam.getCustomParam().get("queryParam");
                    if (Objects.equals(param.getAnalysistype(), "pa_cvprofitschema")) {
                        CvprofitSchema cvprofitSchema = CvprofitSchema.create((Object)param.getAnalysisobjectId());
                        Map argsMap = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                        if (Objects.equals(argsMap.getOrDefault("noData", Boolean.FALSE), Boolean.TRUE)) {
                            String tip = ResManager.loadKDString((String)"\u5206\u6790\u770b\u677f\u5fc5\u8981\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u53e6\u5b58\u4e3a\u5feb\u7167\uff0c\u8bf7\u68c0\u67e5\u5206\u6790\u65b9\u6848\u53d6\u503c\u3002", (String)"CvprofitBoardRptPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                            this.getView().showTipNotification(tip);
                            return;
                        }
                        snapshoot = cvprofitSchema.builSnapshoot(param, eventArgs);
                        useorg = this.getUseorg();
                    } else if (Objects.equals(param.getAnalysistype(), "pa_cvprofitsnapshoot")) {
                        CvprofitSnapshoot cvprofitSnapshoot = CvprofitSnapshoot.create((Object)param.getAnalysisobjectId());
                        snapshoot = cvprofitSnapshoot.builSnapshoot(param, eventArgs);
                        useorg = cvprofitSnapshoot.getCreateOrg();
                    } else {
                        return;
                    }
                    CvprofitSnapshootEdit.openByAsNew((AbstractFormPlugin)this, snapshoot, useorg);
                }
                catch (Exception ex) {
                    ViewHelper.showTip((IFormView)this.getView(), ex);
                }
            }
        }
    }

    private void showTips(List<String> valid, boolean isDelete) {
        String collect = valid.stream().map(s -> String.format("\u201c%s\u201d", ((FieldEdit)this.getControl((String)s)).getDisplayName().getLocaleValue())).collect(Collectors.joining("\u3001"));
        if (isDelete) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u91cd\u65b0\u586b\u5199%s\uff0c\u5f53\u524d\u586b\u5165\u7684\u503c\u4e0d\u53ef\u7528\u3002", (String)"CvprofitBoardRptPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), collect));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"CvprofitBoardRptPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), collect));
        }
    }

    public String getUseorg() {
        return (String)this.getView().getFormShowParameter().getCustomParam("useorg");
    }
}

