/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.CvprofitSetDialogPlugin;
import kd.fi.pa.cost.data.CvprofitModel;
import kd.fi.pa.dto.TagTextFiledData;
import kd.fi.pa.utils.PAUtil;

public class CvprofitFilterDialogPlugin
extends CvprofitSetDialogPlugin {
    private static final Log logger = LogFactory.getLog(CvprofitFilterDialogPlugin.class);
    private static final String FORMID = "pa_cvprofitfilterdialog";
    private static final String CTRL_FILTERGRIDAP = "filtergridap";
    private static final String P_VALUE = "setvalue";
    private static final Set<String> set = new HashSet<String>();
    private static final Set<String> datetimeSet = new HashSet<String>();

    public static void openBy(AbstractFormPlugin plugin, Object modelPkId, Object value, String useOrgId, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(FORMID);
        fsp.setCustomParam("model", modelPkId);
        fsp.setCustomParam("useOrgId", (Object)useOrgId);
        fsp.setCustomParam(P_VALUE, value);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        fsp.setStatus(plugin.getView().getFormShowParameter().getStatus());
        plugin.getView().showForm(fsp);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        filterGrid.addBeforeF7SelectListener(evt -> {
            QFilter qFilter = this.getDimensionTypeQFilter(evt.getFieldName());
            if (qFilter != null) {
                evt.addCustomQFilter(qFilter);
            }
            evt.setUseOrgId(this.getUseOrg());
        });
    }

    public QFilter getDimensionTypeQFilter(String fieldName) {
        String dimensionNumber = fieldName.substring(0, fieldName.lastIndexOf("."));
        Long fmodel = this.getFmodel();
        CvprofitModel model = CvprofitModel.create((Object)fmodel);
        DynamicObject dimension = model.getDimension(dimensionNumber);
        return CvprofitBusinessHelper.getQFilterByDimension((DynamicObject)dimension);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("model");
        this.getModel().setValue("model", customParam);
    }

    public void afterBindData(EventObject e) {
        this.setInitFilterGridCondition();
    }

    private void setInitFilterGridCondition() {
        CvprofitModel model = CvprofitModel.create((Object)this.getFmodel());
        String entityNumber = model.getEntitynumber();
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        filterGrid.setEntityNumber(entityNumber);
        LinkedHashMap<String, Map> colMap = new LinkedHashMap<String, Map>(10);
        Map dimensionsMap = model.getDimensionsMap();
        Set dfieldNameSet = dimensionsMap.keySet().stream().filter(s -> !Objects.equals(s, model.getOrgNumber()) && !Objects.equals(s, model.getPeriodNumber())).collect(Collectors.toSet());
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        List allFilterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        for (Map fc : allFilterColumns) {
            String fieldName = String.valueOf(fc.get("fieldName"));
            String fieldCaption = (String)fc.get("fieldCaption");
            if (dfieldNameSet.contains(fieldName)) {
                this.clearSomeCpOption(fc);
                colMap.put(fieldName, fc);
                continue;
            }
            int charIndex = fieldName.lastIndexOf(46);
            String baseField = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
            if (!dfieldNameSet.contains(baseField) || !fieldName.endsWith(".name") && !fieldName.endsWith(".number") && !fieldName.endsWith(".longnumber")) continue;
            String baseFieldCaption = fieldCaption.substring(0, fieldCaption.indexOf(46));
            fc.put("fieldCaption", baseFieldCaption);
            this.clearSomeCpOption(fc);
            Map map = (Map)colMap.get(baseField);
            if (map != null) {
                if (!fieldName.endsWith(".name")) continue;
                colMap.put(baseField, fc);
                continue;
            }
            colMap.put(baseField, fc);
        }
        filterGrid.setFilterColumns(new ArrayList(colMap.values()));
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam(P_VALUE);
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.getView().updateView(CTRL_FILTERGRIDAP);
    }

    private void clearSomeCpOption(Map<String, Object> fc) {
        List list = (List)PAUtil.cast((Object)fc.get("compareTypes"));
        if ("datetime".equals(fc.getOrDefault("type", ""))) {
            if (list != null) {
                list.removeIf(dto -> !datetimeSet.contains(dto.getId()));
            }
        } else if (list != null) {
            list.removeIf(dto -> set.contains(dto.getId()));
        }
    }

    @Override
    protected void btnOk() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        String entityNumber = filterGrid.getEntityNumber();
        TagTextFiledData data = new TagTextFiledData("dt", "df");
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            try {
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber());
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), true);
                filterBuilder.buildFilter(false);
                filterGridState.getFilterCondition().setFilter(filterBuilder.getFilterObject().getFilter());
                FilterCondition filterCondition = filterGridState.getFilterCondition();
                String conditionJson = SerializationUtils.toJsonString((Object)filterCondition);
                List filterRow = filterCondition.getFilterRow();
                if (!filterRow.isEmpty()) {
                    CvprofitModel model = CvprofitModel.create((Object)this.getFmodel());
                    for (SimpleFilterRow row : filterRow) {
                        String fieldName = row.getFieldName();
                        if (!fieldName.endsWith(".name") || "9".equals(row.getCompareType()) || "37".equals(row.getCompareType()) || row.getValue().size() == row.getBaseDataIds().size()) continue;
                        int charIndex = fieldName.indexOf(46);
                        String baseField = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
                        String name = (String)model.getDimensionsMap().get(baseField);
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u6761\u4ef6\u503c\u5931\u6548\u6216\u9519\u8bef,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CvprofitFilterDialogPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), name));
                        return;
                    }
                }
                String desc = filterCondition.getFilter();
                data.setText(desc.substring(0, Math.min(desc.length(), 200)));
                data.setValue(conditionJson);
            }
            catch (Exception ex) {
                logger.error("pa.fas.fasfilterdialogplugin", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
                return;
            }
        }
        this.getView().returnDataToParent((Object)data);
        this.getView().close();
    }

    static {
        set.add("60");
        set.add("211");
        set.add("21");
        set.add("36");
        set.add("19");
        set.add("65");
        set.add("-1");
        set.add("-2");
        set.add("-3");
        set.add("-4");
        datetimeSet.add("501");
        datetimeSet.add("502");
        datetimeSet.add("1");
        datetimeSet.add("67");
        datetimeSet.add("21");
        datetimeSet.add("36");
    }
}

