/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.CvprofitFilterDialogPlugin;
import kd.fi.pa.cost.CvprofitSetDialogPlugin;
import kd.fi.pa.cost.formula.Factor;
import kd.fi.pa.cost.formula.Formula;
import kd.fi.pa.dto.TagTextFiledData;
import kd.fi.pa.utils.PAUtil;

public class CvprofitFormulaPlugin
extends CvprofitSetDialogPlugin {
    private static final Log logger = LogFactory.getLog(CvprofitFormulaPlugin.class);
    private static final String FORMID = "pa_cvprofitformula";
    private static final String P_VALUE = "set_value";
    private static final String ACTIONID_set_filter = "actionid_set_filter";
    private static final String ENTRY_ENTRYENTITY = "entryentity";

    public static void openBy(AbstractFormPlugin plugin, Object modelPkId, Object value, String useOrgId, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(FORMID);
        fsp.setCustomParam("model", modelPkId);
        fsp.setCustomParam("useOrgId", (Object)useOrgId);
        fsp.setCustomParam(P_VALUE, value);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        fsp.setStatus(plugin.getView().getFormShowParameter().getStatus());
        plugin.getView().showForm(fsp);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit measure = (BasedataEdit)this.getControl("m");
        measure.addBeforeF7SelectListener(event -> {
            DynamicObject dy = this.getModelDynamicObject();
            if (dy == null) {
                event.setCancel(true);
                return;
            }
            Set collect = dy.getDynamicObjectCollection("measure_entry").stream().map(dynamicObject -> dynamicObject.getDynamicObject("measure").getPkValue()).collect(Collectors.toSet());
            event.getCustomQFilters().add(new QFilter("id", "in", collect));
        });
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTRYENTITY);
            entryGrid.addCellClickListener(new CellClickListener(){

                public void cellClick(CellClickEvent evt) {
                    String fieldKey = evt.getFieldKey();
                    if (Objects.equals(fieldKey, "dt")) {
                        CvprofitFormulaPlugin.this.openSetDimensionFilter(true);
                    }
                }

                public void cellDoubleClick(CellClickEvent evt) {
                }
            });
        } else {
            this.addClickListeners(new String[]{"dt"});
        }
    }

    @Override
    public void createNewData(BizDataEventArgs e) {
        try {
            super.createNewData(e);
            this.reloadData(e.getDataEntity());
        }
        catch (Exception ex) {
            logger.error("\u52a0\u8f7d\u5206\u6790\u6a21\u578b\u53d6\u503c\u53d1\u751f\u9519\u8bef", (Throwable)ex);
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    private void reloadData(Object dataEntity) {
        String evaluation_tag;
        if (dataEntity instanceof DynamicObject && StringUtils.isNotEmpty((CharSequence)(evaluation_tag = (String)this.getView().getFormShowParameter().getCustomParam(P_VALUE)))) {
            Map tagMap = (Map)PAUtil.cast((Object)SerializationUtils.fromJsonString((String)evaluation_tag, Map.class));
            List list = (List)PAUtil.cast(tagMap.get("formulaMapList"));
            DynamicObjectCollection collection = ((DynamicObject)dataEntity).getDynamicObjectCollection(ENTRY_ENTRYENTITY);
            for (Object row : list) {
                Map map = (Map)PAUtil.cast(row);
                DynamicObject dynamicObject = collection.addNew();
                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    Object object = map.get(property.getName());
                    if (object == null) continue;
                    if (property instanceof BasedataProp) {
                        ((BasedataProp)property).setFieldValue(this.getModel(), (Object)dynamicObject, object);
                        continue;
                    }
                    property.setValueFast((Object)dynamicObject, object);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"dt") && StringUtils.isBlank((Object)(newValue = e.getChangeSet()[0].getNewValue()))) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTRYENTITY);
            this.getModel().setValue("df", null, rowIndex);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("dt".equals(control.getKey())) {
            this.openSetDimensionFilter(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        TagTextFiledData data;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (ACTIONID_set_filter.equals(actionId) && event.getReturnData() != null && (data = (TagTextFiledData)PAUtil.cast((Object)event.getReturnData())) != null) {
            data.fillValue(this.getModel(), ENTRY_ENTRYENTITY);
        }
    }

    @Override
    protected void btnOk() {
        TagTextFiledData data = new TagTextFiledData("evaluation");
        try {
            Long fmodel = this.getFmodel();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTRYENTITY);
            List mapList = CvprofitBusinessHelper.formulaEntryToMapList((DynamicObjectCollection)entryEntity);
            Factor factor = Formula.create((Long)fmodel, (List)mapList);
            data.setText(factor.toString());
            data.setValue(Formula.createTag((Long)fmodel, (List)mapList));
        }
        catch (Exception exception) {
            this.getView().showTipNotification(exception.getMessage());
            return;
        }
        this.getView().returnDataToParent((Object)data);
        this.getView().close();
    }

    private void openSetDimensionFilter(boolean view) {
        TagTextFiledData data = new TagTextFiledData("dt", "df").pickValue(this.getModel(), ENTRY_ENTRYENTITY);
        if (view && StringUtils.isEmpty((CharSequence)data.getValue())) {
            return;
        }
        CvprofitFilterDialogPlugin.openBy(this, this.getFmodel(), data.getValue(), String.valueOf(this.getUseOrg()), ACTIONID_set_filter);
    }
}

