/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.cost.CvprofitBoardPlugin;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.CvprofitDataSourceTypeEnum;
import kd.fi.pa.cost.CvprofitFormulaPlugin;
import kd.fi.pa.cost.EntryTreeNode;
import kd.fi.pa.cost.EntryTreeOperater;
import kd.fi.pa.dto.ChangeDataDTO;
import kd.fi.pa.dto.TagTextFiledData;
import kd.fi.pa.utils.PAUtil;

public class CvprofitSchemaEdit
extends AbstractFormPlugin {
    private static final String FORMID = "pa_cvprofitschema";
    private static final String F_MODEL = "model";
    private static final String ENTRY_TREEENTRYENTITY = "treeentryentity";
    private static final String F_E_evaluation = "evaluation";
    private static final String F_E_fixedvalue = "fixedvalue";
    private static final String CALLBACKID_deleteentry = "treeentryentity_deleteentry";
    private static final String CALLBACKID_insertentry = "treeentryentity_insertentry";
    private static final String CALLBACKID_downlevelentity = "treeentryentity_downlevelentity";
    private static final String CALLBACKID_changedata = "callbackid_changedata";
    private static final String ACTIONID_set_evaluation = "actionid_set_evaluation";
    private static final String TAG_DATACHANGE = "pa_cvprofitschema_is_datachange";

    public static void openByView(AbstractFormPlugin plugin, Object value) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId(FORMID);
        fsp.setHasRight(true);
        fsp.setPkId((Object)DB.genGlobalLongId());
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setCustomParam("viewinfo", value);
        plugin.getView().showForm((FormShowParameter)fsp);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{F_E_evaluation});
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (F_E_evaluation.equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    CvprofitSchemaEdit.this.openEvaluationSettingDialog();
                }
            };
            control.setKey(F_E_evaluation);
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    private void openEvaluationSettingDialog() {
        DynamicObject model = this.getFmodel();
        if (model == null) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_TREEENTRYENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_TREEENTRYENTITY);
        EntryTreeNode root = CvprofitBusinessHelper.buildTreeNode((DynamicObjectCollection)entryEntity);
        EntryTreeNode node = root.getNode(Integer.valueOf(rowIndex));
        if (node.isLeaf()) {
            Object value = this.getModel().getValue("evaluation_tag", rowIndex);
            CvprofitFormulaPlugin.openBy(this, model.getPkValue(), value, this.getUseOrgId(), ACTIONID_set_evaluation);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit modelF7 = (BasedataEdit)this.getControl(F_MODEL);
        modelF7.addBeforeF7SelectListener(event -> {
            event.addCustomQFilter(new QFilter("analysis_system.number", "is not null", null).and("analysis_system.enable", "=", (Object)Character.valueOf('1')).and("tablenumber", "!=", (Object)Character.valueOf(' ')).and("tablenumber", "is not null", null));
            Set ids = CvprofitBusinessHelper.queryNotDateTimeModelSet();
            event.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        });
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        Object viewinfo = this.getView().getFormShowParameter().getCustomParam("viewinfo");
        if (viewinfo instanceof String) {
            MainEntityType type = this.getModel().getDataEntityType();
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            DynamicObject schema = (DynamicObject)jser.deserializeFromString((String)viewinfo, null);
            BusinessDataReader.loadRefence((Object[])new DynamicObject[]{schema}, (IDataEntityType)type);
            e.setDataEntity(schema);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
        operater.expandAll();
        operater.refreshLock();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object object = ThreadCache.get((Object)TAG_DATACHANGE);
        if ("ignore".equals(object)) {
            ThreadCache.remove((Object)TAG_DATACHANGE);
            return;
        }
        String propName = e.getProperty().getName();
        if (Objects.equals(propName, "datasourcetype")) {
            ChangeDataDTO dto = new ChangeDataDTO(propName, e.getChangeSet());
            if (Objects.equals(dto.getOldValue(), "1") && this.allEmpty("evaluation_tag")) {
                return;
            }
            if (Objects.equals(dto.getOldValue(), "2") && this.allEmpty(F_E_fixedvalue)) {
                return;
            }
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CALLBACKID_changedata, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u6570\u636e\u6e90\u5c06\u6e05\u7a7a\u65b9\u6848\u5b9a\u4e49\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u66f4\u6539\uff1f", (String)"CvprofitSchemaEdit_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Save, listener, null, SerializationUtils.toJsonString((Object)dto));
        } else if (Objects.equals(propName, F_MODEL)) {
            if (this.allEmpty("evaluation_tag")) {
                return;
            }
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CALLBACKID_changedata, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5206\u6790\u6a21\u578b\u5c06\u6e05\u7a7a\u65b9\u6848\u5b9a\u4e49\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u66f4\u6539\uff1f", (String)"CvprofitSchemaEdit_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Save, listener, null, SerializationUtils.toJsonString((Object)new ChangeDataDTO(propName, e.getChangeSet())));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("insertentry".equalsIgnoreCase(operateKey)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            if (operater.cancelInsertentry()) {
                args.setCancel(true);
                return;
            }
            EntryTreeNode selectNode = operater.getSelectNode();
            if (selectNode != null && selectNode.isLeaf() && selectNode.filled()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u589e\u52a0\u4e0b\u7ea7\u5c06\u6e05\u7a7a\u5f53\u524d\u8282\u70b9\u7684\u5c5e\u6027\u548c\u53d6\u503c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u589e\u52a0\uff1f", (String)"CvprofitSchemaEdit_5", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_insertentry, (IFormPlugin)this));
                args.setCancel(true);
            }
        } else if ("deleteentry".equalsIgnoreCase(operateKey)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            if (operater.containNotLeaf()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u975e\u660e\u7ec6\u8282\u70b9\uff0c\u5c06\u4f1a\u540c\u65f6\u5220\u9664\u5176\u4e0b\u7ea7\u8282\u70b9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CvprofitSchemaEdit_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_deleteentry, (IFormPlugin)this));
                args.setCancel(true);
            }
        } else if ("uplevelentity".equalsIgnoreCase(operateKey)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            operater.uplevel();
            args.setCancel(true);
        } else if ("downlevelentity".equalsIgnoreCase(operateKey)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            if (operater.cancelDownlevelentity()) {
                args.setCancel(true);
                return;
            }
            EntryTreeNode brotherNode = operater.getPreBrotherNode();
            if (brotherNode != null && brotherNode.isLeaf() && brotherNode.filled()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u964d\u7ea7\u5c06\u6e05\u7a7a\u4e0a\u7ea7\u8282\u70b9\u7684\u5c5e\u6027\u548c\u53d6\u503c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u964d\u7ea7\uff1f", (String)"CvprofitSchemaEdit_6", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_downlevelentity, (IFormPlugin)this));
            } else {
                operater.downlevel();
            }
            args.setCancel(true);
        } else if ("copyentryrow".equalsIgnoreCase(operateKey)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            operater.copyentryrow();
            args.setCancel(true);
        } else if ("enable".equals(operateKey)) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (PAUtil.idIsNull((Object)pkValue) || this.getModel().getDataChanged()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5206\u6790\u65b9\u6848\u3002", (String)"CvprofitSchemaEdit_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (formOperate instanceof Save) {
            this.getModel().setValue("enable", (Object)Character.valueOf('0'));
            if (!Objects.equals(CvprofitDataSourceTypeEnum.MODEL.getCode(), this.getModel().getValue("datasourcetype"))) {
                this.getModel().setValue(F_MODEL, null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (result != null && !result.isSuccess()) {
            return;
        }
        if ("deleteentry".equals(operateKey) || "moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey)) {
            new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY).clearAndLock();
        } else if ("insertentry".equals(operateKey)) {
            new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY).refresh();
        } else if ("cvpboard".equals(operateKey)) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (PAUtil.idIsNull((Object)pkValue) || this.getModel().getDataChanged()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5206\u6790\u65b9\u6848\u3002", (String)"CvprofitSchemaEdit_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            } else if (!Objects.equals(this.getModel().getValue("enable"), "1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5206\u6790\u65b9\u6848\u3002", (String)"CvprofitSchemaEdit_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            } else {
                CvprofitBoardPlugin.openBy(this, this.getUseOrgId(), FORMID, pkValue);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        TagTextFiledData data;
        String actionId = e.getActionId();
        if (ACTIONID_set_evaluation.equals(actionId) && e.getReturnData() != null && (data = (TagTextFiledData)PAUtil.cast((Object)e.getReturnData())) != null) {
            data.fillValue(this.getModel(), ENTRY_TREEENTRYENTITY);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (callBackId.equals(CALLBACKID_deleteentry) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            operater.deleteentry();
            operater.refresh();
        } else if (callBackId.equals(CALLBACKID_insertentry) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_TREEENTRYENTITY);
            this.getModel().beginInit();
            this.getModel().setValue("attribute", null, rowIndex);
            this.getModel().setValue(F_E_evaluation, null, rowIndex);
            this.getModel().setValue("evaluation_tag", null, rowIndex);
            this.getModel().setValue(F_E_fixedvalue, null, rowIndex);
            this.getModel().endInit();
            this.getModel().updateCache();
            this.getView().invokeOperation("insertentry");
        } else if (callBackId.equals(CALLBACKID_downlevelentity) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            EntryTreeOperater operater = new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY);
            operater.downlevel();
            operater.refresh();
        } else if (CALLBACKID_changedata.equals(callBackId)) {
            String customVaule = event.getCustomVaule();
            ChangeDataDTO dto = (ChangeDataDTO)SerializationUtils.fromJsonString((String)customVaule, ChangeDataDTO.class);
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                ThreadCache.put((Object)TAG_DATACHANGE, (Object)"ignore");
                if ("datasourcetype".equals(dto.getPropName())) {
                    this.getModel().setValue(F_MODEL, null);
                    this.clearData();
                } else if (F_MODEL.equals(dto.getPropName())) {
                    this.clearData();
                }
            } else {
                ThreadCache.put((Object)TAG_DATACHANGE, (Object)"ignore");
                Object oldValue = dto.getOldValue();
                if (oldValue instanceof Map) {
                    this.getModel().setValue(dto.getPropName(), ((Map)oldValue).get("id"));
                } else {
                    this.getModel().setValue(dto.getPropName(), oldValue);
                }
                this.getView().updateView(ENTRY_TREEENTRYENTITY);
            }
        }
    }

    private boolean allEmpty(String field) {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRY_TREEENTRYENTITY);
        for (DynamicObject data : datas) {
            Object object = data.get(field);
            if (!StringUtils.isNotBlank((Object)object)) continue;
            return false;
        }
        return true;
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.beginInit();
        int entryRowCount = model.getEntryRowCount(ENTRY_TREEENTRYENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue(F_E_fixedvalue, null, i);
            this.getModel().setValue(F_E_evaluation, null, i);
            this.getModel().setValue("evaluation_tag", null, i);
        }
        model.endInit();
        this.getView().updateView(ENTRY_TREEENTRYENTITY);
        new EntryTreeOperater(this.getView(), ENTRY_TREEENTRYENTITY).refreshLock();
    }

    private DynamicObject getFmodel() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue(F_MODEL);
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"CvprofitSchemaEdit_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }

    private String getUseOrgId() {
        return String.valueOf(this.getModel().getValue("useorg_id"));
    }
}

