/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.pa.cost.CtrlUnitUseOrg;
import kd.fi.pa.cost.CvprofitBoadCusViewHelper;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.CvprofitSchemaEdit;
import kd.fi.pa.cost.data.CvprofitQueryParam;
import kd.fi.pa.cost.data.CvprofitSnapshoot;
import kd.fi.pa.utils.PAUtil;

public class CvprofitSnapshootEdit
extends AbstractFormPlugin {
    private static final String FORMID = "pa_cvprofitsnapshootas";
    private static final String F_CREATEORG = "schemaorg";
    private static final String P_VALUE = "snapshootinfo_tag";

    public static void openByAsNew(AbstractFormPlugin plugin, Object value, String useOrgId) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(FORMID);
        fsp.setCustomParam("useorg", (Object)useOrgId);
        fsp.setCustomParam(P_VALUE, value);
        plugin.getView().showForm((FormShowParameter)fsp);
    }

    public void initialize() {
        this.getView().addCustomControls(new String[]{"snapshootinfo"});
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if ("snapshootinfo".equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    CvprofitSnapshootEdit.this.detailClickSnapshootinfo();
                }
            };
            control.setKey("snapshootinfo");
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    private void detailClickSnapshootinfo() {
        CvprofitSnapshoot snapshoot = CvprofitSnapshoot.create((DynamicObject)this.getModel().getDataEntity());
        CvprofitSchemaEdit.openByView(this, snapshoot.getSchemaInfo());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit orgF7 = (BasedataEdit)this.getControl(F_CREATEORG);
        orgF7.addBeforeF7SelectListener(event -> {
            CtrlUnitUseOrg useOrg = CtrlUnitUseOrg.create((String)"pa_cvprofitschema");
            event.addCustomQFilter(new QFilter("id", "in", (Object)useOrg.getAllUseOrgIds()));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object snapshootinfo_tag = fsp.getCustomParam(P_VALUE);
        this.getModel().setValue(P_VALUE, snapshootinfo_tag);
        Object useorg = fsp.getCustomParam("useorg");
        if (useorg instanceof String) {
            this.getModel().setValue(F_CREATEORG, (Object)Long.valueOf((String)useorg));
        } else {
            CtrlUnitUseOrg unitUseOrg = CtrlUnitUseOrg.create((String)"pa_cvprofitschema");
            String defaultUseOrg = unitUseOrg.getDefaultUseOrg();
            this.getModel().setValue(F_CREATEORG, (Object)Long.valueOf(defaultUseOrg));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        CvprofitSnapshoot snapshoot = CvprofitSnapshoot.create((DynamicObject)dataEntity);
        CvprofitQueryParam queryParam = snapshoot.getCvprofitQueryParam();
        this.getModel().beginInit();
        this.getModel().setValue("snapshootinfo", (Object)queryParam.getName());
        this.getModel().setValue("fromanalysistype", (Object)queryParam.getAnalysistype());
        this.getModel().setValue("fromanalysisobject", (Object)queryParam.getAnalysisobjectId());
        CvprofitBusinessHelper.bindSnapshootInfo((IDataModel)this.getModel(), (CvprofitQueryParam)queryParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put("setval_edit_model", "view");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperationResult result = args.getOperationResult();
        if (result != null && !result.isSuccess()) {
            return;
        }
        String entityId = this.getView().getFormShowParameter().getFormId();
        if (formOperate instanceof Save && Objects.equals("pa_cvprofitsnapshoot", entityId)) {
            CvprofitBoadCusViewHelper.send_event(this.getView(), "save", null);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (Objects.equals(itemKey, "tblsnapshootview")) {
            LargeTextEdit edit = (LargeTextEdit)this.getControl("snapshootinfo");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ide_largertextedit");
            showParameter.setCaption(edit.getProperty().getDisplayName().toString());
            showParameter.setCustomParam("lock", (Object)Boolean.TRUE);
            String largeTextValue = (String)this.getModel().getValue(P_VALUE, 0);
            showParameter.setCustomParam("largeTextValue", (Object)largeTextValue);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void customEvent(CustomEventArgs e) {
        Object pkvalue;
        String key = e.getKey();
        String eventName = e.getEventName();
        if ("cvprofitboard".equals(key) && "mounted".equals(eventName)) {
            Object pkvalue2 = this.getModel().getValue("id");
            if (PAUtil.idNotNull((Object)pkvalue2)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"cvprofitboard"});
                CvprofitBoadCusViewHelper.sendRefreshSnapShoot(this.getView(), (Long)pkvalue2);
                this.getView().updateView("cvprofitboard");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"cvprofitboard"});
            }
        } else if ("cvprofitboard".equals(key) && "save".equals(eventName) && PAUtil.idNotNull((Object)(pkvalue = this.getModel().getValue("id")))) {
            String eventArgs = e.getEventArgs();
            CvprofitSnapshoot cvprofitSnapshoot = CvprofitSnapshoot.create((Object)pkvalue);
            String snapshoot = cvprofitSnapshoot.updateSnapshoot(eventArgs);
            this.getModel().setValue(P_VALUE, (Object)snapshoot);
            OperationResult operate = OperationServiceHelper.executeOperate((String)"save", (String)this.getView().getEntityId(), (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
            if (!operate.isSuccess()) {
                this.getView().showOperationResult(operate);
            } else {
                this.getModel().setDataChanged(false);
            }
        }
    }
}

