/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.dto;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.fi.pa.utils.PAUtil;

public class TagTextFiledData
implements Serializable {
    private static final long serialVersionUID = 5724147110201845897L;
    private final String textnumber;
    private final String valuenumber;
    private String text;
    private String value;

    public TagTextFiledData(String textnumber) {
        this.textnumber = textnumber;
        this.valuenumber = textnumber + "_tag";
    }

    public TagTextFiledData(String textnumber, String valuenumber) {
        this.textnumber = textnumber;
        this.valuenumber = valuenumber;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TagTextFiledData pickValue(IDataModel model) {
        this.text = (String)model.getValue(this.textnumber);
        this.value = (String)model.getValue(this.valuenumber);
        return this;
    }

    public TagTextFiledData pickValue(IDataModel model, String entryentity) {
        int rowIndex = model.getEntryCurrentRowIndex(entryentity);
        this.text = (String)model.getValue(this.textnumber, rowIndex);
        this.value = (String)model.getValue(this.valuenumber, rowIndex);
        return this;
    }

    public void fillValue(IDataModel model, String entryentity) {
        int rowIndex = model.getEntryCurrentRowIndex(entryentity);
        model.setValue(this.textnumber, (Object)this.text, rowIndex);
        model.setValue(this.valuenumber, (Object)this.value, rowIndex);
    }

    public boolean datachange(IDataModel model) {
        Object modelValue = model.getValue(this.valuenumber);
        return Objects.equals(modelValue, this.value);
    }

    public void fillValue(IDataModel model) {
        model.setValue(this.textnumber, (Object)this.text);
        model.setValue(this.valuenumber, (Object)this.value);
    }

    public void callBackValue(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            if (!data.isEmpty()) {
                String idcollect = data.stream().map(row -> String.valueOf(row.getPrimaryKeyValue())).collect(Collectors.joining(","));
                this.setValue(idcollect);
                String desccollect = data.stream().limit(100L).map(ListSelectedRow::getName).collect(Collectors.joining(","));
                this.setValue(idcollect);
                if (data.size() > 100 || desccollect.length() > 200) {
                    desccollect = desccollect.substring(0, Math.min(200, desccollect.length())) + "...";
                }
                this.setText(desccollect);
            }
        } else if (returnData instanceof Map) {
            Map map = (Map)PAUtil.cast((Object)returnData);
            this.setValue((String)map.get("value"));
            this.setText((String)map.get("text"));
        } else if (returnData instanceof String) {
            this.setValue((String)returnData);
            this.setText((String)returnData);
        } else {
            throw new KDBizException("not support this closedCallBack returnData");
        }
    }
}

