/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.PAExecutionLogPluginUtils;
import kd.fi.pa.helper.PARuleHelper;
import org.apache.commons.lang3.StringUtils;

public class ExecutionLogListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ExecutionLogListPlugin.class);
    private static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        PARuleHelper.processFilterItemSelectedByDefault((FilterContainerSearchClickArgs)args, (IPageCache)this.getPageCache(), (String)(currentCommonFilter == null ? "" : ((List)currentCommonFilter.get("FieldName")).get(0).toString()), (String)"analysis_system.id", (String)"analysis_model.id");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IListView listView = (IListView)this.getView();
        IPageCache pageCache = this.getPageCache();
        pageCache.put("modelComboItem", null);
        ControlFilters controlFilters = listView.getControlFilters();
        FormShowParameter fsp = listView.getFormShowParameter();
        FilterColumn systemFilter = args.getFilterColumn("analysis_system.name");
        FilterColumn modelFilter = args.getFilterColumn("analysis_model.name");
        FilterColumn periodFilter = args.getFilterColumn("startperiod.name");
        if (controlFilters == null) {
            List systemComboItem = PARuleHelper.getComboItems((String)"pa_anasystemsetting", (QFilter)enableFilter);
            if (systemComboItem.isEmpty()) {
                PARuleHelper.setComboItems((FilterColumn)modelFilter, (List)PARuleHelper.getEmptyComboItems());
                PARuleHelper.setComboItems((FilterColumn)periodFilter, (List)PARuleHelper.getEmptyComboItems());
                return;
            }
            Object org = fsp.getCustomParam("org_field");
            Object analysisSystem = fsp.getCustomParam("analysis_system");
            Object analysisModel = fsp.getCustomParam("analysis_model");
            Object period = fsp.getCustomParam("startperiod");
            FilterColumn orgFilterColumn = args.getFilterColumn("org_field.name");
            orgFilterColumn.setDefaultValue(org != null ? String.valueOf(org) : null);
            PARuleHelper.setComboItems((FilterColumn)systemFilter, (List)systemComboItem);
            String systemIdStr = analysisSystem != null ? String.valueOf(analysisSystem) : ((ComboItem)systemComboItem.get(0)).getValue();
            systemFilter.setDefaultValue(systemIdStr);
            PARuleHelper.setComboItems((FilterColumn)modelFilter, (List)PARuleHelper.getEmptyComboItems());
            modelFilter.setDefaultValue(null);
            PARuleHelper.setComboItems((FilterColumn)periodFilter, (List)PARuleHelper.getEmptyComboItems());
            periodFilter.setDefaultValue(null);
            if (analysisModel != null) {
                QFilter modelQFilter = new QFilter("analysis_system", "=", (Object)Long.parseLong(systemIdStr)).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter());
                List modelComboItems = PARuleHelper.getComboItems((String)"pa_analysismodel", (QFilter)modelQFilter);
                PARuleHelper.setComboItems((FilterColumn)modelFilter, (List)modelComboItems);
                String analysisModelStr = analysisModel.toString();
                modelFilter.setDefaultValue(analysisModelStr);
                if (modelFilter instanceof CommonFilterColumn) {
                    pageCache.put("modelComboItem", analysisModelStr);
                }
                if (!modelComboItems.isEmpty()) {
                    DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(analysisModelStr), (String)"pa_analysismodel");
                    String periodEntity = FormPluginUtil.getBaseEntityId(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                    if (StringUtils.isBlank((CharSequence)periodEntity)) {
                        this.removeFilterColumns(args, "startperiod.name");
                        return;
                    }
                    QFilter periodQFilter = FormPluginUtil.getBaseQFilter(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                    List periodComboItems = PARuleHelper.getComboItems((String)periodEntity, (QFilter)periodQFilter, (String)"id,name", (String)"number");
                    PARuleHelper.setComboItems((FilterColumn)periodFilter, (List)periodComboItems);
                    if (period != null) {
                        periodFilter.setDefaultValue(period.toString());
                    }
                }
            }
        } else {
            List systemList = controlFilters.getFilter("analysis_system.id");
            if (systemList != null && !systemList.isEmpty()) {
                QFilter modelQFilter = new QFilter("analysis_system", "=", (Object)Long.parseLong((String)systemList.get(0))).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter());
                List systemComboItems = PARuleHelper.getComboItems((String)"pa_analysismodel", (QFilter)modelQFilter);
                PARuleHelper.setComboItems((FilterColumn)modelFilter, (List)systemComboItems);
                String currentModelValue = CollectionUtils.isEmpty((Collection)systemComboItems) ? null : ((ComboItem)systemComboItems.get(0)).getValue();
                modelFilter.setDefaultValue(currentModelValue);
                if (modelFilter instanceof CommonFilterColumn) {
                    pageCache.put("modelComboItem", currentModelValue);
                }
            } else {
                PARuleHelper.setComboItems((FilterColumn)modelFilter, (List)PARuleHelper.getEmptyComboItems());
                modelFilter.setDefaultValue(null);
                PARuleHelper.setComboItems((FilterColumn)periodFilter, (List)PARuleHelper.getEmptyComboItems());
                periodFilter.setDefaultValue(null);
            }
            List modelList = controlFilters.getFilter("analysis_model.id");
            if (modelList != null && !modelList.isEmpty()) {
                DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong((String)modelList.get(0)), (String)"pa_analysismodel");
                String periodEntity = FormPluginUtil.getBaseEntityId(modelObj, DimensionNecessityEnum.PERIOD.getCode());
                if (StringUtils.isBlank((CharSequence)periodEntity)) {
                    this.removeFilterColumns(args, "startperiod.name");
                    return;
                }
                QFilter periodQFilter = FormPluginUtil.getBaseQFilter(modelObj, DimensionNecessityEnum.PERIOD.getCode());
                List periodComboItems = PARuleHelper.getComboItems((String)periodEntity, (QFilter)periodQFilter, (String)"id,name", (String)"number");
                PARuleHelper.setComboItems((FilterColumn)periodFilter, (List)periodComboItems);
            } else {
                PARuleHelper.setComboItems((FilterColumn)periodFilter, (List)PARuleHelper.getEmptyComboItems());
                periodFilter.setDefaultValue(null);
            }
        }
    }

    private void removeFilterColumns(FilterContainerInitArgs args, String fieldName) {
        List commonFilterColumns = args.getCommonFilterColumns();
        commonFilterColumns.removeIf(p -> fieldName.equals(p.getFieldName()));
        List schemeFilterColumns = args.getSchemeFilterColumns();
        schemeFilterColumns.removeIf(p -> fieldName.equals(p.getFieldName()));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        IFormView view = this.getView();
        String fieldName = args.getFieldName();
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        List qFilters = args.getQfilters();
        switch (fieldName) {
            case "analysis_model.id": {
                List anaSysList = controlFilters.getFilter("analysis_system.id");
                if (anaSysList == null || anaSysList.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"ExecutionLogListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                qFilters.add(new QFilter("analysis_system", "=", (Object)Long.parseLong(anaSysList.get(0).toString())).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter()));
                break;
            }
            case "analysis_model.name": {
                List anaSysList = controlFilters.getFilter("analysis_system.name");
                if (anaSysList == null || anaSysList.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"ExecutionLogListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                DynamicObjectCollection anaSystem = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])new QFilter("name", "=", anaSysList.get(0)).and(enableFilter).toArray());
                HashSet modelIdSet = new HashSet(anaSystem.size());
                anaSystem.forEach(dyo -> modelIdSet.add(dyo.get("id")));
                qFilters.add(new QFilter("analysis_system", "in", modelIdSet).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter()));
                break;
            }
            case "startperiod.id": {
                List analysisModelList = controlFilters.getFilter("analysis_model.id");
                if (analysisModelList == null || analysisModelList.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"ExecutionLogListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String analysisModelStr = analysisModelList.get(0).toString();
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(analysisModelStr), (String)"pa_analysismodel");
                args.setRefEntityId(FormPluginUtil.getBaseEntityId(analysisModelObj, "1"));
                qFilters.add(FormPluginUtil.getBaseQFilter(analysisModelObj, "1"));
                break;
            }
            case "startperiod.name": {
                List analysisModelList = controlFilters.getFilter("analysis_model.name");
                if (analysisModelList == null || analysisModelList.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"ExecutionLogListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String analysisModelName = analysisModelList.get(0).toString();
                if (analysisModelName == null || analysisModelName.isEmpty()) break;
                DynamicObject analysisModelIdObj = QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter("name", "=", (Object)analysisModelName).toArray());
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelIdObj.getLong("id"), (String)"pa_analysismodel");
                args.setRefEntityId(FormPluginUtil.getBaseEntityId(analysisModelObj, "1"));
                qFilters.add(FormPluginUtil.getBaseQFilter(analysisModelObj, "1"));
                break;
            }
        }
    }

    private DynamicObject getDynamicObj(Object pk, String entity) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entity);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        if (pageData == null || pageData.isEmpty()) {
            return;
        }
        ArrayList<Long> dimIdList = new ArrayList<Long>(pageData.size());
        block0: for (DynamicObject data : pageData) {
            DynamicObjectCollection dimCol = data.getDynamicObject("analysis_model").getDynamicObjectCollection("dimension_entry");
            for (DynamicObject dyo : dimCol) {
                if (!DimensionNecessityEnum.PERIOD.getCode().equals(dyo.getString("necessity_dim"))) continue;
                dimIdList.add(dyo.getLong("dimension_id"));
                continue block0;
            }
        }
        Map dimMap = BusinessDataServiceHelper.loadFromCache((Object[])new HashSet(dimIdList).toArray(), (String)"pa_dimension");
        int i = 0;
        boolean propExist = ((DynamicObject)pageData.get(0)).getDynamicObjectType().getProperties().get((Object)"startperiod") != null;
        for (DynamicObject data : pageData) {
            Object periodId;
            String baseEntityId;
            if ("bd_period".equals(baseEntityId = FormPluginUtil.getBaseEntityIdByDimension((DynamicObject)dimMap.get(dimIdList.get(i++)))) || !propExist || data.get("startperiod") != null || (periodId = data.get("startperiod_id")) == null) continue;
            data.set("startperiod", (Object)this.getDynamicObj(periodId, baseEntityId));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("modify".equals(operateKey)) {
            try {
                long userId = RequestContext.get().getCurrUserId();
                Object executionLogPkId = null;
                if (args.getListSelectedData().size() == 1) {
                    executionLogPkId = args.getListSelectedData().get(0).getPrimaryKeyValue();
                }
                if (!PAExecutionLogPluginUtils.hasOrgRight(userId, "47150e89000000ac", executionLogPkId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6267\u884c\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecutionLogListPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
            catch (Exception e) {
                logger.error("verify user execution log right error", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u6267\u884c\u65e5\u5fd7\u201d\u64cd\u4f5c\u6743\u9650\u5931\u8d25\u3002", (String)"ExecutionLogListPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

