/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.model.TaskInst;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.TaskExecuteEngineService;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.ExecutionTypeEnum;
import kd.fi.pa.enums.WriteOffTypeEnum;
import kd.fi.pa.formplugin.util.DimensionDyUtil;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.PAExecutionLogPluginUtils;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;

public class ExecutionResultFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ExecutionResultFormPlugin.class);

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("adjustentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        Object periodId;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        String baseEntity = (String)model.getValue("itemclasstypefield");
        if (StringUtils.isNotEmpty((String)baseEntity) && model.getValue("startperiod") != null && (periodId = model.getValue("startperiod_id")) != null) {
            model.setValue("startperiod", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)baseEntity));
        }
        DimensionTypeEnum periodDimensionType = DimensionDyUtil.getDimensionTypeCodeFromNess((Long)model.getValue("analysis_model_id"), DimensionNecessityEnum.PERIOD);
        view.setVisible(Boolean.FALSE, new String[]{"daterange", "startperiod"});
        if (periodDimensionType == DimensionTypeEnum.DATE) {
            view.setVisible(Boolean.TRUE, new String[]{"daterange"});
        } else if (periodDimensionType == DimensionTypeEnum.DATABASE || periodDimensionType == DimensionTypeEnum.PERIOD) {
            view.setVisible(Boolean.TRUE, new String[]{"startperiod"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"itemclasstypefield"});
        String executionMode = (String)model.getValue("execution_mode");
        if (ExecutionModeEnum.writeOff.getCodeString().equals(executionMode)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        } else if (ExecutionModeEnum.execute.getCodeString().equals(executionMode)) {
            view.setVisible(Boolean.FALSE, new String[]{"adjustentry"});
            String executionStatus = (String)model.getValue("execution_status");
            boolean executeFailure = PASyncLogStatusEnum.FAILURE.getCodeString().equals(executionStatus);
            view.setVisible(Boolean.valueOf(!executeFailure), new String[]{"operate", "entry_writeoffstatus"});
            view.setVisible(Boolean.valueOf(executeFailure), new String[]{"entry_executiontime", "entry_executionstatus"});
            Container hideContainer = (Container)this.getControl(executeFailure ? "flexpanelap" : "flexpanelap1");
            hideContainer.setCollapseable(false);
            int entryRowCount = model.getEntryRowCount("entryentity");
            if (executeFailure && entryRowCount > 0) {
                String entryStatus = (String)model.getValue("entry_executionstatus", entryRowCount - 1);
                if (PASyncLogStatusEnum.FAILURE.getCodeString().equals(entryStatus)) {
                    EntryGrid entry = (EntryGrid)this.getControl("entryentity");
                    ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(1);
                    CellStyle cellStyle = new CellStyle();
                    cellStyle.setRow(entryRowCount - 1);
                    cellStyle.setForeColor("red");
                    cellStyle.setFieldKey("entry_executionstatus");
                    cellStyleList.add(cellStyle);
                    entry.setCellStyle(cellStyleList);
                }
            }
        } else if (ExecutionModeEnum.adjust.getCodeString().equals(executionMode)) {
            Container hideContainer = (Container)this.getControl("flexpanelap1");
            hideContainer.setCollapseable(false);
            view.setVisible(Boolean.FALSE, new String[]{"entryentity"});
            view.setVisible(Boolean.TRUE, new String[]{"adjustentry"});
            int adjustEntryRow = model.getEntryRowCount("adjustentry");
            HashSet<Long> adjustIdSet = new HashSet<Long>(adjustEntryRow);
            for (int i = 0; i < adjustEntryRow; ++i) {
                Long currentRowAdjustId = (Long)model.getValue("adjustid", i);
                adjustIdSet.add(currentRowAdjustId);
            }
            HashMap<Long, Tuple> infoMap = new HashMap<Long, Tuple>(adjustEntryRow);
            QFilter idFilter = new QFilter("id", "in", adjustIdSet);
            DynamicObjectCollection adjustCol = QueryServiceHelper.query((String)"pa_dataadjust", (String)"id,billno,adjuststatus", (QFilter[])idFilter.toArray());
            if (adjustCol != null && !adjustCol.isEmpty()) {
                for (DynamicObject adjustObj : adjustCol) {
                    infoMap.put(adjustObj.getLong("id"), new Tuple((Object)adjustObj.getString("billno"), (Object)adjustObj.getString("adjuststatus")));
                }
            }
            for (int i = 0; i < adjustEntryRow; ++i) {
                Long currentRowAdjustId = (Long)model.getValue("adjustid", i);
                Tuple numberAndOffStatus = (Tuple)infoMap.get(currentRowAdjustId);
                if (numberAndOffStatus == null) continue;
                model.setValue("adjustnumber", numberAndOffStatus.item1, i);
                model.setValue("writeoffstatus", numberAndOffStatus.item2, i);
            }
            view.updateView("adjustentry");
        }
        model.endInit();
        view.updateView("fieldsetpanelap");
        model.setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String modelNewVersionMsg;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Long execLogId = (Long)this.getModel().getValue("id");
        Long modelId = (Long)this.getModel().getValue("analysis_model_id");
        if (("viewdata".equals(args.getOperateKey()) || "writeoff".equals(args.getOperateKey())) && StringUtils.isNotEmpty((String)(modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId)))) {
            this.getView().showTipNotification(modelNewVersionMsg);
            return;
        }
        switch (args.getOperateKey()) {
            case "viewdata": {
                Long ruleId = (Long)this.getModel().getValue("rule_pk", rowIndex);
                QFilter ruleExecLogFilter = new QFilter("execution_logpk", "=", (Object)execLogId).and(new QFilter("rule_pk", "=", (Object)ruleId));
                DynamicObject ruleExecLog = QueryServiceHelper.queryOne((String)"pa_ruleexeclog", (String)"id,detailtime", (QFilter[])ruleExecLogFilter.toArray());
                if (ruleExecLog == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u89c4\u5219\u6267\u884c\u65e5\u5fd7\u3002", (String)"ExecutionResultFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long detailTime = ruleExecLog.getLong("detailtime");
                Long ruleLogId = ruleExecLog.getLong("id");
                this.openResultTracePage(execLogId, ruleLogId, detailTime);
                break;
            }
            case "writeoff": {
                String writeOffStatus = (String)this.getModel().getValue("entry_writeoffstatus", rowIndex);
                if ("4".equals(writeOffStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u6570\u636e\u5df2\u51b2\u9500\uff0c\u65e0\u9700\u91cd\u590d\u5904\u7406\u3002", (String)"ExecutionResultFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u540e\u5c06\u6e05\u9664\u6240\u9009\u89c4\u5219\u53ca\u4e4b\u540e\u76f8\u540c\u7ec4\u7ec7\u548c\u671f\u95f4\u5185\u6267\u884c\u7684\u89c4\u5219\u7684\u6240\u6709\u4e1a\u52a1\u5904\u7406\u7ed3\u679c\uff0c\u6062\u590d\u81f3\u6570\u636e\u540c\u6b65\u540e\u7684\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"ExecutionResultFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("entry_writeoffstatus", (IFormPlugin)this));
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("adjustnumber".equals(fieldName)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            IDataModel model = this.getModel();
            Long adjustId = (Long)model.getValue("adjustid", rowIndex);
            BillShowParameter bsp = new BillShowParameter();
            bsp.setPkId((Object)adjustId);
            bsp.setFormId("pa_dataadjust");
            bsp.setStatus(OperationStatus.VIEW);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String result = event.getResultValue();
        if (MessageBoxResult.Yes.name().equals(result)) {
            try {
                IDataModel model = this.getModel();
                IFormView view = this.getView();
                String callBackId = event.getCallBackId();
                if ("entry_writeoffstatus".equals(callBackId)) {
                    int rowIndex = model.getEntryCurrentRowIndex("entryentity");
                    Long id = (Long)model.getValue("id");
                    Long logRuleEntryId = (Long)((DynamicObject)model.getEntryEntity("entryentity").get(rowIndex)).get("id");
                    Long currentBusinessRuleId = (Long)model.getValue("entry_businessrule_id", rowIndex);
                    ExecutionLogDTO executionLog = this.buildDto();
                    executionLog.setEditLogId(id);
                    executionLog.setCurrentRowBusinessRuleId(currentBusinessRuleId);
                    executionLog.setWriteOffType(WriteOffTypeEnum.SINGLE_RULE.getCode());
                    executionLog.setLogRuleEntryId(logRuleEntryId);
                    if (logRuleEntryId > 0L) {
                        if (executionLog.getOrgIds() == null || executionLog.getOrgIds().length == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7\u4e2d\u7ec4\u7ec7\u548c\u6267\u884c\u7ec4\u7ec7\u90fd\u4e3a\u7a7a\u3002", (String)"ExecutionResultFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        Set<Long> orgIdSet = Arrays.stream(executionLog.getOrgIds()).collect(Collectors.toSet());
                        if (FormPluginUtil.validatePrePeriodStatus(executionLog.getAnalysisModel()) && !FormPluginUtil.validatePeriodStatus(executionLog.getAnalysisModel(), orgIdSet, Collections.singleton(executionLog.getStartPeriod()))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u671f\u95f4\u3002", (String)"ExecutionResultFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        TaskInst taskInst = new TaskInst(false, Long.valueOf(DB.genGlobalLongId()));
                        TaskExecuteEngineService taskExecuteEngineService = (TaskExecuteEngineService)EngineServiceFactory.getTaskExecuteEngineService();
                        taskExecuteEngineService.work(executionLog, taskInst);
                        view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u53ef\u5728\u6267\u884c\u65e5\u5fd7\u5217\u8868\u67e5\u8be2\u6267\u884c\u60c5\u51b5\u3002", (String)"ExecutionResultFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("confirmCallBack error", (Throwable)e);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s\u3002", (String)"ExecutionResultFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]), e.getMessage());
                throw new KDBizException((Throwable)e, new ErrorCode("", errorMsg), new Object[0]);
            }
        }
    }

    private ExecutionLogDTO buildDto() {
        Long orgId;
        IDataModel model = this.getModel();
        ExecutionLogDTO dto = new ExecutionLogDTO();
        dto.setAnalysisSystem((Long)model.getValue("analysis_system_id"));
        dto.setAnalysisModel((Long)model.getValue("analysis_model_id"));
        DynamicObjectCollection orgCol = (DynamicObjectCollection)model.getValue("execorg");
        if (orgCol != null) {
            List orgIds = orgCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toCollection(ArrayList::new));
            dto.setOrgIds(orgIds.toArray(new Long[0]));
        }
        if ((dto.getOrgIds() == null || dto.getOrgIds().length == 0) && (orgId = (Long)model.getValue("org_field_id")) != null) {
            dto.setOrgIds(new Long[]{orgId});
        }
        dto.setExecutionMode(ExecutionModeEnum.writeOff);
        dto.setItemClassTypeField((String)model.getValue("itemclasstypefield"));
        dto.setStartPeriod((Long)model.getValue("startperiod_id"));
        dto.setExecutionTime(new Date());
        dto.setDetailTime(Long.valueOf(System.currentTimeMillis()));
        dto.setExecutionStatus(PASyncLogStatusEnum.NEW);
        dto.setExecutionType(ExecutionTypeEnum.MANUAL.getCode());
        return dto;
    }

    private void openResultTracePage(Long execLogId, Long execRuleLogId, Long timestamp) {
        DynamicObject execLogObj = BusinessDataServiceHelper.loadSingleFromCache((Object)execLogId, (String)"pa_executionlog");
        if (execLogObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6267\u884c\u7ed3\u679c", (String)"ExecutionResultFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject analysisModel = execLogObj.getDynamicObject("analysis_model");
        DynamicObject analysisSystem = execLogObj.getDynamicObject("analysis_system");
        String analysisModelName = analysisModel.getString("name");
        String sysName = analysisSystem.getString("name");
        Object modelId = analysisModel.getPkValue();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put("id", execLogId);
        param.getCustomParams().put("execlogid", execLogId);
        param.getCustomParams().put("subexeclogid", execRuleLogId);
        param.getCustomParams().put("isNeedColor", false);
        param.getCustomParams().put("shownumber", false);
        param.getCustomParams().put("timestamp", timestamp);
        param.setFormId("pa_reviewsource_2");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getCustomParams().put("report_analysis", sysName);
        param.getCustomParams().put("report_analysis_model", analysisModelName);
        param.getCustomParams().put("report_analysis_model_id", modelId);
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("viewdata".equals(operateKey) || "writeoff".equals(operateKey)) {
            try {
                long userId = RequestContext.get().getCurrUserId();
                Object executionLogPkId = this.getModel().getValue("id");
                if (!PAExecutionLogPluginUtils.hasOrgRight(userId, "viewdata".equals(operateKey) ? "47150e89000000ac" : "2CI4JV/12ITY", executionLogPkId)) {
                    if ("viewdata".equals(operateKey)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6267\u884c\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecutionResultFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6267\u884c\u65e5\u5fd7\u201d\u7684\u201c\u51b2\u9500\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecutionResultFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                }
            }
            catch (Exception e) {
                logger.error("verify user execution log right error", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u6267\u884c\u65e5\u5fd7\u201d\u64cd\u4f5c\u6743\u9650\u5931\u8d25\u3002", (String)"ExecutionResultFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

