/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.IPageCache;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.helper.PARuleHelper;

public class PABusinessListPlugin
extends AbstractListPlugin {
    public static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        PARuleHelper.processFilterItemSelectedByDefault((FilterContainerSearchClickArgs)args, (IPageCache)this.getPageCache(), (String)(currentCommonFilter == null ? "" : ((List)currentCommonFilter.get("FieldName")).get(0).toString()), (String)"analysissystem.id", (String)"analysismodel.id");
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if ("analysissystem.name".equals(args.getFieldName())) {
            args.addCustomQFilter(enableFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IListView listView = (IListView)this.getView();
        IPageCache pageCache = this.getPageCache();
        pageCache.put("modelComboItem", null);
        if (((ListShowParameter)listView.getFormShowParameter()).isLookUp()) {
            return;
        }
        ControlFilters controlFilters = listView.getControlFilters();
        if (controlFilters == null && "true".equals(listView.getFormShowParameter().getCustomParam("isDataCheck"))) {
            controlFilters = this.buildControlFiltersByFormParam(args, listView);
        }
        FilterColumn anaModelName = args.getFilterColumn("analysismodel.name");
        if (controlFilters == null) {
            DynamicObjectCollection anaSystem = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])enableFilter.toArray(), (String)"number", (int)1);
            if (anaSystem == null || anaSystem.isEmpty()) {
                PARuleHelper.setComboItems((FilterColumn)anaModelName, (List)PARuleHelper.getEmptyComboItems());
                return;
            }
            FilterColumn filterColumn = args.getFilterColumn("analysissystem.name");
            filterColumn.setDefaultValue(((DynamicObject)anaSystem.get(0)).get("id").toString());
            QFilter modelFilter = new QFilter("analysis_system", "=", ((DynamicObject)anaSystem.get(0)).get("id")).and(enableFilter).and(this.getModelQFilters());
            List anaModelCmbList = PARuleHelper.getComboItems((String)"pa_analysismodel", (QFilter)modelFilter);
            PARuleHelper.setComboItems((FilterColumn)anaModelName, (List)anaModelCmbList);
            if (anaModelName instanceof CommonFilterColumn) {
                String modelValue = !anaModelCmbList.isEmpty() ? ((ComboItem)anaModelCmbList.get(0)).getValue() : null;
                anaModelName.setDefaultValue(modelValue);
                pageCache.put("modelComboItem", modelValue);
            }
            return;
        }
        List anaSys = controlFilters.getFilter("analysissystem.id");
        if (anaSys != null && !anaSys.isEmpty()) {
            FilterColumn filterColumn = args.getFilterColumn("analysissystem.name");
            filterColumn.setDefaultValue(anaSys.get(0).toString());
            QFilter modelFilter = new QFilter("analysis_system", "=", (Object)Long.parseLong(anaSys.get(0).toString())).and(enableFilter).and(this.getModelQFilters());
            List anaModelCmbList = PARuleHelper.getComboItems((String)"pa_analysismodel", (QFilter)modelFilter);
            PARuleHelper.setComboItems((FilterColumn)anaModelName, (List)anaModelCmbList);
            if (anaModelName instanceof CommonFilterColumn) {
                List anaModel = controlFilters.getFilter("analysismodel.id");
                String modelValue = CollectionUtils.isNotEmpty((Collection)anaModel) && "true".equals(this.getPageCache().get("useDefaultValue")) ? anaModel.get(0).toString() : (!anaModelCmbList.isEmpty() ? ((ComboItem)anaModelCmbList.get(0)).getValue() : null);
                anaModelName.setDefaultValue(modelValue);
                pageCache.put("modelComboItem", modelValue);
            }
        } else {
            PARuleHelper.setComboItems((FilterColumn)anaModelName, (List)PARuleHelper.getEmptyComboItems());
        }
    }

    private ControlFilters buildControlFiltersByFormParam(FilterContainerInitArgs args, IListView listView) {
        ArrayList filters = new ArrayList(4);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String customParam;
            String srcFieldKey = filterColumn.getFilterField().getSrcFieldKey();
            if (!StringUtils.isNotEmpty((String)srcFieldKey) || !StringUtils.isNotEmpty((String)(customParam = (String)listView.getFormShowParameter().getCustomParam(srcFieldKey)))) continue;
            HashMap filter = new HashMap();
            ArrayList<String> l1 = new ArrayList<String>();
            l1.add(String.format("%s.id", srcFieldKey));
            filter.put("FieldName", l1);
            ArrayList<String> l2 = new ArrayList<String>();
            l2.add(customParam);
            filter.put("Value", l2);
            filter.put("Compare", new ArrayList(0));
            filters.add(filter);
        }
        FilterKeyValueCollections fastFilter = new FilterKeyValueCollections("fastfilter", null);
        FilterKeyValueCollections customFilter = new FilterKeyValueCollections("customfilter", filters);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setCachedFilterValues(new FilterContainerFilterValues(fastFilter, customFilter));
        ControlFilters controlFilters = listView.getControlFilters();
        this.getPageCache().put("useDefaultValue", "true");
        return controlFilters;
    }

    public QFilter getModelQFilters() {
        return PARuleHelper.getAnalysisPeriodFilter();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("analysismodel.id".equals(fieldName)) {
            List anaSys = ((IListView)this.getView()).getControlFilters().getFilter("analysissystem.id");
            if (anaSys != null && !anaSys.isEmpty()) {
                args.getQfilters().add(new QFilter("analysis_system", "=", (Object)Long.parseLong(anaSys.get(0).toString())).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter()));
            }
        } else if ("analysismodel.name".equals(fieldName)) {
            List anaSys = ((IListView)this.getView()).getControlFilters().getFilter("analysissystem.name");
            DynamicObjectCollection anaSystem = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])new QFilter("name", "=", anaSys.get(0)).and(enableFilter).toArray());
            HashSet<Object> idSet = new HashSet<Object>(anaSystem.size());
            for (DynamicObject dyo : anaSystem) {
                idSet.add(dyo.get("id"));
            }
            args.getQfilters().add(new QFilter("analysis_system", "in", idSet).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter()));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (BillOperationStatus.ADDNEW == e.getParameter().getBillStatus()) {
            BillShowParameter showParam = e.getParameter();
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            List orgIdList = controlFilters.getFilter("useorg.id");
            List anaSysIdList = controlFilters.getFilter("analysissystem.id");
            List anaModelIdList = controlFilters.getFilter("analysismodel.id");
            String orgId = null;
            if (orgIdList != null && !orgIdList.isEmpty()) {
                orgId = orgIdList.get(0).toString();
            } else {
                DynamicObjectCollection org;
                List orgNameList = controlFilters.getFilter("useorg.name");
                if (orgNameList != null && !orgNameList.isEmpty() && !(org = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)orgNameList.get(0).toString())})).isEmpty()) {
                    orgId = ((DynamicObject)org.get(0)).get("id").toString();
                }
            }
            if (orgId == null) {
                Map customParams = e.getParameter().getCustomParams();
                orgId = (String)customParams.get("useorgId");
            }
            String anaSysId = null;
            if (anaSysIdList != null && !anaSysIdList.isEmpty()) {
                anaSysId = anaSysIdList.get(0).toString();
            } else {
                DynamicObjectCollection anaSys;
                List anaSysNameList = controlFilters.getFilter("analysissystem.name");
                if (anaSysNameList != null && !anaSysNameList.isEmpty() && !(anaSys = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)anaSysNameList.get(0).toString()).and(enableFilter)})).isEmpty()) {
                    anaSysId = ((DynamicObject)anaSys.get(0)).get("id").toString();
                }
            }
            String anaModelId = null;
            if (anaModelIdList != null && !anaModelIdList.isEmpty()) {
                anaModelId = anaModelIdList.get(0).toString();
            } else {
                DynamicObjectCollection anaModel;
                List anaModelNameList = controlFilters.getFilter("analysismodel.name");
                if (anaModelNameList != null && !anaModelNameList.isEmpty() && !(anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)anaModelNameList.get(0).toString()).and(enableFilter)})).isEmpty()) {
                    anaModelId = ((DynamicObject)anaModel.get(0)).get("id").toString();
                }
            }
            showParam.setCustomParam("customParamOrgId", (Object)orgId);
            showParam.setCustomParam("customParamAnaSysId", (Object)anaSysId);
            showParam.setCustomParam("customParamAnaModelId", (Object)anaModelId);
            showParam.setCustomParam("useorgId", (Object)orgId);
        }
    }
}

