/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.helper.SystemParamHelper;

public class PABusinessPlanFormPlugin
extends AbstractFormPlugin {
    private static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
    private static final Set<String> baseEntityIdSet = new HashSet<String>(16);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.processDefaultData(this.getModel(), view);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.processDefaultData(model, view);
        } else if (!this.isModelPeriodDateType((Long)model.getValue("analysismodel_id")).booleanValue()) {
            this.setPeriodBaseEntityId(model, view);
            this.initRuleEntryPeriod(model);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.processDefaultData(model, view);
        }
        this.setPeriodVisibleByModelPeriodType((Long)model.getValue("analysismodel_id"));
        if (SystemParamHelper.getVisibleOfBusinessRuleStepItem()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rulesummarysetting"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rulesummarysetting"});
        }
        model.setDataChanged(false);
    }

    private void initRuleEntryPeriod(IDataModel model) {
        int cnt = model.getEntryRowCount("pa_businessplan_rule");
        for (int idx = 0; idx < cnt; ++idx) {
            DynamicObject rule = (DynamicObject)model.getValue("rulenumber", idx);
            if (rule == null) continue;
            model.setValue("endperiod", rule.get("endperiod_id"), idx);
            model.setValue("startperiod", rule.get("startperiod_id"), idx);
        }
    }

    private void processDefaultData(IDataModel model, IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object orgId = customParams.get("customParamOrgId");
        model.setValue("createorg", orgId == null ? null : Long.valueOf(Long.parseLong(orgId.toString())));
        FormPluginUtil.processDefaultSysAndModel(model, view);
        if (!this.isModelPeriodDateType((Long)model.getValue("analysismodel_id")).booleanValue()) {
            this.setPeriodBaseEntityId(model, view);
            DynamicObjectCollection cols = model.getDataEntity().getDynamicObjectCollection("pa_businessplan_rule");
            for (int i = 0; i < cols.size(); ++i) {
                DynamicObject dy = ((DynamicObject)cols.get(i)).getDynamicObject("rulenumber");
                if (dy == null) continue;
                model.setValue("startperiod", dy.get("startperiod_id"), i);
                model.setValue("endperiod", dy.get("endperiod_id"), i);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("save".equals(operateKey)) {
            int cnt = model.getEntryRowCount("pa_businessplan_rule");
            if (cnt == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PABusinessPlanFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap<Long, ArrayList<Integer>> ruleIndexMap = new HashMap<Long, ArrayList<Integer>>(cnt);
            for (int i = 0; i < cnt; ++i) {
                Long ruleId = (Long)model.getValue("rulenumber_id", i);
                if (ruleId == null || ruleId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PABusinessPlanFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ArrayList<Integer> ruleIndexList = (ArrayList<Integer>)ruleIndexMap.get(ruleId);
                if (ruleIndexList == null) {
                    ruleIndexList = new ArrayList<Integer>(1);
                }
                ruleIndexList.add(i + 1);
                ruleIndexMap.put(ruleId, ruleIndexList);
            }
            StringBuilder repeatMessage = new StringBuilder();
            for (Map.Entry entry : ruleIndexMap.entrySet()) {
                List ruleIndexList = (List)entry.getValue();
                if (ruleIndexList.size() <= 1) continue;
                repeatMessage.append('[');
                for (int i = 0; i < ruleIndexList.size(); ++i) {
                    if (i < ruleIndexList.size() - 1) {
                        repeatMessage.append(ruleIndexList.get(i)).append(',');
                        continue;
                    }
                    repeatMessage.append(ruleIndexList.get(i));
                }
                repeatMessage.append(']');
            }
            if (repeatMessage.length() > 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u89c4\u5219\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u66f4\u6539\u3002", (String)"PABusinessPlanFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), repeatMessage.toString()));
                args.setCancel(true);
                return;
            }
            model.setValue("rulecount", (Object)cnt);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.initF7();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (itemKey) {
            case "uprow": {
                if (model.getEntryCurrentRowIndex("pa_businessplan_rule") == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6b65\u9aa4\u7684\u6267\u884c\u987a\u5e8f\u5df2\u662f\u6700\u4f18\u5148\u3002", (String)"PABusinessPlanFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    break;
                }
                view.invokeOperation("moveentryup");
                break;
            }
            case "downrow": {
                if (model.getEntryCurrentRowIndex("pa_businessplan_rule") == model.getEntryRowCount("pa_businessplan_rule") - 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6b65\u9aa4\u5df2\u662f\u6700\u540e\u6267\u884c\u7684\u6b65\u9aa4\u3002", (String)"PABusinessPlanFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    break;
                }
                view.invokeOperation("moveentrydown");
                break;
            }
            case "rulesummarysetting": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("pa_rulesummarysetting");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("ruleGroupId", this.getModel().getValue("id"));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ruleSummarySetting"));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("ruleSummarySetting".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            LinkedHashMap stepSummaryHistorySettingMap = (LinkedHashMap)closedCallBackEvent.getReturnData();
            this.getModel().setValue("rulesummaryswitchdata_tag", JSON.toJSON((Object)stepSummaryHistorySettingMap));
        }
    }

    private void initF7() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object analysisSystem = model.getValue("analysissystem");
        Object analysisModel = model.getValue("analysismodel");
        BasedataEdit ruleNumberF7 = (BasedataEdit)this.getControl("rulenumber");
        ruleNumberF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object org = model.getValue("createorg");
            if (analysisSystem == null || analysisModel == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u548c\u5206\u6790\u6a21\u578b\u3002", (String)"PABusinessPlanFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("analysissystem", "=", ((DynamicObject)analysisSystem).get("id")).and("analysismodel", "=", ((DynamicObject)analysisModel).get("id"));
            QFilter orgDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pa_businessrule", (Long)((DynamicObject)org).getLong("id"));
            qFilter.and(orgDataFilter);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit analysisModelF7 = (BasedataEdit)this.getControl("analysismodel");
        analysisModelF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (analysisSystem == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PABusinessPlanFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("analysis_system", "=", ((DynamicObject)analysisSystem).get("id"));
            qFilter.and(PARuleHelper.getAnalysisPeriodFilter());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propertyName) {
            case "analysissystem": 
            case "analysismodel": {
                Long analysisModelId;
                int cnt = model.getEntryRowCount("pa_businessplan_rule");
                boolean showConfirmFlag = false;
                if (cnt > 0) {
                    for (int i = 0; i < cnt; ++i) {
                        if (model.getValue("rulenumber", i) == null && !StringUtils.isNotEmpty((CharSequence)((String)model.getValue("ruledesc", i)))) continue;
                        showConfirmFlag = true;
                        break;
                    }
                }
                if (showConfirmFlag) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5206\u6790\u4f53\u7cfb\u6216\u5206\u6790\u6a21\u578b\u4f1a\u6e05\u7a7a\u4e1a\u52a1\u89c4\u5219\u5217\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PABusinessPlanFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackAnalysis", (IFormPlugin)this), null, propertyName + ',' + (oldValue == null ? "0" : ((DynamicObject)oldValue).get("id")));
                    break;
                }
                if ("analysissystem".equals(propertyName)) {
                    this.setAnalysisModelDefault(model, view);
                    break;
                }
                Long l = analysisModelId = newValue == null ? null : Long.valueOf(((DynamicObject)newValue).getLong("id"));
                if (analysisModelId == null || !this.isModelPeriodDateType(analysisModelId).booleanValue()) {
                    this.setPeriodVisible(Boolean.TRUE);
                    this.setPeriodBaseEntityId(model, view);
                    break;
                }
                this.setPeriodVisible(Boolean.FALSE);
                break;
            }
            case "rulenumber": {
                if (this.isModelPeriodDateType((Long)model.getValue("analysismodel_id")).booleanValue()) break;
                if (newValue != null) {
                    DynamicObject newDyo = (DynamicObject)newValue;
                    model.setValue("startperiod", newDyo.get("startperiod_id"), rowIndex);
                    model.setValue("endperiod", newDyo.get("endperiod_id"), rowIndex);
                    break;
                }
                model.setValue("startperiod", null, rowIndex);
                model.setValue("endperiod", null, rowIndex);
            }
        }
    }

    private void setPeriodBaseEntityId(IDataModel model, IFormView view) {
        DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
        FormPluginUtil.setItemClassTypeEntityId(baseEntityIdSet, anaModel, DimensionNecessityEnum.PERIOD.getCode(), "periodbasetype", model, view);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult) {
            if ("confirmCallbackAnalysis".equalsIgnoreCase(actionId)) {
                String oldValue = messageBoxClosedEvent.getCustomVaule();
                String[] oldValueArr = oldValue.split(",");
                if ("analysissystem".equals(oldValueArr[0])) {
                    this.setAnalysisModelDefault(model, view);
                }
                if (this.isModelPeriodDateType((Long)model.getValue("analysismodel_id")).booleanValue()) {
                    this.setPeriodVisible(Boolean.FALSE);
                } else {
                    this.setPeriodVisible(Boolean.TRUE);
                    this.setPeriodBaseEntityId(model, view);
                }
                model.deleteEntryData("pa_businessplan_rule");
            }
        } else if ("confirmCallbackAnalysis".equalsIgnoreCase(actionId)) {
            model.beginInit();
            String oldValue = messageBoxClosedEvent.getCustomVaule();
            String[] oldValueArr = oldValue.split(",");
            model.setValue(oldValueArr[0], "0".equals(oldValueArr[1]) ? null : Long.valueOf(Long.parseLong(oldValueArr[1])));
            model.endInit();
            view.updateView("fs_baseinfo");
            this.setPeriodVisibleByModelPeriodType((Long)model.getValue("analysismodel_id"));
        }
    }

    private void setAnalysisModelDefault(IDataModel model, IFormView view) {
        DynamicObject anaSystem = (DynamicObject)model.getValue("analysissystem");
        if (anaSystem == null) {
            model.beginInit();
            model.setValue("analysismodel", null);
            model.endInit();
            view.updateView("fs_baseinfo");
            this.setPeriodVisible(Boolean.TRUE);
            return;
        }
        DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", anaSystem.get("id")).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter())}, (String)"number", (int)1);
        model.beginInit();
        if (anaModel == null || anaModel.isEmpty()) {
            model.setValue("analysismodel", null);
            this.setPeriodVisible(Boolean.TRUE);
        } else {
            Long analysisModelId = ((DynamicObject)anaModel.get(0)).getLong("id");
            model.setValue("analysismodel", (Object)analysisModelId);
            this.setPeriodVisibleByModelPeriodType(analysisModelId);
        }
        model.endInit();
        view.updateView("fs_baseinfo");
        if (!this.isModelPeriodDateType((Long)model.getValue("analysismodel_id")).booleanValue()) {
            this.setPeriodBaseEntityId(model, view);
        }
    }

    private Boolean isModelPeriodDateType(Long modelId) {
        if (modelId != null && modelId != 0L) {
            DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
            DimensionTypeEnum dimType = FormPluginUtil.getDimensionTypeEnumByModelAndDim(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
            return DimensionTypeEnum.DATE == dimType;
        }
        return Boolean.FALSE;
    }

    private void setPeriodVisibleByModelPeriodType(Long modelId) {
        this.getView().setVisible(Boolean.valueOf(this.isModelPeriodDateType(modelId) == false), new String[]{"startperiod", "endperiod"});
    }

    private void setPeriodVisible(Boolean visible) {
        this.getView().setVisible(visible, new String[]{"startperiod", "endperiod"});
    }
}

