/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.enums.TailDifferenceTypeEnum;
import kd.fi.pa.enums.AllocationFlagEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.model.impl.PADimensionModel;
import org.apache.commons.io.IOUtils;

public class PABusinessRuleExportAndImportListPlugin
extends AbstractListPlugin
implements UploadListener {
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operate;
        Object op = args.getSource();
        if (op instanceof FormOperate && "exportdts".equals(operate = ((FormOperate)op).getOperateKey())) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"PABusinessRuleExportAndImportListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                Object bizRuleId = args.getListSelectedData().get(0).getPrimaryKeyValue();
                DynamicObject bizRuleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizRuleId, (String)"pa_businessrule");
                if (this.validateData(bizRuleObj)) {
                    String url = this.downLoadDto(bizRuleObj);
                    this.getView().download(url);
                } else {
                    args.setCancel(true);
                }
            }
        }
    }

    private boolean validateData(DynamicObject bizRuleObj) {
        String status = bizRuleObj.getString("status");
        String enable = bizRuleObj.getString("enable");
        if ("C".equals(status) && "1".equals(enable)) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u542f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\uff0c\u65b9\u53ef\u5bfc\u51fa\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u72b6\u6001\u548c\u542f\u7528\u72b6\u6001\u3002", (String)"PABusinessRuleExportAndImportListPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        return false;
    }

    private boolean checkPerim(String operationKey) {
        OperationResult operationResult = this.getView().invokeOperation(operationKey);
        if (operationResult == null) {
            return true;
        }
        if (operationResult.isSuccess()) {
            return true;
        }
        this.getView().showOperationResult(operationResult);
        return false;
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (this.checkPerim("importdts") && urls.length > 0) {
            String url = (String)urls[0];
            BizRuleDataExportAndImportHandler exportAndImportHandler = new BizRuleDataExportAndImportHandler();
            boolean isError = false;
            try {
                String orgIdStr = this.getPageCache().get("createOrg");
                Long org = StringUtils.isEmpty((String)orgIdStr) ? RequestContext.get().getOrgId() : Long.parseLong(orgIdStr);
                OperationResult result = exportAndImportHandler.importData(url, org);
                if (result != null) {
                    isError = true;
                    this.getView().showOperationResult(result);
                }
            }
            catch (ValidateException e) {
                isError = true;
                this.getView().showErrorNotification(e.getMessage());
            }
            if (!isError) {
                ((ListView)this.getView()).refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"PABusinessRuleExportAndImportListPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public String downLoadDto(DynamicObject bizRuleObj) {
        LocalDate now = LocalDate.now();
        String dateStr = String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth());
        String fileName = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5bfc\u51fa_%s.dts", (String)"PABusinessRuleExportAndImportListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), dateStr);
        BizRuleDataExportAndImportHandler exportAndImportHandler = new BizRuleDataExportAndImportHandler();
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, exportAndImportHandler.export(bizRuleObj).getBytes(StandardCharsets.UTF_8), 60);
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("appId", "pa");
        refEntitiyMap.put("entityNum", "pa_businessrule");
        refEntitiyMap.put("permissionItemId", "4730fc9f000004ae");
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
        return url;
    }

    private static class ValidateException
    extends KDBizException {
        private static final long serialVersionUID = 6116024770916341768L;

        public ValidateException(String message) {
            super(message);
        }
    }

    private static class ExtendShareRuleDynamicObject
    extends ExtendDynamicObject {
        private static final long serialVersionUID = 5282475696874233941L;
        private int stepIndex;
        private String name;
        private String[] shareMeasureNumbers;
        private String[][] sendEntryEntity;
        private String receiveRule;
        private String shareFactorNumber;
        private String measureNumber;
        private BigDecimal sendRate;
        private String tailDifferenceType;
        private String accountFilter;
        private String[] relationGroupDimNumbers;
        private Boolean addShareFlag;
        private String[][] receiveEntryEntity;
        private boolean inputRatioBox;
        private String[][] saveSubFlexData;
        private boolean limitBox;
        private String limitType;
        private String[][] saveSubLimit;
        private String[][] flagEntryEntity;

        @Override
        String serializeKey() {
            return "sharerule:";
        }

        @Override
        Map<String, BaseDataItem> achieveBaseData(DynamicObject analysisModel, boolean isId) {
            DynamicObjectCollection dimEntryCols = analysisModel.getDynamicObjectCollection("dimension_entry");
            Map<String, DynamicObject> dimensionMap = dimEntryCols.stream().map(rowData -> rowData.getDynamicObject("dimension")).collect(Collectors.toMap(dimObj -> dimObj.getString("number"), dimObj -> dimObj));
            HashMap<String, BaseDataItem> baseDataItemMap = new HashMap<String, BaseDataItem>(10);
            this.processSendAndReceive(this.sendEntryEntity, dimensionMap, baseDataItemMap, isId, true);
            if (!isId && StringUtils.isNotEmpty((String)this.shareFactorNumber)) {
                BaseDataItem baseDataItem = (BaseDataItem)baseDataItemMap.get("pa_sharefactor");
                if (baseDataItem == null) {
                    baseDataItem = new BaseDataItem(new HashMap<String, Object>(10), null);
                    baseDataItemMap.put("pa_sharefactor", baseDataItem);
                }
                baseDataItem.numberToIdMap.put(this.shareFactorNumber, null);
            }
            this.processSendAndReceive(this.receiveEntryEntity, dimensionMap, baseDataItemMap, isId, false);
            this.processDetailsAndLimit(this.saveSubFlexData, dimensionMap, baseDataItemMap, isId, true);
            this.processDetailsAndLimit(this.saveSubLimit, dimensionMap, baseDataItemMap, isId, false);
            this.processFlagEntry(this.flagEntryEntity, dimensionMap, baseDataItemMap, isId);
            return baseDataItemMap;
        }

        private String achieveBaseEntity(DynamicObject dimObj) {
            DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimObj.getString("dimensiontype"));
            String entityNumber = null;
            switch (dimType) {
                case DATABASE: 
                case PERIOD: {
                    entityNumber = dimObj.getDynamicObject("dimensionsource").getString("id");
                    break;
                }
                case ASSISTANTDATA: {
                    entityNumber = "bos_assistantdata_detail";
                }
            }
            return entityNumber;
        }

        @Override
        void idConvertNumber(Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
            this.sendAndReceiveIdConvertNumber(this.sendEntryEntity, baseDataItemMap);
            this.sendAndReceiveIdConvertNumber(this.receiveEntryEntity, baseDataItemMap);
            this.detailsAndLimitIdConvertNumber(this.saveSubFlexData, baseDataItemMap, dimensionMap, true);
            this.detailsAndLimitIdConvertNumber(this.saveSubLimit, baseDataItemMap, dimensionMap, false);
            this.flagIdConvertNumber(this.saveSubLimit, baseDataItemMap, dimensionMap);
        }

        @Override
        DynamicObject createDynamicObject(Map<String, BaseDataItem> baseDataItemMap, boolean isId, DynamicObject analysisModel, Long orgId) {
            DynamicObject rowData2;
            Object dimObj2;
            DynamicObjectCollection dimEntryCols = analysisModel.getDynamicObjectCollection("dimension_entry");
            Map<String, DynamicObject> dimensionMap = dimEntryCols.stream().map(rowData -> rowData.getDynamicObject("dimension")).collect(Collectors.toMap(dimObj -> dimObj.getString("number"), dimObj -> dimObj));
            this.numberConvertId(baseDataItemMap, dimensionMap);
            DynamicObjectCollection measureCols = analysisModel.getDynamicObjectCollection("measure_entry");
            Map<String, DynamicObject> measureMap = measureCols.stream().map(rowData -> rowData.getDynamicObject("measure")).collect(Collectors.toMap(measureObj -> measureObj.getString("number"), measureObj -> measureObj));
            DynamicObject shareRule = BusinessDataServiceHelper.newDynamicObject((String)"pa_sharerulenew");
            shareRule.set("name", (Object)this.name);
            shareRule.set("analysissystem", analysisModel.get("analysis_system"));
            shareRule.set("analysismodel", (Object)analysisModel);
            this.fillFixFieldValue(shareRule);
            DynamicObjectCollection shareMeasureCols = shareRule.getDynamicObjectCollection("mulbasedatafield");
            if (this.shareMeasureNumbers != null) {
                for (int i = 0; i < this.shareMeasureNumbers.length; ++i) {
                    DynamicObject rowData3 = shareMeasureCols.addNew();
                    DynamicObject measureObj2 = measureMap.get(this.shareMeasureNumbers[i]);
                    if (measureObj2 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%3$s\u7684\u5ea6\u91cf\uff0c\u8bf7\u68c0\u67e5\u5ea6\u91cf\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, this.shareMeasureNumbers[i]));
                    }
                    this.setBaseDataId(rowData3, "fbasedataid", measureObj2.getPkValue());
                }
                shareRule.set("mulbasedatafield", (Object)shareMeasureCols);
            }
            if (this.sendRate == null) {
                shareRule.set("sendrate", (Object)new BigDecimal(100));
            } else {
                shareRule.set("sendrate", (Object)this.sendRate);
            }
            if (this.tailDifferenceType == null) {
                shareRule.set("taildifferencetype", (Object)TailDifferenceTypeEnum.MAX_RATE.getType());
            } else {
                shareRule.set("taildifferencetype", (Object)this.tailDifferenceType);
            }
            if (this.addShareFlag == null) {
                shareRule.set("addshareflag", (Object)Boolean.FALSE);
            } else {
                shareRule.set("addshareflag", (Object)this.addShareFlag);
            }
            DynamicObjectCollection sendEntryCols = shareRule.getDynamicObjectCollection("sendentryentity");
            if (this.sendEntryEntity != null) {
                for (int i = 0; i < this.sendEntryEntity.length; ++i) {
                    String[] sendEntry = this.sendEntryEntity[i];
                    dimObj2 = dimensionMap.get(sendEntry[0]);
                    if (dimObj2 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_30", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, sendEntry[0]));
                    }
                    DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimObj2.getString("dimensiontype"));
                    rowData2 = sendEntryCols.addNew();
                    this.setBaseDataId(rowData2, "senddimension", dimObj2.getPkValue());
                    rowData2.set("combofield", (Object)sendEntry[1]);
                    rowData2.set("dimensionvalue", (Object)sendEntry[2]);
                    rowData2.set("dimensionid", (Object)sendEntry[3]);
                    rowData2.set("dimensiontext_tag", (Object)sendEntry[4]);
                    rowData2.set("sendmatename", (Object)sendEntry[5]);
                    if (StringUtils.isNotEmpty((String)sendEntry[6]) && dimType != DimensionTypeEnum.getEnum((String)sendEntry[6])) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_41", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, sendEntry[0]));
                    }
                    rowData2.set("senddimtype", (Object)sendEntry[6]);
                }
                shareRule.set("sendentryentity", (Object)sendEntryCols);
            }
            shareRule.set("receiverule", (Object)this.receiveRule);
            if (StringUtils.isNotEmpty((String)this.shareFactorNumber)) {
                BaseDataItem baseDataItem = baseDataItemMap.get("pa_sharefactor");
                if (baseDataItem != null && baseDataItem.numberToIdMap.get(this.shareFactorNumber) != null) {
                    this.setBaseDataId(shareRule, "sharefactor", baseDataItem.numberToIdMap.get(this.shareFactorNumber));
                } else {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%3$s\u7684\u5206\u644a\u56e0\u5b50\uff0c\u8bf7\u68c0\u67e5\u5206\u644a\u56e0\u5b50\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, this.shareFactorNumber));
                }
            }
            if (StringUtils.isNotEmpty((String)this.measureNumber)) {
                DynamicObject measureObj3 = measureMap.get(this.measureNumber);
                if (measureObj3 == null) {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%3$s\u7684\u5ea6\u91cf\uff0c\u8bf7\u68c0\u67e5\u5ea6\u91cf\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, this.measureNumber));
                }
                this.setBaseDataId(shareRule, "measure", measureObj3.getPkValue());
            }
            if (StringUtils.isNotEmpty((String)this.accountFilter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)this.accountFilter, FilterCondition.class);
                List filterRowList = filterCondition.getFilterRow();
                for (SimpleFilterRow filterRow : filterRowList) {
                    filterRow.setBaseDataIds(new ArrayList(0));
                }
                String filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                shareRule.set("accountfilter_tag", (Object)filterStr);
            }
            if (this.relationGroupDimNumbers != null) {
                DynamicObjectCollection relatedGroupDimCols = shareRule.getDynamicObjectCollection("relatedgroupdim");
                for (int i = 0; i < this.relationGroupDimNumbers.length; ++i) {
                    dimObj2 = dimensionMap.get(this.relationGroupDimNumbers[i]);
                    if (dimObj2 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%3$s\u7684\u5173\u8054\u5206\u7ec4\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_35", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, this.relationGroupDimNumbers[i]));
                    }
                    DynamicObject rowData4 = relatedGroupDimCols.addNew();
                    this.setBaseDataId(rowData4, "fbasedataid", dimObj2.getPkValue());
                }
                shareRule.set("relatedgroupdim", (Object)relatedGroupDimCols);
            }
            DynamicObjectCollection receiveEntryCols = shareRule.getDynamicObjectCollection("receiveentryentity");
            if (this.receiveEntryEntity != null) {
                for (int i = 0; i < this.receiveEntryEntity.length; ++i) {
                    String[] receiveEntry = this.receiveEntryEntity[i];
                    DynamicObject dimObj3 = dimensionMap.get(receiveEntry[0]);
                    if (dimObj3 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_36", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, receiveEntry[0]));
                    }
                    rowData2 = receiveEntryCols.addNew();
                    this.setBaseDataId(rowData2, "receivedimension", dimObj3.getPkValue());
                    rowData2.set("comboreceive", (Object)receiveEntry[1]);
                    rowData2.set("receivedimvalue", (Object)receiveEntry[2]);
                    rowData2.set("receivedimid", (Object)receiveEntry[3]);
                    rowData2.set("receivedimensiontext_tag", (Object)receiveEntry[4]);
                    rowData2.set("receivematename", (Object)receiveEntry[5]);
                    DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimObj3.getString("dimensiontype"));
                    if (StringUtils.isNotEmpty((String)receiveEntry[6]) && dimType != DimensionTypeEnum.getEnum((String)receiveEntry[6])) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u6761\u4ef6\u7b2c%3$s\u884c\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_43", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, receiveEntry[0]));
                    }
                    rowData2.set("receivedimtype", (Object)receiveEntry[6]);
                }
                shareRule.set("receiveentryentity", (Object)receiveEntryCols);
            }
            shareRule.set("inputratiobox", (Object)this.inputRatioBox);
            DynamicObjectCollection saveSubFlexDataCols = shareRule.getDynamicObjectCollection("savesubflexdata");
            if (this.saveSubFlexData != null) {
                for (int i = 0; i < this.saveSubFlexData.length; ++i) {
                    String[] row = this.saveSubFlexData[i];
                    DynamicObject saveSubFlexData = saveSubFlexDataCols.addNew();
                    saveSubFlexData.set("subvalue", (Object)(StringUtils.isNotEmpty((String)row[1]) && row[1].length() > 10 ? row[1].substring(0, 10) : row[1]));
                    saveSubFlexData.set("subvalue_tag", (Object)row[1]);
                    saveSubFlexData.set("subdataid", (Object)row[2]);
                }
                shareRule.set("savesubflexdata", (Object)saveSubFlexDataCols);
            }
            shareRule.set("limitbox", (Object)this.limitBox);
            shareRule.set("limittype", (Object)this.limitType);
            DynamicObjectCollection saveSubLimitCols = shareRule.getDynamicObjectCollection("savesublimit");
            if (this.saveSubLimit != null) {
                for (int i = 0; i < this.saveSubLimit.length; ++i) {
                    String[] row = this.saveSubLimit[i];
                    DynamicObject saveSubLimit = saveSubLimitCols.addNew();
                    saveSubLimit.set("subvaluelimit", (Object)(StringUtils.isNotEmpty((String)row[1]) && row[1].length() > 10 ? row[1].substring(0, 10) : row[1]));
                    saveSubLimit.set("subvaluelimit_tag", (Object)row[1]);
                    Map idMapType = (Map)JSON.parseObject((String)row[1], (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                    CharSequence[] ids = new String[idMapType.size()];
                    for (Map.Entry entry : idMapType.entrySet()) {
                        int index = Integer.parseInt(((String)entry.getKey()).substring(((String)entry.getKey()).lastIndexOf("_") + 1));
                        ids[index] = String.valueOf(entry.getValue());
                    }
                    String idsStr = String.join((CharSequence)",", ids);
                    saveSubLimit.set("subdataidlimit", (Object)idsStr);
                }
                shareRule.set("savesublimit", (Object)saveSubLimitCols);
            }
            DynamicObjectCollection flagEntryDyCol = shareRule.getDynamicObjectCollection("flagentryentity");
            if (this.flagEntryEntity != null) {
                for (int i = 0; i < this.flagEntryEntity.length; ++i) {
                    DynamicObject rowData5 = flagEntryDyCol.addNew();
                    String targetDimNumber = this.flagEntryEntity[i][0];
                    String type = this.flagEntryEntity[i][1];
                    String valueText = this.flagEntryEntity[i][2];
                    String value = this.flagEntryEntity[i][3];
                    String sourceDimNumber = this.flagEntryEntity[i][4];
                    if (StringUtils.isEmpty((String)targetDimNumber)) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"PABusinessRuleExportAndImportListPlugin_55", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1));
                    }
                    DynamicObject targetDimDy = dimensionMap.get(targetDimNumber);
                    if (targetDimDy == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7ef4\u5ea6\u3002", (String)"PABusinessRuleExportAndImportListPlugin_56", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetDimNumber));
                    }
                    this.setBaseDataId(rowData5, "f_targetdim", targetDimDy.getPkValue());
                    if (StringUtils.isEmpty((String)type)) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u5206\u644a\u6807\u8bc6\u503c\u6765\u6e90\u4e3a\u7a7a\u3002", (String)"PABusinessRuleExportAndImportListPlugin_57", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1));
                    }
                    rowData5.set("f_flagtype", (Object)type);
                    if (AllocationFlagEnum.VALUE.getCode().equals(type)) {
                        if (StringUtils.isEmpty((String)valueText) || StringUtils.isEmpty((String)value)) {
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u5e38\u91cf\u4e3a\u7a7a\u3002", (String)"PABusinessRuleExportAndImportListPlugin_58", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1));
                        }
                        rowData5.set("f_valuetext", (Object)valueText);
                        rowData5.set("f_value", (Object)value);
                    }
                    if (!AllocationFlagEnum.SENDER.getCode().equals(type)) continue;
                    if (StringUtils.isEmpty((String)sourceDimNumber)) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u53d1\u9001\u65b9\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"PABusinessRuleExportAndImportListPlugin_59", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1));
                    }
                    DynamicObject sourceDimDy = dimensionMap.get(sourceDimNumber);
                    if (sourceDimDy == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u65b9\u7ef4\u5ea6\u7ef4\u5ea6\u3002", (String)"PABusinessRuleExportAndImportListPlugin_60", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetDimNumber));
                    }
                    this.setBaseDataId(rowData5, "f_sourcedim", sourceDimDy.getPkValue());
                }
                shareRule.set("flagentryentity", (Object)flagEntryDyCol);
            }
            return shareRule;
        }

        @Override
        void numberConvertId(Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
            this.sendAndReceiveNumberConvertId(this.sendEntryEntity, baseDataItemMap, true);
            this.sendAndReceiveNumberConvertId(this.receiveEntryEntity, baseDataItemMap, false);
            this.detailsAndLimitNumberConvertId(this.saveSubFlexData, baseDataItemMap, dimensionMap, true);
            this.detailsAndLimitNumberConvertId(this.saveSubLimit, baseDataItemMap, dimensionMap, false);
            this.flagNumberConvertId(this.saveSubLimit, baseDataItemMap, dimensionMap);
        }

        private void detailsAndLimitNumberConvertId(String[][] entryData, Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap, boolean isDetails) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String jsonStr = entryData[i][1];
                Map numberMapType = (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                HashMap idMapType = new HashMap(16);
                for (Map.Entry entry : numberMapType.entrySet()) {
                    BaseDataItem baseDataItem;
                    String dimensionNumber = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).lastIndexOf("_"));
                    Object value = entry.getValue();
                    idMapType.put(entry.getKey(), value);
                    if ("sharerate".equals(dimensionNumber)) continue;
                    DynamicObject dim = dimensionMap.get(dimensionNumber);
                    if (dim == null) {
                        String error = isDetails ? ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8be6\u60c5\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_37", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u9650\u5b9a\u7ec4\u5408\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_38", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        throw new ValidateException(String.format(error, this.stepIndex, this.name, i + 1, dimensionNumber));
                    }
                    DimensionTypeEnum dataType = DimensionTypeEnum.getCode((String)dim.getString("dimensiontype"));
                    String entityNumber = null;
                    switch (dataType) {
                        case DATABASE: 
                        case PERIOD: {
                            entityNumber = dim.getDynamicObject("dimensionsource").getString("id");
                            break;
                        }
                        case ASSISTANTDATA: {
                            entityNumber = "bos_assistantdata_detail";
                        }
                    }
                    if (!StringUtils.isNotEmpty((String)entityNumber) || (baseDataItem = baseDataItemMap.get(entityNumber)) == null || value == null) continue;
                    Object id = baseDataItem.numberToIdMap.get(String.valueOf(value));
                    idMapType.put(entry.getKey(), id);
                }
                entryData[i][1] = JSON.toJSONString(idMapType);
            }
        }

        private void sendAndReceiveNumberConvertId(String[][] entryData, Map<String, BaseDataItem> baseDataItemMap, boolean isSend) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String key = entryData[i][5];
                if (!StringUtils.isNotEmpty((String)key)) continue;
                BaseDataItem baseDataItem = baseDataItemMap.get(key);
                if (baseDataItem == null) {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a\u5206\u644a\u89c4\u5219%1$s\u8d4b\u503c\u5230\u53d1\u9001\u65b9\u6216\u63a5\u6536\u65b9\u7b2c%2$d\u884c\uff0c\u7ef4\u5ea6\u503c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_26", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.name, i + 1));
                }
                if (StringUtils.isNotEmpty((String)entryData[i][4])) {
                    Map numberMap = (Map)JSON.parseObject((String)entryData[i][4], (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    HashMap idMap = new HashMap(numberMap.size());
                    int finalI = i;
                    numberMap.forEach((k, v) -> {
                        Object id = baseDataItem.numberToIdMap.get(k);
                        if (id == null) {
                            String error = isSend ? ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_29", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_27", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                            throw new ValidateException(String.format(error, this.stepIndex, this.name, finalI + 1, k));
                        }
                        idMap.put(String.valueOf(id), v);
                    });
                    entryData[i][4] = JSON.toJSONString(idMap);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)entryData[i][3])) continue;
                String[] numbers = entryData[i][3].split(",");
                ArrayList<String> idList = new ArrayList<String>(numbers.length);
                for (String number : numbers) {
                    if (!StringUtils.isNotEmpty((String)number)) continue;
                    Object id = baseDataItem.numberToIdMap.get(number);
                    if (id == null) {
                        String error = isSend ? ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_29", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_27", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        error = String.format(error, this.stepIndex, this.name, i + 1, number);
                        throw new ValidateException(error);
                    }
                    idList.add(String.valueOf(id));
                }
                entryData[i][3] = String.join((CharSequence)",", idList);
            }
        }

        private void flagNumberConvertId(String[][] entryData, Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String value = entryData[i][3];
                if (!StringUtils.isNotEmpty((String)value)) continue;
                String targetDimNumber = entryData[i][0];
                DynamicObject targetDimDy = dimensionMap.get(targetDimNumber);
                if (targetDimDy != null) {
                    String entityNumber = this.achieveBaseEntity(targetDimDy);
                    BaseDataItem baseDataItem = baseDataItemMap.get(entityNumber);
                    if (baseDataItem != null) {
                        Object id = baseDataItem.numberToIdMap.get(value);
                        if (id == null) {
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u5e38\u91cf\u3002", (String)"PABusinessRuleExportAndImportListPlugin_61", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, value));
                        }
                        entryData[i][3] = String.valueOf(id);
                        continue;
                    }
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$d\u884c\uff0c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7ef4\u5ea6\u7f16\u53f7\u4e3a%4$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_62", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetDimNumber));
                }
                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7ef4\u5ea6\u3002", (String)"PABusinessRuleExportAndImportListPlugin_56", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetDimNumber));
            }
        }

        private void detailsAndLimitIdConvertNumber(String[][] entryData, Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap, boolean isDetails) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String jsonStr = entryData[i][1];
                Map mapType = (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                HashMap numberMapType = new HashMap(16);
                for (Map.Entry entry : mapType.entrySet()) {
                    BaseDataItem baseDataItem;
                    String dimensionNumber = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).lastIndexOf("_"));
                    Object value = entry.getValue();
                    numberMapType.put(entry.getKey(), value);
                    if ("sharerate".equals(dimensionNumber)) continue;
                    DynamicObject dim = dimensionMap.get(dimensionNumber);
                    if (dim == null) {
                        String error = isDetails ? ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8be6\u60c5\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_37", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u9650\u5b9a\u7ec4\u5408\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_38", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        throw new ValidateException(String.format(error, this.stepIndex, this.name, i + 1, dimensionNumber));
                    }
                    DimensionTypeEnum dataType = DimensionTypeEnum.getCode((String)dim.getString("dimensiontype"));
                    String entityNumber = null;
                    switch (dataType) {
                        case DATABASE: 
                        case PERIOD: {
                            entityNumber = dim.getDynamicObject("dimensionsource").getString("id");
                            break;
                        }
                        case ASSISTANTDATA: {
                            entityNumber = "bos_assistantdata_detail";
                        }
                    }
                    if (!StringUtils.isNotEmpty((String)entityNumber) || (baseDataItem = baseDataItemMap.get(entityNumber)) == null || value == null) continue;
                    String number = baseDataItem.idToNumberMap.get(value);
                    numberMapType.put(entry.getKey(), number);
                }
                entryData[i][1] = JSON.toJSONString(numberMapType);
            }
        }

        private void sendAndReceiveIdConvertNumber(String[][] entryData, Map<String, BaseDataItem> baseDataItemMap) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                BaseDataItem baseDataItem;
                String key = entryData[i][5];
                if (!StringUtils.isNotEmpty((String)key) || (baseDataItem = baseDataItemMap.get(key)) == null) continue;
                boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                if (StringUtils.isNotEmpty((String)entryData[i][4])) {
                    Map idMap = (Map)JSON.parseObject((String)entryData[i][4], (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    HashMap numberMap = new HashMap(idMap.size());
                    idMap.forEach((k, v) -> {
                        Object id = isString ? k : Long.valueOf(k);
                        String number = baseDataItem.idToNumberMap.get(id);
                        numberMap.put(number, v);
                    });
                    entryData[i][4] = JSON.toJSONString(numberMap);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)entryData[i][3])) continue;
                String[] ids = entryData[i][3].split(",");
                ArrayList<String> numberList = new ArrayList<String>(ids.length);
                for (String id : ids) {
                    if (!StringUtils.isNotEmpty((String)id)) continue;
                    Object pk = isString ? id : Long.valueOf(id);
                    String number = baseDataItem.idToNumberMap.get(pk);
                    numberList.add(number);
                }
                entryData[i][3] = String.join((CharSequence)",", numberList);
            }
        }

        private void flagIdConvertNumber(String[][] entryData, Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String number;
                BaseDataItem baseDataItem;
                String entityNumber;
                String targetDimNumber;
                DynamicObject targetDimDy;
                String value = entryData[i][3];
                if (!StringUtils.isNotEmpty((String)value) || (targetDimDy = dimensionMap.get(targetDimNumber = entryData[i][0])) == null || !StringUtils.isNotEmpty((String)(entityNumber = this.achieveBaseEntity(targetDimDy))) || (baseDataItem = baseDataItemMap.get(entityNumber)) == null) continue;
                boolean isString = PADimensionModel.isStringPrimaryKeyType((String)entityNumber);
                Object id = isString ? value : Long.valueOf(value);
                entryData[i][3] = number = baseDataItem.idToNumberMap.get(id);
            }
        }

        private void processSendAndReceive(String[][] entryData, Map<String, DynamicObject> dimensionMap, Map<String, BaseDataItem> baseDataItemMap, boolean isId, boolean isSend) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String[] ids;
                String key = entryData[i][5];
                String dimensionNumber = entryData[i][0];
                DynamicObject dimension = dimensionMap.get(dimensionNumber);
                if (dimension == null) {
                    String error = isSend ? ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_30", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_36", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                    throw new ValidateException(String.format(error, this.stepIndex, this.name, i + 1, dimensionNumber));
                }
                if (!StringUtils.isNotEmpty((String)key)) continue;
                BaseDataItem baseDataItem = baseDataItemMap.get(key);
                if (baseDataItem == null) {
                    QFilter filter = null;
                    if (!isId) {
                        filter = this.achieveDimensionTypeFilter(dimension);
                    }
                    baseDataItem = isId ? new BaseDataItem(new HashMap<Object, String>(10)) : new BaseDataItem(new HashMap<String, Object>(10), filter);
                    baseDataItemMap.put(key, baseDataItem);
                }
                boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                if (StringUtils.isNotEmpty((String)entryData[i][4])) {
                    Map map = (Map)JSON.parseObject((String)entryData[i][4], (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    BaseDataItem finalBaseDataItem = baseDataItem;
                    map.forEach((k, v) -> {
                        if (isId) {
                            finalBaseDataItem.idToNumberMap.put(isString ? k : Long.valueOf(k), null);
                        } else {
                            finalBaseDataItem.numberToIdMap.put((String)k, null);
                        }
                    });
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)entryData[i][3])) continue;
                for (String id : ids = entryData[i][3].split(",")) {
                    if (!StringUtils.isNotEmpty((String)id)) continue;
                    if (isId) {
                        baseDataItem.idToNumberMap.put(isString ? id : Long.valueOf(id), null);
                        continue;
                    }
                    baseDataItem.numberToIdMap.put(id, null);
                }
            }
        }

        private void processDetailsAndLimit(String[][] entryData, Map<String, DynamicObject> dimensionMap, Map<String, BaseDataItem> baseDataItemMap, boolean isId, boolean isDetails) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String jsonStr = entryData[i][1];
                Map mapType = (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                HashMap changeNameMapType = new HashMap(16);
                for (Map.Entry entry : mapType.entrySet()) {
                    changeNameMapType.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).lastIndexOf("_")), entry.getValue());
                }
                for (Map.Entry fieldToValueEntry : changeNameMapType.entrySet()) {
                    String dimensionNumber = (String)fieldToValueEntry.getKey();
                    if ("sharerate".equals(dimensionNumber)) continue;
                    Object value = fieldToValueEntry.getValue();
                    DynamicObject dim = dimensionMap.get(dimensionNumber);
                    if (dim == null) {
                        String error = isDetails ? ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8be6\u60c5\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_37", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u9650\u5b9a\u7ec4\u5408\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_38", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        throw new ValidateException(String.format(error, this.stepIndex, this.name, i + 1, dimensionNumber));
                    }
                    DimensionTypeEnum dataType = DimensionTypeEnum.getCode((String)dim.getString("dimensiontype"));
                    String entityNumber = null;
                    switch (dataType) {
                        case DATABASE: 
                        case PERIOD: {
                            entityNumber = dim.getDynamicObject("dimensionsource").getString("id");
                            break;
                        }
                        case ASSISTANTDATA: {
                            entityNumber = "bos_assistantdata_detail";
                        }
                    }
                    if (!StringUtils.isNotEmpty((String)entityNumber)) continue;
                    BaseDataItem baseDataItem = baseDataItemMap.get(entityNumber);
                    if (baseDataItem == null) {
                        QFilter filter = this.achieveDimensionTypeFilter(dim);
                        baseDataItem = isId ? new BaseDataItem(new HashMap<Object, String>(10)) : new BaseDataItem(new HashMap<String, Object>(10), filter);
                        baseDataItemMap.put(entityNumber, baseDataItem);
                    }
                    if (value == null) continue;
                    if (isId) {
                        baseDataItem.idToNumberMap.put(value, null);
                        continue;
                    }
                    baseDataItem.numberToIdMap.put(String.valueOf(value), null);
                }
            }
        }

        private void processFlagEntry(String[][] entryData, Map<String, DynamicObject> dimensionMap, Map<String, BaseDataItem> baseDataItemMap, boolean isId) {
            if (entryData == null) {
                return;
            }
            for (int i = 0; i < entryData.length; ++i) {
                String value;
                String entityNumber;
                String targetDimNumber = entryData[i][0];
                DynamicObject targetDimDy = dimensionMap.get(targetDimNumber);
                if (targetDimDy == null || !StringUtils.isNotEmpty((String)(entityNumber = this.achieveBaseEntity(targetDimDy)))) continue;
                BaseDataItem baseDataItem = baseDataItemMap.get(entityNumber);
                if (baseDataItem == null) {
                    if (isId) {
                        baseDataItem = new BaseDataItem(new HashMap<Object, String>(10));
                    } else {
                        QFilter filter = this.achieveDimensionTypeFilter(targetDimDy);
                        baseDataItem = new BaseDataItem(new HashMap<String, Object>(10), filter);
                    }
                    baseDataItemMap.put(entityNumber, baseDataItem);
                }
                if (!StringUtils.isNotEmpty((String)(value = entryData[i][3]))) continue;
                boolean isString = PADimensionModel.isStringPrimaryKeyType((String)entityNumber);
                if (isId) {
                    baseDataItem.idToNumberMap.put(isString ? value : Long.valueOf(value), null);
                    continue;
                }
                baseDataItem.numberToIdMap.put(value, null);
            }
        }

        public ExtendShareRuleDynamicObject(DynamicObject shareRule) {
            DynamicObjectCollection flagEntryDyCol;
            DynamicObjectCollection receiveEntryCols;
            DynamicObjectCollection sendEntryCols;
            this.name = shareRule.getString("name");
            DynamicObjectCollection measureCols = shareRule.getDynamicObjectCollection("mulbasedatafield");
            if (measureCols != null) {
                this.shareMeasureNumbers = new String[measureCols.size()];
                int index = 0;
                for (Object measureCol : measureCols) {
                    this.shareMeasureNumbers[index++] = this.achieveNumber((DynamicObject)measureCol, "fbasedataid");
                }
            }
            if ((sendEntryCols = shareRule.getDynamicObjectCollection("sendentryentity")) != null) {
                int index = 0;
                this.sendEntryEntity = new String[sendEntryCols.size()][7];
                for (Object sendEntryCol : sendEntryCols) {
                    String[] row = new String[]{this.achieveNumber((DynamicObject)sendEntryCol, "senddimension"), sendEntryCol.getString("combofield"), sendEntryCol.getString("dimensionvalue"), sendEntryCol.getString("dimensionid"), sendEntryCol.getString("dimensiontext_tag"), sendEntryCol.getString("sendmatename"), sendEntryCol.getString("senddimtype")};
                    this.sendEntryEntity[index++] = row;
                }
            }
            this.receiveRule = shareRule.getString("receiverule");
            this.shareFactorNumber = this.achieveNumber(shareRule, "sharefactor");
            this.measureNumber = this.achieveNumber(shareRule, "measure");
            this.sendRate = shareRule.getBigDecimal("sendrate");
            this.tailDifferenceType = shareRule.getString("taildifferencetype");
            this.accountFilter = shareRule.getString("accountfilter_tag");
            this.addShareFlag = shareRule.getBoolean("addshareflag");
            DynamicObjectCollection relatedGroupDimCols = shareRule.getDynamicObjectCollection("relatedgroupdim");
            if (relatedGroupDimCols != null) {
                int index = 0;
                this.relationGroupDimNumbers = new String[relatedGroupDimCols.size()];
                for (Object relatedGroupDim : relatedGroupDimCols) {
                    String dimNumber = relatedGroupDim.getDynamicObject("fbasedataid").getString("number");
                    this.relationGroupDimNumbers[index++] = dimNumber;
                }
            }
            if ((receiveEntryCols = shareRule.getDynamicObjectCollection("receiveentryentity")) != null) {
                int index = 0;
                this.receiveEntryEntity = new String[receiveEntryCols.size()][7];
                for (Object receiveEntryCol : receiveEntryCols) {
                    String[] row = new String[]{this.achieveNumber((DynamicObject)receiveEntryCol, "receivedimension"), receiveEntryCol.getString("comboreceive"), receiveEntryCol.getString("receivedimvalue"), receiveEntryCol.getString("receivedimid"), receiveEntryCol.getString("receivedimensiontext_tag"), receiveEntryCol.getString("receivematename"), receiveEntryCol.getString("receivedimtype")};
                    this.receiveEntryEntity[index++] = row;
                }
            }
            this.inputRatioBox = shareRule.getBoolean("inputratiobox");
            DynamicObjectCollection saveSubFlexDataCols = shareRule.getDynamicObjectCollection("savesubflexdata");
            if (saveSubFlexDataCols != null) {
                this.saveSubFlexData = new String[saveSubFlexDataCols.size()][3];
                int index = 0;
                for (Object saveSubFlexDataCol : saveSubFlexDataCols) {
                    String[] row = new String[]{saveSubFlexDataCol.getString("subvalue"), saveSubFlexDataCol.getString("subvalue_tag"), saveSubFlexDataCol.getString("subdataid")};
                    this.saveSubFlexData[index++] = row;
                }
            }
            this.limitBox = shareRule.getBoolean("limitbox");
            this.limitType = shareRule.getString("limittype");
            DynamicObjectCollection saveSubLimitCols = shareRule.getDynamicObjectCollection("savesublimit");
            if (saveSubLimitCols != null) {
                this.saveSubLimit = new String[saveSubLimitCols.size()][3];
                int index = 0;
                for (DynamicObject saveSubLimitCol : saveSubLimitCols) {
                    String[] row = new String[]{saveSubLimitCol.getString("subvaluelimit"), saveSubLimitCol.getString("subvaluelimit_tag"), saveSubLimitCol.getString("subdataidlimit")};
                    this.saveSubLimit[index++] = row;
                }
            }
            if ((flagEntryDyCol = shareRule.getDynamicObjectCollection("flagentryentity")) != null) {
                this.flagEntryEntity = new String[flagEntryDyCol.size()][5];
                int index = 0;
                for (DynamicObject flagEntryDy : flagEntryDyCol) {
                    String[] row = new String[]{this.achieveNumber(flagEntryDy, "f_targetdim"), flagEntryDy.getString("f_flagtype"), flagEntryDy.getString("f_valuetext"), flagEntryDy.getString("f_value"), this.achieveNumber(flagEntryDy, "f_sourcedim")};
                    this.flagEntryEntity[index++] = row;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getStepIndex() {
            return this.stepIndex;
        }

        public void setStepIndex(int stepIndex) {
            this.stepIndex = stepIndex;
        }

        public String[] getShareMeasureNumbers() {
            return this.shareMeasureNumbers;
        }

        public void setShareMeasureNumbers(String[] shareMeasureNumbers) {
            this.shareMeasureNumbers = shareMeasureNumbers;
        }

        public String[][] getSendEntryEntity() {
            return this.sendEntryEntity;
        }

        public void setSendEntryEntity(String[][] sendEntryEntity) {
            this.sendEntryEntity = sendEntryEntity;
        }

        public String getReceiveRule() {
            return this.receiveRule;
        }

        public void setReceiveRule(String receiveRule) {
            this.receiveRule = receiveRule;
        }

        public String getShareFactorNumber() {
            return this.shareFactorNumber;
        }

        public void setShareFactorNumber(String shareFactorNumber) {
            this.shareFactorNumber = shareFactorNumber;
        }

        public String getMeasureNumber() {
            return this.measureNumber;
        }

        public void setMeasureNumber(String measureNumber) {
            this.measureNumber = measureNumber;
        }

        public BigDecimal getSendRate() {
            return this.sendRate;
        }

        public void setSendRate(BigDecimal sendRate) {
            this.sendRate = sendRate;
        }

        public String getTailDifferenceType() {
            return this.tailDifferenceType;
        }

        public void setTailDifferenceType(String tailDifferenceType) {
            this.tailDifferenceType = tailDifferenceType;
        }

        public String getAccountFilter() {
            return this.accountFilter;
        }

        public void setAccountFilter(String accountFilter) {
            this.accountFilter = accountFilter;
        }

        public String[] getRelationGroupDimNumbers() {
            return this.relationGroupDimNumbers;
        }

        public void setRelationGroupDimNumbers(String[] relationGroupDimNumbers) {
            this.relationGroupDimNumbers = relationGroupDimNumbers;
        }

        public Boolean getAddShareFlag() {
            return this.addShareFlag;
        }

        public void setAddShareFlag(Boolean addShareFlag) {
            this.addShareFlag = addShareFlag;
        }

        public String[][] getReceiveEntryEntity() {
            return this.receiveEntryEntity;
        }

        public void setReceiveEntryEntity(String[][] receiveEntryEntity) {
            this.receiveEntryEntity = receiveEntryEntity;
        }

        public boolean isInputRatioBox() {
            return this.inputRatioBox;
        }

        public void setInputRatioBox(boolean inputRatioBox) {
            this.inputRatioBox = inputRatioBox;
        }

        public String[][] getSaveSubFlexData() {
            return this.saveSubFlexData;
        }

        public void setSaveSubFlexData(String[][] saveSubFlexData) {
            this.saveSubFlexData = saveSubFlexData;
        }

        public boolean isLimitBox() {
            return this.limitBox;
        }

        public void setLimitBox(boolean limitBox) {
            this.limitBox = limitBox;
        }

        public String getLimitType() {
            return this.limitType;
        }

        public void setLimitType(String limitType) {
            this.limitType = limitType;
        }

        public String[][] getSaveSubLimit() {
            return this.saveSubLimit;
        }

        public void setSaveSubLimit(String[][] saveSubLimit) {
            this.saveSubLimit = saveSubLimit;
        }

        public String[][] getFlagEntryEntity() {
            return this.flagEntryEntity;
        }

        public void setFlagEntryEntity(String[][] flagEntryEntity) {
            this.flagEntryEntity = flagEntryEntity;
        }
    }

    private static class ExtendDerivationRuleDynamicObject
    extends ExtendDynamicObject {
        private static final long serialVersionUID = -5260449199283975531L;
        private int stepIndex;
        private String name;
        private String[][] sendEntry;
        private String derivationMode;
        private String mappingMap;
        private String mappingMapType;
        private String mappingRelationShipNumber;
        private String[] sourceEntryEntity;
        private String[][] targetEntryEntity;
        private String[][] mtSourceEntryEntity;
        private String[][] mtTargetEntryEntity;
        private String[][] customEntryEntity;

        public ExtendDerivationRuleDynamicObject(DynamicObject derivationRule) {
            DynamicObjectCollection customEntryEntityCols;
            DynamicObjectCollection mtTargetEntryCols;
            DynamicObjectCollection mtSourceEntryCols;
            DynamicObjectCollection targetEntryCols;
            this.name = derivationRule.getString("name");
            DynamicObjectCollection sendEntryCols = derivationRule.getDynamicObjectCollection("sendentryentity");
            if (sendEntryCols != null) {
                this.sendEntry = new String[sendEntryCols.size()][5];
                int index = 0;
                for (Object sendEntryObj : sendEntryCols) {
                    String[] entryDataArr = new String[]{this.achieveNumber((DynamicObject)sendEntryObj, "senddimension"), sendEntryObj.getString("combofield"), sendEntryObj.getString("dimensiontype_basedata"), sendEntryObj.getString("dimensiontype_assistant"), sendEntryObj.getString("dimensiontext_tag")};
                    this.sendEntry[index++] = entryDataArr;
                }
            }
            this.derivationMode = derivationRule.getString("derivationmode");
            this.mappingMap = derivationRule.getString("mappingmap");
            this.mappingMapType = derivationRule.getString("mappingmaptype");
            this.mappingRelationShipNumber = this.achieveNumber(derivationRule, "mappingrelationship");
            DynamicObjectCollection sourceEntryCols = derivationRule.getDynamicObjectCollection("source_entryentity");
            if (sourceEntryCols != null) {
                this.sourceEntryEntity = new String[sourceEntryCols.size()];
                int index = 0;
                for (Object sourceEntryCol : sourceEntryCols) {
                    this.sourceEntryEntity[index++] = this.achieveNumber((DynamicObject)sourceEntryCol, "sourcefield");
                }
            }
            if ((targetEntryCols = derivationRule.getDynamicObjectCollection("target_entryentity")) != null) {
                this.targetEntryEntity = new String[targetEntryCols.size()][5];
                int index = 0;
                for (Iterator targetEntryCol : targetEntryCols) {
                    String[] targetRow = new String[]{this.achieveNumber((DynamicObject)targetEntryCol, "targetfield"), targetEntryCol.getString("default_text_e"), targetEntryCol.getString("default_text"), targetEntryCol.getString("fieldtype_basedata"), targetEntryCol.getString("fieldtype_assistant")};
                    this.targetEntryEntity[index++] = targetRow;
                }
            }
            if ((mtSourceEntryCols = derivationRule.getDynamicObjectCollection("mt_source_entryentity")) != null) {
                this.mtSourceEntryEntity = new String[mtSourceEntryCols.size()][7];
                int index = 0;
                for (Iterator mtSourceEntryCol : mtSourceEntryCols) {
                    String[] mtSourceRow = new String[]{this.achieveNumber((DynamicObject)mtSourceEntryCol, "mt_source"), mtSourceEntryCol.getString("mt_sourcefield"), mtSourceEntryCol.getString("mt_sourcefield_number"), mtSourceEntryCol.getString("mt_sourcefield_type"), mtSourceEntryCol.getString("mt_m_sourcefield"), mtSourceEntryCol.getString("mt_m_sourcefield_number"), mtSourceEntryCol.getString("mt_m_sourcefield_type")};
                    this.mtSourceEntryEntity[index++] = mtSourceRow;
                }
            }
            if ((mtTargetEntryCols = derivationRule.getDynamicObjectCollection("mt_target_entryentity")) != null) {
                this.mtTargetEntryEntity = new String[mtTargetEntryCols.size()][11];
                int index = 0;
                for (DynamicObject mtTargetEntryCol : mtTargetEntryCols) {
                    String[] mtTargetRow = new String[]{mtTargetEntryCol.getString("mt_m_targetfield"), mtTargetEntryCol.getString("mt_m_targetfield_number"), mtTargetEntryCol.getString("mt_m_targetfield_type"), mtTargetEntryCol.getString("mt_m_default_text_e"), mtTargetEntryCol.getString("mt_m_default_text"), mtTargetEntryCol.getString("mt_m_fieldtype_basedata"), mtTargetEntryCol.getString("mt_m_fieldtype_assistant"), this.achieveNumber(mtTargetEntryCol, "mt_target"), mtTargetEntryCol.getString("mt_targetfield"), mtTargetEntryCol.getString("mt_targetfield_number"), mtTargetEntryCol.getString("mt_targetfield_type")};
                    this.mtTargetEntryEntity[index++] = mtTargetRow;
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(customEntryEntityCols = derivationRule.getDynamicObjectCollection("custom_entryentity")))) {
                this.customEntryEntity = new String[customEntryEntityCols.size()][12];
                int index = 0;
                for (DynamicObject customEntryCol : customEntryEntityCols) {
                    String[] customRow = new String[]{customEntryCol.getString("filtercondition"), customEntryCol.getString("filterconditionjson_tag"), this.achieveNumber(customEntryCol, "sourcedim"), customEntryCol.getString("sourcedimfield"), customEntryCol.getString("sourcedimfieldnum"), customEntryCol.getString("sourcedimfieldtype"), this.achieveNumber(customEntryCol, "targetdim"), customEntryCol.getString("targetdimfield"), customEntryCol.getString("targetdimfieldnum"), customEntryCol.getString("targetdimfieldtype"), customEntryCol.getString("defaulttext"), customEntryCol.getString("defaulttextvalue")};
                    this.customEntryEntity[index++] = customRow;
                }
            }
        }

        @Override
        String serializeKey() {
            return "derivationrule:";
        }

        @Override
        Map<String, BaseDataItem> achieveBaseData(DynamicObject analysisModel, boolean isId) {
            QFilter filter;
            Object baseDataItem;
            String key;
            String groupNumber;
            String baseEntity;
            int i;
            DynamicObjectCollection dimEntryCols = analysisModel.getDynamicObjectCollection("dimension_entry");
            Map<String, DynamicObject> dimensionMap = dimEntryCols.stream().map(rowData -> rowData.getDynamicObject("dimension")).collect(Collectors.toMap(dimObj -> dimObj.getString("number"), dimObj -> dimObj));
            HashMap<String, BaseDataItem> baseDataItemMap = new HashMap<String, BaseDataItem>(10);
            if (this.sendEntry != null) {
                for (i = 0; i < this.sendEntry.length; ++i) {
                    baseEntity = this.sendEntry[i][2];
                    groupNumber = this.sendEntry[i][3];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    baseDataItem = (BaseDataItem)baseDataItemMap.get(key);
                    if (baseDataItem == null) {
                        if (isId) {
                            baseDataItem = new BaseDataItem(new HashMap<Object, String>(10));
                        } else {
                            DynamicObject dimObj2 = dimensionMap.get(this.sendEntry[i][0]);
                            if (dimObj2 == null) {
                                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_30", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.sendEntry[i][0]));
                            }
                            filter = this.achieveDimensionTypeFilter(dimObj2);
                            baseDataItem = new BaseDataItem(new HashMap<String, Object>(10), filter);
                        }
                        baseDataItemMap.put(key, (BaseDataItem)baseDataItem);
                    }
                    if (!StringUtils.isNotEmpty((String)this.sendEntry[i][4])) continue;
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                    Object finalBaseDataItem = baseDataItem;
                    Map map = (Map)JSON.parseObject((String)this.sendEntry[i][4], (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    map.forEach((arg_0, arg_1) -> ExtendDerivationRuleDynamicObject.lambda$achieveBaseData$3(isId, (BaseDataItem)finalBaseDataItem, isString, arg_0, arg_1));
                }
            }
            if (this.targetEntryEntity != null) {
                for (i = 0; i < this.targetEntryEntity.length; ++i) {
                    baseEntity = this.targetEntryEntity[i][3];
                    groupNumber = this.targetEntryEntity[i][4];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    baseDataItem = (BaseDataItem)baseDataItemMap.get(key);
                    if (baseDataItem == null) {
                        if (isId) {
                            baseDataItem = new BaseDataItem(new HashMap<Object, String>(10));
                        } else {
                            DynamicObject dimObj3 = dimensionMap.get(this.targetEntryEntity[i][0]);
                            if (dimObj3 == null) {
                                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_31", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.targetEntryEntity[i][0]));
                            }
                            filter = this.achieveDimensionTypeFilter(dimObj3);
                            baseDataItem = new BaseDataItem(new HashMap<String, Object>(10), filter);
                        }
                        baseDataItemMap.put(key, (BaseDataItem)baseDataItem);
                    }
                    if (!StringUtils.isNotEmpty((String)this.targetEntryEntity[i][2])) continue;
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                    if (isId) {
                        ((BaseDataItem)baseDataItem).idToNumberMap.put(isString ? this.targetEntryEntity[i][2] : Long.valueOf(this.targetEntryEntity[i][2]), null);
                        continue;
                    }
                    ((BaseDataItem)baseDataItem).numberToIdMap.put(this.targetEntryEntity[i][2], null);
                }
            }
            if (this.mtTargetEntryEntity != null) {
                for (i = 0; i < this.mtTargetEntryEntity.length; ++i) {
                    baseEntity = this.mtTargetEntryEntity[i][5];
                    groupNumber = this.mtTargetEntryEntity[i][6];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    baseDataItem = (BaseDataItem)baseDataItemMap.get(key);
                    if (baseDataItem == null) {
                        if (isId) {
                            baseDataItem = new BaseDataItem(new HashMap<Object, String>(10));
                        } else {
                            DynamicObject dimObj4 = dimensionMap.get(this.mtTargetEntryEntity[i][7]);
                            if (dimObj4 == null) {
                                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u76ee\u6807\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_32", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.mtTargetEntryEntity[i][7]));
                            }
                            filter = this.achieveDimensionTypeFilter(dimObj4);
                            baseDataItem = new BaseDataItem(new HashMap<String, Object>(10), filter);
                        }
                        baseDataItemMap.put(key, (BaseDataItem)baseDataItem);
                    }
                    if (!StringUtils.isNotEmpty((String)this.mtTargetEntryEntity[i][4])) continue;
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                    if (isId) {
                        ((BaseDataItem)baseDataItem).idToNumberMap.put(isString ? this.mtTargetEntryEntity[i][4] : Long.valueOf(this.mtTargetEntryEntity[i][4]), null);
                        continue;
                    }
                    ((BaseDataItem)baseDataItem).numberToIdMap.put(this.mtTargetEntryEntity[i][4], null);
                }
            }
            if (!isId && StringUtils.isNotEmpty((String)this.mappingRelationShipNumber)) {
                BaseDataItem baseDataItem2 = (BaseDataItem)baseDataItemMap.get("pa_mappingrelationship");
                if (baseDataItem2 == null) {
                    baseDataItem2 = new BaseDataItem(new HashMap<String, Object>(10), null);
                    baseDataItemMap.put("pa_mappingrelationship", baseDataItem2);
                }
                baseDataItem2.numberToIdMap.put(this.mappingRelationShipNumber, null);
            }
            if (this.customEntryEntity != null) {
                for (int i2 = 0; i2 < this.customEntryEntity.length; ++i2) {
                    String filterConditionStr = this.customEntryEntity[i2][1];
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
                    List filterRowList = filterCondition.getFilterRow();
                    for (SimpleFilterRow filterRow : filterRowList) {
                        String fieldName = filterRow.getFieldName();
                        if (fieldName.endsWith(".id")) {
                            String[] fields = fieldName.split("\\.");
                            if (fields.length <= 0) continue;
                            String dimNumber = fields[0];
                            DynamicObject dimObj5 = dimensionMap.get(dimNumber);
                            if (dimObj5 != null) {
                                String entityNumber = this.achieveBaseEntity(dimObj5);
                                BaseDataItem baseDataItem3 = (BaseDataItem)baseDataItemMap.get(entityNumber);
                                if (baseDataItem3 == null) {
                                    if (isId) {
                                        baseDataItem3 = new BaseDataItem(new HashMap<Object, String>(10));
                                    } else {
                                        QFilter filter2 = this.achieveDimensionTypeFilter(dimObj5);
                                        baseDataItem3 = new BaseDataItem(new HashMap<String, Object>(10), filter2);
                                    }
                                    baseDataItemMap.put(entityNumber, baseDataItem3);
                                }
                                boolean isString = PADimensionModel.isStringPrimaryKeyType((String)entityNumber);
                                List filterValueList = filterRow.getBaseDataIds();
                                if (!CollectionUtils.isNotEmpty((Collection)filterValueList)) continue;
                                for (FilterValue filterValue : filterValueList) {
                                    String idStr = String.valueOf(filterValue.getValue());
                                    if (isId) {
                                        baseDataItem3.idToNumberMap.put(isString ? idStr : Long.valueOf(idStr), null);
                                        continue;
                                    }
                                    baseDataItem3.numberToIdMap.put(idStr, null);
                                }
                                continue;
                            }
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_44", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i2 + 1, dimNumber));
                        }
                        filterRow.setBaseDataIds(new ArrayList(0));
                    }
                    this.customEntryEntity[i2][1] = SerializationUtils.toJsonString((Object)filterCondition);
                    if (!StringUtils.isNotEmpty((String)this.customEntryEntity[i2][11])) continue;
                    String targetDimNumber = this.customEntryEntity[i2][6];
                    DynamicObject dimObj6 = dimensionMap.get(targetDimNumber);
                    if (dimObj6 != null) {
                        String entityNumber = this.achieveBaseEntity(dimObj6);
                        if (!StringUtils.isNotEmpty((String)entityNumber)) continue;
                        BaseDataItem baseDataItem4 = (BaseDataItem)baseDataItemMap.get(entityNumber);
                        if (baseDataItem4 == null) {
                            if (isId) {
                                baseDataItem4 = new BaseDataItem(new HashMap<Object, String>(10));
                            } else {
                                QFilter filter3 = this.achieveDimensionTypeFilter(dimObj6);
                                baseDataItem4 = new BaseDataItem(new HashMap<String, Object>(10), filter3);
                            }
                            baseDataItemMap.put(entityNumber, baseDataItem4);
                        }
                        boolean isString = PADimensionModel.isStringPrimaryKeyType((String)entityNumber);
                        if (isId) {
                            baseDataItem4.idToNumberMap.put(isString ? this.customEntryEntity[i2][11] : Long.valueOf(this.customEntryEntity[i2][11]), null);
                            continue;
                        }
                        baseDataItem4.numberToIdMap.put(this.customEntryEntity[i2][11], null);
                        continue;
                    }
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_45", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i2 + 1, targetDimNumber));
                }
            }
            return baseDataItemMap;
        }

        private String achieveBaseEntity(DynamicObject dimObj) {
            DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimObj.getString("dimensiontype"));
            String entityNumber = null;
            switch (dimType) {
                case DATABASE: 
                case PERIOD: {
                    entityNumber = dimObj.getDynamicObject("dimensionsource").getString("id");
                    break;
                }
                case ASSISTANTDATA: {
                    entityNumber = "bos_assistantdata_detail";
                }
            }
            return entityNumber;
        }

        @Override
        void idConvertNumber(Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
            Object id;
            Object baseDataItem;
            String key;
            String groupNumber;
            String baseEntity;
            int i;
            if (this.sendEntry != null) {
                for (i = 0; i < this.sendEntry.length; ++i) {
                    baseEntity = this.sendEntry[i][2];
                    groupNumber = this.sendEntry[i][3];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key) || (baseDataItem = baseDataItemMap.get(key)) == null || !StringUtils.isNotEmpty((String)this.sendEntry[i][4])) continue;
                    Map idMap = (Map)JSON.parseObject((String)this.sendEntry[i][4], (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    HashMap numberMap = new HashMap(idMap.size());
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                    idMap.forEach((arg_0, arg_1) -> ExtendDerivationRuleDynamicObject.lambda$idConvertNumber$4(isString, numberMap, (BaseDataItem)baseDataItem, arg_0, arg_1));
                    this.sendEntry[i][4] = JSON.toJSONString(numberMap);
                }
            }
            if (this.targetEntryEntity != null) {
                for (i = 0; i < this.targetEntryEntity.length; ++i) {
                    String number;
                    baseEntity = this.targetEntryEntity[i][3];
                    groupNumber = this.targetEntryEntity[i][4];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key) || (baseDataItem = baseDataItemMap.get(key)) == null || !StringUtils.isNotEmpty((String)this.targetEntryEntity[i][2])) continue;
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                    id = isString ? this.targetEntryEntity[i][2] : Long.valueOf(this.targetEntryEntity[i][2]);
                    this.targetEntryEntity[i][2] = number = ((BaseDataItem)baseDataItem).idToNumberMap.get(id);
                }
            }
            if (this.mtTargetEntryEntity != null) {
                for (i = 0; i < this.mtTargetEntryEntity.length; ++i) {
                    String number;
                    baseEntity = this.mtTargetEntryEntity[i][5];
                    groupNumber = this.mtTargetEntryEntity[i][6];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key) || (baseDataItem = baseDataItemMap.get(key)) == null || !StringUtils.isNotEmpty((String)this.mtTargetEntryEntity[i][4])) continue;
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)key);
                    id = isString ? this.mtTargetEntryEntity[i][4] : Long.valueOf(this.mtTargetEntryEntity[i][4]);
                    this.mtTargetEntryEntity[i][4] = number = ((BaseDataItem)baseDataItem).idToNumberMap.get(id);
                }
            }
            if (this.customEntryEntity != null) {
                for (i = 0; i < this.customEntryEntity.length; ++i) {
                    String number;
                    BaseDataItem baseDataItem2;
                    String entityNumber;
                    String targetDimNumber;
                    DynamicObject dimObj;
                    String filterConditionStr = this.customEntryEntity[i][1];
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
                    List filterRowList = filterCondition.getFilterRow();
                    for (SimpleFilterRow filterRow : filterRowList) {
                        String dimNumber;
                        DynamicObject dimObj2;
                        String[] fields;
                        String fieldName = filterRow.getFieldName();
                        if (!fieldName.endsWith(".id") || (fields = fieldName.split("\\.")).length <= 0 || (dimObj2 = dimensionMap.get(dimNumber = fields[0])) == null) continue;
                        String entityNumber2 = this.achieveBaseEntity(dimObj2);
                        BaseDataItem baseDataItem3 = baseDataItemMap.get(entityNumber2);
                        boolean isString = PADimensionModel.isStringPrimaryKeyType((String)entityNumber2);
                        List filterValueList = filterRow.getBaseDataIds();
                        if (baseDataItem3 == null || !CollectionUtils.isNotEmpty((Collection)filterValueList)) continue;
                        for (FilterValue filterValue : filterValueList) {
                            String idStr = String.valueOf(filterValue.getValue());
                            Object id2 = isString ? idStr : Long.valueOf(idStr);
                            String number2 = baseDataItem3.idToNumberMap.get(id2);
                            filterValue.setValue((Object)number2);
                        }
                    }
                    this.customEntryEntity[i][1] = SerializationUtils.toJsonString((Object)filterCondition);
                    if (!StringUtils.isNotEmpty((String)this.customEntryEntity[i][11]) || (dimObj = dimensionMap.get(targetDimNumber = this.customEntryEntity[i][6])) == null || !StringUtils.isNotEmpty((String)(entityNumber = this.achieveBaseEntity(dimObj))) || (baseDataItem2 = baseDataItemMap.get(entityNumber)) == null) continue;
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)entityNumber);
                    Object id3 = isString ? this.customEntryEntity[i][11] : Long.valueOf(this.customEntryEntity[i][11]);
                    this.customEntryEntity[i][11] = number = baseDataItem2.idToNumberMap.get(id3);
                }
            }
        }

        @Override
        DynamicObject createDynamicObject(Map<String, BaseDataItem> baseDataItemMap, boolean isId, DynamicObject analysisModel, Long orgId) {
            DynamicObject rowData2;
            DynamicObject dimObj2;
            DynamicObjectCollection dimEntryCols = analysisModel.getDynamicObjectCollection("dimension_entry");
            Map<String, DynamicObject> dimensionMap = dimEntryCols.stream().map(rowData -> rowData.getDynamicObject("dimension")).collect(Collectors.toMap(dimObj -> dimObj.getString("number"), dimObj -> dimObj));
            this.numberConvertId(baseDataItemMap, dimensionMap);
            DynamicObject derivationRule = BusinessDataServiceHelper.newDynamicObject((String)"pa_derivationrule");
            derivationRule.set("analysissystem", analysisModel.get("analysis_system"));
            derivationRule.set("analysismodel", (Object)analysisModel);
            this.fillFixFieldValue(derivationRule);
            RequestContext rc = RequestContext.get();
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)rc.getOrgId(), (String)"bos_org");
            derivationRule.set("useOrg", (Object)orgObj);
            derivationRule.set("createorg", (Object)orgObj);
            derivationRule.set("org", (Object)orgObj);
            String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)"pa_businessrule", (String)String.valueOf(rc.getOrgId()));
            if (StringUtils.isNotEmpty((String)ctrlStrategy)) {
                String[] ctrlStrategyArr = ctrlStrategy.split(",");
                if (ctrlStrategyArr.length <= 1) {
                    derivationRule.set("ctrlstrategy", (Object)ctrlStrategy);
                } else {
                    for (String ctr : ctrlStrategyArr) {
                        if (!StringUtils.isNotEmpty((String)ctr)) continue;
                        derivationRule.set("ctrlstrategy", (Object)ctr);
                        break;
                    }
                }
            }
            derivationRule.set("name", (Object)this.name);
            DynamicObjectCollection sendEntryCols = derivationRule.getDynamicObjectCollection("sendentryentity");
            if (this.sendEntry != null) {
                int index = 1;
                for (String[] sendEntry : this.sendEntry) {
                    dimObj2 = dimensionMap.get(sendEntry[0]);
                    if (dimObj2 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_30", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, index, sendEntry[0]));
                    }
                    rowData2 = sendEntryCols.addNew();
                    this.setBaseDataId(rowData2, "senddimension", dimObj2.getPkValue());
                    rowData2.set("combofield", (Object)sendEntry[1]);
                    DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimObj2.getString("dimensiontype"));
                    if (StringUtils.isNotEmpty((String)sendEntry[2]) && dimType != DimensionTypeEnum.DATABASE && dimType != DimensionTypeEnum.PERIOD) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_41", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, index, sendEntry[0]));
                    }
                    rowData2.set("dimensiontype_basedata", (Object)sendEntry[2]);
                    if (StringUtils.isNotEmpty((String)sendEntry[3]) && dimType != DimensionTypeEnum.ASSISTANTDATA) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u7b2c%3$s\u884c\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_41", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, index, sendEntry[0]));
                    }
                    rowData2.set("dimensiontype_assistant", (Object)sendEntry[3]);
                    rowData2.set("dimensiontext_tag", (Object)sendEntry[4]);
                    ++index;
                }
            }
            derivationRule.set("derivationmode", (Object)this.derivationMode);
            derivationRule.set("mappingmap", (Object)this.mappingMap);
            derivationRule.set("mappingmaptype", (Object)this.mappingMapType);
            if (StringUtils.isNotEmpty((String)this.mappingMapType)) {
                try {
                    EntityMetadataCache.getDataEntityType((String)this.mappingMapType);
                }
                catch (Exception e) {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%3$s\u7684\u6765\u6e90\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_39", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, this.mappingMapType));
                }
            }
            if (StringUtils.isNotEmpty((String)this.mappingRelationShipNumber)) {
                BaseDataItem baseDataItem = baseDataItemMap.get("pa_mappingrelationship");
                if (baseDataItem == null || baseDataItem.numberToIdMap.get(this.mappingRelationShipNumber) == null) {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%3$s\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u6620\u5c04\u5173\u7cfb\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, this.mappingRelationShipNumber));
                }
                this.setBaseDataId(derivationRule, "mappingrelationship", baseDataItem.numberToIdMap.get(this.mappingRelationShipNumber));
            }
            DynamicObjectCollection sourceEntryCols = derivationRule.getDynamicObjectCollection("source_entryentity");
            if (this.sourceEntryEntity != null) {
                for (int i = 0; i < this.sourceEntryEntity.length; ++i) {
                    DynamicObject dimObj3 = dimensionMap.get(this.sourceEntryEntity[i]);
                    if (dimObj3 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u6e90\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_33", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.sourceEntryEntity[i]));
                    }
                    DynamicObject rowData3 = sourceEntryCols.addNew();
                    this.setBaseDataId(rowData3, "sourcefield", dimObj3.getPkValue());
                }
                derivationRule.set("source_entryentity", (Object)sourceEntryCols);
            }
            DynamicObjectCollection targetEntryCols = derivationRule.getDynamicObjectCollection("target_entryentity");
            if (this.targetEntryEntity != null) {
                for (int i = 0; i < this.targetEntryEntity.length; ++i) {
                    String[] targetRow = this.targetEntryEntity[i];
                    DynamicObject dimObj4 = dimensionMap.get(targetRow[0]);
                    if (dimObj4 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_31", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetRow[0]));
                    }
                    DynamicObject rowData4 = targetEntryCols.addNew();
                    this.setBaseDataId(rowData4, "targetfield", dimObj4.getPkValue());
                    rowData4.set("default_text_e", (Object)targetRow[1]);
                    rowData4.set("default_text", (Object)targetRow[2]);
                    DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimObj4.getString("dimensiontype"));
                    if (StringUtils.isNotEmpty((String)targetRow[3]) && dimType != DimensionTypeEnum.DATABASE && dimType != DimensionTypeEnum.PERIOD) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_42", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetRow[0]));
                    }
                    rowData4.set("fieldtype_basedata", (Object)targetRow[3]);
                    if (StringUtils.isNotEmpty((String)targetRow[4]) && dimType != DimensionTypeEnum.ASSISTANTDATA) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_42", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetRow[0]));
                    }
                    rowData4.set("fieldtype_assistant", (Object)targetRow[4]);
                }
                derivationRule.set("target_entryentity", (Object)targetEntryCols);
            }
            DynamicObjectCollection mtSourceEntryCols = derivationRule.getDynamicObjectCollection("mt_source_entryentity");
            if (this.mtSourceEntryEntity != null) {
                for (int i = 0; i < this.mtSourceEntryEntity.length; ++i) {
                    String[] mtSourceRow = this.mtSourceEntryEntity[i];
                    dimObj2 = dimensionMap.get(mtSourceRow[0]);
                    if (dimObj2 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u5173\u8054\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u6e90\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_34", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, mtSourceRow[0]));
                    }
                    rowData2 = mtSourceEntryCols.addNew();
                    this.setBaseDataId(rowData2, "mt_source", dimObj2.getPkValue());
                    rowData2.set("mt_sourcefield", (Object)mtSourceRow[1]);
                    rowData2.set("mt_sourcefield_number", (Object)mtSourceRow[2]);
                    rowData2.set("mt_sourcefield_type", (Object)mtSourceRow[3]);
                    rowData2.set("mt_m_sourcefield", (Object)mtSourceRow[4]);
                    rowData2.set("mt_m_sourcefield_number", (Object)mtSourceRow[5]);
                    rowData2.set("mt_m_sourcefield_type", (Object)mtSourceRow[6]);
                }
                derivationRule.set("mt_source_entryentity", (Object)mtSourceEntryCols);
            }
            DynamicObjectCollection mtTargetEntryCols = derivationRule.getDynamicObjectCollection("mt_target_entryentity");
            if (this.mtTargetEntryEntity != null) {
                for (int i = 0; i < this.mtTargetEntryEntity.length; ++i) {
                    String[] mtTargetRow = this.mtTargetEntryEntity[i];
                    DynamicObject dimObj5 = dimensionMap.get(mtTargetRow[7]);
                    if (dimObj5 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u76ee\u6807\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_32", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, mtTargetRow[7]));
                    }
                    DynamicObject rowData5 = mtTargetEntryCols.addNew();
                    rowData5.set("mt_m_targetfield", (Object)mtTargetRow[0]);
                    rowData5.set("mt_m_targetfield_number", (Object)mtTargetRow[1]);
                    rowData5.set("mt_m_targetfield_type", (Object)mtTargetRow[2]);
                    rowData5.set("mt_m_default_text_e", (Object)mtTargetRow[3]);
                    rowData5.set("mt_m_default_text", (Object)mtTargetRow[4]);
                    rowData5.set("mt_m_fieldtype_basedata", (Object)mtTargetRow[5]);
                    rowData5.set("mt_m_fieldtype_assistant", (Object)mtTargetRow[6]);
                    this.setBaseDataId(rowData5, "mt_target", dimObj5.getPkValue());
                    rowData5.set("mt_targetfield", (Object)mtTargetRow[8]);
                    rowData5.set("mt_targetfield_number", (Object)mtTargetRow[9]);
                    rowData5.set("mt_targetfield_type", (Object)mtTargetRow[10]);
                }
                derivationRule.set("mt_target_entryentity", (Object)mtTargetEntryCols);
            }
            DynamicObjectCollection customEntryEntityCols = derivationRule.getDynamicObjectCollection("custom_entryentity");
            if (this.customEntryEntity != null) {
                for (int i = 0; i < this.customEntryEntity.length; ++i) {
                    DynamicObject dimObj6;
                    rowData2 = customEntryEntityCols.addNew();
                    rowData2.set("filtercondition", (Object)this.customEntryEntity[i][0]);
                    rowData2.set("filterconditionjson_tag", (Object)this.customEntryEntity[i][1]);
                    if (StringUtils.isNotEmpty((String)this.customEntryEntity[i][2])) {
                        dimObj6 = dimensionMap.get(this.customEntryEntity[i][2]);
                        if (dimObj6 == null) {
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u6e90\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_46", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.customEntryEntity[i][2]));
                        }
                        rowData2.set("sourcedim", dimObj6.getPkValue());
                    }
                    rowData2.set("sourcedimfield", (Object)this.customEntryEntity[i][3]);
                    rowData2.set("sourcedimfieldnum", (Object)this.customEntryEntity[i][4]);
                    rowData2.set("sourcedimfieldtype", (Object)this.customEntryEntity[i][5]);
                    dimObj6 = dimensionMap.get(this.customEntryEntity[i][6]);
                    if (dimObj6 == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u76ee\u6807\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_47", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.customEntryEntity[i][6]));
                    }
                    rowData2.set("targetdim", dimObj6.getPkValue());
                    rowData2.set("targetdimfield", (Object)this.customEntryEntity[i][7]);
                    rowData2.set("targetdimfieldnum", (Object)this.customEntryEntity[i][8]);
                    rowData2.set("targetdimfieldtype", (Object)this.customEntryEntity[i][9]);
                    rowData2.set("defaulttext", (Object)this.customEntryEntity[i][10]);
                    rowData2.set("defaulttextvalue", (Object)this.customEntryEntity[i][11]);
                }
                derivationRule.set("custom_entryentity", (Object)customEntryEntityCols);
            }
            return derivationRule;
        }

        @Override
        void numberConvertId(Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
            Object baseDataItem;
            String key;
            String groupNumber;
            String baseEntity;
            int i;
            if (this.sendEntry != null) {
                for (i = 0; i < this.sendEntry.length; ++i) {
                    baseEntity = this.sendEntry[i][2];
                    groupNumber = this.sendEntry[i][3];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key) || StringUtils.isEmpty((String)this.sendEntry[i][4])) continue;
                    baseDataItem = baseDataItemMap.get(key);
                    if (baseDataItem != null) {
                        Map numberMap = (Map)JSON.parseObject((String)this.sendEntry[i][4], (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        HashMap idMap = new HashMap(numberMap.size());
                        int finalI = i;
                        numberMap.forEach((arg_0, arg_1) -> this.lambda$numberConvertId$8((BaseDataItem)baseDataItem, finalI, idMap, arg_0, arg_1));
                        this.sendEntry[i][4] = JSON.toJSONString(idMap);
                        continue;
                    }
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a\u63a8\u5bfc\u89c4\u5219%1$s\u53d1\u9001\u65b9\u503c\u8303\u56f4\u7b2c%2$d\u884c\uff0c\u7ef4\u5ea6\u503c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_19", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.name, i + 1));
                }
            }
            if (this.targetEntryEntity != null) {
                for (i = 0; i < this.targetEntryEntity.length; ++i) {
                    baseEntity = this.targetEntryEntity[i][3];
                    groupNumber = this.targetEntryEntity[i][4];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key) || StringUtils.isEmpty((String)this.targetEntryEntity[i][2])) continue;
                    baseDataItem = baseDataItemMap.get(key);
                    if (baseDataItem != null) {
                        Object id = ((BaseDataItem)baseDataItem).numberToIdMap.get(this.targetEntryEntity[i][2]);
                        if (id == null) {
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u9ed8\u8ba4\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.targetEntryEntity[i][2]));
                        }
                        this.targetEntryEntity[i][2] = String.valueOf(id);
                        continue;
                    }
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a\u63a8\u5bfc\u89c4\u5219%1$s\u76ee\u6807\u7ef4\u5ea6\u7b2c%2$d\u884c\uff0c\u9ed8\u8ba4\u503c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_21", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.name, i + 1));
                }
            }
            if (this.mtTargetEntryEntity != null) {
                for (i = 0; i < this.mtTargetEntryEntity.length; ++i) {
                    baseEntity = this.mtTargetEntryEntity[i][5];
                    groupNumber = this.mtTargetEntryEntity[i][6];
                    String string = StringUtils.isNotEmpty((String)baseEntity) ? baseEntity : (key = StringUtils.isNotEmpty((String)groupNumber) ? "bos_assistantdata_detail" : null);
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    baseDataItem = baseDataItemMap.get(key);
                    if (baseDataItem == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a\u63a8\u5bfc\u89c4\u5219%1$s\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u7b2c%2$d\u884c\uff0c\u9ed8\u8ba4\u503c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_22", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.name, i + 1));
                    }
                    if (!StringUtils.isNotEmpty((String)this.mtTargetEntryEntity[i][4])) continue;
                    String number = this.mtTargetEntryEntity[i][4];
                    Object id = ((BaseDataItem)baseDataItem).numberToIdMap.get(number);
                    if (id == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u63a5\u6536\u65b9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u9ed8\u8ba4\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, number));
                    }
                    this.mtTargetEntryEntity[i][4] = String.valueOf(id);
                }
            }
            if (this.customEntryEntity != null) {
                for (i = 0; i < this.customEntryEntity.length; ++i) {
                    String filterConditionStr = this.customEntryEntity[i][1];
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
                    List filterRowList = filterCondition.getFilterRow();
                    for (SimpleFilterRow filterRow : filterRowList) {
                        String[] fields;
                        String fieldName = filterRow.getFieldName();
                        if (!fieldName.endsWith(".id") || (fields = fieldName.split("\\.")).length <= 0) continue;
                        String dimNumber = fields[0];
                        DynamicObject dimObj = dimensionMap.get(dimNumber);
                        if (dimObj != null) {
                            String entityNumber = this.achieveBaseEntity(dimObj);
                            BaseDataItem baseDataItem2 = baseDataItemMap.get(entityNumber);
                            List filterValueList = filterRow.getBaseDataIds();
                            if (baseDataItem2 != null && CollectionUtils.isNotEmpty((Collection)filterValueList)) {
                                for (FilterValue filterValue : filterValueList) {
                                    String number = String.valueOf(filterValue.getValue());
                                    Object id = baseDataItem2.numberToIdMap.get(number);
                                    if (id == null) {
                                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u5b57\u6bb5\u6765\u6e90\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a%5$s\u7f16\u53f7\u4e3a%6$s\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_48", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, dimNumber, entityNumber, number));
                                    }
                                    filterValue.setValue((Object)String.valueOf(id));
                                }
                                continue;
                            }
                            if (baseDataItem2 != null) continue;
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$d\u884c\uff0c\u8fc7\u6ee4\u6761\u4ef6\u7ef4\u5ea6\u7f16\u53f7\u4e3a%4$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_54", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, dimNumber));
                        }
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_44", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, dimNumber));
                    }
                    this.customEntryEntity[i][1] = SerializationUtils.toJsonString((Object)filterCondition);
                    if (!StringUtils.isNotEmpty((String)this.customEntryEntity[i][11])) continue;
                    String targetDimNumber = this.customEntryEntity[i][6];
                    DynamicObject dimObj = dimensionMap.get(targetDimNumber);
                    if (dimObj != null) {
                        String entityNumber = this.achieveBaseEntity(dimObj);
                        if (!StringUtils.isNotEmpty((String)entityNumber)) continue;
                        BaseDataItem baseDataItem3 = baseDataItemMap.get(entityNumber);
                        if (baseDataItem3 != null) {
                            Object id = baseDataItem3.numberToIdMap.get(this.customEntryEntity[i][11]);
                            if (id == null) {
                                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u9ed8\u8ba4\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_51", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, this.customEntryEntity[i][11]));
                            }
                            this.customEntryEntity[i][11] = String.valueOf(id);
                            continue;
                        }
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$d\u884c\uff0c\u76ee\u6807\u7ef4\u5ea6\u7f16\u53f7\u4e3a%4$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PABusinessRuleExportAndImportListPlugin_52", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetDimNumber));
                    }
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u5355\u7ef4\u5ea6\u3002", (String)"PABusinessRuleExportAndImportListPlugin_53", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, i + 1, targetDimNumber));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[][] getSendEntry() {
            return this.sendEntry;
        }

        public void setSendEntry(String[][] sendEntry) {
            this.sendEntry = sendEntry;
        }

        public String getDerivationMode() {
            return this.derivationMode;
        }

        public void setDerivationMode(String derivationMode) {
            this.derivationMode = derivationMode;
        }

        public String getMappingMap() {
            return this.mappingMap;
        }

        public void setMappingMap(String mappingMap) {
            this.mappingMap = mappingMap;
        }

        public String getMappingMapType() {
            return this.mappingMapType;
        }

        public void setMappingMapType(String mappingMapType) {
            this.mappingMapType = mappingMapType;
        }

        public String getMappingRelationShipNumber() {
            return this.mappingRelationShipNumber;
        }

        public void setMappingRelationShipNumber(String mappingRelationShipNumber) {
            this.mappingRelationShipNumber = mappingRelationShipNumber;
        }

        public String[] getSourceEntryEntity() {
            return this.sourceEntryEntity;
        }

        public void setSourceEntryEntity(String[] sourceEntryEntity) {
            this.sourceEntryEntity = sourceEntryEntity;
        }

        public String[][] getTargetEntryEntity() {
            return this.targetEntryEntity;
        }

        public void setTargetEntryEntity(String[][] targetEntryEntity) {
            this.targetEntryEntity = targetEntryEntity;
        }

        public String[][] getMtSourceEntryEntity() {
            return this.mtSourceEntryEntity;
        }

        public void setMtSourceEntryEntity(String[][] mtSourceEntryEntity) {
            this.mtSourceEntryEntity = mtSourceEntryEntity;
        }

        public String[][] getMtTargetEntryEntity() {
            return this.mtTargetEntryEntity;
        }

        public void setMtTargetEntryEntity(String[][] mtTargetEntryEntity) {
            this.mtTargetEntryEntity = mtTargetEntryEntity;
        }

        public int getStepIndex() {
            return this.stepIndex;
        }

        public void setStepIndex(int stepIndex) {
            this.stepIndex = stepIndex;
        }

        private /* synthetic */ void lambda$numberConvertId$8(BaseDataItem baseDataItem, int finalI, Map idMap, String k, String v) {
            Object id = baseDataItem.numberToIdMap.get(k);
            if (id == null) {
                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%1$s\u7684\u6b65\u9aa4%2$s\uff1a\u53d1\u9001\u65b9\u503c\u8303\u56f4\u7b2c%3$s\u884c\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%4$s\u7684\u7ef4\u5ea6\u503c\u3002", (String)"PABusinessRuleExportAndImportListPlugin_18", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.stepIndex, this.name, finalI + 1, k));
            }
            idMap.put(String.valueOf(id), v);
        }

        private static /* synthetic */ void lambda$idConvertNumber$4(boolean isString, Map numberMap, BaseDataItem baseDataItem, String k, String v) {
            Object id = isString ? k : Long.valueOf(k);
            numberMap.put(baseDataItem.idToNumberMap.get(id), v);
        }

        private static /* synthetic */ void lambda$achieveBaseData$3(boolean isId, BaseDataItem finalBaseDataItem, boolean isString, String k, String v) {
            if (isId) {
                finalBaseDataItem.idToNumberMap.put(isString ? k : Long.valueOf(k), null);
            } else {
                finalBaseDataItem.numberToIdMap.put(k, null);
            }
        }
    }

    private static class ExtendBizRuleDynamicObject
    extends ExtendDynamicObject {
        private static final long serialVersionUID = 5520497642644106070L;
        private String analysisSystemNumber;
        private String analysisModelNumber;
        private String name;
        private String number;
        private String periodTypeNumber;
        private String startPeriodNumber;
        private String endPeriodNumber;
        private String accountTypeNumber;
        private String accountFilter;
        private String desc;
        private String[][] stepMessage;

        public ExtendBizRuleDynamicObject(DynamicObject bizRule) {
            this.analysisSystemNumber = this.achieveNumber(bizRule, "analysissystem");
            this.analysisModelNumber = this.achieveNumber(bizRule, "analysismodel");
            this.name = bizRule.getString("name");
            this.number = bizRule.getString("number");
            this.periodTypeNumber = this.achieveNumber(bizRule, "periodtype");
            this.startPeriodNumber = this.achieveNumber(bizRule, "startperiod");
            this.endPeriodNumber = this.achieveNumber(bizRule, "endperiod");
            this.accountTypeNumber = this.achieveNumber(bizRule, "accounttype");
            this.accountFilter = bizRule.getString("accountfilter_tag");
            this.desc = bizRule.getString("desc");
            DynamicObjectCollection stepEntry = bizRule.getDynamicObjectCollection("stepentry");
            if (stepEntry != null) {
                this.stepMessage = new String[stepEntry.size()][3];
                int index = 0;
                for (DynamicObject entryDynamicObject : stepEntry) {
                    String[] entryValues = new String[]{String.valueOf(index), entryDynamicObject.getString("cardhandletype"), entryDynamicObject.getString("cardstepname")};
                    this.stepMessage[index++] = entryValues;
                }
            }
        }

        @Override
        String serializeKey() {
            return "bizrule:";
        }

        @Override
        Map<String, BaseDataItem> achieveBaseData(DynamicObject analysisModel, boolean isId) {
            if (isId) {
                return new HashMap<String, BaseDataItem>(1);
            }
            HashMap<String, BaseDataItem> baseDataItemMap = new HashMap<String, BaseDataItem>();
            if (StringUtils.isNotEmpty((String)this.accountTypeNumber)) {
                BaseDataItem accountTypeDataItem = new BaseDataItem(new HashMap<String, Object>(2), null);
                accountTypeDataItem.numberToIdMap.put(this.accountTypeNumber, null);
                baseDataItemMap.put("pa_accounttype", accountTypeDataItem);
            }
            if (StringUtils.isNotEmpty((String)this.periodTypeNumber)) {
                BaseDataItem periodTypeDataItem = new BaseDataItem(new HashMap<String, Object>(2), null);
                periodTypeDataItem.numberToIdMap.put(this.periodTypeNumber, null);
                baseDataItemMap.put("bd_period_type", periodTypeDataItem);
            }
            if (StringUtils.isNotEmpty((String)this.startPeriodNumber) || StringUtils.isNotEmpty((String)this.endPeriodNumber)) {
                DynamicObject dimension = FormPluginUtil.getDimension(analysisModel, "1");
                QFilter qfilter = this.achieveDimensionTypeFilter(dimension);
                BaseDataItem periodDataItem = new BaseDataItem(new HashMap<String, Object>(2), qfilter);
                if (StringUtils.isNotEmpty((String)this.startPeriodNumber)) {
                    periodDataItem.numberToIdMap.put(this.startPeriodNumber, null);
                }
                if (StringUtils.isNotEmpty((String)this.endPeriodNumber)) {
                    periodDataItem.numberToIdMap.put(this.endPeriodNumber, null);
                }
                baseDataItemMap.put("bd_period", periodDataItem);
            }
            return baseDataItemMap;
        }

        @Override
        void idConvertNumber(Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
        }

        @Override
        DynamicObject createDynamicObject(Map<String, BaseDataItem> baseDataItemMap, boolean isId, DynamicObject analysisModel, Long orgId) {
            BaseDataItem baseDataItem;
            this.numberConvertId(null, null);
            DynamicObject bizRuleObject = BusinessDataServiceHelper.newDynamicObject((String)"pa_businessrule");
            bizRuleObject.set("analysissystem", analysisModel.get("analysis_system"));
            bizRuleObject.set("analysismodel", (Object)analysisModel);
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
            bizRuleObject.set("useOrg", (Object)orgObj);
            bizRuleObject.set("createorg", (Object)orgObj);
            bizRuleObject.set("org", (Object)orgObj);
            String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)"pa_businessrule", (String)String.valueOf(orgId));
            if (StringUtils.isNotEmpty((String)ctrlStrategy)) {
                String[] ctrlStrategyArr = ctrlStrategy.split(",");
                if (ctrlStrategyArr.length <= 1) {
                    bizRuleObject.set("ctrlstrategy", (Object)ctrlStrategy);
                } else {
                    for (String ctr : ctrlStrategyArr) {
                        if (!StringUtils.isNotEmpty((String)ctr)) continue;
                        bizRuleObject.set("ctrlstrategy", (Object)ctr);
                        break;
                    }
                }
            }
            this.fillFixFieldValue(bizRuleObject);
            bizRuleObject.set("name", (Object)this.name);
            bizRuleObject.set("number", (Object)("IMPORT_" + this.number));
            bizRuleObject.set("periodbasetype", (Object)"bd_period");
            if (StringUtils.isNotEmpty((String)this.periodTypeNumber) && ((baseDataItem = baseDataItemMap.get("bd_period_type")) == null || baseDataItem.numberToIdMap.get(this.accountTypeNumber) == null)) {
                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a%s\u5bf9\u5e94\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u7c7b\u578b\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.periodTypeNumber));
            }
            if (StringUtils.isNotEmpty((String)this.startPeriodNumber) || StringUtils.isNotEmpty((String)this.endPeriodNumber)) {
                BaseDataItem periodBaseDataItem = baseDataItemMap.get("bd_period");
                if (periodBaseDataItem == null) {
                    throw new ValidateException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isNotEmpty((String)this.startPeriodNumber)) {
                    Object startPeriodId = periodBaseDataItem.numberToIdMap.get(this.startPeriodNumber);
                    if (startPeriodId == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%s\u7684\u8d77\u59cb\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.startPeriodNumber));
                    }
                    this.setBaseDataId(bizRuleObject, "startperiod", startPeriodId);
                }
                if (StringUtils.isNotEmpty((String)this.endPeriodNumber)) {
                    Object endPeriodId = periodBaseDataItem.numberToIdMap.get(this.endPeriodNumber);
                    if (endPeriodId == null) {
                        throw new ValidateException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%s\u7684\u7ed3\u675f\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_28", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.endPeriodNumber));
                    }
                    this.setBaseDataId(bizRuleObject, "endperiod", endPeriodId);
                }
            }
            if (StringUtils.isNotEmpty((String)this.accountTypeNumber)) {
                baseDataItem = baseDataItemMap.get("pa_accounttype");
                if (baseDataItem == null || baseDataItem.numberToIdMap.get(this.accountTypeNumber) == null) {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a%s\u5bf9\u5e94\u7684\u79d1\u76ee\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u8868\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.accountTypeNumber));
                }
                this.setBaseDataId(bizRuleObject, "accounttype", baseDataItem.numberToIdMap.get(this.accountTypeNumber));
            }
            if (StringUtils.isNotEmpty((String)this.accountFilter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)this.accountFilter, FilterCondition.class);
                List filterRowList = filterCondition.getFilterRow();
                for (SimpleFilterRow filterRow : filterRowList) {
                    filterRow.setBaseDataIds(new ArrayList(0));
                }
                String filterStr = SerializationUtils.toJsonString((Object)filterCondition);
                bizRuleObject.set("accountfilter_tag", (Object)filterStr);
            }
            bizRuleObject.set("desc", (Object)this.desc);
            if (this.stepMessage != null && this.stepMessage.length > 0) {
                DynamicObjectCollection stepEntry = bizRuleObject.getDynamicObjectCollection("stepentry");
                for (int i = 0; i < this.stepMessage.length; ++i) {
                    String[] rowData = this.stepMessage[i];
                    DynamicObject rowObj = stepEntry.addNew();
                    rowObj.set("cardhandletype", (Object)rowData[1]);
                    rowObj.set("cardstepname", (Object)rowData[2]);
                }
                bizRuleObject.set("stepentry", (Object)stepEntry);
            }
            bizRuleObject.set("stepname", (Object)"xxx");
            bizRuleObject.set("handletype", (Object)"xxx");
            return bizRuleObject;
        }

        @Override
        void numberConvertId(Map<String, BaseDataItem> baseDataItemMap, Map<String, DynamicObject> dimensionMap) {
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getAnalysisSystemNumber() {
            return this.analysisSystemNumber;
        }

        public void setAnalysisSystemNumber(String analysisSystemNumber) {
            this.analysisSystemNumber = analysisSystemNumber;
        }

        public String getAnalysisModelNumber() {
            return this.analysisModelNumber;
        }

        public void setAnalysisModelNumber(String analysisModelNumber) {
            this.analysisModelNumber = analysisModelNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPeriodTypeNumber() {
            return this.periodTypeNumber;
        }

        public void setPeriodTypeNumber(String periodTypeNumber) {
            this.periodTypeNumber = periodTypeNumber;
        }

        public String getStartPeriodNumber() {
            return this.startPeriodNumber;
        }

        public void setStartPeriodNumber(String startPeriodNumber) {
            this.startPeriodNumber = startPeriodNumber;
        }

        public String getEndPeriodNumber() {
            return this.endPeriodNumber;
        }

        public void setEndPeriodNumber(String endPeriodNumber) {
            this.endPeriodNumber = endPeriodNumber;
        }

        public String getAccountTypeNumber() {
            return this.accountTypeNumber;
        }

        public void setAccountTypeNumber(String accountTypeNumber) {
            this.accountTypeNumber = accountTypeNumber;
        }

        public String getAccountFilter() {
            return this.accountFilter;
        }

        public void setAccountFilter(String accountFilter) {
            this.accountFilter = accountFilter;
        }

        public String[][] getStepMessage() {
            return this.stepMessage;
        }

        public void setStepMessage(String[][] stepMessage) {
            this.stepMessage = stepMessage;
        }
    }

    static abstract class ExtendDynamicObject
    implements Serializable {
        private static final long serialVersionUID = 7729625579792964779L;

        ExtendDynamicObject() {
        }

        abstract String serializeKey();

        abstract Map<String, BaseDataItem> achieveBaseData(DynamicObject var1, boolean var2);

        Map<String, BaseDataItem> mergeBaseData(Map<String, BaseDataItem> thatBaseDataMap, Map<String, BaseDataItem> antherBaseDataMap) {
            HashMap<String, BaseDataItem> newMap = new HashMap<String, BaseDataItem>(10);
            if (thatBaseDataMap != null) {
                newMap.putAll(thatBaseDataMap);
            }
            if (antherBaseDataMap != null) {
                antherBaseDataMap.forEach((baseEntityNumber, baseDataItem) -> {
                    BaseDataItem oldValue = (BaseDataItem)newMap.get(baseEntityNumber);
                    if (oldValue == null) {
                        newMap.put((String)baseEntityNumber, oldValue);
                    } else {
                        BaseDataItem newValue = oldValue.mergeItem((BaseDataItem)baseDataItem);
                        newMap.put((String)baseEntityNumber, newValue);
                    }
                });
            }
            return newMap;
        }

        protected String achieveNumber(DynamicObject bizRule, String field) {
            DynamicObject dynamicObject = bizRule.getDynamicObject(field);
            return dynamicObject == null ? null : dynamicObject.getString("number");
        }

        abstract void idConvertNumber(Map<String, BaseDataItem> var1, Map<String, DynamicObject> var2);

        abstract DynamicObject createDynamicObject(Map<String, BaseDataItem> var1, boolean var2, DynamicObject var3, Long var4);

        abstract void numberConvertId(Map<String, BaseDataItem> var1, Map<String, DynamicObject> var2);

        protected void setBaseDataId(DynamicObject bizRuleObject, String field, Object pk) {
            bizRuleObject.set(field + "_id", pk);
        }

        protected void fillFixFieldValue(DynamicObject ruleObj) {
            ruleObj.set("enable", (Object)"1");
            ruleObj.set("status", (Object)"A");
            RequestContext rc = RequestContext.get();
            this.setBaseDataId(ruleObj, "creator", rc.getCurrUserId());
            ruleObj.set("createtime", (Object)new Date());
        }

        protected QFilter achieveDimensionTypeFilter(DynamicObject dimension) {
            DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            QFilter qFilter = null;
            if (DimensionTypeEnum.DATABASE == dimType) {
                String typeField = dimension.getString("typefield");
                Object groupId = dimension.get("group_id");
                if (StringUtils.isNotEmpty((String)typeField)) {
                    qFilter = new QFilter(typeField, "=", groupId);
                }
            } else if (DimensionTypeEnum.ASSISTANTDATA == dimType) {
                Object groupId = dimension.get("assistantsource_id");
                qFilter = new QFilter("group", "=", groupId);
            }
            return qFilter;
        }
    }

    private static class BaseDataItem {
        Map<Object, String> idToNumberMap;
        Map<String, Object> numberToIdMap;
        boolean isId;
        QFilter groupFilters;

        public BaseDataItem(Map<Object, String> idToNumberMap) {
            this.idToNumberMap = idToNumberMap;
            this.isId = true;
        }

        public BaseDataItem(Map<String, Object> numberToIdMap, QFilter groupFilters) {
            this.numberToIdMap = numberToIdMap;
            this.isId = false;
            this.groupFilters = groupFilters;
        }

        public BaseDataItem(Map<Object, String> idToNumberMap, Map<String, Object> numberToIdMap, boolean isId, QFilter groupFilters) {
            this.idToNumberMap = idToNumberMap;
            this.numberToIdMap = numberToIdMap;
            this.isId = isId;
            this.groupFilters = groupFilters;
        }

        BaseDataItem mergeItem(BaseDataItem antherBaseDataItem) {
            if (this.isId && antherBaseDataItem.isId || !this.isId && !antherBaseDataItem.isId) {
                HashMap<Object, String> newIdToNumberMap = new HashMap<Object, String>(10);
                HashMap<String, Object> newNumberToIdMap = new HashMap<String, Object>(10);
                if (this.isId) {
                    if (this.idToNumberMap != null) {
                        newIdToNumberMap.putAll(this.idToNumberMap);
                    }
                    if (antherBaseDataItem.idToNumberMap != null) {
                        newIdToNumberMap.putAll(antherBaseDataItem.idToNumberMap);
                    }
                } else {
                    if (this.numberToIdMap != null) {
                        newNumberToIdMap.putAll(this.numberToIdMap);
                    }
                    if (antherBaseDataItem.numberToIdMap != null) {
                        newNumberToIdMap.putAll(antherBaseDataItem.numberToIdMap);
                    }
                }
                QFilter filter = null;
                if (this.groupFilters != null) {
                    filter = this.groupFilters;
                }
                if (filter == null) {
                    filter = antherBaseDataItem.groupFilters;
                }
                return new BaseDataItem(newIdToNumberMap, newNumberToIdMap, this.isId, filter);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6570\u636e\u8f6c\u6362\u6a21\u5f0f\u4e0d\u6b63\u786e\uff0c\u57fa\u7840\u8d44\u6599\u6570\u636e\u65e0\u6cd5\u5408\u5e76\u5904\u7406\u3002", (String)"PABusinessRuleExportAndImportListPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    private static class BizRuleDataExportAndImportHandler {
        private BizRuleDataExportAndImportHandler() {
        }

        OperationResult importData(String url, Long orgId) {
            List contents;
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream is = null;
            try {
                is = tempFileCache.getInputStream(url);
                contents = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5bfc\u5165\u6570\u636e\u5931\u8d25 :%s\u3002", (String)"PABusinessRuleExportAndImportListPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            if (contents.isEmpty()) {
                return null;
            }
            ExtendDynamicObject[] steps = new ExtendDynamicObject[contents.size() - 1];
            ExtendBizRuleDynamicObject bizRuleObj = null;
            int stepIndex = 0;
            for (String content : contents) {
                if (!StringUtils.isNotEmpty((String)content)) continue;
                int index = content.indexOf(58) + 1;
                String serializeKey = content.substring(0, index);
                ExtendDynamicObject[] dataStr = content.substring(index);
                try {
                    switch (serializeKey) {
                        case "bizrule:": {
                            bizRuleObj = (ExtendBizRuleDynamicObject)SerializationUtils.deSerializeFromBase64((String)dataStr);
                            break;
                        }
                        case "derivationrule:": {
                            ExtendDerivationRuleDynamicObject extendDerivationRuleDynamicObject = (ExtendDerivationRuleDynamicObject)SerializationUtils.deSerializeFromBase64((String)dataStr);
                            steps[stepIndex++] = extendDerivationRuleDynamicObject;
                            extendDerivationRuleDynamicObject.setStepIndex(stepIndex);
                            break;
                        }
                        case "sharerule:": {
                            ExtendShareRuleDynamicObject shareRuleDynamicObject = (ExtendShareRuleDynamicObject)SerializationUtils.deSerializeFromBase64((String)dataStr);
                            steps[stepIndex++] = shareRuleDynamicObject;
                            shareRuleDynamicObject.setStepIndex(stepIndex);
                            break;
                        }
                        default: {
                            throw new ValidateException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5bfc\u5165\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u88ab\u4fee\u6539\u8fc7\u3002", (String)"PABusinessRuleExportAndImportListPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]), serializeKey));
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ValidateException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5bfc\u5165\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u88ab\u4fee\u6539\u8fc7\u3002", (String)"PABusinessRuleExportAndImportListPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]), serializeKey));
                }
            }
            if (bizRuleObj == null) {
                throw new KDBizException("data loss");
            }
            List systemIdList = QueryServiceHelper.queryPrimaryKeys((String)"pa_anasystemsetting", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizRuleObj.getAnalysisSystemNumber())}, null, (int)1);
            if (systemIdList.size() != 1) {
                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%s\u7684\u5206\u6790\u4f53\u7cfb\uff0c\u8bf7\u68c0\u67e5\u5206\u6790\u4f53\u7cfb\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]), bizRuleObj.getAnalysisSystemNumber()));
            }
            Object systemId = systemIdList.get(0);
            DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", systemId), new QFilter("number", "=", (Object)bizRuleObj.getAnalysisModelNumber())});
            if (analysisModel == null) {
                throw new ValidateException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%s\u7684\u5206\u6790\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u5206\u6790\u6a21\u578b\u914d\u7f6e\u3002", (String)"PABusinessRuleExportAndImportListPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]), bizRuleObj.getAnalysisModelNumber()));
            }
            Map<String, BaseDataItem> baseDataItemMap = bizRuleObj.achieveBaseData(analysisModel, false);
            for (ExtendDynamicObject extendDynamicObject : steps) {
                Map<String, BaseDataItem> stepBaseDataItemMap = extendDynamicObject.achieveBaseData(analysisModel, false);
                this.mergeBaseDataItem(baseDataItemMap, stepBaseDataItemMap);
            }
            if (!baseDataItemMap.isEmpty()) {
                for (Map.Entry entry : baseDataItemMap.entrySet()) {
                    String baseEntityNumber = (String)entry.getKey();
                    BaseDataItem baseDataItem = (BaseDataItem)entry.getValue();
                    this.queryId(baseEntityNumber, baseDataItem);
                }
            }
            DynamicObject bizRuleObjDynamicObject = bizRuleObj.createDynamicObject(baseDataItemMap, false, analysisModel, orgId);
            DynamicObject[] dynamicObjectArray = new DynamicObject[steps.length];
            int index = 0;
            for (ExtendDynamicObject step : steps) {
                dynamicObjectArray[index++] = step.createDynamicObject(baseDataItemMap, false, analysisModel, orgId);
            }
            DynamicObjectCollection dynamicObjectCollection = bizRuleObjDynamicObject.getDynamicObjectCollection("stepentry");
            ArrayList<DynamicObject> derivationDataList = new ArrayList<DynamicObject>(dynamicObjectCollection.size());
            ArrayList<DynamicObject> shareDataList = new ArrayList<DynamicObject>(dynamicObjectCollection.size());
            block48: for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                String handType;
                DynamicObject rowObj = (DynamicObject)dynamicObjectCollection.get(i);
                DynamicObject rule = dynamicObjectArray[i];
                switch (handType = rowObj.getString("cardhandletype")) {
                    case "A": {
                        rowObj.set("cardderivationmodel", (Object)rule);
                        derivationDataList.add(rule);
                        continue block48;
                    }
                    case "B": {
                        rowObj.set("cardsharemodel", (Object)rule);
                        shareDataList.add(rule);
                    }
                }
            }
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                OperationResult operationResult;
                OperationResult result;
                if (!derivationDataList.isEmpty() && !(result = OperationServiceHelper.executeOperate((String)"save", (String)"pa_derivationrule", (DynamicObject[])derivationDataList.toArray(new DynamicObject[0]), null)).isSuccess()) {
                    h.markRollback();
                    operationResult = result;
                    return operationResult;
                }
                if (!shareDataList.isEmpty() && !(result = OperationServiceHelper.executeOperate((String)"save", (String)"pa_sharerulenew", (DynamicObject[])shareDataList.toArray(new DynamicObject[0]), null)).isSuccess()) {
                    h.markRollback();
                    operationResult = result;
                    return operationResult;
                }
                result = OperationServiceHelper.executeOperate((String)"save", (String)"pa_businessrule", (DynamicObject[])new DynamicObject[]{bizRuleObjDynamicObject}, null);
                if (!result.isSuccess()) {
                    h.markRollback();
                    operationResult = result;
                    return operationResult;
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
            return null;
        }

        String export(DynamicObject bizRuleObj) {
            StringBuilder sb = new StringBuilder();
            ExtendBizRuleDynamicObject bizRuleExtend = new ExtendBizRuleDynamicObject(bizRuleObj);
            Object modelId = bizRuleObj.getDynamicObject("analysismodel").getPkValue();
            DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
            Map<String, BaseDataItem> baseDataItemMap = bizRuleExtend.achieveBaseData(modelObj, true);
            DynamicObjectCollection stepEntry = bizRuleObj.getDynamicObjectCollection("stepentry");
            if (stepEntry != null) {
                int seq;
                Long id;
                int index = 0;
                HashMap<Long, Integer> stepIndexMap = new HashMap<Long, Integer>(stepEntry.size());
                ArrayList<Long> derivationIdList = new ArrayList<Long>(stepEntry.size());
                ArrayList<Long> shareRuleIdList = new ArrayList<Long>(stepEntry.size());
                ExtendDynamicObject[] stepDynamicObjects = new ExtendDynamicObject[stepEntry.size()];
                for (Object entryDynamicObject : stepEntry) {
                    String handType;
                    switch (handType = entryDynamicObject.getString("cardhandletype")) {
                        case "A": {
                            DynamicObject derivationObj = entryDynamicObject.getDynamicObject("cardderivationmodel");
                            Long derivationId = derivationObj.getLong("id");
                            derivationIdList.add(derivationId);
                            stepIndexMap.put(derivationId, index++);
                            break;
                        }
                        case "B": {
                            DynamicObject shareRuleObj = entryDynamicObject.getDynamicObject("cardsharemodel");
                            Long shareId = shareRuleObj.getLong("id");
                            shareRuleIdList.add(shareId);
                            stepIndexMap.put(shareId, index++);
                        }
                    }
                }
                if (!derivationIdList.isEmpty()) {
                    Map derivationMap = BusinessDataServiceHelper.loadFromCache((String)"pa_derivationrule", (QFilter[])new QFilter[]{new QFilter("id", "in", derivationIdList)});
                    for (DynamicObject valueObj : derivationMap.values()) {
                        id = valueObj.getLong("id");
                        seq = (Integer)stepIndexMap.get(id);
                        stepDynamicObjects[seq] = new ExtendDerivationRuleDynamicObject(valueObj);
                        this.mergeBaseDataItem(baseDataItemMap, stepDynamicObjects[seq].achieveBaseData(modelObj, true));
                    }
                }
                if (!shareRuleIdList.isEmpty()) {
                    Map allocationMap = BusinessDataServiceHelper.loadFromCache((String)"pa_sharerulenew", (QFilter[])new QFilter[]{new QFilter("id", "in", shareRuleIdList)});
                    for (DynamicObject valueObj : allocationMap.values()) {
                        id = valueObj.getLong("id");
                        seq = (Integer)stepIndexMap.get(id);
                        stepDynamicObjects[seq] = new ExtendShareRuleDynamicObject(valueObj);
                        this.mergeBaseDataItem(baseDataItemMap, stepDynamicObjects[seq].achieveBaseData(modelObj, true));
                    }
                }
                if (!baseDataItemMap.isEmpty()) {
                    for (Map.Entry<String, BaseDataItem> BaseDataItemEntry : baseDataItemMap.entrySet()) {
                        String baseEntityNumber = BaseDataItemEntry.getKey();
                        BaseDataItem baseDataItem = BaseDataItemEntry.getValue();
                        this.queryNumber(baseEntityNumber, baseDataItem);
                    }
                }
                DynamicObjectCollection dimEntryCols = modelObj.getDynamicObjectCollection("dimension_entry");
                Map<String, DynamicObject> numberToDimMap = dimEntryCols.stream().map(rowData -> rowData.getDynamicObject("dimension")).collect(Collectors.toMap(dimObj -> dimObj.getString("number"), dimObj -> dimObj));
                for (ExtendDynamicObject stepDynamicObject : stepDynamicObjects) {
                    stepDynamicObject.idConvertNumber(baseDataItemMap, numberToDimMap);
                    sb.append(stepDynamicObject.serializeKey()).append(SerializationUtils.serializeToBase64((Object)stepDynamicObject)).append("\r\n");
                }
            }
            sb.append(bizRuleExtend.serializeKey()).append(SerializationUtils.serializeToBase64((Object)bizRuleExtend)).append("\r\n");
            return sb.toString();
        }

        void queryId(String baseEntityNumber, BaseDataItem baseDataItem) {
            QFilter[] qFilterArray;
            if (baseDataItem.numberToIdMap.isEmpty()) {
                return;
            }
            BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityNumber);
            String numberProp = entityType.getNumberProperty();
            String primaryKey = entityType.getPrimaryKey().getName();
            Object[] numbers = baseDataItem.numberToIdMap.keySet().toArray(new Object[0]);
            if (baseDataItem.groupFilters == null) {
                QFilter[] qFilterArray2 = new QFilter[1];
                qFilterArray = qFilterArray2;
                qFilterArray2[0] = new QFilter(numberProp, "in", (Object)numbers);
            } else {
                QFilter[] qFilterArray3 = new QFilter[2];
                qFilterArray3[0] = new QFilter(numberProp, "in", (Object)numbers);
                qFilterArray = qFilterArray3;
                qFilterArray3[1] = baseDataItem.groupFilters;
            }
            QFilter[] qFilters = qFilterArray;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryNumber", (String)baseEntityNumber, (String)(primaryKey + "," + numberProp), (QFilter[])qFilters, null);){
                for (Row row : dataSet) {
                    String number = row.getString(numberProp);
                    Object primary = row.get(primaryKey);
                    baseDataItem.numberToIdMap.put(number, primary);
                }
            }
        }

        void queryNumber(String baseEntityNumber, BaseDataItem baseDataItem) {
            if (baseDataItem.idToNumberMap.isEmpty()) {
                return;
            }
            BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityNumber);
            String numberProp = entityType.getNumberProperty();
            String primaryKey = entityType.getPrimaryKey().getName();
            Object[] ids = baseDataItem.idToNumberMap.keySet().toArray(new Object[0]);
            QFilter[] qFilters = new QFilter[]{new QFilter(primaryKey, "in", (Object)ids)};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryNumber", (String)baseEntityNumber, (String)(primaryKey + "," + numberProp), (QFilter[])qFilters, null);){
                for (Row row : dataSet) {
                    String number = row.getString(numberProp);
                    Object primary = row.get(primaryKey);
                    baseDataItem.idToNumberMap.put(primary, number);
                }
            }
        }

        void mergeBaseDataItem(Map<String, BaseDataItem> baseMap, Map<String, BaseDataItem> mergeMap) {
            if (mergeMap == null) {
                return;
            }
            mergeMap.forEach((k, v) -> {
                BaseDataItem bdi = (BaseDataItem)baseMap.get(k);
                if (bdi == null) {
                    baseMap.put((String)k, (BaseDataItem)v);
                } else {
                    BaseDataItem newBdi = bdi.mergeItem((BaseDataItem)v);
                    baseMap.put((String)k, newBdi);
                }
            });
        }
    }
}

