/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.PluginExceptionHelper;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.formplugin.verification.VerificationHelper;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PABusinessRuleFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(PABusinessRuleFormPlugin.class);
    private static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
    private static final Set<String> baseEntityIdSet = new HashSet<String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vectorapmoveup", "vectorapmovedown", "accfilterclick"});
        EntryGrid stepEntry = (EntryGrid)this.getView().getControl("stepentry");
        stepEntry.addRowClickListener((RowClickEventListener)this);
        this.initF7();
    }

    private void initF7() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object analysisSystem = model.getValue("analysissystem");
        BasedataEdit analysisModelF7 = (BasedataEdit)this.getControl("analysismodel");
        analysisModelF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (analysisSystem == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PABusinessRuleFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("analysis_system", "=", ((DynamicObject)analysisSystem).get("id"));
            qFilter.and(PARuleHelper.getAnalysisPeriodFilter());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit startPeriodF7 = (BasedataEdit)this.getControl("startperiod");
        BasedataEdit endPeriodF7 = (BasedataEdit)this.getControl("endperiod");
        startPeriodF7.addBeforeF7SelectListener(beforeF7SelectEvent -> this.periodF7Filter(model, view, beforeF7SelectEvent));
        endPeriodF7.addBeforeF7SelectListener(beforeF7SelectEvent -> this.periodF7Filter(model, view, beforeF7SelectEvent));
    }

    private void periodF7Filter(IDataModel model, IFormView view, BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
        if (anaModel == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PABusinessRuleFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.processDefaultData(model, view);
        }
    }

    private void processDefaultData(IDataModel model, IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object orgId = customParams.get("customParamOrgId");
        Long orgIdL = orgId == null ? null : Long.valueOf(Long.parseLong(orgId.toString()));
        model.setValue("createorg", (Object)orgIdL);
        model.setValue("useorg", (Object)orgIdL);
        model.setValue("org", (Object)orgIdL);
        FormPluginUtil.processDefaultSysAndModel(model, view);
        this.setPeriodBaseEntityId(model, view);
        this.processDateDim();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.processDefaultData(model, view);
        } else {
            this.setPeriodBaseEntityId(model, view);
            String baseEntityId = (String)model.getValue("periodbasetype");
            if ("bd_period".equals(baseEntityId)) {
                return;
            }
            model.beginInit();
            if (StringUtils.isNotEmpty((CharSequence)baseEntityId) && (model.getValue("startperiod") == null || model.getValue("endperiod") == null)) {
                Object endPeriodId;
                Object startPeriodId = model.getValue("startperiod_id");
                if (startPeriodId != null) {
                    model.setValue("startperiod", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriodId, (String)baseEntityId));
                }
                if ((endPeriodId = model.getValue("endperiod_id")) != null) {
                    model.setValue("endperiod", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodId, (String)baseEntityId));
                }
            }
            model.endInit();
            view.updateView("fs_baseinfo");
        }
    }

    private void setPeriodBaseEntityId(IDataModel model, IFormView view) {
        DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
        if (anaModel == null) {
            model.setValue("startperiod", null);
            model.setValue("endperiod", null);
            return;
        }
        QFilter qFilter = FormPluginUtil.getBaseQFilter(anaModel, "1");
        FormPluginUtil.setItemClassTypeEntityId(baseEntityIdSet, anaModel, "1", "periodbasetype", model, view);
        ItemClassEdit startPeriod = (ItemClassEdit)this.getControl("startperiod");
        ItemClassEdit endPeriod = (ItemClassEdit)this.getControl("endperiod");
        startPeriod.setQFilter(qFilter);
        endPeriod.setQFilter(qFilter);
    }

    public void afterBindData(EventObject e) {
        String filterJson;
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Object isCopy = view.getFormShowParameter().getCustomParams().get("iscopy");
            if (isCopy != null && ((Boolean)isCopy).booleanValue()) {
                int cnt = model.getEntryRowCount("stepentry");
                for (int i = 0; i < cnt; ++i) {
                    model.setValue("copystatus", (Object)"1", i);
                }
            }
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"number"});
            if (!"A".equals(model.getValue("status"))) {
                view.setVisible(Boolean.FALSE, new String[]{"stepopflex"});
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(filterJson = (String)model.getValue("accountfilter_tag")))) {
            model.setValue("accfilterclick", (Object)this.getFilterDesc(filterJson));
        }
        view.updateView("fs_baseinfo");
        this.initCardEntry(model, view, true);
        EntryGrid stepEntry = (EntryGrid)this.getControl("stepentry");
        view.getPageCache().put("pageCacheAfterBindData", "mark");
        String stepIndex = (String)this.getView().getFormShowParameter().getCustomParam("stepIndex");
        if (StringUtils.isNotBlank((CharSequence)stepIndex)) {
            stepEntry.selectRows(Integer.parseInt(stepIndex));
        } else {
            stepEntry.selectRows(0);
        }
        this.processDateDim((DynamicObject)model.getValue("analysismodel"));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        try {
            switch (propertyName) {
                case "startperiod": 
                case "endperiod": {
                    Long startPeriodId = (Long)model.getValue("startperiod_id");
                    Long endPeriodId = (Long)model.getValue("endperiod_id");
                    DynamicObject startPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriodId, (String)"bd_period");
                    DynamicObject endPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodId, (String)"bd_period");
                    try {
                        if (startPeriod != null && endPeriod != null && (startPeriod.getDate("enddate").compareTo(endPeriod.getDate("enddate")) > 0 || startPeriod.getDate("begindate").compareTo(endPeriod.getDate("begindate")) > 0)) {
                            model.beginInit();
                            view.showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u59cb\u671f\u95f4\u3002", (String)"PABusinessRuleFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                            model.setValue("startperiod", endPeriod.get("id"));
                            model.endInit();
                            view.updateView("fs_baseinfo");
                        }
                    }
                    catch (Exception ex) {
                        logger.error("[FI-PA] BusinessRule Process Error!", (Throwable)ex);
                    }
                    break;
                }
                case "stepname": {
                    int curIdx = Integer.parseInt(view.getPageCache().get("pageCacheOldRowIdx"));
                    model.setValue("cardstepname", newValue, curIdx);
                    view.updateView("detailflex");
                    break;
                }
                case "handletype": {
                    if (StringUtils.isNotEmpty((CharSequence)((String)oldValue))) {
                        view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7c7b\u578b\u4f1a\u6e05\u7a7a\u5f53\u524d\u5361\u7247\u5df2\u8bbe\u7f6e\u7684\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PABusinessRuleFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackHandleType", (IFormPlugin)this), null, oldValue.toString());
                        break;
                    }
                    this.handleTypeChanged(model, view);
                    break;
                }
                case "analysissystem": 
                case "analysismodel": {
                    int cnt = model.getEntryRowCount("stepentry");
                    String handleType = (String)model.getValue("cardhandletype", 0);
                    String stepName = (String)model.getValue("cardstepname", 0);
                    if (cnt > 1 || StringUtils.isNotEmpty((CharSequence)handleType) || StringUtils.isNotEmpty((CharSequence)stepName)) {
                        view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5206\u6790\u4f53\u7cfb\u6216\u5206\u6790\u6a21\u578b\u4f1a\u6e05\u7a7a\u89c4\u5219\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PABusinessRuleFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackAnalysis", (IFormPlugin)this), null, propertyName + ',' + (oldValue == null ? "0" : ((DynamicObject)oldValue).get("id")));
                        break;
                    }
                    if ("analysissystem".equals(propertyName)) {
                        this.setAnalysisModelDefault(model, view);
                        this.processDateDim();
                        break;
                    }
                    this.setPeriodBaseEntityId(model, view);
                    this.setAccountFilterEmpty((DynamicObject)oldValue, (DynamicObject)newValue, model);
                    this.setPeriodEmpty((DynamicObject)oldValue, (DynamicObject)newValue, model);
                    this.processDateDim((DynamicObject)newValue);
                    break;
                }
                case "periodbasetype": {
                    model.beginInit();
                    model.setValue("startperiod", null);
                    model.setValue("endperiod", null);
                    model.endInit();
                    view.updateView("fs_baseinfo");
                    break;
                }
                case "accfilterclick": {
                    if (newValue != null && !String.valueOf(newValue).isEmpty()) break;
                    model.beginInit();
                    model.setValue("accountfilter_tag", null);
                    model.endInit();
                    view.updateView("accountfilter_tag");
                    break;
                }
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    private void processDateDim() {
        Object modelObj = this.getModel().getValue("analysismodel");
        if (!ObjectUtils.isEmpty((Object)modelObj)) {
            this.processDateDim((DynamicObject)modelObj);
        }
    }

    private boolean processDateDim(DynamicObject newValue) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return true;
        }
        IFormView view = this.getView();
        BasedataEdit startPeriodEdit = (BasedataEdit)view.getControl("startperiod");
        BasedataEdit endPeriodEdit = (BasedataEdit)view.getControl("endperiod");
        Long analysisModelId = newValue.getLong("id");
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        DynamicObject dimension = FormPluginUtil.getDimension(analysisModelObj, "1");
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
        if (DimensionTypeEnum.DATE == dimType) {
            this.processHandleType(false);
        } else {
            this.processHandleType(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)ValidatorTipsUtil.isModelNewVersion(analysisModelId)) || DimensionTypeEnum.DATE == dimType) {
            startPeriodEdit.setMustInput(false);
            endPeriodEdit.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"startperiod", "endperiod", "accfilterclick"});
            return true;
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"startperiod", "endperiod", "accfilterclick"});
        startPeriodEdit.setMustInput(true);
        endPeriodEdit.setMustInput(true);
        return false;
    }

    private void processHandleType(boolean flag) {
        DynamicProperty handleTypeProp = this.getModel().getDataEntityType().getProperty("handletype");
        if (handleTypeProp instanceof ComboProp) {
            List items = ((ComboProp)handleTypeProp).getComboItems();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.size());
            for (ValueMapItem item : items) {
                if (StringUtils.equals((CharSequence)"B", (CharSequence)item.getValue()) && !flag) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(item.getName());
                comboItem.setValue(item.getValue());
                comboItem.setItemVisible(item.isItemVisible());
                comboItems.add(comboItem);
            }
            ComboEdit edit = (ComboEdit)this.getView().getControl("handletype");
            edit.setComboItems(comboItems);
        }
    }

    private void setAccountFilterEmpty(DynamicObject oldAnaModel, DynamicObject newAnaModel, IDataModel model) {
        String newBaseEntityId;
        String oldBaseEntityId = oldAnaModel == null ? null : VerificationHelper.getEntityNumber(oldAnaModel.getLong("id"));
        String string = newBaseEntityId = newAnaModel == null ? null : VerificationHelper.getEntityNumber(newAnaModel.getLong("id"));
        if (StringUtils.isEmpty((CharSequence)oldBaseEntityId) || StringUtils.isEmpty((CharSequence)newBaseEntityId) || !Objects.equals(oldBaseEntityId, newBaseEntityId)) {
            model.beginInit();
            model.setValue("accfilterclick", null);
            model.setValue("accountfilter_tag", null);
            model.endInit();
            this.getView().updateView("fs_baseinfo");
        }
    }

    private void setPeriodEmpty(DynamicObject oldAnaModel, DynamicObject newAnaModel, IDataModel model) {
        String newBaseEntityId;
        String oldBaseEntityId = oldAnaModel == null ? null : VerificationHelper.getEntityNumber(oldAnaModel.getLong("id"));
        String string = newBaseEntityId = newAnaModel == null ? null : VerificationHelper.getEntityNumber(newAnaModel.getLong("id"));
        if (StringUtils.isEmpty((CharSequence)oldBaseEntityId) || StringUtils.isEmpty((CharSequence)newBaseEntityId) || !Objects.equals(oldBaseEntityId, newBaseEntityId)) {
            model.beginInit();
            model.setValue("startperiod", null);
            model.setValue("endperiod", null);
            model.endInit();
            this.getView().updateView("fs_baseinfo");
        }
    }

    private void setAnalysisModelDefault(IDataModel model, IFormView view) {
        Object oldAnaModel = model.getValue("analysismodel");
        DynamicObject anaSystem = (DynamicObject)model.getValue("analysissystem");
        if (anaSystem == null) {
            model.beginInit();
            model.setValue("analysismodel", null);
            Object newAnaModel = model.getValue("analysismodel");
            this.setAccountFilterEmpty((DynamicObject)oldAnaModel, (DynamicObject)newAnaModel, model);
            model.endInit();
            view.updateView("fs_baseinfo");
            return;
        }
        DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", anaSystem.get("id")).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter())}, (String)"number", (int)1);
        model.beginInit();
        if (anaModel == null || anaModel.isEmpty()) {
            model.setValue("analysismodel", null);
        } else {
            model.setValue("analysismodel", ((DynamicObject)anaModel.get(0)).get("id"));
        }
        Object newAnaModel = model.getValue("analysismodel");
        this.setAccountFilterEmpty((DynamicObject)oldAnaModel, (DynamicObject)newAnaModel, model);
        this.setPeriodEmpty((DynamicObject)oldAnaModel, (DynamicObject)newAnaModel, model);
        model.endInit();
        this.setPeriodBaseEntityId(model, view);
        view.updateView("fs_baseinfo");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            switch (operateKey) {
                case "newentry": {
                    this.initCardEntry(model, view, true);
                    break;
                }
                case "moveentryup": 
                case "moveentrydown": 
                case "deleteentry": {
                    this.initCardEntry(model, view, false);
                    break;
                }
                case "submit": {
                    view.setVisible(Boolean.FALSE, new String[]{"stepopflex"});
                }
                case "save": {
                    int curIdx = model.getEntryCurrentRowIndex("stepentry");
                    this.showModelDetail(model, view, curIdx);
                    this.deleteDataByCache(model, view);
                    break;
                }
                case "unsubmit": 
                case "unaudit": {
                    view.setVisible(Boolean.TRUE, new String[]{"stepopflex"});
                    int curIdx = model.getEntryCurrentRowIndex("stepentry");
                    this.showModelDetail(model, view, curIdx);
                }
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (operateKey) {
            case "save": 
            case "submit": {
                int saveResult;
                String oldIdxStr;
                String handleType;
                int cnt = model.getEntryRowCount("stepentry");
                if (cnt == 1 && StringUtils.isEmpty((CharSequence)(handleType = (String)model.getValue("cardhandletype", 0)))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u6267\u884c\u6b65\u9aa4\u4fe1\u606f\u3002", (String)"PABusinessRuleFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!this.checkUnique(model, view)) {
                    args.setCancel(true);
                    return;
                }
                IPageCache pageCache = view.getPageCache();
                if ("submit".equals(operateKey)) {
                    String emptySendFilterStepName;
                    String ignoreEmptySendFilter = pageCache.get("ignoreEmptySendFilter");
                    String accountFilter = (String)model.getValue("accountfilter_tag");
                    if (!(accountFilter != null && !accountFilter.isEmpty() || Boolean.parseBoolean(ignoreEmptySendFilter) || (emptySendFilterStepName = this.getEmptySendFilterStepName()) == null || emptySendFilterStepName.isEmpty())) {
                        view.showConfirm(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6b65\u9aa4\u672a\u914d\u7f6e\u53d1\u9001\u65b9\u6761\u4ef6\uff0c\u5c06\u9002\u7528\u4e8e\u6267\u884c\u671f\u95f4\u548c\u7ec4\u7ec7\u7684\u6240\u6709\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f\u6b65\u9aa4\uff1a%s", (String)"PABusinessRuleFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]), emptySendFilterStepName), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("tips_sender", (IFormPlugin)this));
                        args.setCancel(true);
                        return;
                    }
                    pageCache.remove("ignoreEmptySendFilter");
                }
                if (!StringUtils.isNotEmpty((CharSequence)(oldIdxStr = pageCache.get("pageCacheOldRowIdx")))) break;
                int oldIdx = Integer.parseInt(oldIdxStr);
                model.setValue("cardstepname", model.getValue("stepname"), oldIdx);
                String oldPageId = pageCache.get("pageCacheStepDetailPageId");
                if (!StringUtils.isNotEmpty((CharSequence)oldPageId) || (saveResult = this.saveModel(model, view, oldIdx)) == 1) break;
                args.setCancel(true);
                break;
            }
            case "deleteentry": {
                int cnt = model.getEntryRowCount("stepentry");
                if (cnt == 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u6b65\u9aa4\u81f3\u5c11\u6709\u4e00\u9879\u3002", (String)"PABusinessRuleFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                IPageCache pageCache = view.getPageCache();
                if (StringUtils.isEmpty((CharSequence)pageCache.get("pageCacheDeleteStepEntry"))) {
                    String handleType = (String)model.getValue("handletype");
                    String stepName = (String)model.getValue("stepname");
                    if (StringUtils.isNotEmpty((CharSequence)handleType) || StringUtils.isNotEmpty((CharSequence)stepName)) {
                        view.showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u7684\u6267\u884c\u6b65\u9aa4\uff1f", (String)"PABusinessRuleFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackDeleteStepEntry", (IFormPlugin)this));
                        args.setCancel(true);
                        return;
                    }
                } else {
                    pageCache.remove("pageCacheDeleteStepEntry");
                }
            }
            case "moveentryup": 
            case "moveentrydown": {
                view.getPageCache().remove("pageCacheOldRowIdx");
            }
        }
    }

    private boolean checkUnique(IDataModel model, IFormView view) {
        String accountNecessity;
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)model.getValue("analysismodel_id"));
        DynamicObject accountDim = (DynamicObject)PAAnalysisModelHelper.queryModelNecessityDims((DynamicObject)analysisModel, (String[])new String[]{accountNecessity = DimensionNecessityEnum.ACCOUNT.getCode()}).get(accountNecessity);
        if (accountDim == null) {
            throw new KDBizException("accountDim is null");
        }
        String accountNumber = accountDim.getDynamicObject("dimension").getString("number");
        String accountEntity = PADimensionHelper.getDimensionSource((DynamicObject)accountDim.getDynamicObject("dimension"));
        String accountFilter = (String)model.getValue("accountfilter_tag");
        try {
            QFilter curFilter = PAExecutorHelper.getQFilterFromFilterCondition((String)accountFilter, (String)accountEntity, (String)accountNumber);
            if (curFilter != null) {
                curFilter.and(FormPluginUtil.getBaseQFilter(analysisModel, DimensionNecessityEnum.ACCOUNT.getCode()));
                Map curAccountMap = BusinessDataServiceHelper.loadFromCache((String)accountEntity, (QFilter[])curFilter.toArray());
                if (curAccountMap == null || curAccountMap.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u79d1\u76ee\uff0c\u8bf7\u4fee\u6539\"\u79d1\u76ee\u8fc7\u6ee4\u6761\u4ef6\"\u3002", (String)"PABusinessRuleFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            logger.error("find account by filter error", (Throwable)exception);
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "vectorapmoveup": {
                if (model.getEntryCurrentRowIndex("stepentry") == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6b65\u9aa4\u7684\u6267\u884c\u987a\u5e8f\u5df2\u662f\u6700\u4f18\u5148\u3002", (String)"PABusinessRuleFormPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    break;
                }
                view.invokeOperation("moveentryup");
                break;
            }
            case "vectorapmovedown": {
                if (model.getEntryCurrentRowIndex("stepentry") == model.getEntryRowCount("stepentry") - 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6b65\u9aa4\u5df2\u662f\u6700\u540e\u6267\u884c\u7684\u6b65\u9aa4\u3002", (String)"PABusinessRuleFormPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    break;
                }
                view.invokeOperation("moveentrydown");
                break;
            }
            case "accfilterclick": {
                DynamicObject analysisModel = (DynamicObject)model.getValue("analysismodel");
                if (analysisModel == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PABusinessRuleFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                String tableNumber = analysisModel.getString("tablenumber");
                if (tableNumber == null || tableNumber.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u672a\u521b\u5efa\u6570\u636e\u8868\uff0c\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868\u3002", (String)"PABusinessRuleFormPlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showFilterConfig(model, view);
            }
        }
    }

    private void showFilterConfig(IDataModel model, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u503c\u6761\u4ef6", (String)"PABusinessRuleFormPlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("pa_expression");
        Long analysisModelId = (Long)model.getValue("analysismodel_id");
        String entityNumber = VerificationHelper.getEntityNumber(analysisModelId);
        showParameter.getCustomParams().put("customParamFilterForm", entityNumber);
        showParameter.getCustomParams().put("customParamConditionJson", model.getValue("accountfilter_tag"));
        showParameter.getCustomParams().put("analysismodel", analysisModelId);
        showParameter.getCustomParams().put("PROXY_CLASS", "kd.fi.pa.formplugin.verification.PaAllocationProxy");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallbackFilter"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String filterJson;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("closeCallbackFilter".equalsIgnoreCase(actionId) && StringUtils.isNotEmpty((CharSequence)(filterJson = (String)result))) {
            model.setValue("accfilterclick", (Object)this.getFilterDesc(filterJson));
            model.setValue("accountfilter_tag", result);
            view.updateView("fs_baseinfo");
        }
    }

    private String getFilterDesc(String filterJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        return new LocaleString(filterCondition.getFilter()).toString();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IDataModel model = this.getModel();
        Object id = model.getValue("id");
        if (id == null || Long.parseLong(id.toString()) == 0L) {
            this.deleteData(model, -1);
        }
        this.deleteDataByCache(model, this.getView());
    }

    private void deleteData(IDataModel model, int idx) {
        HashSet<Object> idSet = new HashSet<Object>(8);
        if (idx > -1) {
            this.getDeleteData(model, idSet, idx);
        } else {
            int cnt = model.getEntryRowCount("stepentry");
            for (int i = 0; i < cnt; ++i) {
                this.getDeleteData(model, idSet, i);
            }
        }
        if (!idSet.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (Object e : idSet) {
                joiner.add(e.toString());
            }
            IPageCache pageCache = this.getView().getPageCache();
            String string2 = pageCache.get("pageCacheNewAddedDerivationShare");
            string2 = StringUtils.isEmpty((CharSequence)string2) ? joiner.toString() : string2 + ',' + joiner;
            pageCache.put("pageCacheNewAddedDerivationShare", string2);
        }
    }

    private void deleteDataByCache(IDataModel model, IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String deleteIdStr = pageCache.get("pageCacheNewAddedDerivationShare");
        if (StringUtils.isNotEmpty((CharSequence)deleteIdStr)) {
            String[] idArr = deleteIdStr.split(",");
            HashSet<Long> idSet = new HashSet<Long>(idArr.length);
            for (String id : idArr) {
                idSet.add(Long.parseLong(id));
            }
            Object id = model.getValue("id");
            if (id != null && Long.parseLong(id.toString()) != 0L) {
                DynamicObject ruleDyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pa_businessrule");
                DynamicObjectCollection stepDyoCol = ruleDyo.getDynamicObjectCollection("stepentry");
                HashSet<Object> removeIdSet = new HashSet<Object>(stepDyoCol.size());
                for (DynamicObject dyo : stepDyoCol) {
                    String handleType = dyo.getString("cardhandletype");
                    boolean aFlag = "A".equals(handleType);
                    if (aFlag) {
                        removeIdSet.add(dyo.get("cardderivationmodel_id"));
                        continue;
                    }
                    removeIdSet.add(dyo.get("cardsharemodel_id"));
                }
                idSet.removeAll(removeIdSet);
            }
            DeleteServiceHelper.delete((String)"pa_derivationrule", (QFilter[])new QFilter("id", "in", idSet).toArray());
            DeleteServiceHelper.delete((String)"pa_sharerulenew", (QFilter[])new QFilter("id", "in", idSet).toArray());
            pageCache.remove("pageCacheNewAddedDerivationShare");
        }
    }

    private void getDeleteData(IDataModel model, Set<Object> idSet, int idx) {
        Boolean isNewAdded = (Boolean)model.getValue("newadded", idx);
        if (isNewAdded.booleanValue()) {
            String handleType = (String)model.getValue("cardhandletype", idx);
            boolean aFlag = "A".equals(handleType);
            if (aFlag) {
                idSet.add(model.getValue("cardderivationmodel_id", idx));
            } else {
                idSet.add(model.getValue("cardsharemodel_id", idx));
            }
        }
    }

    private void showModelDetail(IDataModel model, IFormView view, int curIdx) {
        Object id;
        IFormView oldPageView;
        IPageCache pageCache = view.getPageCache();
        String oldPageId = pageCache.get("pageCacheStepDetailPageId");
        if (StringUtils.isNotEmpty((CharSequence)oldPageId) && (oldPageView = view.getView(oldPageId)) != null) {
            oldPageView.close();
        }
        Object anaSys = model.getValue("analysissystem");
        Object anaMod = model.getValue("analysismodel");
        String handleType = (String)model.getValue("handletype");
        if (StringUtils.isEmpty((CharSequence)handleType) || anaSys == null || anaMod == null) {
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"stepdetailflex"});
        boolean aFlag = "A".equals(handleType);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(aFlag ? "pa_derivationrule" : "pa_sharerulenew");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("stepdetailflex");
        parameter.setParentFormId(view.getFormShowParameter().getFormId());
        parameter.setStatus(view.getFormShowParameter().getStatus());
        parameter.setCustomParam("analysissystem", ((DynamicObject)anaSys).get("id"));
        parameter.setCustomParam("analysismodel", ((DynamicObject)anaMod).get("id"));
        parameter.setCustomParam("showTBMain", (Object)Boolean.FALSE);
        parameter.setCustomParam("showSource", (Object)"pa_businessrule");
        parameter.setCustomParam("showEnable", (Object)(!"A".equalsIgnoreCase((String)model.getValue("status")) ? 1 : 0));
        parameter.setCustomParam("name", model.getValue("stepname"));
        parameter.setCustomParam("accountfilter_tag", model.getValue("accountfilter_tag"));
        Object object = id = aFlag ? model.getValue("derivationmodel_id") : model.getValue("sharemodel_id");
        if (id != null && Long.parseLong(id.toString()) != 0L) {
            Boolean copyStatus = (Boolean)model.getValue("copystatus", curIdx);
            if (copyStatus.booleanValue()) {
                parameter.setCustomParam("copydataid", id);
            } else {
                parameter.setPkId(id);
            }
        }
        view.showForm((FormShowParameter)parameter);
        pageCache.put("pageCacheStepDetailPageId", parameter.getPageId());
    }

    private void handleTypeChanged(IDataModel model, IFormView view) {
        String handleType = (String)model.getValue("handletype");
        int curIdx = model.getEntryCurrentRowIndex("stepentry");
        this.deleteData(model, curIdx);
        model.setValue("cardhandletype", (Object)handleType, curIdx);
        model.setValue("cardderivationmodel", null, curIdx);
        model.setValue("cardsharemodel", null, curIdx);
        model.setValue("newadded", (Object)"0", curIdx);
        CardEntry stepEntry = (CardEntry)this.getControl("stepentry");
        boolean aFlag = "A".equals(handleType);
        boolean bFlag = "B".equals(handleType);
        stepEntry.setChildVisible(aFlag, curIdx, new String[]{"derivationview"});
        stepEntry.setChildVisible(bFlag, curIdx, new String[]{"shareview"});
        view.setVisible(Boolean.FALSE, new String[]{"derivationmodel"});
        view.setVisible(Boolean.FALSE, new String[]{"sharemodel"});
        model.beginInit();
        model.setValue("derivationmodel", null);
        model.setValue("sharemodel", null);
        model.endInit();
        view.setVisible(Boolean.FALSE, new String[]{"stepdetailflex"});
        IPageCache pageCache = view.getPageCache();
        String oldPageId = pageCache.get("pageCacheStepDetailPageId");
        if (StringUtils.isNotEmpty((CharSequence)oldPageId)) {
            view.getView(oldPageId).close();
        }
        pageCache.remove("pageCacheStepDetailPageId");
        view.updateView("detailflex");
        this.showModelDetail(model, view, curIdx);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        try {
            if (MessageBoxResult.Yes == messageBoxResult) {
                if ("confirmCallbackHandleType".equalsIgnoreCase(actionId)) {
                    this.handleTypeChanged(model, view);
                } else if ("confirmCallbackAnalysis".equalsIgnoreCase(actionId)) {
                    String oldValue = messageBoxClosedEvent.getCustomVaule();
                    String[] oldValueArr = oldValue.split(",");
                    if ("analysissystem".equals(oldValueArr[0])) {
                        this.setAnalysisModelDefault(model, view);
                        this.processDateDim();
                    }
                    if ("analysismodel".equals(oldValueArr[0])) {
                        DynamicObject oldAnaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(oldValueArr[1]), (String)"pa_analysismodel");
                        Object newAnaModel = model.getValue("analysismodel");
                        this.setAccountFilterEmpty(oldAnaModel, (DynamicObject)newAnaModel, model);
                        this.processDateDim((DynamicObject)newAnaModel);
                    }
                    this.setPeriodBaseEntityId(model, view);
                    this.deleteData(model, -1);
                    model.deleteEntryData("stepentry");
                    view.getPageCache().remove("pageCacheOldRowIdx");
                    int newEntryRow = model.createNewEntryRow("stepentry");
                    EntryGrid cardEntry = (EntryGrid)this.getControl("stepentry");
                    cardEntry.selectRows(newEntryRow);
                    this.initCardEntry(model, view, true);
                } else if ("confirmCallbackDeleteStepEntry".equalsIgnoreCase(actionId)) {
                    IPageCache pageCache = view.getPageCache();
                    this.deleteData(model, model.getEntryCurrentRowIndex("stepentry"));
                    pageCache.put("pageCacheDeleteStepEntry", "mark");
                    view.invokeOperation("deleteentry");
                } else if ("tips_sender".equals(actionId)) {
                    this.getPageCache().put("ignoreEmptySendFilter", "true");
                    view.invokeOperation("submit");
                }
            } else if ("confirmCallbackHandleType".equalsIgnoreCase(actionId)) {
                model.beginInit();
                String oldValue = messageBoxClosedEvent.getCustomVaule();
                model.setValue("handletype", (Object)oldValue);
                model.endInit();
                view.updateView("detailflex");
            } else if ("confirmCallbackAnalysis".equalsIgnoreCase(actionId)) {
                model.beginInit();
                String oldValue = messageBoxClosedEvent.getCustomVaule();
                String[] oldValueArr = oldValue.split(",");
                model.setValue(oldValueArr[0], "0".equals(oldValueArr[1]) ? null : Long.valueOf(Long.parseLong(oldValueArr[1])));
                model.endInit();
                view.updateView("fs_baseinfo");
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = view.getPageCache();
        try {
            if ("stepentry".equals(entryKey)) {
                int curIdx = evt.getRow();
                String oldIdxStr = pageCache.get("pageCacheOldRowIdx");
                String oldPageId = pageCache.get("pageCacheStepDetailPageId");
                if (StringUtils.isNotEmpty((CharSequence)oldIdxStr)) {
                    int saveResult;
                    int oldIdx = Integer.parseInt(oldIdxStr);
                    model.setValue("cardstepname", model.getValue("stepname"), oldIdx);
                    if (StringUtils.isNotEmpty((CharSequence)oldPageId) && (saveResult = this.saveModel(model, view, oldIdx)) == -1 && curIdx == oldIdx) {
                        return;
                    }
                }
                pageCache.put("pageCacheOldRowIdx", String.valueOf(curIdx));
                view.setVisible(Boolean.FALSE, new String[]{"derivationmodel", "sharemodel", "stepdetailflex"});
                if (StringUtils.isNotEmpty((CharSequence)oldPageId)) {
                    view.getView(oldPageId).close();
                }
                pageCache.remove("pageCacheStepDetailPageId");
                String handleType = (String)model.getValue("cardhandletype", curIdx);
                DynamicObject derivationDyo = (DynamicObject)model.getValue("cardderivationmodel", curIdx);
                DynamicObject shareDyo = (DynamicObject)model.getValue("cardsharemodel", curIdx);
                model.beginInit();
                String message = ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\uff1a%s", (String)"PABusinessRuleFormPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                String indexStr = String.format("%02d", curIdx + 1);
                model.setValue("executeseq", (Object)String.format(message, indexStr), curIdx);
                model.setValue("stepname", model.getValue("cardstepname", curIdx));
                model.setValue("handletype", (Object)handleType);
                view.setVisible(Boolean.FALSE, new String[]{"derivationmodel"});
                view.setVisible(Boolean.FALSE, new String[]{"sharemodel"});
                model.setValue("derivationmodel", (Object)derivationDyo);
                model.setValue("sharemodel", (Object)shareDyo);
                model.endInit();
                this.showModelDetail(model, view, curIdx);
                view.updateView("detailflex");
            }
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get("pageCacheAfterBindData"))) {
                pageCache.remove("pageCacheAfterBindData");
                model.setDataChanged(false);
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    private int saveModel(IDataModel model, IFormView view, int idx) {
        if (!"A".equalsIgnoreCase((String)model.getValue("status"))) {
            return 0;
        }
        IPageCache pageCache = view.getPageCache();
        String oldPageId = pageCache.get("pageCacheStepDetailPageId");
        IFormView stepDetailFlexView = view.getView(oldPageId);
        IDataModel stepDetailFlexModel = stepDetailFlexView.getModel();
        String handleType = (String)model.getValue("handletype");
        boolean aFlag = "A".equals(handleType);
        Object ansSysPK = model.getValue("analysissystem");
        Object ansMdl = model.getValue("analysismodel");
        if (ansSysPK != null && ansMdl != null) {
            stepDetailFlexModel.setValue("analysissystem", ((DynamicObject)ansSysPK).getPkValue());
            stepDetailFlexModel.setValue("analysismodel", ((DynamicObject)ansMdl).getPkValue());
        }
        stepDetailFlexModel.setValue("status", (Object)Character.valueOf('C'));
        if (aFlag) {
            Object org = model.getValue("createorg");
            stepDetailFlexModel.setValue("createorg", org);
            stepDetailFlexModel.setValue("useorg", org);
        }
        stepDetailFlexModel.setValue("name", model.getValue("cardstepname", idx));
        logger.info("PABusinessRuleFormPlugin - savemodel: ANALYSISMODEL" + model.getValue("analysismodel"));
        logger.info("PABusinessRuleFormPlugin - savemodel:\u5f00\u59cb\u8c03\u7528\u89c4\u5219\u7684\u4fdd\u5b58\u64cd\u4f5c");
        OperationResult operationResult = stepDetailFlexView.invokeOperation("save");
        if (!operationResult.isSuccess()) {
            List validateErrors = operationResult.getValidateResult().getValidateErrors();
            StringBuilder errorInfo = new StringBuilder();
            String message = operationResult.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                errorInfo.append(message);
            }
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo error : allErrorInfo) {
                    errorInfo.append(error.getMessage());
                }
            }
            String error = stepDetailFlexView.getPageCache().get("shareRuleErrorKey");
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                errorInfo.append(error);
            }
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%02d\u7684\u6b65\u9aa4\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"PABusinessRuleFormPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]), idx + 1, errorInfo));
            return -1;
        }
        view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e3a%02d\u7684\u6b65\u9aa4\u4fdd\u5b58\u6210\u529f\u3002", (String)"PABusinessRuleFormPlugin_17", (String)"fi-pa-formplugin", (Object[])new Object[0]), idx + 1));
        Object cardModel = model.getValue(aFlag ? "cardderivationmodel" : "cardsharemodel", idx);
        if (cardModel == null || ((Boolean)model.getValue("copystatus", idx)).booleanValue()) {
            model.setValue("newadded", (Object)"1", idx);
            model.setValue("copystatus", (Object)"0", idx);
        }
        model.setValue(aFlag ? "cardderivationmodel" : "cardsharemodel", stepDetailFlexModel.getValue("id"), idx);
        model.beginInit();
        model.setValue(aFlag ? "derivationmodel" : "sharemodel", stepDetailFlexModel.getValue("id"));
        model.endInit();
        view.updateView("detailflex");
        return 1;
    }

    private void initCardEntry(IDataModel model, IFormView view, boolean initPage) {
        int cnt = model.getEntryRowCount("stepentry");
        CardEntry stepEntry = (CardEntry)this.getControl("stepentry");
        String s = ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\uff1a%s", (String)"PABusinessRuleFormPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < cnt; ++i) {
            model.setValue("executeseq", (Object)String.format(s, String.format("%02d", i + 1)), i);
            model.setValue("derivationview", (Object)ResManager.loadKDString((String)"\u63a8\u5bfc", (String)"PABusinessRuleFormPlugin_18", (String)"fi-pa-formplugin", (Object[])new Object[0]), i);
            model.setValue("shareview", (Object)ResManager.loadKDString((String)"\u5206\u644a", (String)"PABusinessRuleFormPlugin_19", (String)"fi-pa-formplugin", (Object[])new Object[0]), i);
            if (!initPage) continue;
            String handleType = (String)model.getValue("cardhandletype", i);
            boolean aFlag = "A".equals(handleType);
            boolean bFlag = "B".equals(handleType);
            stepEntry.setChildVisible(aFlag, i, new String[]{"derivationview"});
            stepEntry.setChildVisible(bFlag, i, new String[]{"shareview"});
            view.setVisible(Boolean.FALSE, new String[]{"derivationmodel"});
            view.setVisible(Boolean.FALSE, new String[]{"sharemodel"});
        }
        view.updateView("detailflex");
    }

    private String getEmptySendFilterStepName() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        int stepCount = model.getEntryRowCount("stepentry");
        int currentRow = model.getEntryCurrentRowIndex("stepentry");
        StringBuilder emptySendFilterStepName = new StringBuilder();
        LinkedHashMap<String, LinkedHashMap<Long, String>> savedStepMap = new LinkedHashMap<String, LinkedHashMap<Long, String>>(stepCount);
        for (int i = 0; i < stepCount; ++i) {
            String handleType = (String)model.getValue("cardhandletype", i);
            boolean derivation = "A".equals(handleType);
            DynamicObject currentObj = derivation ? (DynamicObject)model.getValue("cardderivationmodel", i) : (DynamicObject)model.getValue("cardsharemodel", i);
            String stepName = (String)model.getValue("cardstepname", i);
            if (currentRow == i || currentObj == null) {
                IDataModel stepDetailFlexModel;
                String oldPageId = pageCache.get("pageCacheStepDetailPageId");
                IFormView stepDetailFlexView = view.getView(oldPageId);
                if (stepDetailFlexView == null || (stepDetailFlexModel = stepDetailFlexView.getModel()) == null) continue;
                int sendEntryCount = stepDetailFlexModel.getEntryRowCount("sendentryentity");
                if (sendEntryCount < 1) {
                    emptySendFilterStepName.append(';').append(stepName);
                    continue;
                }
                boolean atLeastOneFilter = false;
                String conditionColumn = derivation ? "dimensionvalue_e" : "dimensionvalue";
                for (int j = 0; j < sendEntryCount; ++j) {
                    boolean noNeedInputValue;
                    Object sendDimension = stepDetailFlexModel.getValue("senddimension", j);
                    String condition = (String)stepDetailFlexModel.getValue("combofield", j);
                    String conditionValue = (String)stepDetailFlexModel.getValue(conditionColumn, j);
                    boolean bl = noNeedInputValue = FilterConditionEnum.IS_NULL.getCode().equals(condition) || FilterConditionEnum.IS_NOTNULL.getCode().equals(condition) || FilterConditionEnum.ALL.getCode().equals(condition);
                    if (ObjectUtils.isEmpty((Object)sendDimension) || !noNeedInputValue && StringUtils.isBlank((CharSequence)conditionValue)) continue;
                    atLeastOneFilter = true;
                    break;
                }
                if (atLeastOneFilter) continue;
                emptySendFilterStepName.append(';').append(stepName);
                continue;
            }
            LinkedHashMap<Long, String> derivationOrShareRuleMap = (LinkedHashMap<Long, String>)savedStepMap.get(handleType);
            if (derivationOrShareRuleMap == null) {
                derivationOrShareRuleMap = new LinkedHashMap<Long, String>(1);
            }
            derivationOrShareRuleMap.put(currentObj.getLong("id"), stepName);
            savedStepMap.put(handleType, derivationOrShareRuleMap);
        }
        if (!savedStepMap.isEmpty()) {
            this.appendSavedEmptySendFilterStepName(emptySendFilterStepName, (Map)savedStepMap.get("A"), "pa_derivationrule");
            this.appendSavedEmptySendFilterStepName(emptySendFilterStepName, (Map)savedStepMap.get("B"), "pa_sharerulenew");
        }
        return emptySendFilterStepName.length() > 0 ? emptySendFilterStepName.substring(1) : null;
    }

    private void appendSavedEmptySendFilterStepName(StringBuilder builder, Map<Long, String> derivationOrShareRuleMap, String entityNumber) {
        if (derivationOrShareRuleMap != null && !derivationOrShareRuleMap.isEmpty()) {
            HashSet<Long> derivationIdSet = new HashSet<Long>(derivationOrShareRuleMap.size());
            for (Map.Entry<Long, String> entry : derivationOrShareRuleMap.entrySet()) {
                derivationIdSet.add(entry.getKey());
            }
            Map objectMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])new QFilter("id", "in", derivationIdSet).toArray());
            if (objectMap != null && !objectMap.isEmpty()) {
                for (Map.Entry entry : objectMap.entrySet()) {
                    DynamicObject derivationOrShareRuleObj = (DynamicObject)entry.getValue();
                    DynamicObjectCollection sendEntryCol = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("sendentryentity");
                    if (sendEntryCol != null && !sendEntryCol.isEmpty()) continue;
                    String stepName = derivationOrShareRuleMap.get(derivationOrShareRuleObj.getLong("id"));
                    builder.append(';').append(stepName);
                }
            }
        }
    }
}

