/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.formplugin.PABusinessListPlugin;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.PAF7Util;

public class PABusinessRuleListPlugin
extends PABusinessListPlugin {
    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        int cnt = pageData.size();
        ArrayList<Long> dimIdList = new ArrayList<Long>(cnt);
        block0: for (DynamicObject data : pageData) {
            DynamicObjectCollection dimCol = data.getDynamicObject("analysismodel").getDynamicObjectCollection("dimension_entry");
            for (Object dyo : dimCol) {
                if (!DimensionNecessityEnum.PERIOD.getCode().equals(dyo.getString("necessity_dim"))) continue;
                dimIdList.add(dyo.getLong("dimension_id"));
                continue block0;
            }
        }
        Map dimMap = BusinessDataServiceHelper.loadFromCache((Object[])new HashSet(dimIdList).toArray(), (String)"pa_dimension");
        HashMap<String, Set<Object>> periodIdMap = new HashMap<String, Set<Object>>(dimMap.size());
        String[] baseEntityIdArr = new String[cnt];
        int i = 0;
        for (DynamicObject data : pageData) {
            String baseEntityId = FormPluginUtil.getBaseEntityIdByDimension((DynamicObject)dimMap.get(dimIdList.get(i)));
            baseEntityIdArr[i++] = baseEntityId;
            if (StringUtils.isEmpty((String)baseEntityId) || "bd_period".equals(baseEntityId)) continue;
            Set periodIdSet = periodIdMap.computeIfAbsent(baseEntityId, k -> new HashSet(8));
            if (data.get("startperiod") == null) {
                periodIdSet.add(data.get("startperiod_id"));
            }
            if (data.get("endperiod") != null) continue;
            periodIdSet.add(data.get("endperiod_id"));
        }
        Map<String, Map<Object, DynamicObject>> periodMap = FormPluginUtil.getBaseEntityDataMap(periodIdMap);
        i = 0;
        for (DynamicObject data : pageData) {
            String baseEntityId;
            Map<Object, DynamicObject> periodDataMap;
            if ((periodDataMap = periodMap.get(baseEntityId = baseEntityIdArr[i++])) == null || periodDataMap.isEmpty()) continue;
            data.set("startperiod", (Object)periodDataMap.get(data.get("startperiod_id")));
            data.set("endperiod", (Object)periodDataMap.get(data.get("endperiod_id")));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        if ("manualexecute".equals(operateKey)) {
            List valueList;
            ControlFilter controlFilter;
            Object[] idArr = this.getSelectedRows().getPrimaryKeyValues();
            if (idArr.length != 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PABusinessRuleListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((Object)idArr[0], (String)"pa_businessrule");
            if (!"1".equals(dyo.getString("enable")) || !"C".equals(dyo.getString("status"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u542f\u7528\u72b6\u6001\u4e3a\u53ef\u7528\u4e14\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u6570\u636e\u53ef\u4ee5\u624b\u5de5\u6267\u884c\u3002", (String)"PABusinessRuleListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            Object useOrgObj = null;
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            Map filters = controlFilters.getFilters();
            if (filters != null && (controlFilter = (ControlFilter)filters.get("useorg.id")) != null && (valueList = controlFilter.getValue()) != null && !valueList.isEmpty()) {
                useOrgObj = valueList.get(0);
            }
            PAF7Util.showBusinessExecute(view, dyo.get("analysissystem_id"), dyo.get("analysismodel_id"), useOrgObj != null ? useOrgObj : dyo.get("useorg_id"), null, idArr[0], (AbstractFormPlugin)this);
        }
    }
}

